/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.filter.CompareType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.list.BillListUserSettingParser;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListColumnGroupConfigUtil;
import kd.bos.list.ListGridView;
import kd.bos.list.SeqColumnType;
import kd.bos.list.ViewCommonUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.utils.SortUtil;

class BillListColumnParser {
    private static final String LIST_FIELD_KEY = "listFieldKey";
    private List<Map<String, Object>> listFieldsControlColumns;
    private String listGridViewKey;
    private List<IListColumn> listColumns;
    private List<ListColumnGroup> listGroupColumns;
    private EntityType entityType;
    private boolean isIncludeParent = true;
    private List<EntryEntityDto> detailGridEntityEntryEntities = new ArrayList<EntryEntityDto>();
    private ListGridView listGridView;
    private List<EntryEntityDto> selectedEntryEntityDtos = new ArrayList<EntryEntityDto>(10);
    private List<String> blackFields = new ArrayList<String>(10);
    private Map<String, List<CompareType>> fieldCompareTypeMap = new HashMap<String, List<CompareType>>(16);
    private boolean isDetailEntry;
    private List<IListColumn> showListColumns;

    List<Map<String, Object>> getListFieldsControlColumns() {
        return this.listFieldsControlColumns;
    }

    void setListFieldsControlColumns(List<Map<String, Object>> listFieldsControlColumns) {
        this.listFieldsControlColumns = listFieldsControlColumns;
    }

    EntityType getEntityType() {
        return this.entityType;
    }

    void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    void setIncludeParent(boolean includeParent) {
        this.isIncludeParent = includeParent;
    }

    void setDetailGridEntityEntryEntities(List<EntryEntityDto> detailGridEntityEntryEntities) {
        this.detailGridEntityEntryEntities = detailGridEntityEntryEntities;
    }

    String getListGridViewKey() {
        return this.listGridViewKey;
    }

    void setListGridView(ListGridView listGridView) {
        this.listGridView = listGridView;
    }

    void setSelectedEntryEntityDtos(List<EntryEntityDto> selectedEntryEntityDtos) {
        this.selectedEntryEntityDtos = selectedEntryEntityDtos;
    }

    List<String> getBlackFields() {
        return this.blackFields;
    }

    void setBlackFields(List<String> blackFields) {
        this.blackFields = blackFields;
    }

    void setFieldCompareTypeMap(Map<String, List<CompareType>> fieldCompareTypeMap) {
        this.fieldCompareTypeMap = fieldCompareTypeMap;
    }

    void setDetailEntry(boolean detailEntry) {
        this.isDetailEntry = detailEntry;
    }

    BillListColumnParser(String listGridViewKey, List<IListColumn> listColumns, List<ListColumnGroup> listGroupColumns) {
        this.listGridViewKey = listGridViewKey;
        this.listColumns = listColumns;
        this.listGroupColumns = listGroupColumns;
    }

    List<IListColumn> getShowListColumns() {
        return this.showListColumns;
    }

    List<IListColumn> parseShowListColumns() {
        List<IListColumn> newListColumns = this.getEntryListColumns();
        BillListUserSettingParser billListUserSettingParser = new BillListUserSettingParser(this.listFieldsControlColumns);
        List<String> designListColumnKeys = this.getListColumnKeys();
        List sortListColumnKeys = SortUtil.sortListByKeys(billListUserSettingParser.getUserListColumnKeys(), designListColumnKeys);
        for (IListColumn listColumn : newListColumns) {
            String key = StringUtils.isNotBlank((CharSequence)listColumn.getListFieldKey()) ? listColumn.getListFieldKey().replace('.', '_') : ((Control)listColumn).getKey();
            if (StringUtils.isNotBlank((CharSequence)key) && sortListColumnKeys.contains(key)) {
                listColumn.setSeq(sortListColumnKeys.indexOf(key));
                continue;
            }
            if (listColumn.getParent() instanceof ListColumnGroup && sortListColumnKeys.contains(listColumn.getParent().getKey())) {
                listColumn.setSeq(sortListColumnKeys.indexOf(listColumn.getParent().getKey()));
                continue;
            }
            if (listColumn.getSeqColType() != SeqColumnType.EntitySeq) continue;
            listColumn.setSeq(-1);
        }
        this.showListColumns = ViewCommonUtil.orderBySeq(newListColumns);
        return this.showListColumns;
    }

    List<IListColumn> getConfigListColumns() {
        List<IListColumn> showListColumns = this.isDetailEntry ? this.getEntryListColumns() : this.getAllListColumns();
        return showListColumns;
    }

    List<IListColumn> getValidListColumns(List<Map<String, Object>> listColumns) {
        List<String> sortedListColumnKeys = this.getSortedListColumnKeys(listColumns);
        List<IListColumn> showListColumns = this.getConfigListColumns();
        HashMap<String, ListColumnGroup> listColumnGroupMap = this.getListColumnGroupMap();
        ArrayList<IListColumn> validListColumns = new ArrayList<IListColumn>(showListColumns.size());
        HashMap<String, Integer> repeatKeyMap = new HashMap<String, Integer>(16);
        Iterator<String> iterator = sortedListColumnKeys.iterator();
        while (iterator.hasNext()) {
            String listColumnKey;
            Integer count = (Integer)repeatKeyMap.get(listColumnKey = iterator.next());
            repeatKeyMap.put(listColumnKey, count == null ? (count = Integer.valueOf(1)) : (count = Integer.valueOf(count + 1)));
            HashMap innerRepeatKeyMap = new HashMap(16);
            for (IListColumn listColumn : showListColumns) {
                ListColumnGroup listColumnGroup;
                ListColumnGroup findedTopListColumnGroup;
                Integer innerCount = (Integer)innerRepeatKeyMap.get(listColumnKey);
                repeatKeyMap.put(listColumnKey, innerCount == null ? (innerCount = Integer.valueOf(1)) : (innerCount = Integer.valueOf(innerCount + 1)));
                String listFieldKey = ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)listColumn);
                if (count.equals(innerCount) && (StringUtils.isEmpty((CharSequence)listColumn.getParentViewKey()) || this.listGridViewKey.equalsIgnoreCase(listColumn.getParentViewKey())) && (listColumnKey.equalsIgnoreCase(listFieldKey.replace('.', '_')) || listColumnKey.equalsIgnoreCase(listFieldKey))) {
                    validListColumns.add(listColumn);
                    continue;
                }
                if (!count.equals(innerCount) || !listColumnKey.equals(listFieldKey.replace('.', '_')) && !listColumnKey.equalsIgnoreCase(listFieldKey) || listColumn.getParent() == null || !(listColumn.getParent() instanceof ListColumnGroup) || !this.listGridViewKey.equalsIgnoreCase((findedTopListColumnGroup = this.findTopListColumnGroup(listColumnGroup = (ListColumnGroup)listColumn.getParent(), listColumnGroupMap)).getParentViewKey()) && !StringUtils.isBlank((CharSequence)findedTopListColumnGroup.getParentViewKey())) continue;
                validListColumns.add(listColumn);
            }
        }
        return validListColumns;
    }

    ListColumnGroup findTopListColumnGroup(ListColumnGroup listColumnGroup, HashMap<String, ListColumnGroup> listColumnGroupMap) {
        ListColumnGroup parentListColumnGroup;
        if (StringUtils.isNotBlank((CharSequence)listColumnGroup.getParentViewKey()) && (parentListColumnGroup = listColumnGroupMap.get(listColumnGroup.getParentViewKey())) != null) {
            return this.findTopListColumnGroup(parentListColumnGroup, listColumnGroupMap);
        }
        return listColumnGroup;
    }

    List<IListColumn> getEntryListColumns() {
        List<IListColumn> listColumns = this.getAllListColumns();
        return ViewCommonUtil.getEntityFields(this.entityType, listColumns, this.listFieldsControlColumns, this.isIncludeParent ? this.selectedEntryEntityDtos : this.detailGridEntityEntryEntities, this.isIncludeParent, this.blackFields);
    }

    List<IListColumn> getAllListColumns() {
        ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>(10);
        listColumns.addAll(this.listColumns);
        block0: for (ListColumnGroup listColumnGroup : this.listGroupColumns) {
            String listFieldKey = ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)listColumnGroup);
            for (Map<String, Object> listColumn : this.listFieldsControlColumns) {
                if (listFieldKey == null || listColumn.get(LIST_FIELD_KEY) == null || !listFieldKey.equalsIgnoreCase(listColumn.get(LIST_FIELD_KEY).toString())) continue;
                listColumnGroup.setUserConfigColumnSettings(listColumn);
                listColumnGroup.setFieldCompareTypeMap(this.fieldCompareTypeMap);
                continue block0;
            }
        }
        for (IListColumn iListColumn : listColumns) {
            if (iListColumn.getParent() != null) continue;
            iListColumn.setParent((Container)this.listGridView);
            iListColumn.setParentViewKey(this.listGridViewKey);
        }
        if (this.listGridView != null && CollectionUtils.isNotEmpty(listColumns)) {
            GridConfigRenderUtils.setListColumnFixed(this.listGroupColumns, this.listGridView.getFreezeList());
            GridConfigRenderUtils.setListColumnFixed(listColumns, this.listGridView.getFreezeList());
        }
        return listColumns;
    }

    private List<String> getSortedListColumnKeys(List<Map<String, Object>> listColumns) {
        List listColumnKeys = this.getListColumnKeys(listColumns);
        BillListUserSettingParser billListUserSettingParser = new BillListUserSettingParser(this.listFieldsControlColumns);
        List<String> userListColumnKeys = billListUserSettingParser.getUserListColumnKeys();
        if (!userListColumnKeys.isEmpty()) {
            listColumnKeys = SortUtil.sortListByKeys(listColumnKeys, userListColumnKeys);
        }
        BillListColumnParser billListColumnParser = new BillListColumnParser(this.listGridViewKey, this.listColumns, this.listGroupColumns);
        List<String> designListColumnKeys = billListColumnParser.getListColumnKeys();
        return SortUtil.sortListByKeys((List)listColumnKeys, designListColumnKeys);
    }

    private List<String> getListColumnKeys(List<Map<String, Object>> listColumns) {
        ArrayList<String> listColumnKeys = new ArrayList<String>();
        for (Map<String, Object> userListColumn : listColumns) {
            if (listColumnKeys.contains(userListColumn.get("k").toString())) continue;
            listColumnKeys.add(userListColumn.get("k").toString());
        }
        return listColumnKeys;
    }

    List<String> getListColumnKeys() {
        ArrayList<String> designListColumnKeys = new ArrayList<String>();
        HashMap<String, ListColumnGroup> listColumnGroupMap = this.getListColumnGroupMap();
        for (IListColumn listColumn : this.listColumns) {
            if (this.isValidListFieldsControlColumn(listColumn)) {
                designListColumnKeys.add(ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)listColumn).replace('.', '_'));
                continue;
            }
            if (listColumn.getParent() == null || !(listColumn.getParent() instanceof ListColumnGroup)) continue;
            this.addListColumnGroupKeyToDesign(designListColumnKeys, listColumnGroupMap, listColumn, (ListColumnGroup)listColumn.getParent());
        }
        return designListColumnKeys;
    }

    private void addListColumnGroupKeyToDesign(List<String> designListColumnKeys, HashMap<String, ListColumnGroup> listColumnGroupMap, IListColumn listColumn, ListColumnGroup parentListColumnGroup) {
        String listColumnGroupParentViewKey = parentListColumnGroup.getParentViewKey();
        if (this.listGridViewKey.equalsIgnoreCase(listColumnGroupParentViewKey) && !designListColumnKeys.contains(parentListColumnGroup.getKey())) {
            this.addChildDesignListColumnKeys(designListColumnKeys, parentListColumnGroup);
        } else {
            ListColumnGroup listColumnGroup = listColumnGroupMap.get(listColumnGroupParentViewKey);
            if (listColumnGroup != null) {
                this.addListColumnGroupKeyToDesign(designListColumnKeys, listColumnGroupMap, listColumn, listColumnGroup);
            }
        }
    }

    private void addChildDesignListColumnKeys(List<String> designListColumnKeys, ListColumnGroup parentListColumnGroup) {
        designListColumnKeys.add(parentListColumnGroup.getKey());
        for (Control control : parentListColumnGroup.getItems()) {
            if (control instanceof IListColumn) {
                designListColumnKeys.add(ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)((IListColumnConfig)control)));
                continue;
            }
            if (!(control instanceof ListColumnGroup)) continue;
            this.addChildDesignListColumnKeys(designListColumnKeys, (ListColumnGroup)control);
        }
    }

    private boolean isValidListFieldsControlColumn(IListColumn iListColumn) {
        return iListColumn.getParentViewKey() == null || this.listGridViewKey.equalsIgnoreCase(iListColumn.getParentViewKey()) && iListColumn.getSeqColType() != SeqColumnType.EntitySeq;
    }

    HashMap<String, ListColumnGroup> getListColumnGroupMap() {
        HashMap<String, ListColumnGroup> listColumnGroupMap = new HashMap<String, ListColumnGroup>(this.listGroupColumns.size());
        for (ListColumnGroup listColumnGroup : this.listGroupColumns) {
            listColumnGroupMap.put(listColumnGroup.getKey(), listColumnGroup);
        }
        return listColumnGroupMap;
    }

    List<IListColumn> getListGridViewColumns(List<Map<String, Object>> listColumns) {
        List<IListColumn> validListColumns = this.getValidListColumns(listColumns);
        ArrayList<IListColumn> finalValidListColumns = new ArrayList<IListColumn>();
        for (IListColumn listColumn : validListColumns) {
            if (this.blackFields.contains(listColumn.getListFieldKey())) continue;
            finalValidListColumns.add(listColumn);
        }
        return finalValidListColumns;
    }

    List<Control> getPermListColumns() {
        List<IListColumn> showListColumns = this.parseShowListColumns();
        Stack<Control> columnStack = new Stack<Control>();
        HashMap<String, ListColumnGroup> listColumnGroupMap = this.getListColumnGroupMap();
        for (int i = showListColumns.size() - 1; i >= 0; --i) {
            IListColumn column = showListColumns.get(i);
            columnStack.push((Control)column);
            if (this.listGridViewKey.equals(column.getParentViewKey())) continue;
            this.pushParentListColumnGroup(columnStack, listColumnGroupMap, column.getParentViewKey());
        }
        ArrayList<Control> permListColumnControls = new ArrayList<Control>();
        HashSet<String> groupKeys = new HashSet<String>();
        while (!columnStack.isEmpty()) {
            Control control = (Control)columnStack.pop();
            if (control instanceof IListColumn && (StringUtils.isEmpty((CharSequence)((IListColumn)control).getParentViewKey()) || this.listGridViewKey.equals(((IListColumn)control).getParentViewKey()))) {
                permListColumnControls.add(control);
                continue;
            }
            if (!(control instanceof ListColumnGroup) || !this.listGridViewKey.equals(((ListColumnGroup)control).getParentViewKey())) continue;
            if (groupKeys.add(control.getKey())) {
                ((ListColumnGroup)control).getItems().clear();
                permListColumnControls.add(control);
            }
            this.popChildColumns(columnStack, control, groupKeys);
        }
        return permListColumnControls;
    }

    private void popChildColumns(Stack<Control> columnStack, Control control, Set<String> groupKeys) {
        Control childControl = columnStack.pop();
        Map childItemSetting = ListColumnGroupConfigUtil.getChildItemSetting(new ArrayList(10), ((ListColumnGroup)control).getUserConfigColumnSettings());
        if (childControl instanceof IListColumn && control.getKey().equals(((IListColumn)childControl).getParentViewKey())) {
            ListColumnGroupConfigUtil.setListColumnSetting((Map)childItemSetting, (IListColumnConfig)((IListColumn)childControl));
            ((ListColumnGroup)control).getItems().add(childControl);
        } else if (childControl instanceof ListColumnGroup && control.getKey().equals(((ListColumnGroup)childControl).getParentViewKey())) {
            if (groupKeys.add(childControl.getKey())) {
                ((ListColumnGroup)control).getItems().add(childControl);
                ((ListColumnGroup)childControl).getItems().clear();
            }
            ListColumnGroupConfigUtil.setListColumnGroupSetting((Map)childItemSetting, (IListColumnConfig)((IListColumnConfig)childControl));
            this.popChildColumns(columnStack, childControl, groupKeys);
        }
    }

    private void pushParentListColumnGroup(Stack<Control> columnStack, HashMap<String, ListColumnGroup> listColumnGroupMap, String parentViewKey) {
        ListColumnGroup listColumnGroup = listColumnGroupMap.get(parentViewKey);
        if (listColumnGroup != null) {
            columnStack.push((Control)listColumnGroup);
            this.pushParentListColumnGroup(columnStack, listColumnGroupMap, listColumnGroup.getParentViewKey());
        }
    }
}

