/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.list.CheckFilterPermissionResult;
import kd.bos.list.ColumnMetaFactory;
import kd.bos.list.ColumnServiceContext;
import kd.bos.list.EnhancedFilterField;
import kd.bos.list.ExtendedFlexDimensions;
import kd.bos.list.HeaderFieldNameConverter;
import kd.bos.list.HeaderFilterParameter;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumnCompareServiceHelper;
import kd.bos.list.ListPermissionService;
import kd.bos.list.column.CompareSearchValue;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.list.events.ListColumnFilter;
import kd.bos.list.events.ListColumnFilterCollection;
import kd.bos.list.events.ListRowFilterEvent;
import kd.bos.orm.query.QFilter;

class BillListHeaderFilterParser {
    public static final String ID = "Id";
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE = "Value";
    private static final String LOGIC = "Logic";
    private static final String RIGHT = "Right";
    private static final String COMPARE = "Compare";
    private Map<String, ListColumnFilterCollection> appendingListColumnFilters;
    private List<Map<String, List<Object>>> newFilter;
    private BiFunction<List<IListColumn>, Map<String, FilterField>, HeaderFilterParameter> builderHeaderQFilters;
    private boolean isReset = false;
    private String currentFieldName;
    private AbstractGrid.GridState state;
    private List<Consumer<ListRowFilterEvent>> listRowFilterListeners;
    private MainEntityType entityType;
    private Map<String, List<CompareType>> fieldCompareTypeMap;
    private Map<String, String> fieldKeyMap;
    private Map<String, ExtendedFlexDimensions> extendedFlexDimensionsList;
    private String bizAppId;
    private Long orgId;

    BillListHeaderFilterParser(Map<String, ListColumnFilterCollection> appendingListColumnFilters, AbstractGrid.GridState state, List<Consumer<ListRowFilterEvent>> listRowFilterListeners, MainEntityType entityType, Map<String, List<CompareType>> fieldCompareTypeMap, Map<String, String> fieldKeyMap, String bizAppId, Long orgId) {
        this(appendingListColumnFilters, state, listRowFilterListeners, entityType, fieldCompareTypeMap, fieldKeyMap, new HashMap<String, ExtendedFlexDimensions>(), bizAppId, orgId);
    }

    BillListHeaderFilterParser(Map<String, ListColumnFilterCollection> appendingListColumnFilters, AbstractGrid.GridState state, List<Consumer<ListRowFilterEvent>> listRowFilterListeners, MainEntityType entityType, Map<String, List<CompareType>> fieldCompareTypeMap, Map<String, String> fieldKeyMap, Map<String, ExtendedFlexDimensions> extendedFlexDimensionsList, String bizAppId, Long orgId) {
        this.appendingListColumnFilters = appendingListColumnFilters;
        this.state = state;
        this.listRowFilterListeners = listRowFilterListeners;
        this.entityType = entityType;
        this.fieldCompareTypeMap = fieldCompareTypeMap;
        this.fieldKeyMap = fieldKeyMap;
        this.extendedFlexDimensionsList = extendedFlexDimensionsList;
        this.builderHeaderQFilters = this::builderHeaderQFilters;
        this.bizAppId = bizAppId;
        this.orgId = orgId;
    }

    BiFunction<List<IListColumn>, Map<String, FilterField>, HeaderFilterParameter> getBuilderHeaderQFilters() {
        return this.builderHeaderQFilters;
    }

    Map<String, ListColumnFilterCollection> parse(List<Map<String, List<Object>>> filter) {
        if (filter.get(0).get(VALUE).isEmpty()) {
            this.isReset = true;
        }
        this.currentFieldName = filter.get(0).get(FIELD_NAME).get(0).toString();
        Map<String, ListColumnFilterCollection> appendingListColumnFilters = this.callListRowFilterListener(filter);
        this.newFilter = new ArrayList<Map<String, List<Object>>>();
        if (this.state.getOldCondition() != null) {
            this.newFilter = (List)SerializationUtils.deSerializeFromBase64((String)this.state.getOldCondition());
        }
        this.addOrDeleteCurrentFilter(filter);
        if (!this.newFilter.isEmpty()) {
            this.state.setOldCondition(SerializationUtils.serializeToBase64(this.newFilter));
        } else {
            this.state.setOldCondition(null);
        }
        return appendingListColumnFilters;
    }

    String getRowSortInfo(String columnName, String sortName) {
        HashMap<String, FilterField> flexFilterFields = new HashMap<String, FilterField>(16);
        for (Map.Entry<String, ExtendedFlexDimensions> extendedFlexDimensionsEntry : this.extendedFlexDimensionsList.entrySet()) {
            flexFilterFields.putAll(extendedFlexDimensionsEntry.getValue().getFilterFields());
        }
        HeaderFieldNameConverter headerFieldNameConverter = new HeaderFieldNameConverter(this.fieldKeyMap, this.entityType);
        FilterField columnFilterField = headerFieldNameConverter.getColumnFilterField(columnName, flexFilterFields);
        columnName = columnFilterField.getFullFieldName();
        StringBuilder sb = new StringBuilder();
        if (columnFilterField.getLatestParent() instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)columnFilterField.getLatestParent();
            String typeName = "";
            if (columnFilterField.getSrcFieldProp() instanceof ItemClassProp) {
                typeName = itemClassProp.getTypePropName();
            } else if (columnFilterField.getRefProp1() instanceof ItemClassProp) {
                typeName = columnFilterField.getSrcFieldKey() + "." + itemClassProp.getTypePropName();
            }
            if (StringUtils.isNotBlank((CharSequence)typeName)) {
                FilterField typeFilterField = headerFieldNameConverter.getColumnFilterField(typeName, flexFilterFields);
                sb.append(typeFilterField.getFullFieldName()).append(" ").append(sortName);
                FilterField idFilterField = columnFilterField.convertToId();
                sb.append(",").append(idFilterField.getFullFieldName()).append(" ").append(sortName).append(",id desc");
            }
        } else {
            sb.append(columnName).append(" ").append(sortName).append(",id desc");
        }
        return sb.toString();
    }

    private Map<String, ListColumnFilterCollection> callListRowFilterListener(List<Map<String, List<Object>>> filter) {
        HashMap<String, ListColumnFilterCollection> appendingListColumnFilters = new HashMap<String, ListColumnFilterCollection>(this.appendingListColumnFilters);
        if (!this.isReset) {
            CompareTypeEnum foundCompareTypeEnum = null;
            for (CompareTypeEnum compareTypeEnum : CompareTypeEnum.values()) {
                if (!filter.get(0).get(COMPARE).get(0).toString().equals(compareTypeEnum.getId())) continue;
                foundCompareTypeEnum = compareTypeEnum;
                break;
            }
            String value = filter.get(0).get(VALUE).get(0).toString();
            ArrayList<String> values = new ArrayList<String>(filter.get(0).get(VALUE).size());
            for (Object o : filter.get(0).get(VALUE)) {
                values.add(o.toString());
            }
            ListRowFilterEvent listRowFilterEvent = this.doCallListRowFilterListener(this.currentFieldName, foundCompareTypeEnum, value, values, filter.get(0).get(ID));
            appendingListColumnFilters.put(this.currentFieldName, listRowFilterEvent.getListColumnFilterCollection());
        } else {
            this.doCallListRowFilterListener(this.currentFieldName, null, null, new ArrayList<String>(0), new ArrayList<Object>(0));
            appendingListColumnFilters.remove(this.currentFieldName);
        }
        return appendingListColumnFilters;
    }

    private ListRowFilterEvent doCallListRowFilterListener(String currentFieldName, CompareTypeEnum foundCompareTypeEnum, String value, List<String> values, List<Object> ids) {
        ListRowFilterEvent listRowFilterEvent = new ListRowFilterEvent(this, new ListColumnFilter(currentFieldName, foundCompareTypeEnum, value, values, ids));
        for (Consumer<ListRowFilterEvent> listRowFilterListener : this.listRowFilterListeners) {
            listRowFilterListener.accept(listRowFilterEvent);
        }
        return listRowFilterEvent;
    }

    private void addOrDeleteCurrentFilter(List<Map<String, List<Object>>> filter) {
        for (Map<String, List<Object>> map : filter) {
            String fieldName = map.get(FIELD_NAME).get(0).toString();
            Iterator<Map<String, List<Object>>> iterator = this.newFilter.iterator();
            while (iterator.hasNext()) {
                Map<String, List<Object>> newMap = iterator.next();
                String oldFieldName = newMap.get(FIELD_NAME).get(0).toString();
                if (!fieldName.equals(oldFieldName)) continue;
                iterator.remove();
            }
            if (this.isReset) continue;
            this.newFilter.add(map);
        }
    }

    private Map<String, Map<String, List<Object>>> convertNewFitlerToMap() {
        HashMap<String, Map<String, List<Object>>> map = new HashMap<String, Map<String, List<Object>>>(this.newFilter.size());
        for (Map<String, List<Object>> stringListMap : this.newFilter) {
            map.put(stringListMap.get(FIELD_NAME).get(0).toString(), stringListMap);
        }
        return map;
    }

    private HeaderFilterParameter builderHeaderQFilters(List<IListColumn> showListColumns, Map<String, FilterField> flexFilterFields) {
        HeaderFilterParameter headerFilterParameter = null;
        int size = this.newFilter.size();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(size);
        HashSet<String> selectFieldsWithNotCompare = new HashSet<String>();
        HashSet<String> selectFields = new HashSet<String>();
        Map<String, Map<String, List<Object>>> filterMap = this.convertNewFitlerToMap();
        HashMap normalfilterMap = new HashMap(size);
        HashMap<String, Map<String, List<Object>>> servicefilterMap = new HashMap<String, Map<String, List<Object>>>(size);
        HashMap<String, ColumnServiceContext> listColumnMetaMap = new HashMap<String, ColumnServiceContext>(size);
        for (IListColumn iListColumn : showListColumns) {
            ListColumnMeta listColumnMeta;
            String string = ((Control)iListColumn).getKey();
            Map<String, List<Object>> stringListMap = filterMap.get(string);
            if (stringListMap == null && (!this.isReset || !this.currentFieldName.equals(string)) || (listColumnMeta = ColumnMetaFactory.getListColumnMeta(iListColumn.getClass().getSimpleName())) == null) continue;
            if (stringListMap != null) {
                servicefilterMap.put(string, stringListMap);
            }
            listColumnMetaMap.put(string, new ColumnServiceContext(listColumnMeta, iListColumn.getColumnServiceContext()));
        }
        for (Map.Entry entry : filterMap.entrySet()) {
            if (listColumnMetaMap.containsKey(entry.getKey())) continue;
            normalfilterMap.put(entry.getKey(), entry.getValue());
        }
        HeaderFieldNameConverter headerFieldNameConverter = new HeaderFieldNameConverter(this.fieldKeyMap, this.entityType);
        if (!this.newFilter.isEmpty()) {
            if (!servicefilterMap.isEmpty()) {
                for (Map.Entry entry : servicefilterMap.entrySet()) {
                    Map servicefilter = (Map)entry.getValue();
                    List valueList = (List)servicefilter.get(VALUE);
                    ArrayList<String> values = new ArrayList<String>(valueList.size());
                    valueList.forEach(c -> values.add(c.toString()));
                    ColumnServiceContext columnServiceContext = (ColumnServiceContext)listColumnMetaMap.get(entry.getKey());
                    CompareSearchValue compareSearchValue = new CompareSearchValue(columnServiceContext.getListColumnMeta(), this.entityType.getName(), ((List)servicefilter.get(COMPARE)).get(0).toString(), values);
                    compareSearchValue.setParaMap(columnServiceContext.getParaMap());
                    QFilter qfilter = ListColumnCompareServiceHelper.search(compareSearchValue);
                    if (qfilter == null) continue;
                    filters.add(qfilter);
                }
            }
            if (!normalfilterMap.isEmpty()) {
                FilterObject filterObject = new FilterObject(this.entityType);
                ArrayList<Map<String, List<Object>>> arrayList = new ArrayList<Map<String, List<Object>>>();
                for (Map map : normalfilterMap.values()) {
                    this.appendPluginFilter(arrayList, filterObject, map, flexFilterFields, headerFieldNameConverter);
                }
                FilterBuilder filterBuilder = new FilterBuilder(this.entityType, filterObject);
                filterBuilder.setFieldCompareTypeMap(this.fieldCompareTypeMap);
                filterBuilder.setSchemeSetting(arrayList, true);
                filterBuilder.buildFilter();
                selectFields.addAll(filterObject.getSelectFields());
                selectFieldsWithNotCompare.addAll(filterObject.getSelectFieldsWithNotCompare());
                CheckFilterPermissionResult checkFilterPermissionResult = this.checkFilterPermission(new ArrayList<String>(selectFields));
                Set<String> cannotReadFilterNames = BillListHeaderFilterParser.getCannotReadFilterNames(showListColumns, checkFilterPermissionResult);
                headerFilterParameter = new HeaderFilterParameter(selectFields, selectFieldsWithNotCompare, checkFilterPermissionResult, cannotReadFilterNames);
                if (filterBuilder.getQFilter() != null) {
                    filters.add(filterBuilder.getQFilter());
                }
            }
        }
        if (this.isReset && listColumnMetaMap.get(this.currentFieldName) == null) {
            String string = headerFieldNameConverter.getRealFilterName(this.currentFieldName, flexFilterFields);
            selectFieldsWithNotCompare.remove(string);
            selectFields.remove(string);
            CheckFilterPermissionResult checkFilterPermissionResult = this.checkFilterPermission(new ArrayList<String>(selectFields));
            Set<String> cannotReadFilterNames = BillListHeaderFilterParser.getCannotReadFilterNames(showListColumns, checkFilterPermissionResult);
            headerFilterParameter = new HeaderFilterParameter(selectFields, selectFieldsWithNotCompare, checkFilterPermissionResult, cannotReadFilterNames);
        }
        if (!filters.isEmpty()) {
            this.state.setColumnQFilter(SerializationUtils.serializeToBase64(filters));
        } else {
            this.state.setColumnQFilter(null);
        }
        return headerFilterParameter;
    }

    private static Set<String> getCannotReadFilterNames(List<IListColumn> showListColumns, CheckFilterPermissionResult checkFilterPermissionResult) {
        HashSet<String> finalNames = new HashSet<String>(16);
        if (!checkFilterPermissionResult.isHasFieldPermission()) {
            HashMap<String, LocaleString> nameMap = new HashMap<String, LocaleString>(16);
            for (IListColumn listColumn : showListColumns) {
                if (!StringUtils.isNotBlank((CharSequence)listColumn.getListFieldKey())) continue;
                nameMap.put(listColumn.getListFieldKey(), listColumn.getCaption());
            }
            for (String filterName : checkFilterPermissionResult.getHasNotFieldPermissionFields()) {
                LocaleString name = (LocaleString)nameMap.get(filterName);
                if (name == null || name.toString() == null) continue;
                finalNames.add(name.toString());
            }
        }
        return finalNames;
    }

    private CheckFilterPermissionResult checkFilterPermission(List<String> filterNames) {
        return ListPermissionService.checkFilterPermission(filterNames, this.bizAppId, (EntityType)this.entityType, this.orgId);
    }

    private void appendPluginFilter(List<Map<String, List<Object>>> mergeFilters, FilterObject filterObject, Map<String, List<Object>> map, Map<String, FilterField> filterFields, HeaderFieldNameConverter headerFieldNameConverter) {
        String orgFieldName = map.get(FIELD_NAME).get(0).toString();
        String newFieldName = headerFieldNameConverter.getRealFilterName(orgFieldName, filterFields);
        ArrayList<String> fieldNameList = new ArrayList<String>();
        fieldNameList.add(newFieldName);
        FilterField thisFilterField = EnhancedFilterField.getOrCreateFilterField(this.entityType, newFieldName, filterFields);
        ListColumnFilterCollection listColumnFilterCollection = this.appendingListColumnFilters.get(orgFieldName);
        HashMap<String, List<Object>> fMap = new HashMap<String, List<Object>>();
        fMap.put(FIELD_NAME, fieldNameList);
        List<Object> values = map.get(VALUE);
        fMap.put(VALUE, values);
        List<Object> ids = map.get(ID);
        if (thisFilterField != null && (ids != null && ids.size() > 1 || values != null && values.size() > 1)) {
            ArrayList<String> compareList = new ArrayList<String>();
            compareList.add(thisFilterField.getDefaultMultiCompareTypeId());
            fMap.put(COMPARE, compareList);
        } else {
            fMap.put(COMPARE, map.get(COMPARE));
        }
        fMap.put(ID, ids);
        mergeFilters.add(fMap);
        if (this.isListColumnFilterCollectionEmpty(listColumnFilterCollection)) {
            ArrayList<String> leftList = new ArrayList<String>(1);
            ArrayList<String> rightList = new ArrayList<String>(1);
            ArrayList<Integer> logicList = new ArrayList<Integer>(1);
            leftList.add("(");
            logicList.add(LogicOperate.OR.getValue());
            fMap.put("Left", leftList);
            fMap.put(LOGIC, logicList);
            ArrayList<Integer> lastRowLogicList = new ArrayList<Integer>();
            lastRowLogicList.add(LogicOperate.AND.getValue());
            rightList.add(")");
            List<Map<String, List<Object>>> listColumnListMapFilters = listColumnFilterCollection.getListColumnListMapFilters();
            int index = listColumnFilterCollection.getlistColumnFilters().size() - 1;
            listColumnListMapFilters.get(index).put(RIGHT, rightList);
            listColumnListMapFilters.get(index).put(LOGIC, lastRowLogicList);
            mergeFilters.addAll(listColumnListMapFilters);
        }
        for (Map<String, List<Object>> mergeFilter : mergeFilters) {
            FilterField filterField = EnhancedFilterField.getOrCreateFilterField(this.entityType, mergeFilter.get(FIELD_NAME).get(0).toString(), filterFields);
            if (filterField == null) continue;
            filterObject.addField(filterField);
        }
    }

    private boolean isListColumnFilterCollectionEmpty(ListColumnFilterCollection listColumnFilterCollection) {
        return listColumnFilterCollection != null && !listColumnFilterCollection.getlistColumnFilters().isEmpty();
    }
}

