/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.LongProp;
import kd.bos.form.control.AbstractGrid;
import kd.bos.list.BillList;
import kd.bos.list.BillListSelection;
import kd.bos.list.ListCache;
import kd.bos.utils.SortUtil;

class BillListSelectedRowsParser {
    private static final String CLEAR_DATA = "clearData";
    private static final String IS_ROLL_LOADING = "isRollLoading";
    private ListCache listCache;
    private BillListSelection billListSelection;
    private boolean isMergeRow;
    private boolean isMultiSelect;
    private boolean clearPageRowCache;
    private BillList billList;

    private AbstractGrid.GridState getEntryState() {
        return this.billList.getEntryState();
    }

    private EntityType getEntityType() {
        return this.billList.getEntityType();
    }

    private ListSelectedRowCollection getListShowParameterSelectedRows() {
        return this.billList.getListShowParameterSelectedRows();
    }

    BillListSelectedRowsParser(ListCache listCache, BillListSelection billListSelection, boolean isMergeRow, boolean isMultiSelect, boolean clearPageRowCache, BillList billList) {
        this.listCache = listCache;
        this.billListSelection = billListSelection;
        this.isMergeRow = isMergeRow;
        this.isMultiSelect = isMultiSelect;
        this.clearPageRowCache = clearPageRowCache;
        this.billList = billList;
    }

    ListSelectedRowCollection initSelectedRows(ListSelectedRowCollection inCachedSelectedRows, ListSelectedRowCollection pageSelectedRows, ListSelectedRowCollection pageAllRows) {
        AbstractGrid.GridState gridState = this.getEntryState();
        ListSelectedRowCollection cachedSelectedRows = this.listCache.getCachedSelectedRows();
        if (this.isMultiSelect && gridState.get(IS_ROLL_LOADING) == null) {
            ListSelectedRowCollection currentPageSelectedRows = pageSelectedRows != null ? pageSelectedRows : this.billListSelection.getCurrentPageSelectedRows();
            LinkedHashSet<ListSelectedRow> listSelectedRowSet = new LinkedHashSet<ListSelectedRow>(inCachedSelectedRows.size() + cachedSelectedRows.size() + currentPageSelectedRows.size());
            ListSelectedRowCollection currentListAllRows = pageAllRows != null ? pageAllRows : this.billList.getCurrentListAllRowCollection();
            Set<ListSelectedRow> currentPageSelectedRowSet = this.getListSelectedRowSet(currentPageSelectedRows);
            Set<ListSelectedRow> currentListAllRowsSet = this.getListSelectedRowSet(currentListAllRows);
            Set<Object> currentPagePkIdSet = this.getPkIdSet(currentPageSelectedRows);
            AbstractGrid.GridState entryState = this.getEntryState();
            ListSelectedRowCollection listNotSelectedRowCollection = new ListSelectedRowCollection();
            HashSet<ListSelectedRow> listNotSelectedRowSet = new HashSet<ListSelectedRow>(16);
            HashSet<Object> listNotSelectedPkSet = new HashSet<Object>(16);
            if (entryState.isSelectAllRows()) {
                this.selectAllListNotSelected(this.isMergeRow, currentPageSelectedRowSet, currentPagePkIdSet, currentListAllRows, listNotSelectedRowSet, listNotSelectedPkSet);
            } else {
                for (ListSelectedRow listSelectedRow : currentListAllRows) {
                    if (!(this.isMergeRow || currentPageSelectedRowSet.contains(listSelectedRow) || listNotSelectedRowSet.contains(listSelectedRow))) {
                        listNotSelectedRowCollection.add((Object)listSelectedRow);
                        listNotSelectedRowSet.add(listSelectedRow);
                        continue;
                    }
                    if (!this.isMergeRow || currentPagePkIdSet.contains(listSelectedRow.getPrimaryKeyValue()) || listNotSelectedRowSet.contains(listSelectedRow.getPrimaryKeyValue())) continue;
                    listNotSelectedRowCollection.add((Object)listSelectedRow);
                    listNotSelectedPkSet.add(listSelectedRow.getPrimaryKeyValue());
                    listNotSelectedRowSet.add(listSelectedRow);
                }
            }
            for (ListSelectedRow listSelectedRow : inCachedSelectedRows) {
                if ((this.isMergeRow || listNotSelectedRowSet.contains(listSelectedRow)) && (!this.isMergeRow || listNotSelectedPkSet.contains(listSelectedRow.getPrimaryKeyValue()))) continue;
                listSelectedRowSet.add(listSelectedRow);
            }
            for (ListSelectedRow listSelectedRow : cachedSelectedRows) {
                if ((this.isMergeRow || listNotSelectedRowSet.contains(listSelectedRow)) && (!this.isMergeRow || listNotSelectedPkSet.contains(listSelectedRow.getPrimaryKeyValue()))) continue;
                listSelectedRowSet.add(listSelectedRow);
            }
            ListSelectedRowCollection currentPageRemoveSelectedRows = new ListSelectedRowCollection();
            boolean isRemoveCurrentRow = true;
            for (Object listSelectedRow : inCachedSelectedRows) {
                if (currentListAllRowsSet.contains(listSelectedRow)) continue;
                isRemoveCurrentRow = false;
                break;
            }
            for (Object listSelectedRow : cachedSelectedRows) {
                if (currentListAllRowsSet.contains(listSelectedRow)) continue;
                isRemoveCurrentRow = false;
                break;
            }
            if (isRemoveCurrentRow) {
                for (Object listSelectedRow : this.listCache.getCurrentCachedSelectedRows()) {
                    if (currentPageSelectedRowSet.contains(listSelectedRow)) continue;
                    currentPageRemoveSelectedRows.add(listSelectedRow);
                }
            }
            for (Object listSelectedRow : currentPageRemoveSelectedRows) {
                listSelectedRowSet.remove(listSelectedRow);
            }
            ListSelectedRowCollection currentCachedSelectedRows = new ListSelectedRowCollection();
            for (ListSelectedRow listSelectedRow : currentListAllRows) {
                if (listNotSelectedRowSet.contains(listSelectedRow)) continue;
                currentCachedSelectedRows.add((Object)listSelectedRow);
            }
            if (currentListAllRows.size() > currentCachedSelectedRows.size() && entryState.isSelectAllRows()) {
                entryState.setSelectAllRows(false);
            }
            ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
            listSelectedRowCollection.addAll(listSelectedRowSet);
            this.listCache.putCurrentCachedSelectedRows(currentCachedSelectedRows);
            this.listCache.putCachedSelectedRows(listSelectedRowCollection);
            return listSelectedRowCollection;
        }
        return cachedSelectedRows;
    }

    private Set<Object> getPkIdSet(ListSelectedRowCollection currentListSelectedRowCollection) {
        HashSet<Object> currentPkIdSet = new HashSet<Object>(16);
        for (ListSelectedRow listSelectedRow : currentListSelectedRowCollection) {
            currentPkIdSet.add(listSelectedRow.getPrimaryKeyValue());
        }
        return currentPkIdSet;
    }

    private Set<ListSelectedRow> getListSelectedRowSet(ListSelectedRowCollection currentListSelectedRowCollection) {
        HashSet<ListSelectedRow> currentPkSet = new HashSet<ListSelectedRow>(16);
        for (ListSelectedRow listSelectedRow : currentListSelectedRowCollection) {
            currentPkSet.add(listSelectedRow);
        }
        return currentPkSet;
    }

    private void selectAllListNotSelected(boolean isMergeRow, Set<ListSelectedRow> currentPageSelectedRowSet, Set<Object> currentPagePkIdSet, ListSelectedRowCollection currentListAllRowCollection, Set<ListSelectedRow> listNotSelectedRowSet, Set<Object> listNotSelectedPkSet) {
        ListSelectedRowCollection listNotSelectedRowCollection = this.listCache.getCachedNotSelectedRows();
        listNotSelectedRowSet.addAll(this.getListSelectedRowSet(listNotSelectedRowCollection));
        listNotSelectedPkSet.addAll(this.getPkIdSet(listNotSelectedRowCollection));
        for (ListSelectedRow listSelectedRow : currentListAllRowCollection) {
            if ((isMergeRow || !listNotSelectedRowSet.contains(listSelectedRow)) && (!isMergeRow || !listNotSelectedPkSet.contains(listSelectedRow.getPrimaryKeyValue()))) continue;
            listNotSelectedRowCollection.remove((Object)listSelectedRow);
            listNotSelectedRowSet.remove(listSelectedRow);
        }
        for (ListSelectedRow listSelectedRow : currentListAllRowCollection) {
            if ((isMergeRow || currentPageSelectedRowSet.contains(listSelectedRow) || listNotSelectedRowSet.contains(listSelectedRow)) && (!isMergeRow || currentPagePkIdSet.contains(listSelectedRow.getPrimaryKeyValue()) || listNotSelectedPkSet.contains(listSelectedRow.getPrimaryKeyValue()))) continue;
            listNotSelectedRowSet.add(listSelectedRow);
            listNotSelectedPkSet.add(listSelectedRow.getPrimaryKeyValue());
        }
        this.listCache.putCachedNotSelectedRows(listNotSelectedRowCollection);
    }

    void loadNotExistsSelectedRows() {
        QueryResult queryResult;
        ListSelectedRowCollection cachedSelectedRows = this.listCache.getCachedSelectedRows();
        ListSelectedRowCollection noCurrentListShowParameterSelectedRowCollection = this.getNoCurrentListShowParameterSelectedRowCollection(cachedSelectedRows);
        if (!noCurrentListShowParameterSelectedRowCollection.isEmpty() && (queryResult = this.queryDataBySelectedRows(noCurrentListShowParameterSelectedRowCollection)) != null) {
            ListSelectedRowCollection allListSelectedRow = this.getAllListSelectedRow(queryResult.getCollection());
            Map<String, List<ListSelectedRow>> listSelectedRowMap = this.getListSelectedRowMap(cachedSelectedRows, allListSelectedRow);
            ListSelectedRowCollection enrichedListShowParameterSelectedRowCollection = this.getEnrichedListShowParameterSelectedRowCollection(listSelectedRowMap);
            this.listCache.putCachedSelectedRows(SortUtil.getSortedNewListSelectRowCollection((ListSelectedRowCollection)cachedSelectedRows, this.getSortKeys(enrichedListShowParameterSelectedRowCollection), t -> t.keyString()));
        }
    }

    private QueryResult queryDataBySelectedRows(ListSelectedRowCollection noCurrentListShowParameterSelectedRowCollection) {
        return this.billList.queryDataBySelectedRows(noCurrentListShowParameterSelectedRowCollection);
    }

    private ListSelectedRowCollection getEnrichedListShowParameterSelectedRowCollection(Map<String, List<ListSelectedRow>> listSelectedRowMap) {
        ListSelectedRowCollection enrichedListShowParameterSelectedRowCollection = new ListSelectedRowCollection();
        for (ListSelectedRow listSelectedRow : this.getListShowParameterSelectedRows()) {
            if (listSelectedRow.getPrimaryKeyValue() == null || !listSelectedRowMap.containsKey(listSelectedRow.getPrimaryKeyValue().toString())) continue;
            enrichedListShowParameterSelectedRowCollection.addAll((Collection)listSelectedRowMap.get(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        return enrichedListShowParameterSelectedRowCollection;
    }

    private Map<String, List<ListSelectedRow>> getListSelectedRowMap(ListSelectedRowCollection cachedSelectedRows, ListSelectedRowCollection allListSelectedRow) {
        HashMap<String, List<ListSelectedRow>> listSelectedRowMap = new HashMap<String, List<ListSelectedRow>>();
        HashSet<ListSelectedRow> cachedSelectedRowSet = new HashSet<ListSelectedRow>(16);
        HashSet<Object> cachedSelectedRowPkSet = new HashSet<Object>(16);
        for (ListSelectedRow listSelectedRow : cachedSelectedRows) {
            if (!this.isMergeRow) {
                cachedSelectedRowSet.add(listSelectedRow);
            } else {
                cachedSelectedRowPkSet.add(listSelectedRow.getPrimaryKeyValue());
            }
            this.putListSelectedRowMap(listSelectedRowMap, listSelectedRow);
        }
        for (ListSelectedRow listSelectedRow : allListSelectedRow) {
            if (!this.isMergeRow && !cachedSelectedRowSet.contains(listSelectedRow)) {
                cachedSelectedRows.add((Object)listSelectedRow);
                cachedSelectedRowSet.add(listSelectedRow);
                this.putListSelectedRowMap(listSelectedRowMap, listSelectedRow);
                continue;
            }
            if (!this.isMergeRow || cachedSelectedRowPkSet.contains(listSelectedRow.getPrimaryKeyValue())) continue;
            cachedSelectedRows.add((Object)listSelectedRow);
            cachedSelectedRowPkSet.add(listSelectedRow.getPrimaryKeyValue());
            this.putListSelectedRowMap(listSelectedRowMap, listSelectedRow);
        }
        return listSelectedRowMap;
    }

    ListSelectedRowCollection restoreSelection(ListSelectedRowCollection alListSelectedRows) {
        ArrayList<Integer> pkRowKeys = new ArrayList<Integer>();
        AbstractGrid.GridState entryState = this.getEntryState();
        ListSelectedRowCollection currentListSelectedRowCollection = new ListSelectedRowCollection();
        ListSelectedRowCollection listSelectedRowCollection = this.listCache.getCachedSelectedRows();
        ListSelectedRowCollection listNotSelectedRowCollection = this.listCache.getCachedNotSelectedRows();
        HashMap<String, List<ListSelectedRow>> listSelectedRowMap = new HashMap<String, List<ListSelectedRow>>();
        ListSelectedRowCollection newListSelectdRowCollection = this.checkCurrentPageSelectedRows(alListSelectedRows, pkRowKeys, currentListSelectedRowCollection, listSelectedRowCollection, listNotSelectedRowCollection, this.isMergeRow, listSelectedRowMap);
        ListSelectedRowCollection enrichedListShowParameterSelectedRowCollection = this.getEnrichedListShowParameterSelectedRowCollection(listSelectedRowMap);
        this.keepOtherPageSelectedRows(entryState, currentListSelectedRowCollection, newListSelectdRowCollection, listSelectedRowCollection);
        this.listCache.putCurrentCachedSelectedRows(currentListSelectedRowCollection);
        if (entryState.get(CLEAR_DATA) == null || entryState.get(CLEAR_DATA) != null && !Boolean.parseBoolean(entryState.get(CLEAR_DATA).toString())) {
            Set<ListSelectedRow> pkSet = this.getListSelectedRowSet(currentListSelectedRowCollection);
            for (ListSelectedRow listSelectedRow : this.listCache.getAppendCachedSelectedRows()) {
                if (pkSet.contains(listSelectedRow)) continue;
                pkSet.add(listSelectedRow);
                currentListSelectedRowCollection.add((Object)listSelectedRow);
            }
        }
        ListSelectedRowCollection sortedNewListSelectdRowCollection = !enrichedListShowParameterSelectedRowCollection.isEmpty() ? SortUtil.getSortedNewListSelectRowCollection((ListSelectedRowCollection)newListSelectdRowCollection, this.getSortKeys(enrichedListShowParameterSelectedRowCollection), t -> t.keyString()) : SortUtil.getSortedNewListSelectRowCollection((ListSelectedRowCollection)newListSelectdRowCollection, this.getSortKeys(listSelectedRowCollection), t -> t.keyString());
        this.listCache.putAppendCachedSelectedRows(currentListSelectedRowCollection);
        this.listCache.putCachedSelectedRows(sortedNewListSelectdRowCollection);
        this.invokeSelectRowsByServer(pkRowKeys);
        if (!entryState.isKeepPageData()) {
            this.billList.clearSelectedAllState();
        }
        return sortedNewListSelectdRowCollection;
    }

    private List<String> getSortKeys(ListSelectedRowCollection enrichedListShowParameterSelectedRowCollection) {
        ArrayList<String> sortKeys = new ArrayList<String>();
        for (ListSelectedRow listSelectedRow : enrichedListShowParameterSelectedRowCollection) {
            sortKeys.add(listSelectedRow.keyString());
        }
        return sortKeys;
    }

    private void invokeSelectRowsByServer(List<Integer> pkRowKeys) {
        int[] selectedRowKeys = new int[pkRowKeys.size()];
        int i = 0;
        for (Integer rowKey : pkRowKeys) {
            selectedRowKeys[i++] = rowKey;
        }
        if (selectedRowKeys.length > 0) {
            this.billList.selectRows(selectedRowKeys);
        }
    }

    private void keepOtherPageSelectedRows(AbstractGrid.GridState entryState, ListSelectedRowCollection currentListSelectedRowCollection, ListSelectedRowCollection newListSelectdRowCollection, ListSelectedRowCollection listSelectedRowCollection) {
        if (entryState.isKeepPageData()) {
            Set<ListSelectedRow> listSelectedRowSet = this.getListSelectedRowSet(currentListSelectedRowCollection);
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                if (listSelectedRowSet.contains(listSelectedRow)) continue;
                if (this.clearPageRowCache) {
                    listSelectedRow.setRowKey(-1);
                }
                newListSelectdRowCollection.add((Object)listSelectedRow);
            }
        }
    }

    private ListSelectedRowCollection checkCurrentPageSelectedRows(ListSelectedRowCollection alListSelectedRows, List<Integer> pkRowKeys, ListSelectedRowCollection currentListSelectedRowCollection, ListSelectedRowCollection listSelectedRowCollection, ListSelectedRowCollection listNotSelectedRowCollection, boolean mergeRow, Map<String, List<ListSelectedRow>> listSelectedRowMap) {
        ListSelectedRowCollection newListSelectdRowCollection = new ListSelectedRowCollection();
        Set<ListSelectedRow> currentPkSet = this.getListSelectedRowSet(currentListSelectedRowCollection);
        Set<ListSelectedRow> newPkSet = this.getListSelectedRowSet(newListSelectdRowCollection);
        Set<ListSelectedRow> listPkSet = this.getListSelectedRowSet(listSelectedRowCollection);
        Set<ListSelectedRow> listNotPkSet = this.getListSelectedRowSet(listNotSelectedRowCollection);
        Set<Object> listPkIdSet = this.getPkIdSet(listSelectedRowCollection);
        Set<Object> listShowParemeterPkIdSet = this.getPkIdSet(this.getListShowParameterSelectedRows());
        for (ListSelectedRow listSelectedRow : alListSelectedRows) {
            boolean selectedAllRowChecked;
            boolean bl = selectedAllRowChecked = !mergeRow && !listNotPkSet.contains(listSelectedRow) && listPkSet.contains(listSelectedRow) || mergeRow && listPkIdSet.contains(listSelectedRow.getPrimaryKeyValue()) || listShowParemeterPkIdSet.contains(listSelectedRow.getPrimaryKeyValue());
            if (selectedAllRowChecked) {
                pkRowKeys.add(listSelectedRow.getRowKey());
                if (!currentPkSet.contains(listSelectedRow)) {
                    currentListSelectedRowCollection.add((Object)listSelectedRow);
                    currentPkSet.add(listSelectedRow);
                }
                if (!newPkSet.contains(listSelectedRow)) {
                    newListSelectdRowCollection.add((Object)listSelectedRow);
                    newPkSet.add(listSelectedRow);
                }
            }
            this.putListSelectedRowMap(listSelectedRowMap, listSelectedRow);
        }
        return newListSelectdRowCollection;
    }

    private void putListSelectedRowMap(Map<String, List<ListSelectedRow>> listSelectedRowMap, ListSelectedRow listSelectedRow) {
        if (listSelectedRow.getPrimaryKeyValue() == null) {
            return;
        }
        List<ListSelectedRow> listSelectedRows = new ArrayList<ListSelectedRow>();
        if (listSelectedRowMap.containsKey(listSelectedRow.getPrimaryKeyValue().toString())) {
            listSelectedRows = listSelectedRowMap.get(listSelectedRow.getPrimaryKeyValue().toString());
        }
        listSelectedRows.add(listSelectedRow);
        listSelectedRowMap.put(listSelectedRow.getPrimaryKeyValue().toString(), listSelectedRows);
    }

    private ListSelectedRowCollection getNoCurrentListShowParameterSelectedRowCollection(ListSelectedRowCollection cachedSelectedRows) {
        ListSelectedRowCollection noCurrentListShowParameterSelectedRowCollection = new ListSelectedRowCollection();
        Set<Object> cachedSelectedRowPkSet = this.getPkIdSet(cachedSelectedRows);
        for (ListSelectedRow listSelectedRow : this.getListShowParameterSelectedRows()) {
            if (cachedSelectedRowPkSet.contains(listSelectedRow.getPrimaryKeyValue())) continue;
            noCurrentListShowParameterSelectedRowCollection.add((Object)listSelectedRow);
        }
        return noCurrentListShowParameterSelectedRowCollection;
    }

    ListSelectedRow getCurrentSelectedRowInfo() {
        AbstractGrid.GridState gridState = this.getEntryState();
        ListSelectedRowCollection listSelectedRowCollection = this.isMultiSelect && gridState.get(IS_ROLL_LOADING) == null && !this.billList.isPC1WPageRows(gridState) ? this.billListSelection.getCurrentPageSelectedRows() : this.listCache.getCachedSelectedRows();
        if (listSelectedRowCollection != null) {
            int focusRow = this.getEntryState().getFocusRow();
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                if (focusRow != listSelectedRow.getRowKey()) continue;
                return listSelectedRow;
            }
        }
        return this.billListSelection.getFocusRow();
    }

    ListSelectedRowCollection getAllListSelectedRow(DynamicObjectCollection rowCollection) {
        List pkFields = this.billList.getListModel().getProvider().getPKFields();
        int rowIndex = this.billList.getStartLine();
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        if (rowCollection == null) {
            return listSelectedRows;
        }
        ListField pkField = (ListField)pkFields.get(0);
        if (!EntityTypeUtil.isContainPropertyName((DynamicObjectType)rowCollection.getDynamicObjectType(), (String)pkField.getFieldName())) {
            return listSelectedRows;
        }
        Map keyMap = EntityTypeUtil.getKeyFields((MainEntityType)((MainEntityType)this.getEntityType()));
        for (DynamicObject row : rowCollection) {
            ListSelectedRow listSelectedRow = null;
            Object value = row.get(pkField.getFieldName());
            Object newValue = this.billListSelection.convertPkValue(pkField, value);
            if (this.getEntityType() instanceof QueryEntityType) {
                listSelectedRow = new ListSelectedRow(newValue, Boolean.valueOf(pkField.getSrcFieldProp() instanceof LongProp));
                Object mainEntitykeyValue = row.get(pkField.getFieldName());
                Object mainEntityPrimayKeyValue = this.billListSelection.convertPkValue(pkField, mainEntitykeyValue);
                listSelectedRow.setQueryEntityPrimayKeyValue(mainEntityPrimayKeyValue);
            } else {
                listSelectedRow = new ListSelectedRow(newValue, Boolean.valueOf(pkField.getSrcFieldProp() instanceof LongProp));
                this.setEntryPrimaryKeyValue(pkFields, this.billListSelection, listSelectedRow, row);
                this.setSubEntryPrimaryKeyValue(pkFields, this.billListSelection, listSelectedRow, row);
            }
            Map<String, String> cachedFieldKeys = this.getExistsFieldKeys(keyMap, rowCollection.getDynamicObjectType());
            this.fillListSelectedRow(keyMap, row, listSelectedRow, cachedFieldKeys);
            listSelectedRow.setRowKey(rowIndex++);
            listSelectedRow.setPageIndex(this.getEntryState().getCurrentPageIndex().intValue());
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }

    private Map<String, String> getExistsFieldKeys(Map<String, String> keyMap, DynamicObjectType dynamicObjectType) {
        HashMap<String, String> existsFieldKeys = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            String fullKey = entry.getValue();
            String[] keys = fullKey.split("\\.");
            if (!EntityTypeUtil.isContainPropertyName((DynamicObjectType)dynamicObjectType, (String)keys[0])) continue;
            existsFieldKeys.put(fullKey, keys[0]);
        }
        return existsFieldKeys;
    }

    private void fillListSelectedRow(Map<String, String> keyMap, DynamicObject row, ListSelectedRow listSelectedRow, Map<String, String> cachedFieldKeys) {
        block16: for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            String fieldKey = cachedFieldKeys.get(entry.getValue());
            if (fieldKey == null || !row.getDataEntityType().getProperties().containsKey((Object)fieldKey)) continue;
            switch (entry.getKey()) {
                case "number": {
                    String[] numbersplit = entry.getValue().split("\\.");
                    if (numbersplit.length > 1) {
                        DynamicObject dynamicObject = row.getDynamicObject(fieldKey);
                        if (dynamicObject == null) continue block16;
                        listSelectedRow.setNumber(dynamicObject.getString(numbersplit[1]));
                        break;
                    }
                    listSelectedRow.setNumber(row.getString(fieldKey));
                    break;
                }
                case "name": {
                    String[] namesplit = entry.getValue().split("\\.");
                    if (namesplit.length > 1) {
                        DynamicObject dynamicObject = row.getDynamicObject(fieldKey);
                        if (dynamicObject == null) continue block16;
                        listSelectedRow.setName(dynamicObject.getString(namesplit[1]));
                        break;
                    }
                    listSelectedRow.setName(row.getString(fieldKey));
                    break;
                }
                case "billNo": {
                    listSelectedRow.setBillNo(row.getString(fieldKey));
                    break;
                }
                case "billStatus": {
                    listSelectedRow.setBillStatus(row.getString(fieldKey));
                    break;
                }
                case "billType": {
                    listSelectedRow.setBillTypeID(Long.valueOf(row.getLong(fieldKey + "_id")));
                    break;
                }
                case "mainOrgId": {
                    listSelectedRow.setMainOrgId(row.getLong(fieldKey + "_id"));
                    break;
                }
            }
        }
    }

    private void setEntryPrimaryKeyValue(List<ListField> pkFields, BillListSelection billListSelection, ListSelectedRow listSelectedRow, DynamicObject row) {
        if (pkFields.size() > 1) {
            ListField pkField = pkFields.get(1);
            if (EntityTypeUtil.isContainPropertyName((DynamicObjectType)row.getDynamicObjectType(), (String)pkField.getFieldName())) {
                Object value = row.get(pkField.getFieldName());
                Object newValue = billListSelection.convertPkValue(pkField, value);
                listSelectedRow.setEntryPrimaryKeyValue(newValue);
                listSelectedRow.setEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
        }
    }

    private void setSubEntryPrimaryKeyValue(List<ListField> pkFields, BillListSelection billListSelection, ListSelectedRow listSelectedRow, DynamicObject row) {
        if (pkFields.size() > 2) {
            ListField pkField = pkFields.get(2);
            if (EntityTypeUtil.isContainPropertyName((DynamicObjectType)row.getDynamicObjectType(), (String)pkField.getFieldName())) {
                Object value = row.get(pkField.getFieldName());
                Object newValue = billListSelection.convertPkValue(pkField, value);
                listSelectedRow.setSubEntryPrimaryKeyValue(newValue);
                listSelectedRow.setSubEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
        }
    }

    void cacheCurrentSelectedRows(ListSelectedRowCollection cachedSelectedRows, ListSelectedRowCollection currentPageSelectedRows, ListSelectedRowCollection appendSelectedRows) {
        if (this.isMultiSelect && this.getEntryState().get(IS_ROLL_LOADING) == null) {
            this.cacheCurrentSelectedRows(cachedSelectedRows, currentPageSelectedRows);
        } else {
            this.cacheRollLoadingSelectedRows(cachedSelectedRows, currentPageSelectedRows, appendSelectedRows);
        }
    }

    private void cacheCurrentSelectedRows(ListSelectedRowCollection cachedSelectedRows, ListSelectedRowCollection currentPageSelectedRows) {
        this.listCache.putCurrentCachedSelectedRows(currentPageSelectedRows);
        Set<ListSelectedRow> pkSet = this.getListSelectedRowSet(cachedSelectedRows);
        for (ListSelectedRow listSelectedRow : currentPageSelectedRows) {
            if (!pkSet.add(listSelectedRow)) continue;
            cachedSelectedRows.add((Object)listSelectedRow);
        }
        this.listCache.putCachedSelectedRows(cachedSelectedRows);
    }

    private void cacheRollLoadingSelectedRows(ListSelectedRowCollection cachedSelectedRows, ListSelectedRowCollection currentPageSelectedRows, ListSelectedRowCollection appendSelectedRows) {
        ListSelectedRowCollection sortedNewListSelectRowCollection = new ListSelectedRowCollection();
        sortedNewListSelectRowCollection.addAll((Collection)currentPageSelectedRows);
        if (this.isMultiSelect) {
            this.listCache.putAppendCachedSelectedRows(currentPageSelectedRows);
            ListSelectedRowCollection notLoadSelectedRows = new ListSelectedRowCollection();
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (ListSelectedRow listSelectedRow : cachedSelectedRows) {
                sortKeys.add(listSelectedRow.keyString());
                if (appendSelectedRows.contains((Object)listSelectedRow)) continue;
                notLoadSelectedRows.add((Object)listSelectedRow);
            }
            sortedNewListSelectRowCollection.addAll(0, (Collection)notLoadSelectedRows);
            sortedNewListSelectRowCollection = SortUtil.getSortedNewListSelectRowCollection((ListSelectedRowCollection)sortedNewListSelectRowCollection, sortKeys, t -> t.toString());
        }
        this.listCache.putCachedSelectedRows(sortedNewListSelectRowCollection);
    }

    List<Integer> cacheSelection(Predicate<ListSelectedRow> predicate) {
        ListSelectedRowCollection listSelectedRowCollection = this.listCache.getCachedSelectedRows();
        ListSelectedRowCollection newListSelectedRowCollection = new ListSelectedRowCollection();
        if (listSelectedRowCollection.isEmpty()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> pkRowKeys = new ArrayList<Integer>(10);
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            if (!predicate.test(listSelectedRow)) continue;
            newListSelectedRowCollection.add((Object)listSelectedRow);
        }
        ListSelectedRowCollection currentListSelectedRowCollection = new ListSelectedRowCollection();
        AbstractGrid.GridState gridState = this.getEntryState();
        if (this.isMultiSelect && gridState.get(IS_ROLL_LOADING) == null) {
            ListSelectedRowCollection currentCachedSelectedRows = this.listCache.getCurrentCachedSelectedRows();
            for (ListSelectedRow listSelectedRow : currentCachedSelectedRows) {
                if (!predicate.test(listSelectedRow)) continue;
                pkRowKeys.add(listSelectedRow.getRowKey());
                currentListSelectedRowCollection.add((Object)listSelectedRow);
            }
        }
        this.listCache.putCachedSelectedRows(newListSelectedRowCollection);
        this.listCache.putCurrentCachedSelectedRows(currentListSelectedRowCollection);
        this.billList.setSelectedRowCollection(newListSelectedRowCollection);
        return pkRowKeys;
    }

    List<Integer> cacheScrolledSelection(Predicate<ListSelectedRow> notContainsRow, List<Integer> rowKeys, Boolean isRollLoading) {
        ListSelectedRowCollection listSelectedRowCollection = this.listCache.getCachedSelectedRowsByPart(rowKeys.toArray(new Integer[0]));
        ListSelectedRowCollection newListSelectedRowCollection = new ListSelectedRowCollection();
        if (listSelectedRowCollection.isEmpty()) {
            return new ArrayList<Integer>();
        }
        int size = listSelectedRowCollection.size();
        if (size > 2) {
            ListSelectedRow secendLast = listSelectedRowCollection.get(size - 1);
            ListSelectedRow last = listSelectedRowCollection.get(size - 2);
            if (secendLast.getPrimaryKeyValue().equals(last.getPrimaryKeyValue())) {
                listSelectedRowCollection = this.listCache.getCachedSelectedRows();
            }
        }
        ArrayList<Integer> removedPkRowKeys = new ArrayList<Integer>(10);
        ArrayList<Integer> pkRowKeys = new ArrayList<Integer>(10);
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            if (notContainsRow.test(listSelectedRow)) {
                newListSelectedRowCollection.add((Object)listSelectedRow);
                continue;
            }
            removedPkRowKeys.add(listSelectedRow.getRowKey());
        }
        ListSelectedRowCollection currentListSelectedRowCollection = new ListSelectedRowCollection();
        AbstractGrid.GridState gridState = this.getEntryState();
        if (isRollLoading.booleanValue() || this.isMultiSelect && gridState.get(IS_ROLL_LOADING) == null) {
            ListSelectedRowCollection currentCachedSelectedRows = isRollLoading != false ? this.listCache.getAppendCachedSelectedRows() : this.listCache.getCurrentCachedSelectedRowsByPart(rowKeys.toArray(new Integer[0]));
            for (ListSelectedRow listSelectedRow : currentCachedSelectedRows) {
                if (!notContainsRow.test(listSelectedRow)) continue;
                pkRowKeys.add(listSelectedRow.getRowKey());
                currentListSelectedRowCollection.add((Object)listSelectedRow);
            }
        }
        if (currentListSelectedRowCollection.isEmpty()) {
            this.listCache.removeCachedSelectedRowsByPart(rowKeys.toArray(new Integer[0]));
            this.listCache.removeCurrentCachedSelectedRowsByPart(rowKeys.toArray(new Integer[0]));
        } else {
            if (!removedPkRowKeys.isEmpty()) {
                this.listCache.removeCachedSelectedRowsByPart(removedPkRowKeys.toArray(new Integer[0]));
                this.listCache.removeCurrentCachedSelectedRowsByPart(removedPkRowKeys.toArray(new Integer[0]));
            }
            if (isRollLoading.booleanValue()) {
                this.listCache.putAppendCachedSelectedRows(currentListSelectedRowCollection);
            }
            this.listCache.putCachedSelectedRowsByPart(currentListSelectedRowCollection, ListCache.ModifyType.UPDATE);
            this.listCache.putCurrentCachedSelectedRowsByPart(currentListSelectedRowCollection, ListCache.ModifyType.UPDATE);
        }
        return pkRowKeys;
    }
}

