/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.List;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.ControlContext;
import kd.bos.list.ExtendedFlexDimensions;
import kd.bos.list.FlexListColumn;
import kd.bos.list.IListColumnConfig;

class FlexListColumnDecorater {
    private ControlContext controlContext;
    private boolean isDetailEntry;
    private EntityType entityType;

    FlexListColumnDecorater(ControlContext controlContext, boolean isDetailEntry, EntityType entityType) {
        this.controlContext = controlContext;
        this.isDetailEntry = isDetailEntry;
        this.entityType = entityType;
    }

    void setFlexListColumnFlexDimensions(List<Control> permListColumns) {
        for (Control permListColumn : permListColumns) {
            if (permListColumn instanceof Container) {
                this.setFlexListColumnFlexDimensions(((Container)permListColumn).getItems());
                continue;
            }
            if (!(permListColumn instanceof IListColumnConfig)) continue;
            this.setFlexListColumnFlexDimensions((IListColumnConfig)permListColumn);
        }
    }

    void setFlexListColumnFlexDimensions(IListColumnConfig listColumn) {
        if (listColumn instanceof FlexListColumn) {
            FlexListColumn flexListColumn = (FlexListColumn)listColumn;
            FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.entityType), (String)flexListColumn.getListFieldKey());
            if (this.isDetailEntry && filterField != null && filterField.getSrcFieldProp().getParent() instanceof EntryType) {
                flexListColumn.setExpand(false);
                return;
            }
            ExtendedFlexDimensions extendedFlexDimensions = this.controlContext.getExtendedFlexDimensionsList().get(flexListColumn.getFieldName());
            if (extendedFlexDimensions != null) {
                flexListColumn.setExtendedFlexDimensions(extendedFlexDimensions);
            } else {
                flexListColumn.extendFlexFieldsWithoutOption(this.entityType);
                this.controlContext.putExtendedFlexDimensions(flexListColumn.getExtendedFlexDimensions());
            }
        }
    }
}

