/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import org.jetbrains.annotations.Nullable;

class HeaderFieldNameConverter {
    private Map<String, String> fieldKeyMap;
    private MainEntityType entityType;

    HeaderFieldNameConverter(Map<String, String> fieldKeyMap, MainEntityType entityType) {
        this.fieldKeyMap = fieldKeyMap;
        this.entityType = entityType;
    }

    @Nullable
    String getRealFilterName(String orgFieldName, Map<String, FilterField> filterFields) {
        String newFieldName = orgFieldName;
        if (newFieldName != null && newFieldName.startsWith("itemclassprop_")) {
            newFieldName = newFieldName.replace("itemclassprop_", "");
        }
        if (newFieldName != null) {
            newFieldName = this.getColumnName(newFieldName, filterFields);
        }
        return newFieldName;
    }

    private String getColumnName(String columnName, Map<String, FilterField> filterFields) {
        FilterField columnFilterField = this.getColumnFilterField(columnName, filterFields);
        return columnFilterField.getFieldName();
    }

    FilterField getColumnFilterField(String columnName, Map<String, FilterField> filterFields) {
        FilterField filterField;
        String originName;
        String displayColumnName = columnName;
        if (columnName.indexOf(95) != -1 && !columnName.equals(this.fieldKeyMap.get(columnName)) && (originName = this.fieldKeyMap.get(columnName)) != null) {
            displayColumnName = originName;
        }
        if ((filterField = this.getOrCreateFilterField(displayColumnName, filterFields)) == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), displayColumnName, "FIELDNOTEXISTS000016")});
        }
        return filterField;
    }

    private FilterField getOrCreateFilterField(String name, Map<String, FilterField> filterFields) {
        FilterField filterField = filterFields.get(name);
        if (filterField == null) {
            filterField = FilterField.create((MainEntityType)this.entityType, (String)name);
        }
        return filterField;
    }
}

