/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterTools;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.ListColumnCompareHelper;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.ListColumnCompareTypesSetListener;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.BillList;
import kd.bos.list.ListBillParameterLoader;
import kd.bos.list.ListColumnCompareType;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListGridView;
import kd.bos.list.SeqColumnType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.service.KDDateUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListColumn
extends AbstractListColumn {
    private static final Log log = LogFactory.getLog(ListColumn.class);
    private static final String FILTER = "filter";
    private static final String USEREGION = "useregion";
    private static final String EDITOR = "editor";
    public static final String SORT = "sort";
    private Tips ctlTips;
    private boolean autoTextWrap;
    private List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners = new ArrayList<ListColumnCompareTypesSetListener>();
    protected IDataEntityProperty srcFieldProp;
    private SortType sortType;
    private String order;
    private boolean columnOrderAndFilter = true;
    private boolean columnOrder = true;
    private boolean columnFilter = true;
    private boolean is_BlankFieldCanOrderAndFilter = false;
    private SeqColumnType columnType;
    private String seqColumnType;
    private String className;
    private String fieldName;
    private boolean is_Hyperlink;
    private String listFieldKey;

    public List<ListColumnCompareTypesSetListener> getListColumnCompareTypesSetListeners() {
        return this.listColumnCompareTypesSetListeners;
    }

    public void setListColumnCompareTypesSetListeners(List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners) {
        this.listColumnCompareTypesSetListeners = listColumnCompareTypesSetListeners;
    }

    public IDataEntityProperty getSrcFieldProp() {
        return this.srcFieldProp;
    }

    void setSrcFieldProp(IDataEntityProperty srcFieldProp) {
        this.srcFieldProp = srcFieldProp;
    }

    public SortType getSortType() {
        if (this.sortType == null) {
            this.sortType = SortType.valueOf((String)this.getOrder());
        }
        return this.sortType;
    }

    @SimplePropertyAttribute
    public String getOrder() {
        return StringUtils.isBlank((CharSequence)this.order) ? SortType.NotOrder.name() : this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @Deprecated
    public boolean isColumnOrderAndFilter() {
        return this.isColumnOrder() && this.isColumnFilter();
    }

    @Deprecated
    public void setColumnOrderAndFilter(boolean columnOrderAndFilter) {
        this.columnOrderAndFilter = columnOrderAndFilter;
        this.setColumnFilter(columnOrderAndFilter);
        this.setColumnOrder(columnOrderAndFilter);
    }

    @SimplePropertyAttribute(name="ColumnOrder")
    @DefaultValueAttribute(value="true")
    public boolean isColumnOrder() {
        return this.columnOrder;
    }

    public void setColumnOrder(boolean columnOrder) {
        this.columnOrder = columnOrder;
    }

    @SimplePropertyAttribute(name="ColumnFilter")
    @DefaultValueAttribute(value="true")
    public boolean isColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(boolean columnFilter) {
        this.columnFilter = columnFilter;
    }

    public Map<String, String> getColumnServiceContext() {
        return null;
    }

    public boolean isBlankFieldCanOrderAndFilter() {
        return this.is_BlankFieldCanOrderAndFilter;
    }

    public void setBlankFieldCanOrderAndFilter(boolean isBlankFieldCanOrderAndFilter) {
        this.is_BlankFieldCanOrderAndFilter = isBlankFieldCanOrderAndFilter;
    }

    public SeqColumnType getSeqColType() {
        if (this.columnType == null) {
            this.columnType = SeqColumnType.valueOf((String)this.getSeqColumnType());
        }
        return this.columnType;
    }

    @SimplePropertyAttribute
    public String getSeqColumnType() {
        return StringUtils.isBlank((CharSequence)this.seqColumnType) ? SeqColumnType.NotSeq.name() : this.seqColumnType;
    }

    public void setSeqColumnType(String seqColumnType) {
        this.seqColumnType = seqColumnType;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @SimplePropertyAttribute(name="Hyperlink")
    public boolean isHyperlink() {
        return this.is_Hyperlink;
    }

    public void setHyperlink(boolean isHyperlink) {
        this.is_Hyperlink = isHyperlink;
    }

    @SimplePropertyAttribute
    public String getListFieldKey() {
        return this.listFieldKey;
    }

    public void setListFieldKey(String strRealKey) {
        this.listFieldKey = strRealKey;
    }

    private Map<String, List<CompareType>> getFieldCompareTypeMap() {
        Map<String, List<CompareType>> fieldCompareTypeMap;
        if (this.getParent() instanceof ListGridView) {
            BillList billList = ((ListGridView)this.getParent()).getParent();
            fieldCompareTypeMap = billList.getContext().getFieldCompareTypeMap();
        } else if (this.getParent() instanceof ListColumnGroup) {
            ListColumnGroup listColumnGroup = (ListColumnGroup)this.getParent();
            fieldCompareTypeMap = listColumnGroup.getFieldCompareTypeMap();
        } else {
            fieldCompareTypeMap = new HashMap<String, List<CompareType>>(0);
        }
        return fieldCompareTypeMap;
    }

    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        ArrayList<Map<String, Object>> sortSetting = new ArrayList<Map<String, Object>>(1);
        if (this.isColumnOrder()) {
            Map column = super.createColumn(entityType);
            column.put("k", this.getListFieldKey());
            FilterField filterField = FilterField.create((MainEntityType)entityType, (String)this.getListFieldKey());
            this.initSeqFilterAndSort(column);
            ListColumnCompareHelper.setColumnCompareOperators((FilterField)filterField, (Map)column, this.getFieldCompareTypeMap(), (String)this.getFieldName(), this::fireListColumnCompareTypesSetListenerByComboItems, this::fireListColumnCompareTypesSetListenerByCompareTypes, (boolean)ListColumn.isListColumnBasedataFilter(entityType, filterField), (Set)this.getContext().getCanNotReadFields());
            this.fixColumnMeta(column, filterField);
            if (column != null && ((Boolean)column.get(SORT)).booleanValue()) {
                sortSetting.add(column);
            }
        }
        return sortSetting;
    }

    private static boolean isListColumnBasedataFilter(MainEntityType entityType, FilterField filterField) {
        return !(entityType instanceof QueryEntityType) && ListBillParameterLoader.isListColumnBasedataFilter(entityType.getName(), filterField);
    }

    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map column = super.createColumn(entityType);
        if (this.is_Hyperlink) {
            column.put("ln", true);
        }
        if (this.getCtlTips() != null) {
            column.put("tips", this.getCtlTips());
        }
        if (this.isAutoTextWrap()) {
            column.put("atw", this.isAutoTextWrap());
        }
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)this.getListFieldKey());
        this.initSeqFilterAndSort(column);
        if (this.isColumnFilter()) {
            ListColumnCompareHelper.setColumnCompareOperators((FilterField)filterField, (Map)column, this.getFieldCompareTypeMap(), (String)this.getFieldName(), this::fireListColumnCompareTypesSetListenerByComboItems, this::fireListColumnCompareTypesSetListenerByCompareTypes, (boolean)ListColumn.isListColumnBasedataFilter(entityType, filterField), (Set)this.getContext().getCanNotReadFields());
        }
        this.fixColumnMeta(column, filterField);
        return column;
    }

    private void fixColumnMeta(Map<String, Object> column, FilterField filterField) {
        if (filterField != null) {
            IDataEntityProperty fieldProp = filterField.getFieldProp();
            if (fieldProp instanceof DateTimeProp || fieldProp instanceof DecimalProp || fieldProp instanceof TimeProp) {
                column.put("isuf", true);
            }
            if (fieldProp instanceof DateTimeProp) {
                this.setDateTimeEditor(column, fieldProp);
            } else if (fieldProp instanceof DecimalProp) {
                column.put(USEREGION, ((DecimalProp)fieldProp).isUseRegion());
                this.setDecimalEditor(column, fieldProp);
            } else {
                column.put(USEREGION, false);
            }
            String operateType = "LIST";
            IDataEntityProperty thisFieldProp = PrivacyCenterTools.isDesensitized((FilterField)filterField, (String)operateType);
            if (thisFieldProp != null) {
                String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)thisFieldProp, (String)operateType, null);
                boolean isSupportSearch = PrivacyDataCenterManager.getPermissionService().isSupportSearch();
                if (isSupportSearch) {
                    boolean isDesensitizeStrategy = "DESENSITIZE".equals(strategy);
                    column.put(SORT, false);
                    if (isDesensitizeStrategy) {
                        column.put(FILTER, false);
                        log.info("\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u6b64\u8131\u654f\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f\u8fc7\u6ee4, prop is {}", (Object)filterField.getFieldName());
                    }
                } else {
                    column.put(SORT, false);
                    column.put(FILTER, false);
                    log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\uff0c\u56e0\u6b64\u8131\u654f\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f\u8fc7\u6ee4, prop is {}", (Object)filterField.getFieldName());
                }
            }
            if (filterField.isEncryptField()) {
                log.info("\u52a0\u5bc6\u5b57\u6bb5\u4e0d\u80fd\u6392\u5e8f, prop is {}", (Object)filterField.getFieldName());
                column.put(SORT, false);
                if (filterField.getSrcFieldProp() instanceof DateTimeProp) {
                    column.put(FILTER, false);
                }
            }
            if (thisFieldProp != null) {
                HashMap editor = (HashMap)column.get(EDITOR);
                String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)thisFieldProp, (String)operateType, null);
                boolean canShowDetail = false;
                if ("CLICKVIEW".equals(strategy)) {
                    canShowDetail = true;
                }
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(3);
                map.put("isprivacy", true);
                map.put("canshowdetail", canShowDetail);
                editor.put("privacy", map);
            }
        }
    }

    private void initSeqFilterAndSort(Map<String, Object> column) {
        if ("fseq".equals(this.getFieldKey())) {
            column.put(SORT, false);
            column.put(FILTER, false);
        } else {
            column.put(SORT, this.isColumnOrder());
            column.put(FILTER, this.isColumnFilter());
        }
    }

    private void setDecimalEditor(Map<String, Object> column, IDataEntityProperty fieldProp) {
        if (!fieldProp.getClass().equals(IntegerProp.class) && !fieldProp.getClass().equals(LongProp.class)) {
            HashMap editor = (HashMap)column.get(EDITOR);
            editor.put("sc", 10);
            editor.put("sz", true);
        }
    }

    private void setDateTimeEditor(Map<String, Object> column, IDataEntityProperty fieldProp) {
        HashMap editor = (HashMap)column.get(EDITOR);
        editor.put("today", KDDateUtils.now());
        editor.put("type", "datetime");
        if (fieldProp instanceof DateProp) {
            editor.put("type", "date");
        } else {
            column.put(USEREGION, ((DateTimeProp)fieldProp).isUseRegion());
            if (((DateTimeProp)fieldProp).getRegionType() == 1) {
                editor.put("type", "date");
            }
        }
    }

    private List<ListColumnCompareType> fireListColumnCompareTypesSetListenerByCompareTypes(List<ListColumnCompareType> listColumnCompareTypes) {
        ListColumnCompareTypesSetEvent listColumnCompareTypesSetEvent = new ListColumnCompareTypesSetEvent((Object)this, listColumnCompareTypes, this.getListFieldKey());
        for (ListColumnCompareTypesSetListener listColumnCompareTypesSetListener : this.listColumnCompareTypesSetListeners) {
            listColumnCompareTypesSetListener.listColumnCompareTypesSet(listColumnCompareTypesSetEvent);
        }
        return listColumnCompareTypesSetEvent.getListColumnCompareTypes();
    }

    private List<ValueMapItem> fireListColumnCompareTypesSetListenerByComboItems(List<ValueMapItem> comboItems) {
        ListColumnCompareTypesSetEvent listColumnCompareTypesSetEvent = new ListColumnCompareTypesSetEvent((Object)this, this.getListFieldKey(), comboItems);
        for (ListColumnCompareTypesSetListener listColumnCompareTypesSetListener : this.listColumnCompareTypesSetListeners) {
            listColumnCompareTypesSetListener.listColumnCompareTypesSet(listColumnCompareTypesSetEvent);
        }
        return listColumnCompareTypesSetEvent.getComboItems();
    }

    protected String getBizType() {
        if (this.getSeqColType() == SeqColumnType.EntitySeq) {
            return "long";
        }
        if (this.srcFieldProp != null) {
            if (this.srcFieldProp instanceof FieldProp) {
                return ((FieldProp)this.srcFieldProp).getClientType();
            }
            if (this.srcFieldProp instanceof IBasedataField) {
                return ((IBasedataField)this.srcFieldProp).getClientType(this.getFieldKey());
            }
        }
        return "text";
    }

    public String getFieldKey() {
        return this.listFieldKey;
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        ItemClassProp prop;
        String itemTypeKey;
        String key = this.getFieldKey();
        ListField listField = fieldSet.get(this.getFieldKey());
        if (listField != null && !listField.isComplex() && listField.getSrcFieldProp() != null) {
            this.srcFieldProp = listField.getSrcFieldProp();
            this.setFieldName(listField.getFieldName());
            if (entityType instanceof QueryEntityType) {
                this.setHeaderField(true);
                this.setEntityName(entityType.getName());
            } else if (this.getSeqColType() == SeqColumnType.EntitySeq) {
                this.setHeaderField(true);
                this.setEntityName(entityType.getName());
            } else {
                this.setHeaderField(!(listField.getSrcFieldProp().getParent() instanceof EntryType));
                this.setEntityName(listField.getSrcFieldProp().getParent().getName());
            }
            return;
        }
        if (this.getSeqColType() == SeqColumnType.EntitySeq) {
            this.setHeaderField(true);
            this.setEntityName(entityType.getName());
            this.setFieldName(this.getListFieldKey());
        } else {
            FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)this.getListFieldKey());
            if (filterField == null) {
                throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{entityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)"bos-form-core", (Object[])new Object[0]), this.getListFieldKey(), "FIELDNOTEXISTS000020")});
            }
            this.srcFieldProp = filterField.getSrcFieldProp();
            this.setFieldName(filterField.getFullFieldName());
            if (entityType instanceof QueryEntityType) {
                this.setHeaderField(true);
                this.setEntityName(entityType.getName());
            } else {
                this.setHeaderField(!(this.srcFieldProp.getParent() instanceof EntryType));
                this.setEntityName(this.srcFieldProp.getParent().getName());
            }
        }
        if (withoutDetailEntry && this.srcFieldProp != null && this.srcFieldProp.getParent() instanceof EntryType) {
            return;
        }
        ListField field = new ListField(key);
        field.setVisible(!this.isListColumnHidden(entityType, isListShowParameter, isLookUp));
        field.setEntityName(this.getEntityName());
        field.setClient(true);
        field.setSeq(this.getSeqColType() == SeqColumnType.EntitySeq);
        field.setFieldName(this.fieldName);
        field.setSrcFieldProp(this.srcFieldProp);
        field.setSortType(this.getSortType());
        field.setHeader(this.getCaption());
        fieldSet.put(key, field);
        if (this.srcFieldProp instanceof ItemClassProp && StringUtils.isNotBlank((CharSequence)(itemTypeKey = (prop = (ItemClassProp)this.srcFieldProp).getTypePropName()))) {
            if (!fieldSet.containsKey(itemTypeKey)) {
                FilterField itemTypeFld = FilterField.create((MainEntityType)((MainEntityType)entityType), (String)itemTypeKey);
                this.addControlField(fieldSet, itemTypeFld.getSrcFieldProp(), itemTypeKey, itemTypeFld.getFullFieldName());
            }
            ListField controlListField = fieldSet.get(itemTypeKey);
            field.setControlField(controlListField);
        }
    }

    @SdkInternal
    protected void addControlField(Map<String, ListField> fieldSet, IDataEntityProperty srcFieldProp, String typePropName, String ormFieldName) {
        ListField field = new ListField(typePropName);
        field.setEntityName(srcFieldProp.getParent().getName());
        field.setFieldName(ormFieldName);
        field.setSrcFieldProp(srcFieldProp);
        fieldSet.put(field.getKey(), field);
    }

    public String toString() {
        return this.listFieldKey;
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        return fieldControlRule.getCanNotReadFields().contains(this.getListFieldKey().split("\\.")[0]);
    }

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        if (ctlTips != null) {
            this.ctlTips = ctlTips;
        }
    }

    @SimplePropertyAttribute(name="AutoTextWrap")
    public boolean isAutoTextWrap() {
        return this.autoTextWrap;
    }

    public void setAutoTextWrap(boolean autoTextWrap) {
        this.autoTextWrap = autoTextWrap;
    }
}

