/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.ListColumnCompareTypesSetListener;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.IListColumnGroupConfig;
import kd.bos.list.ListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListColumnGroup
extends Container
implements IListColumnGroupConfig {
    private static final String TEXT_ALIGN = "textAlign";
    private static final String VISIBLE = "visible";
    private static final String FIXED = "fixed";
    private static final String DEFAULT = "default";
    private static final String LIST_FIELD_KEY = "listFieldKey";
    private static final String IS_HEADER_FIELD = "isHeaderField";
    private static final String ENTITY_NAME = "entityName";
    private static final String CLASS = "class";
    private static final String CAPTION = "caption";
    private String parentViewKey;
    private int visible;
    private boolean noDisplayScaleZero;
    private Map<String, Object> userConfigColumnSettings;
    private String textAlign = "default";
    private String entityName;
    private boolean groupCollapsible;
    private boolean groupDefaultCollapse;
    private Tips ctlTips;
    private List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners = new ArrayList<ListColumnCompareTypesSetListener>();
    private String tableHeaderCellBackColor;
    private Map<String, List<CompareType>> fieldCompareTypeMap = new HashMap<String, List<CompareType>>(16);
    private boolean isFixed;
    private LocaleString name;

    public List<ListColumnCompareTypesSetListener> getListColumnCompareTypesSetListeners() {
        return this.listColumnCompareTypesSetListeners;
    }

    public void setListColumnCompareTypesSetListeners(List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners) {
        this.listColumnCompareTypesSetListeners = listColumnCompareTypesSetListeners;
    }

    Map<String, List<CompareType>> getFieldCompareTypeMap() {
        return this.fieldCompareTypeMap;
    }

    void setFieldCompareTypeMap(Map<String, List<CompareType>> fieldCompareTypeMap) {
        this.fieldCompareTypeMap = fieldCompareTypeMap;
    }

    public Map<String, Object> getUserConfigColumnSettings() {
        return this.userConfigColumnSettings;
    }

    public void setUserConfigColumnSettings(Map<String, Object> userConfigColumnSettings) {
        this.userConfigColumnSettings = userConfigColumnSettings;
    }

    public String getListFieldKey() {
        return this.key;
    }

    public LocaleString getCaption() {
        return this.name;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default")
    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    @SimplePropertyAttribute(name="Fixed")
    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public String getParentViewKey() {
        return this.parentViewKey;
    }

    public void setParentViewKey(String parentViewKey) {
        this.parentViewKey = parentViewKey;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    public boolean isNoDisplayScaleZero() {
        return this.noDisplayScaleZero;
    }

    public void setNoDisplayScaleZero(boolean noDisplayScaleZero) {
        this.noDisplayScaleZero = noDisplayScaleZero;
    }

    @SimplePropertyAttribute(name="GroupCollapsible")
    public boolean isGroupCollapsible() {
        return this.groupCollapsible;
    }

    public void setGroupCollapsible(boolean groupCollapsible) {
        this.groupCollapsible = groupCollapsible;
    }

    @SimplePropertyAttribute(name="GroupDefaultCollapse")
    public boolean isGroupDefaultCollapse() {
        return this.groupDefaultCollapse;
    }

    public void setGroupDefaultCollapse(boolean groupDefaultCollapse) {
        this.groupDefaultCollapse = groupDefaultCollapse;
    }

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @SimplePropertyAttribute(name="TableHeaderCellBackColor")
    public String getTableHeaderCellBackColor() {
        return this.tableHeaderCellBackColor;
    }

    public void setTableHeaderCellBackColor(String tableHeaderCellBackColor) {
        this.tableHeaderCellBackColor = tableHeaderCellBackColor;
    }

    @SdkInternal
    public Map<String, Object> createColumn(MainEntityType entityType, Map<String, Map<String, Object>> decimalFieldMap) {
        return this.createColumn(entityType, decimalFieldMap, 0);
    }

    @SdkInternal
    public Map<String, Object> createColumn(MainEntityType entityType, Map<String, Map<String, Object>> decimalFieldMap, int orderAndFilter) {
        HashMap<String, Object> ctl = new HashMap<String, Object>(5);
        ctl.put("header", this.getName());
        ctl.put("children", this.createColumns(entityType, decimalFieldMap, orderAndFilter));
        ctl.put("groupcollapsible", this.isGroupCollapsible());
        ctl.put("groupdefaultcollapse", this.isGroupDefaultCollapse());
        if (this.isInvisible()) {
            ctl.put("vi", 0);
        } else {
            ctl.put("vi", this.getUserVisible());
        }
        if (!DEFAULT.equals(this.getTextAlign())) {
            ctl.put("text-align", this.getTextAlign());
        }
        if (this.getCtlTips() != null) {
            ctl.put("tips", this.getCtlTips());
        }
        if (this.getUserFixed()) {
            ctl.put("isFixed", this.getUserFixed());
        }
        ctl.put("dataIndex", this.getKey());
        if (StringUtils.isNotBlank((CharSequence)this.getTableHeaderCellBackColor())) {
            ctl.put("thcb", this.getTableHeaderCellBackColor());
        }
        return ctl;
    }

    private List<Object> createColumns(MainEntityType entityType, Map<String, Map<String, Object>> decimalFieldMap, int orderAndFilter) {
        ArrayList<Object> cols = new ArrayList<Object>();
        for (Control item : this.getItems()) {
            if (item instanceof ListColumnGroup) {
                ((ListColumnGroup)item).setFieldCompareTypeMap(this.fieldCompareTypeMap);
                cols.add(((ListColumnGroup)item).createColumn(entityType, decimalFieldMap, orderAndFilter));
                continue;
            }
            IListColumn col = (IListColumn)item;
            if (item instanceof ListColumn) {
                ((ListColumn)item).setListColumnCompareTypesSetListeners(this.listColumnCompareTypesSetListeners);
            }
            if (col instanceof DecimalListColumn) {
                ((DecimalListColumn)col).setNoDisplayScaleZero(this.isNoDisplayScaleZero());
            }
            Map column = col.createColumn(entityType);
            Map editor = (Map)column.get("editor");
            FilterField filterField = FilterField.create((MainEntityType)entityType, (String)col.getListFieldKey());
            if (filterField != null && filterField.getFieldProp() instanceof ComboProp) {
                ViewCommonUtil.setComboListColumnEditor(col, (ComboProp)filterField.getFieldProp(), (Map<String, Object>)editor, filterField.getLatestParent());
            }
            if (filterField != null && filterField.getFieldProp() instanceof DecimalProp) {
                ViewCommonUtil.setDecimalColumnEditor(col, filterField.getFieldProp(), column);
                ViewCommonUtil.createDecimalEditor(column, (Map)column.get("editor"), decimalFieldMap);
            }
            if (orderAndFilter == 1) {
                column.put("filter", false);
                column.put("sort", false);
            } else if (orderAndFilter == 2) {
                column.put("filter", false);
            } else if (orderAndFilter == 3) {
                column.put("sort", false);
            }
            column.put("key", ((Control)col).getKey());
            cols.add(column);
        }
        return cols;
    }

    public boolean isHeaderField() {
        return true;
    }

    public LocaleString getEntityCaption() {
        return null;
    }

    public List<IListColumnConfig> getListColumnConfigList() {
        ArrayList<IListColumnConfig> listColumnConfigs = new ArrayList<IListColumnConfig>(this.getItems().size());
        for (Control item : this.getItems()) {
            listColumnConfigs.add((IListColumnConfig)item);
        }
        return listColumnConfigs;
    }
}

