/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.SortType;
import kd.bos.form.control.Control;
import kd.bos.list.IListColumn;

class ListColumnToListField {
    private EntityType entityType;
    private boolean withoutDetailEntry;
    private boolean isListShowParameter;
    private boolean isLookUp;
    private Set<String> entryEntitySet;

    ListColumnToListField(EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp, Set<String> entryEntitySet) {
        this.entityType = entityType;
        this.withoutDetailEntry = withoutDetailEntry;
        this.isListShowParameter = isListShowParameter;
        this.isLookUp = isLookUp;
        this.entryEntitySet = entryEntitySet;
    }

    List<ListField> getListFields(List<Control> childItems) {
        LinkedHashMap<String, ListField> fieldSet = new LinkedHashMap<String, ListField>();
        for (Control control : childItems) {
            if (!(control instanceof IListColumn)) continue;
            IListColumn listColumn = (IListColumn)control;
            listColumn.addFieldSet(fieldSet, this.entityType, this.withoutDetailEntry, this.isListShowParameter, this.isLookUp);
        }
        return this.getValidListFields(fieldSet);
    }

    private List<ListField> getValidListFields(Map<String, ListField> fieldSet) {
        ArrayList<ListField> validListFields = new ArrayList<ListField>();
        ArrayList<ListField> listFields = new ArrayList<ListField>(fieldSet.values());
        Map<String, List<ListField>> controlFieldOwnerMap = this.getControlOwnerMapList(listFields);
        for (ListField listField : listFields) {
            List<ListField> controlFieldOwnerList = controlFieldOwnerMap.get(listField.getListFieldKey());
            if ((listField.isVisible() && controlFieldOwnerList == null || listField.isVisible() && controlFieldOwnerList != null && this.isControlOwnerVisible(controlFieldOwnerList)) && this.entryEntitySet.contains(listField.getEntityName())) {
                validListFields.add(listField);
            }
            if (!listField.isVisible() && this.entryEntitySet.contains(listField.getEntityName()) && this.isHasControlOwnerOrVisible(controlFieldOwnerList)) {
                validListFields.add(listField);
            }
            if (listField.isVisible() || !this.entryEntitySet.contains(listField.getEntityName()) || listField.getSortType() == SortType.NotOrder) continue;
            validListFields.add(listField);
        }
        return validListFields;
    }

    private boolean isControlOwnerVisible(List<ListField> controlFieldOwnerList) {
        boolean iscontroFieldOwnerVisible = false;
        for (ListField listField2 : controlFieldOwnerList) {
            if (!listField2.isVisible()) continue;
            iscontroFieldOwnerVisible = true;
            break;
        }
        return iscontroFieldOwnerVisible;
    }

    private boolean isHasControlOwnerOrVisible(List<ListField> controlFieldOwnerList) {
        if (controlFieldOwnerList == null || controlFieldOwnerList.isEmpty()) {
            return false;
        }
        return this.isControlOwnerVisible(controlFieldOwnerList);
    }

    private Map<String, List<ListField>> getControlOwnerMapList(List<ListField> listFields) {
        HashMap<String, List<ListField>> controlFieldOwnerMap = new HashMap<String, List<ListField>>();
        for (ListField listField : listFields) {
            if (listField.getControlField() == null) continue;
            List<Object> fields = new ArrayList<ListField>();
            if (controlFieldOwnerMap.containsKey(listField.getControlField().getListFieldKey())) {
                fields = (List)controlFieldOwnerMap.get(listField.getControlField().getListFieldKey());
            }
            fields.add(listField);
            controlFieldOwnerMap.put(listField.getControlField().getListFieldKey(), fields);
        }
        return controlFieldOwnerMap;
    }
}

