/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.BillListColumnParser;
import kd.bos.list.FlexListColumnDecorater;
import kd.bos.list.IListColumn;
import kd.bos.list.IListColumnConfig;
import kd.bos.list.IListColumnGroupConfig;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListColumnGroupConfigUtil;
import kd.bos.list.MergeListColumn;
import kd.bos.list.SeqColumnType;

class ListFieldControlParser {
    private static final String LIST_FIELD_KEY = "listFieldKey";
    private BillListColumnParser billListColumnParser;
    private FlexListColumnDecorater flexListColumnDecorater;

    ListFieldControlParser(BillListColumnParser billListColumnParser, FlexListColumnDecorater flexListColumnDecorater) {
        this.billListColumnParser = billListColumnParser;
        this.flexListColumnDecorater = flexListColumnDecorater;
    }

    List<Map<String, Object>> getBackListColumns(List<Map<String, Object>> listColumns) {
        List<IListColumn> finalValidListColumns = this.billListColumnParser.getListGridViewColumns(listColumns);
        List<Map<String, Object>> thisListFieldsControlColumns = this.billListColumnParser.getListFieldsControlColumns();
        for (IListColumn listColumn : finalValidListColumns) {
            this.setBackListColumnByUserConfig(listColumn, thisListFieldsControlColumns);
        }
        ArrayList<Map<String, Object>> backListColumns = new ArrayList<Map<String, Object>>();
        Consumer<Control> consumer = control -> {
            if (control instanceof IListColumnGroupConfig) {
                IListColumnGroupConfig listColumnGroupConfig = (IListColumnGroupConfig)control;
                if (listColumnGroupConfig instanceof Container) {
                    this.flexListColumnDecorater.setFlexListColumnFlexDimensions(((Container)listColumnGroupConfig).getItems());
                } else {
                    this.flexListColumnDecorater.setFlexListColumnFlexDimensions((IListColumnConfig)listColumnGroupConfig);
                }
                backListColumns.add(listColumnGroupConfig.getListColumnConfigMap((MainEntityType)this.billListColumnParser.getEntityType()));
            } else if (control instanceof IListColumnConfig) {
                IListColumnConfig listColumnConfig = (IListColumnConfig)control;
                String listFieldKey = ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)listColumnConfig);
                for (Map map : listColumns) {
                    if (!map.get("k").toString().equalsIgnoreCase(listFieldKey) || !(listColumnConfig instanceof IListColumn)) continue;
                    ((IListColumn)listColumnConfig).setWidth(new LocaleString(map.get("w").toString()));
                }
                backListColumns.add(listColumnConfig.getListColumnConfigMap((MainEntityType)this.billListColumnParser.getEntityType()));
            }
        };
        for (IListColumn listColumn : finalValidListColumns) {
            this.setListColumnHeaderField(listColumn);
        }
        this.iteratorOrderListColumns(finalValidListColumns, consumer);
        int seq = 0;
        for (Map map : backListColumns) {
            map.put("seq", seq++);
        }
        return backListColumns;
    }

    private void iteratorOrderListColumns(List<IListColumn> listColumns, Consumer<Control> consumer) {
        HashSet<String> topListColumnGroupColumnsSet = new HashSet<String>(16);
        for (IListColumn iListColumn : listColumns) {
            if (!this.billListColumnParser.getListGridViewKey().equalsIgnoreCase(iListColumn.getParentViewKey())) {
                this.findTopListColumn(topListColumnGroupColumnsSet, iListColumn.getParentViewKey(), consumer);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)iListColumn.getParentViewKey()) && !this.billListColumnParser.getListGridViewKey().equalsIgnoreCase(iListColumn.getParentViewKey())) continue;
            consumer.accept((Control)iListColumn);
        }
    }

    private void findTopListColumn(Set<String> topListColumnGroupColumnsSet, String parentControlKey, Consumer<Control> consumer) {
        ListColumnGroup listColumnGroup = this.billListColumnParser.getListColumnGroupMap().get(parentControlKey);
        if (listColumnGroup != null) {
            if (this.billListColumnParser.getListGridViewKey().equalsIgnoreCase(listColumnGroup.getParentViewKey())) {
                if (topListColumnGroupColumnsSet.add(listColumnGroup.getKey())) {
                    consumer.accept((Control)listColumnGroup);
                }
            } else {
                this.findTopListColumn(topListColumnGroupColumnsSet, listColumnGroup.getParentViewKey(), consumer);
            }
        }
    }

    private void setBackListColumnByUserConfig(IListColumn backListColumn, List<Map<String, Object>> listFieldsControlColumns) {
        String listFieldKey = ListColumnGroupConfigUtil.getListFieldKey((IListColumnConfig)backListColumn);
        for (Map<String, Object> listColumn : listFieldsControlColumns) {
            if (listFieldKey == null || listColumn.get(LIST_FIELD_KEY) == null || !listFieldKey.equalsIgnoreCase(listColumn.get(LIST_FIELD_KEY).toString())) continue;
            backListColumn.setUserConfigColumnSettings(listColumn);
            break;
        }
    }

    List<String> createSortSetting(MainEntityType entityType) {
        List<Map<String, Object>> factorySetColumnSetting = this.createFactorySetColumnSetting(t -> {
            ArrayList sortSetting = new ArrayList(10);
            sortSetting.addAll(t.getSortSetting(entityType));
            return sortSetting;
        });
        ArrayList<String> sortSetting = new ArrayList<String>(factorySetColumnSetting.size());
        for (Map<String, Object> factorySetColumn : factorySetColumnSetting) {
            sortSetting.add(factorySetColumn.get("k").toString());
        }
        return sortSetting;
    }

    List<Map<String, Object>> createFactorySetColumnSetting() {
        return this.createFactorySetColumnSetting(t -> {
            ArrayList<Map> factorySetColumnListMap = new ArrayList<Map>(10);
            factorySetColumnListMap.add(t.getFactoryConfigColumnSetting());
            return factorySetColumnListMap;
        });
    }

    List<Map<String, Object>> createFactorySetColumnSetting(Function<IListColumnConfig, List<Map<String, Object>>> doFunction) {
        List<IListColumn> factorySetColumns = this.billListColumnParser.getConfigListColumns();
        ArrayList<Map<String, Object>> factorySetColumnListMap = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> factorySetColumnKeys = new ArrayList<String>();
        String parentViewKey = this.billListColumnParser.getListGridViewKey();
        HashMap<String, ListColumnGroup> listColumnGroupMap = this.billListColumnParser.getListColumnGroupMap();
        for (IListColumn factorySetColumn : factorySetColumns) {
            factorySetColumn.setUserConfigColumnSettings(null);
            if (!factorySetColumnKeys.contains(factorySetColumn.getListFieldKey()) && factorySetColumn.getSeqColType() != SeqColumnType.EntitySeq && (StringUtils.isEmpty((CharSequence)factorySetColumn.getParentViewKey()) || parentViewKey.equalsIgnoreCase(factorySetColumn.getParentViewKey()))) {
                factorySetColumnKeys.add(factorySetColumn.getListFieldKey());
                this.setListColumnHeaderField(factorySetColumn);
                factorySetColumnListMap.addAll((Collection<Map<String, Object>>)doFunction.apply((IListColumnConfig)factorySetColumn));
                continue;
            }
            if (factorySetColumn.getParent() instanceof ListColumnGroup) {
                ListColumnGroup listColumnGroup = (ListColumnGroup)factorySetColumn.getParent();
                ListColumnGroup findedTopListColumnGroup = this.billListColumnParser.findTopListColumnGroup(listColumnGroup, listColumnGroupMap);
                if (factorySetColumnKeys.contains(findedTopListColumnGroup.getKey()) || !parentViewKey.equals(findedTopListColumnGroup.getParentViewKey()) && !StringUtils.isBlank((CharSequence)findedTopListColumnGroup.getParentViewKey())) continue;
                factorySetColumnKeys.add(findedTopListColumnGroup.getKey());
                factorySetColumnListMap.addAll((Collection<Map<String, Object>>)doFunction.apply((IListColumnConfig)findedTopListColumnGroup));
                continue;
            }
            if (!factorySetColumnKeys.contains(factorySetColumn.getParent().getKey()) && factorySetColumn.getParent() instanceof MergeListColumn && (parentViewKey.equals(((MergeListColumn)factorySetColumn.getParent()).getParentViewKey()) || StringUtils.isBlank((CharSequence)((MergeListColumn)factorySetColumn.getParent()).getParentViewKey()))) {
                factorySetColumnKeys.add(factorySetColumn.getParent().getKey());
                factorySetColumnListMap.addAll((Collection<Map<String, Object>>)doFunction.apply((IListColumnConfig)((MergeListColumn)factorySetColumn.getParent())));
                continue;
            }
            if (factorySetColumn.getSeqColType() == SeqColumnType.EntitySeq || factorySetColumnKeys.contains(((Control)factorySetColumn).getKey()) || !StringUtils.isEmpty((CharSequence)factorySetColumn.getParentViewKey()) && !parentViewKey.equalsIgnoreCase(factorySetColumn.getParentViewKey())) continue;
            factorySetColumnKeys.add(((Control)factorySetColumn).getKey());
            factorySetColumnListMap.addAll((Collection<Map<String, Object>>)doFunction.apply((IListColumnConfig)factorySetColumn));
        }
        return factorySetColumnListMap;
    }

    private void setListColumnHeaderField(IListColumn backListColumn) {
        FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.billListColumnParser.getEntityType()), (String)backListColumn.getListFieldKey());
        if (this.billListColumnParser.getEntityType() instanceof QueryEntityType) {
            backListColumn.setHeaderField(true);
        } else if (backListColumn.getSeqColType() == SeqColumnType.EntitySeq) {
            backListColumn.setHeaderField(true);
        } else if (filterField != null) {
            backListColumn.setHeaderField(!(filterField.getSrcFieldProp().getParent() instanceof EntryType));
            backListColumn.setEntityName(filterField.getSrcFieldProp().getParent().getName());
            backListColumn.setEntityCaption(filterField.getSrcFieldProp().getParent().getDisplayName());
        }
    }
}

