/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.ClientBR;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ListColumnCompareTypesSetListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.rule.ClientRuleExecuteContext;
import kd.bos.list.AbstractListContainerColumn;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.FlexListColumn;
import kd.bos.list.IListChild;
import kd.bos.list.IListColumn;
import kd.bos.list.ListBillParameterLoader;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnContext;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MergeListColumn;
import kd.bos.list.SeqColumnType;
import kd.bos.list.ViewCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListGridView
extends Container
implements IListChild {
    private static final Log logger = LogFactory.getLog(ListGridView.class);
    private static final String TOOLBAR_LOCATION = "tl";
    private static final String SHOW_SELECT_INFO = "showSelectInfo";
    private static final String SHOW_SEL_CHECKBOX = "selcheckbox";
    private static final String CHILDREN = "children";
    private static final String CELLSTYLERULES = "cellStyleRules";
    private String toolbarLocation = "-1";
    FormMetadata formMeta = null;
    private boolean showSelectInfo = true;
    private List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners = new ArrayList<ListColumnCompareTypesSetListener>();
    private Map<String, Object> operationCol;
    private List<ClientBR> clientRules = new ArrayList<ClientBR>();
    private boolean paginationHide;
    private boolean showSelCheckbox = true;
    private int visible;
    private int titleFontSize = 12;
    private boolean titleAutoWrap;
    private String rowHeight;
    private String maxRowHeight;
    private boolean autoRowHeight;
    private String columnWidthStyle;
    private boolean is_DetailEntry;
    private String formDetailId;
    private String formDetailHeight;
    private boolean formDetailAutoHeight;
    private String headHeight;
    private int orderAndFilter;
    private String pageType = "";
    private List<Map<String, String>> freezeList;
    protected BillList parent;
    private NumberFormatProvider numberFormatProvider;

    public List<ListColumnCompareTypesSetListener> getListColumnCompareTypesSetListeners() {
        return this.listColumnCompareTypesSetListeners;
    }

    public void setListColumnCompareTypesSetListeners(List<ListColumnCompareTypesSetListener> listColumnCompareTypesSetListeners) {
        this.listColumnCompareTypesSetListeners = listColumnCompareTypesSetListeners;
    }

    @SimplePropertyAttribute(name="ToolbarLocation")
    @DefaultValueAttribute(value="-1")
    public String getToolbarLocation() {
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String toolbarLocation) {
        this.toolbarLocation = toolbarLocation;
    }

    @SimplePropertyAttribute(name="ShowSelectInfo")
    @DefaultValueAttribute(value="true")
    public boolean isShowSelectInfo() {
        return this.showSelectInfo;
    }

    public void setShowSelectInfo(boolean showSelectInfo) {
        this.showSelectInfo = showSelectInfo;
    }

    @SimplePropertyAttribute
    public Map<String, Object> getOperationCol() {
        return this.operationCol;
    }

    public void setOperationCol(Map<String, Object> operationCol) {
        this.operationCol = operationCol;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ClientBR.class)
    public List<ClientBR> getClientRules() {
        return this.clientRules;
    }

    public void setClientRules(List<ClientBR> clientRules) {
        this.clientRules = clientRules;
    }

    @SimplePropertyAttribute(name="PaginationHide")
    public boolean isPaginationHide() {
        return this.paginationHide;
    }

    public void setPaginationHide(boolean paginationHide) {
        this.paginationHide = paginationHide;
    }

    @SimplePropertyAttribute(name="ShowSelCheckbox")
    @DefaultValueAttribute(value="true")
    public boolean isShowSelCheckbox() {
        return this.showSelCheckbox;
    }

    public void setShowSelCheckbox(boolean showSelCheckbox) {
        this.showSelCheckbox = showSelCheckbox;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="12")
    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    @SimplePropertyAttribute(name="TitleAutoWrap")
    public boolean isTitleAutoWrap() {
        return this.titleAutoWrap;
    }

    public void setTitleAutoWrap(boolean titleAutoWrap) {
        this.titleAutoWrap = titleAutoWrap;
    }

    @SimplePropertyAttribute
    public String getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(String rowHeight) {
        this.rowHeight = rowHeight;
    }

    @SimplePropertyAttribute
    public String getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(String maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    @SimplePropertyAttribute(name="AutoRowHeight")
    public boolean isAutoRowHeight() {
        return this.autoRowHeight;
    }

    public void setAutoRowHeight(boolean autoRowHeight) {
        this.autoRowHeight = autoRowHeight;
    }

    @SimplePropertyAttribute(name="ColumnWidthStyle")
    public String getColumnWidthStyle() {
        return this.columnWidthStyle;
    }

    public void setColumnWidthStyle(String columnWidthStyle) {
        this.columnWidthStyle = columnWidthStyle;
    }

    @SimplePropertyAttribute(name="DetailEntry")
    public boolean isDetailEntry() {
        return this.is_DetailEntry;
    }

    public void setDetailEntry(boolean isDetailEntry) {
        this.is_DetailEntry = isDetailEntry;
    }

    @SimplePropertyAttribute
    public String getFormDetailId() {
        return this.formDetailId;
    }

    public void setFormDetailId(String formDetailId) {
        this.formDetailId = formDetailId;
    }

    @SimplePropertyAttribute
    public String getFormDetailHeight() {
        return this.formDetailHeight;
    }

    public void setFormDetailHeight(String formDetailHeight) {
        this.formDetailHeight = formDetailHeight;
    }

    @SimplePropertyAttribute(name="FormDetailAutoHeight")
    public boolean isFormDetailAutoHeight() {
        return this.formDetailAutoHeight;
    }

    public void setFormDetailAutoHeight(boolean formDetailAutoHeight) {
        this.formDetailAutoHeight = formDetailAutoHeight;
    }

    @SimplePropertyAttribute
    public String getHeadHeight() {
        return this.headHeight;
    }

    public void setHeadHeight(String headHeight) {
        this.headHeight = headHeight;
    }

    @SimplePropertyAttribute(name="OrderAndFilter")
    public int getOrderAndFilter() {
        return this.orderAndFilter;
    }

    public void setOrderAndFilter(int orderAndFilter) {
        this.orderAndFilter = orderAndFilter;
    }

    @SimplePropertyAttribute(name="PageType")
    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String type) {
        this.pageType = type;
    }

    @SimplePropertyAttribute
    public List<Map<String, String>> getFreezeList() {
        return this.freezeList;
    }

    public void setFreezeList(List<Map<String, String>> freezeList) {
        this.freezeList = freezeList;
    }

    public void bindData(BindingContext bctx) {
        if (StringUtils.isBlank((CharSequence)this.parent.getEntityId())) {
            return;
        }
        this.updateControlMeta();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        Map<String, Object> createHeaderColumns = this.createHeaderColumns();
        clientViewProxy.preInvokeControlMethod(this.getKey(), "createGridColumns", new Object[]{createHeaderColumns});
        if (this.isDetailEntry()) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("columns", this.createColumns(false));
            clientViewProxy.preInvokeControlMethod(this.getKey(), "createSubGridColumns", new Object[]{meta});
        }
    }

    public Map<String, Object> createClientConfig() {
        Object suppresscopy;
        Map map = super.createClientConfig();
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.visible);
        }
        map.put("phide", this.paginationHide);
        map.put("pt", this.getPageType());
        if (this.isAutoRowHeight()) {
            map.put("arh", this.isAutoRowHeight());
        }
        if (this.isAutoRowHeight() && StringUtils.isNotBlank((CharSequence)this.getMaxRowHeight())) {
            map.put("mrh", this.getMaxRowHeight());
        }
        if (!this.isAutoRowHeight() && StringUtils.isNotBlank((CharSequence)this.getRowHeight())) {
            map.put("rh", this.getRowHeight());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getHeadHeight())) {
            map.put("hh", this.getHeadHeight());
        }
        map.put("type", "grid");
        if (StringUtils.isNotBlank((CharSequence)this.toolbarLocation) && !"-1".equals(this.toolbarLocation)) {
            map.put(TOOLBAR_LOCATION, this.toolbarLocation);
        }
        if (!this.showSelectInfo) {
            map.put(SHOW_SELECT_INFO, false);
        }
        if (!this.parent.isLookUp() && !this.isShowSelCheckbox()) {
            map.put(SHOW_SEL_CHECKBOX, this.isShowSelCheckbox());
        }
        if (this.parent.isSumDataLoadOnFirst()) {
            map.put("autoGetAggData", true);
        }
        if (this.getTitleFontSize() != 12) {
            map.put("tfs", this.getTitleFontSize());
        }
        if (ListBillParameterLoader.option(this.parent.getEntityType().getName(), "listcolumnbasedatafilter", true)) {
            map.put("bif", true);
        }
        if (this.isTitleAutoWrap()) {
            map.put("taw", this.isTitleAutoWrap());
        }
        map.put("scp", (suppresscopy = ListSysPublicParameter.option("suppresscopy")) != null ? Boolean.parseBoolean(suppresscopy.toString()) : false);
        return map;
    }

    protected void createChildClientConfigs(Map<String, Object> map) {
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    private List<EntryEntityDto> getEntryEntities() {
        List<EntryEntityDto> entryEntityDtos = this.parent.getSelectedEntryEntityDtos();
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            entryEntityDto.setPkFieldName(entryEntityDto.getPkFieldName().replace(".", "_"));
        }
        return entryEntityDtos;
    }

    private void createOrderAndFilterColumn(Map<String, Object> col) {
        int order = this.getOrderAndFilter();
        if (order != 0) {
            this.setOrderAndFilterColumn(col, order);
        }
    }

    private void setOrderAndFilterColumn(Map<String, Object> col, int orderAndFilter) {
        if (col.get(CHILDREN) != null && col.get(CHILDREN) instanceof List) {
            List list = (List)col.get(CHILDREN);
            for (Object o : list) {
                if (!(o instanceof Map)) continue;
                HashMap m = (HashMap)o;
                this.setOrderAndFilterColumn(m, orderAndFilter);
            }
        } else if (orderAndFilter == 1) {
            col.put("filter", false);
            col.put("sort", false);
        } else if (orderAndFilter == 2) {
            col.put("filter", false);
        } else if (orderAndFilter == 3) {
            col.put("sort", false);
        }
    }

    private Map<String, Object> createHeaderColumns() {
        List<Map<String, Object>> rowStyleRules;
        List<Map<String, Object>> cols = this.createColumns(true);
        HashMap<String, Object> meta = new HashMap<String, Object>(16);
        meta.put("rk", "rk");
        meta.put("seq", "fseq");
        meta.put("columns", cols);
        meta.put("entryentities", this.getEntryEntities());
        if (this.isInvisible()) {
            meta.put("vi", 0);
        } else {
            meta.put("vi", this.visible);
        }
        meta.put("gridtype", "VIEWGRID");
        meta.put("mergerow", this.getParent().getListUserOption().isMergeRow(this.getView().getFormShowParameter().getCustomParams()));
        meta.put("isGridStriped", this.getParent().getListUserOption().isGridStriped());
        meta.put("isCellSum", this.getParent().getListUserOption().isCellSum());
        meta.put("noHeaderSpan", !this.getParent().getListUserOption().isNoHeaderSpan());
        if (this.getOperationCol() != null) {
            meta.put("operations", this.createOperationCol());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFormDetailId())) {
            meta.put("formDetailId", this.getFormDetailId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFormDetailHeight())) {
            meta.put("formDetailHeight", this.getFormDetailHeight());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getColumnWidthStyle())) {
            meta.put("columnWidthStyle", this.getColumnWidthStyle());
        }
        if (this.isDetailEntry()) {
            meta.put("detailentry", true);
            if (this.isFormDetailAutoHeight()) {
                meta.put("formDetailAutoHeight", true);
            }
        }
        if (!(rowStyleRules = this.buildRowStyleRules()).isEmpty()) {
            meta.put("rowStyleRules", rowStyleRules);
        }
        this.setTotalType(meta);
        return meta;
    }

    private Map<String, Object> createOperationCol() {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("items", this.getOperationCol().get("operationColItems"));
        item.put("position", this.getOperationCol().get("colIndex"));
        return item;
    }

    @Override
    public void setParent(BillList parent) {
        this.parent = parent;
    }

    public BillList getParent() {
        return this.parent;
    }

    private boolean isValidListColumn(boolean bHideSeq, IListColumn col) {
        return !bHideSeq || col.getSeqColType() != SeqColumnType.EntitySeq;
    }

    private void addCellStyleRules(Map<String, Object> column, String key) {
        if (this.getClientRules() != null && !this.getClientRules().isEmpty()) {
            List<Map<String, Object>> rules = this.createClientRules();
            List cellStyleRules = column.get(CELLSTYLERULES) == null ? new ArrayList() : (List)column.get(CELLSTYLERULES);
            HashMap<String, Object> transRule = null;
            for (Map<String, Object> rule : rules) {
                transRule = new HashMap<String, Object>();
                if (rule.get("fieldKey") == null || !rule.get("fieldKey").equals(key)) continue;
                transRule.put("cond", rule.get("cond"));
                transRule.put("style", rule.get("style"));
                cellStyleRules.add(transRule);
            }
            column.put(CELLSTYLERULES, cellStyleRules);
        }
    }

    private void addCellStyleRulesListColumnGroup(Map<String, Object> column, ListColumnGroup listColumnGroup) {
        List maps = (List)column.get(CHILDREN);
        List items = listColumnGroup.getItems();
        if (!CollectionUtils.isEmpty((Collection)maps)) {
            for (Map map : maps) {
                String key = (String)map.get("key");
                for (Control item : items) {
                    if (!(item instanceof ListColumnGroup)) continue;
                    this.addCellStyleRulesListColumnGroup(map, (ListColumnGroup)item);
                }
                this.addCellStyleRules(map, key);
            }
        }
    }

    private void setEditableColumnEditor(IListColumn col, FilterField filterField, Map<String, Object> editor, Map<String, Map<String, Object>> decimalFieldMap) {
        Map<String, Object> colType;
        if (filterField == null || filterField.getFieldProp() == null) {
            return;
        }
        if (this.parent == null || this.parent.getBeforeCreateListColumnsArgs() == null) {
            return;
        }
        String fieldKey = col.getListFieldKey();
        if (!this.parent.getBeforeCreateListColumnsArgs().getEditableColumnKeys().contains(fieldKey)) {
            return;
        }
        IDataEntityProperty fieldProp = filterField.getFieldProp();
        if (this.numberFormatProvider != null && fieldProp instanceof AmountProp && (colType = decimalFieldMap.get(fieldKey)) != null) {
            editor.put("pc", colType.get("pc"));
        }
        if (StringUtils.isBlank((CharSequence)this.parent.getBillFormOrEntityId())) {
            return;
        }
        String id = MetadataDao.getIdByNumber((String)this.parent.getBillFormOrEntityId(), (MetaCategory)MetaCategory.Form);
        if (this.formMeta == null) {
            this.formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            if (this.formMeta == null) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.formMeta.getEntityId())) {
                EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)this.formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
                if (meta == null) {
                    return;
                }
                this.formMeta.bindEntityMetadata(meta);
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String entityNumber = this.parent.getListModel().getDataEntityType().getName();
        String bizAppId = ShowFormHelper.getBizAppId(this.getView().getFormShowParameter());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, bizAppId, entityNumber);
        if (fieldControlRules != null) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null || !temp.getCanNotReadFields().contains(fieldKey) && !temp.getCanNotWriteFields().contains(fieldKey)) continue;
                return;
            }
        }
        boolean isValidateField = false;
        List<Class> fieldTypeClz = Arrays.asList(TextField.class, IntegerField.class, DecimalField.class, BigIntField.class, AmountField.class);
        for (ControlAp ctlAp : this.formMeta.getItems()) {
            Field field;
            if (!(ctlAp instanceof FieldAp) || (field = ((FieldAp)ctlAp).getField()) == null || !StringUtils.equals((CharSequence)field.getKey(), (CharSequence)fieldKey) || !fieldTypeClz.contains(field.getClass())) continue;
            isValidateField = true;
            break;
        }
        editor.put("eb", isValidateField);
    }

    private Map<String, Object> createColumn(MainEntityType entityType, IListColumn col, FilterField filterField, Map<String, Map<String, Object>> decimalFieldMap) {
        if (col instanceof DecimalListColumn) {
            ((DecimalListColumn)col).setNoDisplayScaleZero(!this.getParent().getListUserOption().isShowZero());
        }
        if (col instanceof MergeListColumn) {
            ((MergeListColumn)col).setNoDisplayScaleZero(!this.getParent().getListUserOption().isShowZero());
        }
        Map column = col.createColumn(entityType);
        Map editor = (Map)column.get("editor");
        if (filterField != null && filterField.getFieldProp() instanceof ComboProp) {
            ViewCommonUtil.setComboListColumnEditor(col, (ComboProp)filterField.getFieldProp(), (Map<String, Object>)editor, filterField.getLatestParent());
        }
        if (filterField != null && filterField.getFieldProp() instanceof DecimalProp) {
            ViewCommonUtil.setDecimalColumnEditor(col, filterField.getFieldProp(), column);
        }
        if (this.numberFormatProvider != null && filterField != null && filterField.getFieldProp() instanceof DecimalProp) {
            ViewCommonUtil.createDecimalEditor(column, editor, decimalFieldMap);
        }
        this.addCellStyleRules(column, ((Control)col).getKey());
        this.setEditableColumnEditor(col, filterField, editor, decimalFieldMap);
        return column;
    }

    private void setTotalType(Map<String, Object> meta) {
        if (this.parent == null || this.parent.getBeforeCreateListColumnsArgs() == null) {
            return;
        }
        BeforeCreateListColumnsArgs args = this.parent.getBeforeCreateListColumnsArgs();
        if (StringUtils.isNotBlank((CharSequence)args.getTotalType())) {
            meta.put("totalType", args.getTotalType());
        }
    }

    public List<Map<String, Object>> createColumns(boolean isHeader) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        boolean bHideSeq = this.getParent().getListUserOption().isHideSeq();
        MainEntityType entityType = (MainEntityType)this.getParent().getEntityType();
        HashMap<String, Map<String, Object>> decimalFieldMap = new HashMap();
        IListDataProvider provider = this.parent.getListModel().getProvider();
        if (provider.getQueryResult().getNumberFormatProvider() != null) {
            decimalFieldMap = provider.getQueryResult().getNumberFormatProvider().getDecimalFieldMap();
        }
        String entityName = this.parent.getEntityType().getName();
        List<Control> listColumns = this.getItems();
        if (this.isDetailEntry() && !isHeader) {
            entityName = this.parent.buildCreateEntityName();
            this.parent.setInnerSelectEntryEntity(entityName);
            this.parent.setIncludeParent(false);
            listColumns = this.parent.rearrangeAndExetendFlex();
            this.parent.setInnerSelectEntryEntity(this.parent.getEntityType().getName());
            this.parent.setIncludeParent(true);
            if (StringUtils.isBlank((CharSequence)entityName)) {
                return cols;
            }
        }
        GridConfigRenderUtils.setListColumnFixed((List)listColumns, this.getFreezeList());
        Map<String, String> fieldKeyMap = this.getParent().getListCache().getFieldKeyMap();
        if (this.numberFormatProvider == null) {
            this.numberFormatProvider = this.parent.getListModel().getProvider().getQueryResult().getNumberFormatProvider();
        }
        for (Control item : listColumns) {
            Map<String, Object> column;
            Container col;
            if (item instanceof ListColumn) {
                ((ListColumn)item).setListColumnCompareTypesSetListeners(this.listColumnCompareTypesSetListeners);
            } else if (item instanceof ListColumnGroup) {
                ((ListColumnGroup)item).setListColumnCompareTypesSetListeners(this.listColumnCompareTypesSetListeners);
            } else if (item instanceof MergeListColumn) {
                ((MergeListColumn)item).setListColumnCompareTypesSetListeners(this.listColumnCompareTypesSetListeners);
            }
            if (isHeader && item instanceof ListColumnGroup) {
                col = (ListColumnGroup)item;
                col.setNoDisplayScaleZero(!this.getParent().getListUserOption().isShowZero());
                column = col.createColumn(entityType, decimalFieldMap, this.getOrderAndFilter());
                this.addCellStyleRulesListColumnGroup(column, (ListColumnGroup)col);
                cols.add(column);
                this.setFieldKey(fieldKeyMap, col, (List)column.get(CHILDREN), CHILDREN);
                continue;
            }
            if (isHeader && item instanceof AbstractListContainerColumn) {
                col = (AbstractListContainerColumn)item;
                col.setView(this.getView());
                col.setParentViewKey(this.getKey());
                col.setParent(this);
                col.setContext(new ListColumnContext(this.getParent().getContext().getCanNotReadFields(), this.getParent().getContext().getBlackFields(), this.getParent().getContext().isSingleOrgMode()));
                col.setDecimalFieldMap(decimalFieldMap);
                column = col.createColumn(entityType);
                cols.add(column);
                this.setFieldKey(fieldKeyMap, col, (List)column.get("items"), "items");
                continue;
            }
            if (!(item instanceof IListColumn) || !this.isValidListColumn(bHideSeq, (IListColumn)(col = (IListColumn)item))) continue;
            FilterField filterField = FilterField.create((MainEntityType)entityType, (String)col.getListFieldKey());
            if (this.isDetailEntry() && (filterField != null && !entityName.equalsIgnoreCase(filterField.getEntityKey()) || !isHeader && col.getSeqColType() == SeqColumnType.EntitySeq) || col.isListColumnHidden((EntityType)entityType, this.getView().getFormShowParameter() instanceof ListShowParameter, this.parent.isLookUp())) continue;
            if (!isHeader && item instanceof ListColumn && filterField != null) {
                ((ListColumn)item).setSrcFieldProp(filterField.getSrcFieldProp());
            }
            Map<String, Object> column2 = this.createColumn(entityType, decimalFieldMap, (IListColumn)col, filterField);
            ListGridView.putFlexListColumnFieldKeyMap(fieldKeyMap, item, column2);
            fieldKeyMap.put(column2.get("dataIndex").toString(), col.toString());
            cols.add(column2);
        }
        this.getParent().getListCache().putFieldKeyMap(fieldKeyMap);
        return cols;
    }

    private static void putFlexListColumnFieldKeyMap(Map<String, String> fieldKeyMap, Control item, Map<String, Object> column) {
        if (item instanceof FlexListColumn && ((FlexListColumn)item).isSplit()) {
            List children = (List)column.get(CHILDREN);
            for (Map child : children) {
                fieldKeyMap.put(child.get("dataIndex").toString(), child.get("fieldName").toString());
            }
        }
    }

    private Map<String, Object> createColumn(MainEntityType entityType, Map<String, Map<String, Object>> decimalFieldMap, IListColumn col, FilterField filterField) {
        col.setParentViewKey(this.getKey());
        col.setParent((Container)this);
        col.setContext(new ListColumnContext(this.getParent().getContext().getCanNotReadFields(), this.getParent().getContext().getBlackFields(), this.getParent().getContext().isSingleOrgMode()));
        if (col instanceof Control && this.getView() != null) {
            ((Control)col).setView(this.getView());
        }
        Map<String, Object> column = this.createColumn(entityType, col, filterField, decimalFieldMap);
        if (filterField != null && filterField.isFieldPropAliasEmpty() && !col.isBlankFieldCanOrderAndFilter()) {
            column.put("filter", false);
            column.put("sort", false);
        } else {
            this.createOrderAndFilterColumn(column);
        }
        return column;
    }

    private void setFieldKey(Map<String, String> fieldKeyMap, Container col, List<Map<String, Object>> childrenListMap, String childKey) {
        for (Control c : col.getItems()) {
            Map<String, Object> foundChild;
            if (c instanceof Container) {
                List thisChildrenListMap = null;
                foundChild = ListGridView.foundChild(childrenListMap, c.getKey());
                if (foundChild != null) {
                    thisChildrenListMap = (List)foundChild.get(childKey);
                }
                this.setFieldKey(fieldKeyMap, (Container)c, thisChildrenListMap, childKey);
                continue;
            }
            if (!(c instanceof ListColumn)) continue;
            ListColumn column = (ListColumn)c;
            if (childrenListMap != null && (foundChild = ListGridView.foundChild(childrenListMap, column.toString())) != null) {
                ListGridView.putFlexListColumnFieldKeyMap(fieldKeyMap, (Control)column, foundChild);
            }
            fieldKeyMap.put(column.getFieldKey().replace('.', '_'), column.toString());
        }
    }

    private static Map<String, Object> foundChild(List<Map<String, Object>> childrenListMap, String dataIndex) {
        Map<String, Object> foundChild = null;
        for (Map<String, Object> child : childrenListMap) {
            if (!dataIndex.equals(child.get("dataIndex"))) continue;
            foundChild = child;
            break;
        }
        return foundChild;
    }

    private List<Map<String, Object>> createClientRules() {
        ArrayList<Map<String, Object>> myClientRules = new ArrayList<Map<String, Object>>();
        for (BR bR : this.clientRules) {
            ClientRuleExecuteContext clientRuleExecuteContext = new ClientRuleExecuteContext(this.getModel(), bR.getPreCondition(), myClientRules);
            bR.execute((RuleExecuteContext)clientRuleExecuteContext);
        }
        return myClientRules;
    }

    private List<Map<String, Object>> buildRowStyleRules() {
        ArrayList<Map<String, Object>> myClientRules = new ArrayList<Map<String, Object>>(6);
        if (this.getClientRules() != null && !this.getClientRules().isEmpty()) {
            List<Map<String, Object>> rules = this.createClientRules();
            HashMap<String, Object> transRule = null;
            for (Map<String, Object> rule : rules) {
                transRule = new HashMap<String, Object>();
                if (!"rowStyleRules".equals(rule.get("type"))) continue;
                transRule.put("cond", rule.get("cond"));
                transRule.put("style", rule.get("style"));
                myClientRules.add(transRule);
            }
        }
        return myClientRules;
    }
}

