/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.AbstractListContainerColumn;
import kd.bos.permission.api.FieldControlRule;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListOperationColumn
extends AbstractListContainerColumn {
    private int operationColumnShowStyle;
    private LocaleString name;
    private List<OperationColItem> operationColItems = new ArrayList<OperationColItem>();
    boolean isSplit;
    private int visible = 11;

    @SimplePropertyAttribute
    public int getOperationColumnShowStyle() {
        return this.operationColumnShowStyle;
    }

    public void setOperationColumnShowStyle(int showStyle) {
        this.operationColumnShowStyle = showStyle;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OperationColItem.class)
    public List<OperationColItem> getOperationColItems() {
        return this.operationColItems;
    }

    public void setOperationColItems(List<OperationColItem> operationColItems) {
        this.operationColItems = operationColItems;
    }

    @SimplePropertyAttribute(name="Split")
    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    @Override
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="11")
    public int getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(int visible) {
        this.visible = visible;
    }

    @Override
    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map<String, Object> col = super.createColumn(entityType);
        col.put("dataIndex", this.getListFieldKey());
        col.put("editor", this.createEditor(entityType));
        col.put("header", this.getName());
        col.put("type", "operate");
        col.put("w", this.getWidth());
        col.put("entity", entityType.getName());
        if (this.isSplit()) {
            col.put("issp", this.isSplit());
        }
        return col;
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        return false;
    }

    private Map<String, Object> createEditor(MainEntityType entityType) {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "operate");
        ArrayList<Map> items = new ArrayList<Map>(10);
        for (OperationColItem item : this.operationColItems) {
            this.setColItemPermissionId(entityType, item);
            if (item == null) continue;
            items.add(item.createControl());
        }
        editor.put("opr", items);
        editor.put("showType", this.getOperationColumnShowStyle());
        return editor;
    }

    private void setColItemPermissionId(MainEntityType entityType, OperationColItem item) {
        if (item == null) {
            return;
        }
        String opk = "submitandnew".equalsIgnoreCase(item.getOperationKey()) ? "submit" : item.getOperationKey();
        EntityMetadataCache.getDataEntityOperate((String)entityType.getName()).stream().filter(o -> StringUtils.equals((CharSequence)opk, (CharSequence)((String)o.get("key")))).findFirst().ifPresent(op -> {
            if (StringUtils.isBlank(op.get("permission"))) {
                return;
            }
            item.setPermissionId((String)op.get("permission"));
        });
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
    }
}

