/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.privacy.PrivacyCenterTools;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.list.BillList;
import kd.bos.orm.impl.ORMConfiguration;
import kd.sdk.annotation.SdkInternal;

class ListPrivacyController {
    private BillList billList;

    ListPrivacyController(BillList billList) {
        this.billList = billList;
    }

    @SdkInternal
    void getPlainText(Integer row, String fieldKey, List<Object> pks) {
        HashMap data = new HashMap(6);
        this.billList.rearrangeListColumns(this.billList.getPermListColumns());
        List<ListField> allListFields = this.billList.getListFields();
        List<ListField> pkFields = this.getPkFields(allListFields);
        if (!StringUtils.isEmpty((CharSequence)fieldKey)) {
            ListSelectedRowCollection listRowColl;
            List<ListField> listFields = this.getGetPlainTextListFields(fieldKey, allListFields);
            if (listFields.isEmpty()) {
                BillList.logger.error("fieldKey not found" + fieldKey);
                return;
            }
            try {
                ListField listField = listFields.get(0);
                FilterField filterField = FilterField.create((MainEntityType)((MainEntityType)this.billList.getEntityType()), (String)listField.getListFieldKey());
                if (filterField == null) {
                    BillList.logger.info("filterField is null. fieldKey : {}", (Object)fieldKey);
                    return;
                }
                String operateType = "LIST";
                DynamicObject dr = null;
                IDataEntityProperty thisFieldProp = PrivacyCenterTools.isDesensitized((FilterField)filterField, (String)operateType);
                if (thisFieldProp != null) {
                    String operateTerminal = this.billList.getView() instanceof IMobileView ? "MOBILE" : "PC";
                    PrivacyCenterUtils.checkDecryptPermission((IDataEntityProperty)thisFieldProp, (String)"LIST", (String)operateTerminal, dr);
                }
            }
            catch (KDException e) {
                if (PrivacyDataConstant.ERRORCODE.equals((Object)e.getErrorCode())) {
                    this.billList.getView().showErrorNotification(e.getMessage());
                    return;
                }
                throw e;
            }
            if (row == -1) {
                AbstractGrid.GridState entryState = this.billList.getEntryState();
                int startLine = this.billList.getStartLine();
                int endLine = startLine + entryState.getPageRows();
                listRowColl = new ListSelectedRowCollection();
                ListSelectedRowCollection allListRowColl = this.billList.getCurrentListAllRowCollection();
                for (int i = startLine; i < endLine; ++i) {
                    listRowColl.add((Object)allListRowColl.get(i));
                }
                List<Object> clearVals = this.getPlainText(listRowColl, allListFields, listFields);
                for (int i = 0; i < clearVals.size(); ++i) {
                    Object clearVal = clearVals.get(i);
                    ArrayList fieldstates = new ArrayList(3);
                    HashMap<String, Object> tmp = new HashMap<String, Object>(6);
                    tmp.put("v", clearVal);
                    tmp.put("r", i);
                    tmp.put("k", fieldKey);
                    fieldstates.add(tmp);
                    data.put("fieldstates", fieldstates);
                    ((IClientViewProxy)this.billList.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.billList.getKey(), "setPlainText", new Object[]{data});
                }
            } else {
                boolean isRollLoading = this.billList.getView() instanceof IMobileView;
                if (isRollLoading) {
                    if (pks == null || pks.isEmpty() || pkFields.size() > pks.size()) {
                        BillList.logger.error("pks " + pks + " pkFields " + pkFields);
                        return;
                    }
                    ArrayList<List<Object>> pkss = new ArrayList<List<Object>>(3);
                    pkss.add(pks);
                    listRowColl = this.getListSelectedRows(pkss, pkFields);
                } else {
                    ListSelectedRowCollection currentListRowColl = this.billList.getCurrentListAllRowCollection();
                    if (currentListRowColl == null || currentListRowColl.isEmpty()) {
                        BillList.logger.error(String.format("currentListRowColl is null or isEmpty, row: %s, fieldKey: %s", row, fieldKey));
                        return;
                    }
                    int realRow = row - currentListRowColl.get(0).getRowKey();
                    if (realRow < 0 || realRow > currentListRowColl.size()) {
                        BillList.logger.error(String.format("realRow : %d, row: %s, fieldKey: %s", realRow, row, fieldKey));
                        return;
                    }
                    ListSelectedRow selectedRow = currentListRowColl.get(realRow);
                    listRowColl = new ListSelectedRowCollection();
                    listRowColl.add((Object)selectedRow);
                }
                List<Object> clearVals = this.getPlainText(listRowColl, allListFields, listFields);
                ArrayList fieldstates = new ArrayList(3);
                HashMap<String, Object> tmp = new HashMap<String, Object>(6);
                tmp.put("v", clearVals.size() > 0 ? clearVals.get(0) : null);
                tmp.put("r", row);
                tmp.put("k", fieldKey);
                fieldstates.add(tmp);
                data.put("fieldstates", fieldstates);
                ((IClientViewProxy)this.billList.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.billList.getKey(), "setPlainText", new Object[]{data});
            }
        }
    }

    private List<ListField> getGetPlainTextListFields(String fieldKey, List<ListField> allListFields) {
        ListField mainListField = null;
        for (ListField field : allListFields) {
            String tmpfieldKey;
            if (field.getKey() == null || !fieldKey.equals(tmpfieldKey = field.getKey().replace(".", "_"))) continue;
            mainListField = field;
            break;
        }
        ArrayList<ListField> listFields = new ArrayList<ListField>(4);
        if (mainListField != null) {
            listFields.add(mainListField);
        }
        return listFields;
    }

    private List<Object> getPlainText(ListSelectedRowCollection listRowColl, List<ListField> allListFields, List<ListField> listFields) {
        ArrayList<Object> clearVals = new ArrayList<Object>(listRowColl.size());
        QueryResult qr = this.billList.getQueryResult(allListFields, listRowColl, false, this.billList.generalFilterParameter(), true, false);
        ListField listField = listFields.get(0);
        if (qr.getCollection().size() != listRowColl.size() && listField.getSrcFieldProp().getParent() != null && !ORMConfiguration.isEntryEntityType((IDataEntityType)listField.getSrcFieldProp().getParent())) {
            HashMap<Object, Object> clearValMap = new HashMap<Object, Object>();
            for (DynamicObject item : qr.getCollection()) {
                Object clearVal = this.getClearValue(listField, item);
                clearValMap.put(item.getPkValue(), clearVal);
            }
            for (ListSelectedRow listSelectedRow : listRowColl) {
                clearVals.add(clearValMap.get(listSelectedRow.getPrimaryKeyValue()));
            }
        } else {
            for (DynamicObject item : qr.getCollection()) {
                Object clearVal = this.getClearValue(listField, item);
                clearVals.add(clearVal);
            }
        }
        return clearVals;
    }

    private Object getClearValue(ListField listField, DynamicObject item) {
        Object value = listField.getFieldProp() == null ? null : listField.getFieldProp().getValueFast((Object)item);
        String mainOrg = ((MainEntityType)this.billList.getEntityType()).getMainOrg();
        try {
            if (this.billList.getListModel().getProvider() == null || this.billList.getListModel().getProvider().getQueryBuilder() == null) {
                BillList.logger.info("getClearValue format error, priovide \uff1a " + this.billList.getListModel().getProvider());
                return value;
            }
            AbstractColumnDesc desc = listField.getColumnDesc(this.billList.getListModel().getProvider().getQueryBuilder().getReturnEntityType(), mainOrg, false);
            desc.setListUserOption(this.billList.listUserOption);
            HashMap<String, Boolean> sysParams = new HashMap<String, Boolean>();
            sysParams.put("ismaterialprecisionenable", FmtInfoUtils.applyMaterialPrecision());
            FormatObject format = null;
            if (BillList.InteServiceHelper_getUserFormat != null) {
                format = (FormatObject)BillList.InteServiceHelper_getUserFormat.invoke(null, RequestContext.get().getCurrUserId());
            }
            desc.setUserFormat(format);
            desc.setFormatParams(sysParams);
            if (desc instanceof TimeColumnDesc && !(value instanceof Object[])) {
                desc.getFormatParams().put("columntype", "listcolumn");
            }
            value = desc.getValue(item);
        }
        catch (Exception e) {
            BillList.logger.error("getUserFormat error", (Throwable)e);
        }
        return value;
    }

    private ListSelectedRowCollection getListSelectedRows(List<List<Object>> pkss, List<ListField> pkFields) {
        ListSelectedRowCollection listRowColl = new ListSelectedRowCollection();
        for (List<Object> pks : pkss) {
            Object newValue;
            ListField pkField;
            Object pkVal = this.billList.billListSelection.convertPkValue(pkFields.get(0), pks.get(0));
            ListSelectedRow listRow = new ListSelectedRow(pkVal, Boolean.valueOf(pkFields.get(0).getSrcFieldProp() instanceof LongProp));
            if (pkFields.size() > 1) {
                pkField = pkFields.get(1);
                newValue = this.billList.billListSelection.convertPkValue(pkField, pks.get(1));
                listRow.setEntryPrimaryKeyValue(newValue);
                listRow.setEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
            if (pkFields.size() > 2) {
                pkField = pkFields.get(2);
                newValue = this.billList.billListSelection.convertPkValue(pkField, pks.get(2));
                listRow.setSubEntryPrimaryKeyValue(newValue);
                listRow.setSubEntryEntityKey(pkField.getSrcFieldProp().getParent().getName());
            }
            listRowColl.add((Object)listRow);
        }
        return listRowColl;
    }

    private List<ListField> getPkFields(List<ListField> listFields) {
        MainEntityType entityType = (MainEntityType)this.billList.getEntityType();
        return EntityTypeUtil.getValidPkFields((EntityType)entityType, listFields);
    }
}

