/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.list.BillList;
import kd.bos.list.events.ChatEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class ListYzjChat {
    private static final String BOS_FORM_CORE = "bos-form-core";
    private BillList billList;

    ListYzjChat(BillList billList) {
        this.billList = billList;
    }

    /*
     * WARNING - void declaration
     */
    void chat(ListSelectedRow currentListSelectedRow) {
        String field = this.billList.getEntryState().getFocusField();
        String fieldKey = null;
        IDataEntityProperty userProp = null;
        List<ListField> listFields = this.billList.getListFields();
        for (ListField listField : listFields) {
            if (!listField.getKey().replace(".", "_").equalsIgnoreCase(field)) continue;
            userProp = listField.getSrcFieldProp();
            fieldKey = listField.getListFieldKey();
            break;
        }
        if (currentListSelectedRow != null && currentListSelectedRow.getPrimaryKeyValue() != null && userProp instanceof UserProp) {
            void var8_14;
            ChatEvent chatEvent = new ChatEvent((Object)this.billList, currentListSelectedRow, fieldKey);
            for (Consumer<ChatEvent> consumer : this.billList.chatListeners) {
                consumer.accept(chatEvent);
            }
            if (chatEvent.isCancel()) {
                return;
            }
            DynamicObject dynamicObject = this.billList.getModel().loadReferenceData((DynamicObjectType)this.billList.getEntityType(), currentListSelectedRow.getPrimaryKeyValue());
            Object var8_11 = null;
            if (userProp.getParent() instanceof EntryType) {
                Object object = this.getEntryUserPropValue(userProp, currentListSelectedRow, dynamicObject);
            } else {
                Object userValue = userProp.getValue((Object)dynamicObject);
                if (userValue != null) {
                    Object object = ((UserProp)userProp).getDynamicComplexPropertyType().getPrimaryKey().getValue(userValue);
                }
            }
            if (var8_14 != null) {
                this.startYzjChat(var8_14);
            }
        }
    }

    private Object getEntryUserPropValue(IDataEntityProperty userProp, ListSelectedRow currentListSelectedRow, DynamicObject rowData) {
        DynamicObject dynamicObject = null;
        Object pkValue = userProp.getParent() instanceof SubEntryType ? currentListSelectedRow.getSubEntryPrimaryKeyValue() : currentListSelectedRow.getEntryPrimaryKeyValue();
        if (pkValue == null) {
            return null;
        }
        EntryProp entryProp = (EntryProp)this.billList.getEntityType().getProperty(userProp.getParent().getName());
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)entryProp.getValue((Object)rowData);
        for (DynamicObject entryRowData : dynamicObjectCollection) {
            if (!pkValue.toString().equalsIgnoreCase(userProp.getParent().getPrimaryKey().getValue((Object)entryRowData).toString())) continue;
            dynamicObject = entryRowData;
            break;
        }
        if (dynamicObject == null) {
            return null;
        }
        Object userValue = userProp.getValue(dynamicObject);
        if (userValue != null) {
            return ((UserProp)userProp).getDynamicComplexPropertyType().getPrimaryKey().getValue(userValue);
        }
        return null;
    }

    private void startYzjChat(Object userId) {
        try {
            ORM orm = ORM.create();
            QFilter f1 = new QFilter("id", "=", userId);
            QFilter[] filters = new QFilter[]{f1};
            DynamicObjectCollection docUser = orm.query("bos_user", "id,name,useropenid", filters, "id asc");
            if (docUser == null || docUser.isEmpty()) {
                this.billList.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BillList_5", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                return;
            }
            String openId = ((DynamicObject)docUser.get(0)).getString("useropenid");
            if (StringUtils.isBlank((CharSequence)openId)) {
                return;
            }
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put("oid", openId);
            ((IClientViewProxy)this.billList.getView().getService(IClientViewProxy.class)).addAction("chatToYZJ_PC", mData);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, BosErrorCode.render, new Object[]{String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e91\u4e4b\u5bb6\u804a\u5929\u7fa4\u7ec4\u5931\u8d25\u3002%s", (String)"BillList_6", (String)BOS_FORM_CORE, (Object[])new Object[0]), ex.getMessage())});
        }
    }
}

