/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.lang.Lang;
import kd.bos.list.AbstractList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MulBdPermUtil;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.QueryFactory;
import kd.bos.list.query.impl.BaseData;
import kd.bos.list.query.impl.BaseDataQuery;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.userconfig.UserConfigLocalCache;
import kd.bos.userconfig.UserConfigQuery;

public class MobileList
extends AbstractList {
    private static final String BOS_FORM_CORE = "bos-form-core";
    private int pageRow = 20;
    private boolean showSearch = false;
    private String primaryField;
    private String secondField;
    private String iconField;
    private ListUserOption listUserOption;
    String billFormId;
    boolean isMulti;
    boolean showModal;
    boolean isShowFrequent;
    ListShowParameter listShowParameter;
    MainEntityType dataEntityType;
    protected static final String MFORM_SETTING = "MFormSetting";
    protected static final String FORM_SETTING = "FormSetting";

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="20")
    public int getPageRow() {
        return this.pageRow;
    }

    public void setPageRow(int pageRow) {
        this.pageRow = pageRow;
    }

    public String getPrimaryField() {
        return this.primaryField;
    }

    public void setPrimaryField(String primaryField) {
        this.primaryField = primaryField;
    }

    public String getSecondField() {
        return this.secondField;
    }

    public void setSecondField(String secondField) {
        this.secondField = secondField;
    }

    public String getIconField() {
        return this.iconField;
    }

    public void setIconField(String iconField) {
        this.iconField = iconField;
    }

    public ListUserOption getListUserOption() {
        if (this.listUserOption != null) {
            return this.listUserOption;
        }
        FormConfig cfg = FormMetadataCache.getMobListFormConfig((String)this.getBillFormId());
        if (cfg == null) {
            this.listUserOption = new ListUserOption();
        } else {
            Map listUserOptions = ParameterHelper.getListOptions((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getBillFormId(), (String)cfg.getListUserOption(), null);
            this.listUserOption = new ListUserOption(listUserOptions);
        }
        return this.listUserOption;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    private String getEntityId() {
        return FormMetadataCache.getFormConfig((String)this.getBillFormId()).getEntityTypeId();
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public void setMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    public boolean isShowModal() {
        return this.showModal;
    }

    public void setShowModal(boolean showModal) {
        this.showModal = showModal;
    }

    public boolean isShowSearch() {
        return this.showSearch;
    }

    public void setShowSearch(boolean showSearch) {
        this.showSearch = showSearch;
    }

    public boolean isShowFrequent() {
        return this.isShowFrequent;
    }

    public void setShowFrequent(boolean isShowFrequent) {
        this.isShowFrequent = isShowFrequent;
    }

    public ListShowParameter getListShowParameter() {
        return this.listShowParameter;
    }

    public void setListShowParameter(ListShowParameter listShowParameter) {
        this.listShowParameter = listShowParameter;
    }

    public MainEntityType getEntityType() {
        if (this.dataEntityType == null) {
            this.dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        }
        return this.dataEntityType;
    }

    private IListModel createListModel() {
        IListModel listModel = (IListModel)TypesContainer.createInstance((String)"kd.bos.mvc.list.ListModel");
        listModel.setEntityId(this.getEntityId());
        listModel.setDataEntityType((EntityType)this.getEntityType());
        listModel.setPageId(this.getView().getPageId());
        listModel.setListUserOption(this.getListUserOption());
        return listModel;
    }

    ListField createListFieldByFieldName(String fieldName) {
        if (this.getEntityType().findProperty(fieldName) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u4e0a\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a%s\u7684\u5b57\u6bb5\u3002", (String)"MobileList_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), fieldName));
        }
        ListField primaryListField = new ListField(fieldName);
        primaryListField.setListFieldKey(fieldName);
        primaryListField.setFieldName(fieldName);
        primaryListField.setLookup(true);
        return primaryListField;
    }

    List<ListField> getQueryFields() {
        ListField iconListField;
        ListField secondListField;
        ListField primaryListField;
        ArrayList<ListField> selectFields = new ArrayList<ListField>();
        Map keyFields = EntityTypeUtil.getKeyFields((MainEntityType)this.getEntityType());
        String innerPrimaryField = this.primaryField;
        if (StringUtils.isEmpty((CharSequence)innerPrimaryField)) {
            innerPrimaryField = (String)keyFields.get("name");
        }
        if (!selectFields.contains(primaryListField = this.createListFieldByFieldName(innerPrimaryField))) {
            selectFields.add(primaryListField);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.secondField) && !selectFields.contains(secondListField = this.createListFieldByFieldName(this.secondField))) {
            selectFields.add(secondListField);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.iconField) && !selectFields.contains(iconListField = this.createListFieldByFieldName(this.iconField))) {
            selectFields.add(iconListField);
        }
        return selectFields;
    }

    DataQueryResult getQueryResult(QFilter qFilter, int start, int limit, String key) {
        return this.getQueryResult(qFilter, start, limit, key, false);
    }

    DataQueryResult getQueryResult(QFilter qFilter, int start, int limit, String key, boolean isFromSelected) {
        PageRowCacheUtils.initTouch();
        PageRowCacheUtils.setPageId((String)this.getView().getPageId());
        PageRowCacheUtils.setControlKey((String)key);
        IListModel model = this.createListModel();
        model.setNeedKeyFields(false);
        ListFilterParameter listFilterParameter2 = this.getListShowParameter().getListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!isFromSelected) {
            qFilters.addAll(listFilterParameter2.getQFilters());
        }
        qFilters.add(qFilter);
        FilterParameter queryFilterParameter = new FilterParameter(qFilters, listFilterParameter2.getOrderBy());
        model.setFilterParameter(queryFilterParameter);
        model.setListFields(this.getQueryFields());
        model.getData(start, limit);
        return new DataQueryResult(model.getQueryResult(), model.getProvider().getListFields());
    }

    DataQueryResult getQueryResult(QFilter qFilter, int pageIndex) {
        if (this.isShowModal()) {
            return this.getQueryResult(qFilter, 0, 50, this.getKey());
        }
        return this.getQueryResult(qFilter, pageIndex * this.getPageRow(), this.getPageRow(), this.getKey());
    }

    private String getColumnDescValue(ColumnDesc columnDesc, DynamicObject dynamicObject) {
        String val = this._getColumnDescValue(columnDesc, dynamicObject);
        return String.valueOf(columnDesc.getDesensitizeValue(Lang.get().toString(), dynamicObject, (Object)val));
    }

    private String _getColumnDescValue(ColumnDesc columnDesc, DynamicObject dynamicObject) {
        Object value = columnDesc.getValue(dynamicObject);
        if (value instanceof Object[]) {
            Object v = ((Object[])value)[0];
            if (v == null) {
                return "";
            }
            return v.toString();
        }
        if (columnDesc.getSrcFieldProp() instanceof ComboProp) {
            return ((ComboProp)columnDesc.getSrcFieldProp()).getItemByName((String)value);
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    List<Map<String, Object>> getRowDatas(DataQueryResult queryResult) {
        return this.getRowDatas(queryResult, new ArrayList<Object>());
    }

    List<Map<String, Object>> getRowDatas(DataQueryResult queryResult, List<Object> pkIds) {
        String pkField = this.getEntityType().getPrimaryKey().getName();
        Map keyFields = EntityTypeUtil.getKeyFields((MainEntityType)this.getEntityType());
        String innerPrimaryField = this.primaryField;
        if (StringUtils.isEmpty((CharSequence)innerPrimaryField)) {
            innerPrimaryField = (String)keyFields.get("name");
        }
        ArrayList<Map<String, Object>> rowdatas = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> columnDesces = new HashMap<String, Object>(16);
        for (ListField listField : queryResult.getSelectFields()) {
            AbstractColumnDesc columnDesc = listField.getColumnDesc(queryResult.getQueryResult().getCollection().getDynamicObjectType(), "", false);
            columnDesces.put(listField.getListFieldKey(), columnDesc);
        }
        DynamicObjectCollection collection = queryResult.getQueryResult().getCollection();
        if (!pkIds.isEmpty()) {
            ArrayList<String> sortKeys = new ArrayList<String>(10);
            for (Object e : pkIds) {
                sortKeys.add(e.toString());
            }
            collection = this.getSortedNewDynamicObjectCollection(collection, sortKeys, t -> t.get(pkField).toString());
        }
        for (DynamicObject dynamicObject : collection) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("id", dynamicObject.get(pkField).toString());
            hashMap.put("mt", this.getColumnDescValue((ColumnDesc)columnDesces.get(innerPrimaryField), dynamicObject));
            if (StringUtils.isNotEmpty((CharSequence)this.secondField)) {
                hashMap.put("st", this.getColumnDescValue((ColumnDesc)columnDesces.get(this.secondField), dynamicObject));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.iconField)) {
                hashMap.put("url", this.getColumnDescValue((ColumnDesc)columnDesces.get(this.iconField), dynamicObject));
            }
            rowdatas.add(hashMap);
        }
        return rowdatas;
    }

    private DynamicObjectCollection getSortedNewDynamicObjectCollection(DynamicObjectCollection newDynamicObjectCollection, List<String> sortKeys, Function<DynamicObject, String> sortKeyFunction) {
        DynamicObjectCollection sortedNewDynamicObjectCollection = new DynamicObjectCollection(newDynamicObjectCollection.getDynamicObjectType(), null);
        LinkedHashMap<String, Integer> bucket = new LinkedHashMap<String, Integer>();
        for (String sortKey : sortKeys) {
            Integer count = 1;
            if (bucket.containsKey(sortKey)) {
                Integer n = count = (Integer)((HashMap)bucket).get(sortKey);
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            bucket.put(sortKey, count);
        }
        this.putBucketListSelectedRowCollection(newDynamicObjectCollection, sortedNewDynamicObjectCollection, bucket, sortKeyFunction);
        for (DynamicObject listSelectedRow : newDynamicObjectCollection) {
            String key = sortKeyFunction.apply(listSelectedRow);
            if ((!bucket.containsKey(key) || (Integer)((HashMap)bucket).get(key) <= 0) && bucket.containsKey(key)) continue;
            sortedNewDynamicObjectCollection.add((Object)listSelectedRow);
        }
        return sortedNewDynamicObjectCollection;
    }

    private void putBucketListSelectedRowCollection(DynamicObjectCollection newDynamicObjectCollection, DynamicObjectCollection sortedNewDynamicObjectCollection, HashMap<String, Integer> bucket, Function<DynamicObject, String> sortKeyFunction) {
        HashMap<String, DynamicObject> listSelectedRowMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : newDynamicObjectCollection) {
            listSelectedRowMap.put(sortKeyFunction.apply(dynamicObject), dynamicObject);
        }
        for (Map.Entry<String, Integer> entry : bucket.entrySet()) {
            if (!listSelectedRowMap.containsKey(entry.getKey())) continue;
            Integer count = entry.getValue();
            while (count > 0) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count - 1);
                bucket.put(entry.getKey(), count);
            }
            if (count != 0) continue;
            bucket.put(entry.getKey(), count);
            sortedNewDynamicObjectCollection.add(listSelectedRowMap.get(entry.getKey()));
        }
    }

    private boolean isSqlQuery() {
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            return listShowParameter.isSqlQuery() || QueryFactory.isSqlQuery();
        }
        return QueryFactory.isSqlQuery();
    }

    Map<String, Object> packageData(DataQueryResult queryResult) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        HashMap<String, Object> listData = new HashMap<String, Object>();
        ArrayList<Object> pkIds = new ArrayList<Object>();
        for (ListSelectedRow listSelectedRow : this.getListShowParameter().getListSelectedRowCollection()) {
            pkIds.add(listSelectedRow.getPrimaryKeyValue());
        }
        this.getView().getFormShowParameter().setCustomParam("originFieldKey", this.listShowParameter.getCustomParam("originFieldKey"));
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (parentFormId.endsWith("_mob")) {
            FormConfig mobileConfig = FormMetadataCache.getFormConfig((String)parentFormId);
            parentFormId = mobileConfig.getEntityTypeId();
        }
        this.getView().getFormShowParameter().setCustomParam("originUseOrg", (Object)this.listShowParameter.getUseOrgId());
        this.getView().getFormShowParameter().setCustomParam("originFormId", (Object)parentFormId);
        MulBdPermUtil.setAuthorizedData(this.getView(), this.getKey(), pkIds);
        configMap.put("isMust", this.getListShowParameter().isMustInput());
        configMap.put("isMulti", this.isMulti());
        configMap.put("showModel", this.isShowModal());
        configMap.put("showSearch", this.isShowSearch());
        configMap.put("type", this.getBillFormId());
        configMap.put("title", new LocaleString(this.getView().getFormShowParameter().getCaption()));
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)this.getKey());
        configMap.put("selected", this.getRowDatas(this.getQueryResult(new QFilter(this.getEntityType().getPrimaryKey().getName(), "in", pkIds), 0, this.getListShowParameter().getListSelectedRowCollection().size(), null, true), pkIds));
        configMap.put("sft", this.isShowFrequent());
        listData.put("config", configMap);
        listData.put("data", this.getRowDatas(queryResult));
        int dataCount = queryResult.getQueryResult().getDataCount();
        int pageCount = dataCount / this.getPageRow() + (dataCount % this.getPageRow() > 0 ? 1 : 0);
        if (this.isSqlQuery()) {
            if (queryResult.getQueryResult().getCollection().size() >= this.getPageRow()) {
                listData.put("hasMore", true);
            } else {
                listData.put("hasMore", false);
            }
        } else {
            listData.put("hasMore", 2 <= pageCount);
        }
        return listData;
    }

    private Map<String, Object> getNextPageDataResult(DataQueryResult queryResult, int pageIndex) {
        int dataCount = queryResult.getQueryResult().getDataCount();
        int pageCount = dataCount / this.getPageRow() + (dataCount % this.getPageRow() > 0 ? 1 : 0);
        List<Map<String, Object>> rowDatas = this.getRowDatas(queryResult);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("pageIndex", pageIndex);
        if (this.isSqlQuery()) {
            if (queryResult.getQueryResult().getCollection().size() >= this.getPageRow()) {
                dataMap.put("hasMore", true);
            } else {
                dataMap.put("hasMore", false);
            }
        } else {
            dataMap.put("hasMore", pageIndex + 2 <= pageCount);
        }
        dataMap.put("data", rowDatas);
        return dataMap;
    }

    private void setNextPageData(int pageIndex, String setMethodName) {
        AbstractList.ListState entryState = this.getEntryState();
        DataQueryResult queryResult = this.getQueryResult(this.getSearchTextFilter(entryState.getSearchText()), pageIndex);
        this.clientViewProxy.invokeControlMethod(this.getKey(), setMethodName, new Object[]{this.getNextPageDataResult(queryResult, pageIndex)});
    }

    public void getNextPageData(int pageIndex) {
        this.setNextPageData(pageIndex, "setNextPageData");
    }

    public void getSearchNextPageData(int pageIndex) {
        this.setNextPageData(pageIndex, "setSearchNextPageData");
    }

    public void bindData(BindingContext object) {
        if (StringUtils.isEmpty((CharSequence)this.getBillFormId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MobileList_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadGeneralF7Data", new Object[]{this.packageData(this.getQueryResult(null, 0))});
        super.bindData(object);
    }

    @Override
    protected ListSelectedRowCollection getSelectedRows(List<Object> pkList) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getBillFormId());
        if (this.isMulti()) {
            for (Object pkValue : pkList) {
                if (!StringUtils.isNotBlank((Object)pkValue)) continue;
                listSelectedRows.add((Object)this.getListSelectedRow(pkValue, (EntityType)entityType));
            }
        } else if (StringUtils.isNotBlank((Object)pkList.get(0))) {
            listSelectedRows.add((Object)this.getListSelectedRow(pkList.get(0), (EntityType)entityType));
        }
        return listSelectedRows;
    }

    @Override
    public void endSelect(List<Object> params) {
        if (params.isEmpty()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String parentFormId = (String)showParameter.getCustomParam("originFormId");
            String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
            String json = this.getView().getPageCache().get(parentFormId + "__" + originFieldKey);
            if (StringUtils.isNotBlank((CharSequence)json)) {
                List unRemovablePks = SerializationUtils.fromJsonStringToList((String)json, String.class);
                params.addAll(unRemovablePks);
            }
        }
        super.endSelect(params);
    }

    private QFilter getSearchTextFilter(String searchText) {
        String innerSecondField;
        Map keyFields = EntityTypeUtil.getKeyFields((MainEntityType)this.getEntityType());
        String innerPrimaryField = this.primaryField;
        if (StringUtils.isEmpty((CharSequence)innerPrimaryField)) {
            innerPrimaryField = (String)keyFields.get("name");
        }
        if (StringUtils.isEmpty((CharSequence)(innerSecondField = this.secondField))) {
            innerSecondField = (String)keyFields.get("number");
        }
        Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)this.getEntityType().getName());
        String searchtype = "1";
        if (pubSysParam != null) {
            searchtype = (String)pubSysParam.get("searchtype");
        }
        String finalSearchKey = searchText;
        if ("2".equals(searchtype)) {
            finalSearchKey = searchText + "%";
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityType().getName());
        ArrayList<String> encryptFields = new ArrayList<String>(6);
        ArrayList<String> searchFields = new ArrayList<String>();
        searchFields.add(innerPrimaryField);
        searchFields.add(innerSecondField);
        if (StringUtils.isNotEmpty((CharSequence)finalSearchKey)) {
            Iterator iterator = searchFields.iterator();
            while (iterator.hasNext()) {
                String searchField = (String)iterator.next();
                IDataEntityProperty prop = entityType.findProperty(searchField);
                boolean isEncrypt = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)prop);
                if (!isEncrypt) continue;
                iterator.remove();
                encryptFields.add(searchField);
            }
        }
        QFilter searchQFilter = null;
        if (encryptFields.isEmpty() || !searchFields.isEmpty()) {
            searchQFilter = QFilter.ftlike((String)finalSearchKey, (String[])searchFields.toArray(new String[0]));
        } else {
            for (String encryptField : encryptFields) {
                if (searchQFilter == null) {
                    searchQFilter = new QFilter(encryptField, "=", (Object)finalSearchKey);
                    continue;
                }
                searchQFilter.or(new QFilter(encryptField, "=", (Object)finalSearchKey));
            }
        }
        return searchQFilter;
    }

    public void onChange(String searchText) {
        AbstractList.ListState entryState = this.getEntryState();
        entryState.putSearchText(searchText);
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)this.getKey());
        DataQueryResult queryResult = this.getQueryResult(this.getSearchTextFilter(searchText), 0);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setSearchResultList", new Object[]{this.getNextPageDataResult(queryResult, 0)});
    }

    public void cancel() {
        this.getView().close();
    }

    private static UserConfig getUserConfig(long userID, String key) {
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        return userConfigQuery.getUserConfig(key, userID);
    }

    private static UserConfig getUserConfigByCache(long userID, String key) {
        String cacheKey = String.format("%s.%s", userID, key);
        UserConfig userConfig = (UserConfig)UserConfigLocalCache.getCacheData((String)cacheKey, (String)key);
        if (userConfig == null && (userConfig = MobileList.getUserConfig(userID, key)) != null) {
            UserConfigLocalCache.cache((String)cacheKey, (Object)userConfig, (String)key);
        }
        return userConfig;
    }

    private static String getSetting(long userID, String key) {
        UserConfig userConfig = MobileList.getUserConfigByCache(userID, key);
        if (userConfig != null) {
            return userConfig.getSetting();
        }
        return "";
    }

    public void getFeqData() {
        String setting = MobileList.getSetting(Long.parseLong(RequestContext.get().getUserId()), this.getView().getFormShowParameter().getParentFormId() + "." + MFORM_SETTING);
        if (StringUtils.isBlank((CharSequence)setting)) {
            setting = MobileList.getSetting(Long.parseLong(RequestContext.get().getUserId()), this.getView().getFormShowParameter().getParentFormId() + "." + FORM_SETTING);
        }
        if (StringUtils.isNotBlank((CharSequence)setting) && this.getEntityType() instanceof BasedataEntityType) {
            Map settingData = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            Map useruistate = (Map)settingData.get("__useruistate__");
            if (!useruistate.containsKey("basedata")) {
                return;
            }
            Map basedata = (Map)useruistate.get("basedata");
            Map formdata = (Map)basedata.get(this.getBillFormId());
            if (formdata == null) {
                return;
            }
            Map recent = (Map)formdata.get("recent");
            List myFrequent = (List)recent.get("myFrequent");
            ArrayList pkIds = new ArrayList();
            HashMap<String, Integer> pkFeq = new HashMap<String, Integer>();
            int i = 0;
            for (Object flist : myFrequent) {
                if (!(flist instanceof Map)) continue;
                Map map = (Map)flist;
                Object pkId = map.get("id");
                pkIds.add(pkId);
                pkFeq.put(pkId.toString(), i++);
            }
            List realPkList = TypeChange.getRealPkList((DynamicObjectType)this.getEntityType(), pkIds);
            BasedataEntityType basedataEntityType = (BasedataEntityType)this.getEntityType();
            ListFilterParameter listFilterParameter2 = this.getListShowParameter().getListFilterParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.addAll(listFilterParameter2.getQFilters());
            qFilters.add(new QFilter("id", "in", (Object)realPkList));
            List baseDatas = BaseDataQuery.queryBaseDataByFilter((BasedataEntityType)basedataEntityType, (QFilter[])qFilters.toArray(new QFilter[0]));
            Collections.sort(baseDatas, (o1, o2) -> Integer.compare((Integer)pkFeq.get(o1.getId().toString()), (Integer)pkFeq.get(o2.getId().toString())));
            ArrayList list = new ArrayList(10);
            for (BaseData baseData2 : baseDatas) {
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(baseData2.getId().toString());
                vals.add(baseData2.getNumber());
                vals.add(baseData2.getName());
                vals.add((String)pkFeq.get(baseData2.getId().toString()));
                list.add(vals);
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setFrequentData", new Object[]{list});
        }
    }

    public void getFeqData(List<List<?>> myFrequent) {
        if (!myFrequent.isEmpty() && this.getEntityType() instanceof BasedataEntityType) {
            ArrayList pkIds = new ArrayList();
            HashMap<String, Integer> pkFeq = new HashMap<String, Integer>();
            int i = 0;
            for (List<?> flist : myFrequent) {
                if (!(flist instanceof Map)) continue;
                Map map = (Map)((Object)flist);
                Object pkId = map.get("id");
                pkIds.add(pkId);
                pkFeq.put(pkId.toString(), i++);
            }
            List realPkList = TypeChange.getRealPkList((DynamicObjectType)this.getEntityType(), pkIds);
            BasedataEntityType basedataEntityType = (BasedataEntityType)this.getEntityType();
            ListFilterParameter listFilterParameter2 = this.getListShowParameter().getListFilterParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.addAll(listFilterParameter2.getQFilters());
            qFilters.add(new QFilter("id", "in", (Object)realPkList));
            List baseDatas = BaseDataQuery.queryBaseDataByFilter((BasedataEntityType)basedataEntityType, (QFilter[])qFilters.toArray(new QFilter[0]));
            Collections.sort(baseDatas, (o1, o2) -> Integer.compare((Integer)pkFeq.get(o1.getId().toString()), (Integer)pkFeq.get(o2.getId().toString())));
            ArrayList list = new ArrayList(10);
            for (BaseData baseData2 : baseDatas) {
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(baseData2.getId().toString());
                vals.add(baseData2.getNumber());
                vals.add(baseData2.getName());
                vals.add((String)pkFeq.get(baseData2.getId().toString()));
                list.add(vals);
            }
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setFrequentData", new Object[]{list});
        }
    }

    static class DataQueryResult {
        QueryResult queryResult;
        List<ListField> selectFields = new ArrayList<ListField>();

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public List<ListField> getSelectFields() {
            return this.selectFields;
        }

        public DataQueryResult(QueryResult queryResult, List<ListField> selectFields) {
            this.queryResult = queryResult;
            this.selectFields = selectFields;
        }
    }
}

