/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.MobileSearchFilterValues;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.BindingContext;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchInitEvent;
import kd.bos.form.control.events.MobileSearchInitListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.list.ControlContext;
import kd.bos.list.ITemplateControl;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobileSearch
extends Container
implements ITemplateControl {
    private MainEntityType entityType;
    private MobileSearchFilterValues mobileSearchFilterValues;
    private LocaleString emptyText;
    private int mobileShowModel;
    private int visible;
    private String billFormId;
    private String entityId;
    ControlContext context = null;
    private boolean multiKeySearch = false;
    protected List<MobileSearchFocusListener> mobileSearchFocusListeners = new ArrayList<MobileSearchFocusListener>();
    protected List<MobileSearchTextChangeListener> mobileSearchTextChangeListeners = new ArrayList<MobileSearchTextChangeListener>();
    protected List<MobileSearchInitListener> mobileSearchInitListeners = new ArrayList<MobileSearchInitListener>();
    private List<BeforeBindDataListener> beforeBindDataListeners = new ArrayList<BeforeBindDataListener>();
    private List<AfterBindDataListener> afterBindDataListeners = new ArrayList<AfterBindDataListener>();
    protected List<MobileSearchCancelListener> mobileSearchCancelListeners = new ArrayList<MobileSearchCancelListener>();

    public MobileSearchFilterValues getMobileSearchFilterValues() {
        if (this.mobileSearchFilterValues != null) {
            return this.mobileSearchFilterValues;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheKey = this.getKey() + "_cachedFilterValues";
        if (this.mobileSearchFilterValues == null && pageCache.get(cacheKey) != null) {
            this.mobileSearchFilterValues = MobileSearchFilterValues.deSerialize((String)pageCache.get(cacheKey));
        }
        if (this.mobileSearchFilterValues == null) {
            this.mobileSearchFilterValues = new MobileSearchFilterValues();
        }
        return this.mobileSearchFilterValues;
    }

    @SdkInternal
    public void setMobileSearchFilterValues(MobileSearchFilterValues mobileSearchFilterValues) {
        this.mobileSearchFilterValues = mobileSearchFilterValues;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(this.getKey() + "_cachedFilterValues", mobileSearchFilterValues.serialize());
    }

    @SimplePropertyAttribute(name="MobileShowModel")
    public int getMobileShowModel() {
        return this.mobileShowModel;
    }

    public void setMobileShowModel(int mobileShowModel) {
        this.mobileShowModel = mobileShowModel;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
        this.entityType = null;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    @SdkInternal
    public void setContext(ControlContext context) {
        this.context = context;
    }

    public ControlContext getContext() {
        if (this.context == null) {
            this.context = new ControlContext();
        }
        return this.context;
    }

    @SimplePropertyAttribute(name="MultiKeySearch")
    public boolean isMultiKeySearch() {
        return this.multiKeySearch;
    }

    public void setMultiKeySearch(boolean isMultiKeySearch) {
        this.multiKeySearch = isMultiKeySearch;
    }

    @SimplePropertyAttribute
    public LocaleString getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(LocaleString emptyText) {
        this.emptyText = emptyText;
    }

    public void addMobileSearchFocusListener(MobileSearchFocusListener listener) {
        this.mobileSearchFocusListeners.add(listener);
    }

    public void addMobileSearchTextChangeListener(MobileSearchTextChangeListener listener) {
        this.mobileSearchTextChangeListeners.add(listener);
    }

    public void addMobileSearchInitListener(MobileSearchInitListener listener) {
        this.mobileSearchInitListeners.add(listener);
    }

    public void addBeforeBindDataListener(BeforeBindDataListener listener) {
        this.beforeBindDataListeners.add(listener);
    }

    public void addAfterBindDataListener(AfterBindDataListener listener) {
        this.afterBindDataListeners.add(listener);
    }

    public void addMobileSearchCancelListener(MobileSearchCancelListener listener) {
        this.mobileSearchCancelListeners.add(listener);
    }

    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.getVisible());
        }
        if (this.getMobileShowModel() != 0) {
            map.put("showModel", this.getMobileShowModel());
        }
        if (StringUtils.isNotBlank((Object)this.getEmptyText())) {
            map.put("emptytip", this.getEmptyText());
        }
        return map;
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    private void setMetadata() {
        Map meta;
        List<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
        if (StringUtils.isNotBlank((CharSequence)this.billFormId) && (meta = FormMetadataCache.getMobFilterMeta((String)this.billFormId)) != null && meta.containsKey(MobileSearch.class.getSimpleName())) {
            String strMobileSearch = (String)meta.get(MobileSearch.class.getSimpleName());
            MobileSearch mobileSearch = (MobileSearch)ControlTypes.fromJsonString((String)strMobileSearch);
            this.setVisible(mobileSearch.getVisible());
            this.setMultiKeySearch(mobileSearch.isMultiKeySearch());
            this.setMobileShowModel(mobileSearch.getMobileShowModel());
            this.setEmptyText(mobileSearch.getEmptyText());
            this.setInvisible(mobileSearch.isInvisible());
            filterColumns = this.getFilterColumns(mobileSearch);
        }
        MobileSearchInitEvent mobileSearchInitEvent = new MobileSearchInitEvent((Object)this, filterColumns);
        for (MobileSearchInitListener mobileSearchInitListener : this.mobileSearchInitListeners) {
            mobileSearchInitListener.mobileSearchInit(mobileSearchInitEvent);
        }
        this.getItems().clear();
        this.getItems().addAll(filterColumns);
    }

    public void bindData(BindingContext bctx) {
        BeforeBindDataEvent beforeBindDataEvent = new BeforeBindDataEvent((Object)this);
        for (BeforeBindDataListener beforeBindDataListener : this.beforeBindDataListeners) {
            beforeBindDataListener.beforeBindData(beforeBindDataEvent);
        }
        this.setMetadata();
        super.bindData(bctx);
        AfterBindDataEvent afterBindDataEvent = new AfterBindDataEvent((Object)this);
        for (AfterBindDataListener afterBindDataListener : this.afterBindDataListeners) {
            afterBindDataListener.afterBindData(afterBindDataEvent);
        }
        this.updateControlMeta();
    }

    @SdkInternal
    public void onFocus() {
        this.setMetadata();
        for (MobileSearchFocusListener mobileSearchForcusListener : this.mobileSearchFocusListeners) {
            mobileSearchForcusListener.focus();
        }
    }

    public void onChange(String text) {
        this.setMetadata();
        this.postBack(text);
        MobileSearchTextChangeEvent mobileSearchTextChangeEvent = new MobileSearchTextChangeEvent((Object)this, text);
        for (MobileSearchTextChangeListener mobileSearchTextChangeListener : this.mobileSearchTextChangeListeners) {
            mobileSearchTextChangeListener.click(mobileSearchTextChangeEvent);
        }
    }

    public void onCancel() {
        this.setMetadata();
        for (MobileSearchCancelListener mobileSearchCancelListener : this.mobileSearchCancelListeners) {
            mobileSearchCancelListener.cancel();
        }
    }

    private List<FilterColumn> getFilterColumns(MobileSearch mobileSearch) {
        ArrayList<FilterColumn> newFilterColumns = new ArrayList<FilterColumn>();
        for (Control control : mobileSearch.getItems()) {
            if (!(control instanceof FilterColumn)) continue;
            newFilterColumns.add((FilterColumn)control);
        }
        return newFilterColumns;
    }

    public String getText() {
        this.clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        return this.clientViewProxy.getViewState(this.getKey()) == null ? "" : this.clientViewProxy.getViewState(this.getKey()).toString();
    }

    public void setText(String text) {
        this.clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        this.clientViewProxy.setFieldProperty(this.getKey(), "v", (Object)text);
    }

    public MainEntityType getEntityType() {
        if (StringUtils.isNotBlank((CharSequence)this.billFormId) && StringUtils.isBlank((CharSequence)this.entityId)) {
            this.entityId = FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId();
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityId())) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MobileSearch_0", (String)"bos-form-core", (Object[])new Object[0]), this.getKey())});
        }
        if (this.entityType == null) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        }
        if (this.entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MobileSearch_1", (String)"bos-form-core", (Object[])new Object[0]), this.entityId)});
        }
        return this.entityType;
    }

    public void refresh() {
    }

    @KSMethod
    public void cancelSearch() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "cancelSearch", new Object[0]);
    }
}

