/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.MobileTreeListPlugin;
import kd.bos.list.AbstractList;
import kd.bos.list.MobileList;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.events.SelectEvent;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobileTreeList
extends MobileList {
    private final int BASE_TOTAL = 1000;
    private final String FIRST_PAGEROW = "first_pagerow";
    private boolean is_OnlySelectLeaf = false;
    private List<ListSelectedListener> listeners = new ArrayList<ListSelectedListener>();

    @Override
    public void addListSelectedListener(ListSelectedListener listener) {
        this.listeners.add(listener);
    }

    public void itemSelect(Object params) {
        ItemSelectEvent evt = new ItemSelectEvent((Object)this);
        evt.setData(params);
        for (ListSelectedListener l : this.listeners) {
            l.itemSelect(evt);
        }
    }

    public void backPressed(Object params) {
        BackPressedEvent evt = new BackPressedEvent((Object)this);
        evt.setData(params);
        for (ListSelectedListener l : this.listeners) {
            l.backPressed(evt);
        }
    }

    @Override
    public void endSelect(List<Object> params) {
        ListSelectedRowCollection listSelectedRows;
        if (params.isEmpty()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String parentFormId = (String)showParameter.getCustomParam("originFormId");
            String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
            String json = this.getView().getPageCache().get(parentFormId + "__" + originFieldKey);
            if (StringUtils.isNotBlank((CharSequence)json)) {
                List unRemovablePks = SerializationUtils.fromJsonStringToList((String)json, String.class);
                params.addAll(unRemovablePks);
            }
        }
        EndSelectEvent evt = new EndSelectEvent((Object)this);
        if (!params.isEmpty()) {
            listSelectedRows = this.getSelectedRows(params);
        } else {
            listSelectedRows = new ListSelectedRowCollection();
            listSelectedRows.setClearFlag(true);
        }
        evt.setData((Object)listSelectedRows);
        for (ListSelectedListener l : this.listeners) {
            l.endSelect(evt);
        }
    }

    public void select(Object params) {
        SelectEvent evt = new SelectEvent((Object)this);
        evt.setData(params);
        for (ListSelectedListener l : this.listeners) {
            l.select(evt);
        }
    }

    @Override
    public void bindData(BindingContext object) {
        if (StringUtils.isEmpty((CharSequence)this.getBillFormId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MobileTreeList_0", (String)"bos-form-core", (Object[])new Object[0]));
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        Map<Object, Object> data = new HashMap();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof MobileTreeListPlugin)) continue;
            MobileTreeListPlugin treeListPlugin = (MobileTreeListPlugin)plugin;
            int pagesize = this.getPageRow() > 1000 ? this.getPageRow() : 1000;
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            cache.put(this.getView().getPageId() + "first_pagerow", String.valueOf(pagesize));
            data = treeListPlugin.packageData(treeListPlugin.getChildrenTreeNode(null, 0, pagesize, "0", this.isOnlySelectLeaf()), true, true);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadGeneralTreeF7Data", new Object[]{data});
    }

    @Override
    public void onChange(String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return;
        }
        AbstractList.ListState entryState = this.getEntryState();
        entryState.putSearchText(searchText);
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)this.getKey());
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        Map<Object, Object> data = new HashMap();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof MobileTreeListPlugin)) continue;
            MobileTreeListPlugin treeListPlugin = (MobileTreeListPlugin)plugin;
            int pagesize = this.getPageRow() > 1000 ? this.getPageRow() : 1000;
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            cache.put(this.getView().getPageId() + "first_pagerow", String.valueOf(pagesize));
            data = treeListPlugin.packageData(treeListPlugin.getChildrenTreeNode(this.setSearchTextFilter(searchText), 0, pagesize, null, this.isOnlySelectLeaf()), false, false);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setLookUpListValue", new Object[]{data});
    }

    @Override
    public void getSearchNextPageData(int pageIndex) {
        AbstractList.ListState entryState = this.getEntryState();
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        Map<Object, Object> data = new HashMap();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof MobileTreeListPlugin)) continue;
            MobileTreeListPlugin treeListPlugin = (MobileTreeListPlugin)plugin;
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            int first_pagerow = 0;
            if (cache.get(this.getView().getPageId() + "first_pagerow") != null) {
                first_pagerow = Integer.parseInt(cache.get(this.getView().getPageId() + "first_pagerow"));
            }
            data = treeListPlugin.packageData(treeListPlugin.getChildrenTreeNode(this.setSearchTextFilter(entryState.getSearchText()), (pageIndex - 2) * this.getPageRow() + first_pagerow, this.getPageRow(), null, this.isOnlySelectLeaf()), false, false);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setSearchNextPageData", new Object[]{data});
    }

    public void getNextPageData(String currentid, int pageIndex) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        Map<Object, Object> data = new HashMap();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof MobileTreeListPlugin)) continue;
            MobileTreeListPlugin treeListPlugin = (MobileTreeListPlugin)plugin;
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            int first_pagerow = 0;
            if (cache.get(this.getView().getPageId() + "first_pagerow") != null) {
                first_pagerow = Integer.parseInt(cache.get(this.getView().getPageId() + "first_pagerow"));
            }
            data = treeListPlugin.packageData(treeListPlugin.getChildrenTreeNode(null, (pageIndex - 2) * this.getPageRow() + first_pagerow, this.getPageRow(), currentid, this.isOnlySelectLeaf()), false, false);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setNextPageData", new Object[]{data});
    }

    private QFilter setSearchTextFilter(String searchText) {
        Map keyFields = EntityTypeUtil.getKeyFields((MainEntityType)this.getEntityType());
        String innerPrimaryField = this.getPrimaryField();
        if (StringUtils.isEmpty((CharSequence)innerPrimaryField)) {
            innerPrimaryField = (String)keyFields.get("name");
        }
        Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)this.getEntityType().getName());
        String searchtype = "1";
        if (pubSysParam != null) {
            searchtype = (String)pubSysParam.get("searchtype");
        }
        String finalSearchKey = searchText;
        if ("2".equals(searchtype)) {
            finalSearchKey = searchText + "%";
        }
        return QFilter.ftlike((String)finalSearchKey, (String[])new String[]{innerPrimaryField});
    }

    @Override
    public void cancel() {
        this.getView().close();
    }

    public int getBaseTotal() {
        return 1000;
    }

    public String getFirstPageKey() {
        return "first_pagerow";
    }

    public boolean isOnlySelectLeaf() {
        return this.is_OnlySelectLeaf;
    }

    public void setOnlySelectLeaf(boolean isOnlySelectLeaf) {
        this.is_OnlySelectLeaf = isOnlySelectLeaf;
    }
}

