/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AmountPrecision;
import kd.bos.entity.datamodel.DecimalPrecision;
import kd.bos.entity.datamodel.IntegerPrecision;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.SummaryType;
import kd.bos.entity.property.QtyProp;

public final class SumDataViewHelper {
    private SumDataViewHelper() {
    }

    public static List<Map<String, Object>> assembleSumResults(List<SummaryResult> summaryResults, List<SummaryResult> pageSummaryResults, List<String> groupBySumFields, Set<String> lstCanNotReadFields, MainEntityType mainEntityType) {
        ArrayList<Map<String, Object>> summaryResultListMap = new ArrayList<Map<String, Object>>(summaryResults.size());
        HashMap receivedFieldMap = new HashMap(summaryResults.size());
        HashMap<String, NumberPrecision> numberPrecisionMap = new HashMap<String, NumberPrecision>(16);
        for (SummaryResult summaryResult : pageSummaryResults) {
            numberPrecisionMap.put(summaryResult.getFieldName(), summaryResult.getNumberPrecision());
        }
        FormatObject formatObject = FormatFactory.getFormat((Long)RequestContext.get().getCurrUserId());
        for (SummaryResult summaryResult : summaryResults) {
            NumberPrecision numberPrecision = (NumberPrecision)numberPrecisionMap.get(summaryResult.getFieldName());
            if (numberPrecision == null) continue;
            BigDecimal result = summaryResult.getNumberPrecision().getResult();
            if (numberPrecision instanceof AmountPrecision) {
                summaryResult.setNumberPrecision((NumberPrecision)new AmountPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
            } else if (numberPrecision instanceof DecimalPrecision) {
                summaryResult.setNumberPrecision((NumberPrecision)new DecimalPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
            } else if (numberPrecision instanceof IntegerPrecision) {
                summaryResult.setNumberPrecision((NumberPrecision)new IntegerPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result, numberPrecision.getFormatObject()));
            } else {
                summaryResult.setNumberPrecision(new NumberPrecision(numberPrecision.getPrecision(), numberPrecision.getSign(), numberPrecision.isShowSign(), result));
            }
            summaryResult.getNumberPrecision().setFormatObject(formatObject);
        }
        boolean bl = true;
        for (SummaryResult summaryResult : summaryResults) {
            int n;
            if (summaryResult.getSummary() != SummaryType.SUM.getValue()) continue;
            Map<String, String> summaryResultMap = new HashMap<String, String>(16);
            if (lstCanNotReadFields.contains(summaryResult.getFieldName())) {
                summaryResultMap.put(summaryResult.getFieldName(), "******");
            } else {
                FilterField field = FilterField.create((MainEntityType)mainEntityType, (String)summaryResult.getFieldName());
                if (field != null && field.getFieldProp() instanceof QtyProp) {
                    summaryResult.getNumberPrecision().setStripTrailingZeros(true);
                }
                summaryResultMap = summaryResult.createSummaryResultMap();
            }
            ArrayList fieldSumList = (ArrayList)receivedFieldMap.get(summaryResult.getFieldName());
            if (fieldSumList == null) {
                fieldSumList = new ArrayList(10);
            }
            fieldSumList.add(summaryResultMap);
            receivedFieldMap.put(summaryResult.getFieldName(), fieldSumList);
            if (n >= fieldSumList.size()) continue;
            n = fieldSumList.size();
        }
        int n = groupBySumFields.size();
        for (void i = n - true; i >= 0; --i) {
            List fieldSumList;
            HashMap<String, Object> rowMap = new HashMap<String, Object>(n);
            for (String string : groupBySumFields) {
                fieldSumList = (List)receivedFieldMap.get(string);
                SumDataViewHelper.putSumList((int)i, rowMap, string, fieldSumList);
            }
            for (Map.Entry entry : receivedFieldMap.entrySet()) {
                if (groupBySumFields.contains(entry.getKey())) continue;
                fieldSumList = (List)entry.getValue();
                SumDataViewHelper.putSumList((int)i, rowMap, (String)entry.getKey(), fieldSumList);
            }
            if (rowMap.isEmpty()) continue;
            summaryResultListMap.add(rowMap);
        }
        return summaryResultListMap;
    }

    private static void putSumList(int i, Map<String, Object> rowMap, String groupBySumField, List<Map<String, Object>> fieldSumList) {
        if (fieldSumList == null) {
            fieldSumList = new ArrayList<Map<String, Object>>(1);
            HashMap<String, String> sumData = new HashMap<String, String>(1);
            sumData.put(groupBySumField, "");
            fieldSumList.add(sumData);
        }
        if (i < fieldSumList.size()) {
            rowMap.putAll(fieldSumList.get(i));
        }
    }
}

