/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ais.mservice.AisEntityService;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterView;
import kd.bos.filter.model.NlpAnalysisHttpRequest;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.ApproverListColumn;
import kd.bos.list.BillList;
import kd.bos.list.ComboListColumn;
import kd.bos.list.ControlContext;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnContext;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListFieldMeta;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.MergeListColumn;
import kd.bos.list.SeqColumnType;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.VoucherNoListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ViewCommonUtil {
    private static final Log log = LogFactory.getLog(ViewCommonUtil.class);
    private static final String LIST_FIELD_KEY = "listFieldKey";

    private ViewCommonUtil() {
    }

    private static void addValidEntryEntityDtos(EntityType entityType, String fieldName, List<EntryEntityDto> entryEntityDtos, List<EntryEntityDto> validEntryEntityDtos) {
        IDataEntityProperty fieldProp = entityType.findProperty(fieldName);
        if (fieldProp != null) {
            for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                if (validEntryEntityDtos.contains(entryEntityDto) || !fieldProp.getParent().getName().equals(entryEntityDto.getKey())) continue;
                validEntryEntityDtos.add(entryEntityDto);
                break;
            }
        }
    }

    public static List<EntryEntityDto> getValidEntryListByFilterColumn(EntityType entityType, List<FilterColumn> filterColumns) {
        List entryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)entityType);
        ArrayList<EntryEntityDto> validEntryEntityDtos = new ArrayList<EntryEntityDto>();
        block0: for (FilterColumn filterColumn : filterColumns) {
            for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                if (validEntryEntityDtos.contains(entryEntityDto) || !filterColumn.getEntryEntity().equals(entryEntityDto.getKey())) continue;
                validEntryEntityDtos.add(entryEntityDto);
                continue block0;
            }
        }
        return ViewCommonUtil.getFullEntryEntityDtos(validEntryEntityDtos, (MainEntityType)entityType);
    }

    public static void expandListColumns(List<IListColumn> controlItems, List<IListColumn> newControlItems) {
        for (IListColumn listColumn : controlItems) {
            if (listColumn instanceof ListOperationColumn || listColumn instanceof TemplateTextListColumn) continue;
            if (listColumn instanceof MergeListColumn) {
                for (Control iListColumn : ((MergeListColumn)listColumn).getItems()) {
                    newControlItems.add((IListColumn)iListColumn);
                }
                continue;
            }
            if (listColumn instanceof DynamicTextListColumn) {
                DynamicTextListColumn dynamicTextListColumn = (DynamicTextListColumn)listColumn;
                for (ListFieldMeta listFieldMeta : dynamicTextListColumn.getListFieldMetas()) {
                    ListColumn dynamicListColumn = new ListColumn();
                    dynamicListColumn.setListFieldKey(listFieldMeta.getKey());
                    newControlItems.add((IListColumn)dynamicListColumn);
                }
                continue;
            }
            newControlItems.add(listColumn);
        }
    }

    public static List<EntryEntityDto> getValidEntryListByListColumn(EntityType entityType, List<IListColumn> controlItems) {
        List entryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)entityType);
        ArrayList<EntryEntityDto> validEntryEntityDtos = new ArrayList<EntryEntityDto>();
        ArrayList<IListColumn> newControlItems = new ArrayList<IListColumn>();
        ViewCommonUtil.expandListColumns(controlItems, newControlItems);
        for (IListColumn listColumn : newControlItems) {
            if (listColumn.getSeqColType() == SeqColumnType.EntitySeq || listColumn instanceof VoucherNoListColumn || listColumn instanceof ApproverListColumn || listColumn instanceof ListColumn && listColumn.getListFieldKey() == null) continue;
            String listFieldKey = listColumn.getSeqColType() == SeqColumnType.EntryEntitySeq ? listColumn.getListFieldKey() : listColumn.getListFieldKey().split("\\.")[0];
            ViewCommonUtil.addValidEntryEntityDtos(entityType, listFieldKey, entryEntityDtos, validEntryEntityDtos);
        }
        ArrayList<EntryEntityDto> orderValidEntryEntityDtos = new ArrayList<EntryEntityDto>();
        block1: for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            for (EntryEntityDto validEntryEntityDto : validEntryEntityDtos) {
                if (!validEntryEntityDto.equals((Object)entryEntityDto)) continue;
                orderValidEntryEntityDtos.add(entryEntityDto);
                continue block1;
            }
        }
        return ViewCommonUtil.getFullEntryEntityDtos(orderValidEntryEntityDtos, (MainEntityType)entityType);
    }

    public static String getFirstEntryEntity(EntityType entityType, List<EntryEntityDto> entryEntityDtos) {
        return ViewCommonUtil.getFirstEntryEntity(entityType.getName(), entryEntityDtos);
    }

    public static String getFirstEntryEntity(String entityTypeName, List<EntryEntityDto> entryEntityDtos) {
        String firstEntryEnity = null;
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            if (!entityTypeName.equals(entryEntityDto.getParentKey())) continue;
            firstEntryEnity = entryEntityDto.getKey();
            break;
        }
        if (firstEntryEnity == null) {
            return entityTypeName;
        }
        return firstEntryEnity;
    }

    static List<EntryEntityDto> getEntityEntryList(EntityType entityType, String entryEntity, List<EntryEntityDto> entryEntityDtos, boolean isIncludeParent) {
        List<EntryEntityDto> entryList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)entryEntity)) {
            if (isIncludeParent) {
                List allEntryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)entityType);
                entryList = EntityTypeUtil.getParentEntryEntities((List)allEntryEntityDtos, (String)entryEntity);
            } else {
                for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                    if (!entryEntity.equalsIgnoreCase(entryEntityDto.getKey())) continue;
                    entryList.add(entryEntityDto);
                    break;
                }
            }
        } else {
            String firstEntryEnity = ViewCommonUtil.getFirstEntryEntity(entityType, entryEntityDtos);
            if (!StringUtils.isEmpty((CharSequence)firstEntryEnity)) {
                entryList = EntityTypeUtil.getParentEntryEntities(entryEntityDtos, (String)firstEntryEnity);
            } else {
                for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                    entryList.add(entryEntityDto);
                }
            }
        }
        return entryList;
    }

    private static void setListColumn(IListColumn metaListColumn, String listFieldKey, List<Map<String, Object>> userConfigListColumns, int amendIndex) {
        for (Map<String, Object> listColumn : userConfigListColumns) {
            if (!StringUtils.isNotBlank((CharSequence)listFieldKey) || listColumn.get(LIST_FIELD_KEY) == null || !listFieldKey.equalsIgnoreCase(listColumn.get(LIST_FIELD_KEY).toString())) continue;
            metaListColumn.setSeq(Integer.parseInt(listColumn.get("seq").toString()) + amendIndex);
            metaListColumn.setUserConfigColumnSettings(listColumn);
            break;
        }
    }

    public static List<IListColumn> getEntityFields(EntityType entityType, List<IListColumn> controlItems, List<EntryEntityDto> entryEntityDtos) {
        return ViewCommonUtil.getEntityFields(entityType, controlItems, new ArrayList<Map<String, Object>>(), entryEntityDtos, true, new ArrayList<String>());
    }

    private static List<IListColumn> addComplexListColumn(EntityType entityType, IListColumn listColumn, int i, int amendIndex, List<EntryEntityDto> entryEntityDtos, List<Map<String, Object>> userConfigListColumns, List<String> blackFields) {
        ArrayList<IListColumn> newListColumns = new ArrayList<IListColumn>();
        listColumn.setBlackFields(blackFields);
        ViewCommonUtil.combineUserConfig(listColumn, userConfigListColumns, i, amendIndex);
        for (Map<String, Object> uMap : userConfigListColumns) {
            if (uMap.get(LIST_FIELD_KEY) == null || !uMap.get(LIST_FIELD_KEY).toString().equalsIgnoreCase(((Control)listColumn).getKey())) continue;
            listColumn.setUserConfigColumnSettings(uMap);
            break;
        }
        if (listColumn instanceof MergeListColumn) {
            MergeListColumn mergeListColumn = (MergeListColumn)listColumn;
            ArrayList<IListColumn> mergeNewControlItems = new ArrayList<IListColumn>();
            for (Control iListColumn : mergeListColumn.getItems()) {
                if (!(iListColumn instanceof IListColumn)) continue;
                mergeNewControlItems.add((IListColumn)iListColumn);
            }
            List<IListColumn> newMergeControlItems = ViewCommonUtil.getEntityFields(entityType, mergeNewControlItems, userConfigListColumns, entryEntityDtos, true, blackFields);
            mergeListColumn.getItems().clear();
            for (IListColumn iListColumn : newMergeControlItems) {
                mergeListColumn.getItems().add((Control)iListColumn);
            }
            newListColumns.add(mergeListColumn);
        } else if (listColumn instanceof DynamicTextListColumn) {
            DynamicTextListColumn dynamicTextListColumn = (DynamicTextListColumn)listColumn;
            newListColumns.add((IListColumn)dynamicTextListColumn);
        } else if (listColumn instanceof ListOperationColumn) {
            ListOperationColumn listOperationColumn = (ListOperationColumn)listColumn;
            newListColumns.add(listOperationColumn);
        } else if (listColumn instanceof TemplateTextListColumn) {
            TemplateTextListColumn templateTextListColumn = (TemplateTextListColumn)listColumn;
            newListColumns.add((IListColumn)templateTextListColumn);
        }
        return newListColumns;
    }

    private static boolean isComplexListColumn(IListColumn listColumn) {
        return listColumn instanceof MergeListColumn || listColumn instanceof DynamicTextListColumn || listColumn instanceof ListOperationColumn || listColumn instanceof TemplateTextListColumn;
    }

    public static List<IListColumn> orderBySeq(List<IListColumn> newListColumns) {
        ArrayList<IListColumn> newControlItems = new ArrayList<IListColumn>();
        if (!newListColumns.isEmpty()) {
            Collections.sort(newListColumns, (o1, o2) -> Integer.compare(o1.getSeq(), o2.getSeq()));
            for (IListColumn listColumn : newListColumns) {
                newControlItems.add(listColumn);
            }
        }
        return newControlItems;
    }

    private static boolean isListColumnExist(String columnKey, List<Map<String, Object>> userConfigListColumns) {
        for (Map<String, Object> listFieldsControlColumn : userConfigListColumns) {
            if (!StringUtils.isNotBlank((CharSequence)columnKey) || listFieldsControlColumn.get(LIST_FIELD_KEY) == null || !columnKey.equalsIgnoreCase(listFieldsControlColumn.get(LIST_FIELD_KEY).toString().replace('.', '_'))) continue;
            return true;
        }
        return false;
    }

    private static void combineUserConfig(IListColumn listColumn, List<Map<String, Object>> userConfigListColumns, int i, int amendIndex) {
        String listFieldKey = ViewCommonUtil.getListFieldKey(listColumn);
        if (ViewCommonUtil.isListColumnExist(listFieldKey.replace('.', '_'), userConfigListColumns)) {
            ViewCommonUtil.setListColumn(listColumn, listFieldKey, userConfigListColumns, amendIndex);
        } else {
            listColumn.setSeq(i);
        }
    }

    private static String getListFieldKey(IListColumn listColumn) {
        String listFieldKey = listColumn.getListFieldKey();
        if (StringUtils.isEmpty((CharSequence)listFieldKey)) {
            listFieldKey = ((Control)listColumn).getKey();
        }
        return listFieldKey;
    }

    private static void initSimpleListColumns(EntityType entityType, IListColumn listColumn, List<Map<String, Object>> userConfigListColumns, int i, int amendIndex, IDataEntityProperty fieldProp, List<String> blackFields) {
        if (fieldProp != null) {
            listColumn.setHeaderField(!(fieldProp.getParent() instanceof EntryType));
            listColumn.setEntityName(fieldProp.getParent().getName());
        } else {
            listColumn.setHeaderField(true);
            listColumn.setEntityName(entityType.getName());
        }
        listColumn.setBlackFields(blackFields);
        ViewCommonUtil.combineUserConfig(listColumn, userConfigListColumns, i, amendIndex);
    }

    public static List<IListColumn> getEntityFields(EntityType entityType, List<IListColumn> controlItems, String entryEntity, List<EntryEntityDto> entryEntityDtos) {
        List<EntryEntityDto> entryList = ViewCommonUtil.getEntityEntryList(entityType, entryEntity, entryEntityDtos, true);
        return ViewCommonUtil.getEntityFields(entityType, controlItems, new ArrayList<Map<String, Object>>(), entryList, true, new ArrayList<String>());
    }

    protected static List<IListColumn> getEntityFields(EntityType entityType, List<IListColumn> controlItems, List<Map<String, Object>> userConfigListColumns, List<EntryEntityDto> entryEntityDtos, boolean isIncludeComplexListColumn, List<String> blackFields) {
        ArrayList<IListColumn> newListColumns = new ArrayList<IListColumn>();
        int i = 0;
        int amendIndex = 0;
        for (IListColumn listColumn : controlItems) {
            boolean complexListColumn = ViewCommonUtil.isComplexListColumn(listColumn);
            if (!isIncludeComplexListColumn && complexListColumn || listColumn instanceof ListColumn && listColumn.getListFieldKey() == null) continue;
            if (complexListColumn) {
                newListColumns.addAll(ViewCommonUtil.addComplexListColumn(entityType, listColumn, i, amendIndex, entryEntityDtos, userConfigListColumns, blackFields));
            } else if (listColumn.getSeqColType() == SeqColumnType.EntitySeq) {
                listColumn.setSeq(i);
                ++amendIndex;
                newListColumns.add(listColumn);
            } else {
                String listFieldKey = ViewCommonUtil.getListFieldKey(listColumn);
                IDataEntityProperty fieldProp = listColumn.getSeqColType() == SeqColumnType.EntryEntitySeq ? entityType.findProperty(listFieldKey) : entityType.findProperty(listFieldKey.split("\\.")[0]);
                ViewCommonUtil.initSimpleListColumns(entityType, listColumn, userConfigListColumns, i, amendIndex, fieldProp, blackFields);
                if (fieldProp != null && (EntityTypeUtil.isContainKey(entryEntityDtos, (String)fieldProp.getParent().getName()) || listFieldKey.startsWith(fieldProp.getParent().getName() + "__"))) {
                    newListColumns.add(listColumn);
                } else if ((listColumn instanceof VoucherNoListColumn || listColumn instanceof ApproverListColumn) && EntityTypeUtil.isContainKey(entryEntityDtos, (String)entityType.getName())) {
                    newListColumns.add(listColumn);
                }
            }
            ++i;
        }
        return newListColumns;
    }

    private static void getListColumn(Container parentControl, List<IListColumn> listColumns, ControlContext context, Container parentView) {
        for (Control control : parentControl.getItems()) {
            if (control instanceof IListColumn) {
                IListColumn listColumn = (IListColumn)control;
                listColumns.add(listColumn);
                listColumn.setParentViewKey(parentControl.getKey());
                listColumn.setParent(parentControl);
                if (context == null) {
                    listColumn.setContext(new ListColumnContext(new HashSet(0), new ArrayList(0), false));
                    continue;
                }
                listColumn.setContext(new ListColumnContext(context.getCanNotReadFields(), context.getBlackFields(), context.isSingleOrgMode()));
                continue;
            }
            if (!(control instanceof Container)) continue;
            ViewCommonUtil.getListColumn((Container)control, listColumns, context, parentView);
        }
    }

    private static void getListColumnGroup(Container parentControl, List<ListColumnGroup> listColumnGroups) {
        for (Control control : parentControl.getItems()) {
            if (control instanceof ListColumnGroup) {
                ListColumnGroup listColumnGroup = (ListColumnGroup)control;
                listColumnGroups.add(listColumnGroup);
                listColumnGroup.setParentViewKey(parentControl.getKey());
                ViewCommonUtil.getListColumnGroup(listColumnGroup, listColumnGroups);
                continue;
            }
            if (!(control instanceof Container)) continue;
            ViewCommonUtil.getListColumnGroup((Container)control, listColumnGroups);
        }
    }

    @Deprecated
    public static BeforeCreateListColumnsArgs createContainerListColumns(Container container) {
        return ViewCommonUtil.createContainerListColumns(container, null);
    }

    public static BeforeCreateListColumnsArgs createContainerListColumns(Container container, ControlContext context) {
        ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>();
        ArrayList<ListColumnGroup> listColumnGroups = new ArrayList<ListColumnGroup>();
        ArrayList<IListColumn> thisListColumns = new ArrayList<IListColumn>();
        ArrayList<ListColumnGroup> thisListColumnGroups = new ArrayList<ListColumnGroup>();
        ViewCommonUtil.getListColumn(container, thisListColumns, context, container);
        ViewCommonUtil.getListColumnGroup(container, thisListColumnGroups);
        listColumns.addAll(thisListColumns);
        listColumnGroups.addAll(thisListColumnGroups);
        return new BeforeCreateListColumnsArgs(container, listColumns, listColumnGroups);
    }

    public static BeforeCreateListColumnsArgs createBeforeCreateListColumnArgs(BillList billList) {
        ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>();
        ArrayList<ListColumnGroup> listColumnGroups = new ArrayList<ListColumnGroup>();
        ControlContext context = billList.getContext();
        if (StringUtils.isNotBlank((CharSequence)billList.getEntityId())) {
            context.setCanNotReadFields(billList.getListCanNotReadFields());
        }
        for (Control item : billList.getItems()) {
            if (!(item instanceof Container)) continue;
            BeforeCreateListColumnsArgs beforeCreateListColumnsArgs = ViewCommonUtil.createContainerListColumns((Container)item, context);
            listColumns.addAll(beforeCreateListColumnsArgs.getListColumns());
            listColumnGroups.addAll(beforeCreateListColumnsArgs.getListGroupColumns());
        }
        return new BeforeCreateListColumnsArgs((Object)billList, listColumns, listColumnGroups);
    }

    public static List<EntryEntityDto> getFullEntryEntityDtos(List<EntryEntityDto> entryEntityDtos, MainEntityType mainEntityType) {
        ArrayList<EntryEntityDto> newEntryEntityDtos = new ArrayList<EntryEntityDto>();
        List allEntryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)mainEntityType);
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            EntryEntityDto pEntityDto;
            if (!newEntryEntityDtos.contains(entryEntityDto)) {
                newEntryEntityDtos.add(entryEntityDto);
            }
            if (StringUtils.isBlank((CharSequence)entryEntityDto.getParentKey()) || entryEntityDtos.contains(pEntityDto = new EntryEntityDto(entryEntityDto.getParentKey())) || newEntryEntityDtos.contains(pEntityDto)) continue;
            List pEntityDtos = EntityTypeUtil.getParentEntryEntities((List)allEntryEntityDtos, (String)entryEntityDto.getParentKey());
            for (EntryEntityDto entryEntityDto2 : pEntityDtos) {
                if (newEntryEntityDtos.contains(entryEntityDto2)) continue;
                newEntryEntityDtos.add(entryEntityDto2);
            }
        }
        return newEntryEntityDtos;
    }

    private static List<Object> createEnumItem(Object value, LocaleString displayValue, String imageKey, int showStyle) {
        ArrayList<Object> item = new ArrayList<Object>();
        item.add(value);
        switch (showStyle) {
            case 1: 
            case 2: {
                item.add(displayValue);
                item.add(imageKey);
                break;
            }
            default: {
                item.add(displayValue);
                item.add(null);
            }
        }
        return item;
    }

    public static List<Object> getStore(int showStyle, List<ValueMapItem> items) {
        ArrayList<Object> myItems = new ArrayList<Object>(10);
        for (ValueMapItem item : items) {
            myItems.add(ViewCommonUtil.createEnumItem(item.getValue(), item.getName(), item.getImageKey(), showStyle));
        }
        myItems.add(ViewCommonUtil.createEnumItem("******", new LocaleString("******"), "", showStyle));
        return myItems;
    }

    public static void setComboListColumnEditor(IListColumn col, ComboProp comboProp, Map<String, Object> editor) {
        ViewCommonUtil.setComboListColumnEditor(ViewCommonUtil.getShowStyle(col), comboProp, editor);
    }

    public static void setComboListColumnEditor(int showStyle, ComboProp comboProp, Map<String, Object> editor) {
        if (comboProp instanceof MulComboProp) {
            editor.put("type", "mulcombo");
        } else {
            editor.put("type", "combo");
        }
        editor.put("st", ViewCommonUtil.getStore(showStyle, comboProp.getComboItems()));
    }

    static void setComboListColumnEditor(IListColumn col, ComboProp comboProp, Map<String, Object> editor, IDataEntityProperty srcFieldProp) {
        ViewCommonUtil.setComboListColumnEditor(ViewCommonUtil.getShowStyle(col), comboProp, editor, srcFieldProp);
    }

    static void setComboListColumnEditor(int showStyle, ComboProp comboProp, Map<String, Object> editor, IDataEntityProperty srcFieldProp) {
        if (comboProp instanceof MulComboProp) {
            editor.put("type", comboProp.getClientType());
        } else {
            editor.put("type", comboProp.getClientType());
            if (srcFieldProp instanceof MulBasedataProp) {
                editor.put("type", "mulcombo");
            }
        }
        editor.put("st", ViewCommonUtil.getStore(showStyle, comboProp.getComboItems()));
    }

    public static int getShowStyle(IListColumn col) {
        int showStyle = 2;
        if (col instanceof ComboListColumn) {
            ComboListColumn comboListColumn = (ComboListColumn)col;
            showStyle = comboListColumn.getShowStyle();
        }
        return showStyle;
    }

    protected static void setDecimalColumnEditor(IListColumn col, IDataEntityProperty fieldProp, Map<String, Object> column) {
        Map editor = (Map)column.get("editor");
        editor.put("type", "number");
        if (column.get("sz") != null) {
            editor.put("sz", column.remove("sz"));
        }
        if (column.get("zs") != null) {
            editor.put("zs", column.remove("zs"));
        }
        if (column.get("mask") != null) {
            editor.put("mask", column.remove("mask"));
        }
        if (column.get("df") != null) {
            editor.put("df", column.remove("df"));
        }
    }

    protected static void createDecimalEditor(Map<String, Object> column, Map<String, Object> editor, Map<String, Map<String, Object>> decimalFieldMap) {
        String key = (String)column.get("dataIndex");
        Map<String, Object> colType = decimalFieldMap.get(key);
        if (colType != null) {
            String numType = (String)colType.get("nt");
            editor.put("nt", numType);
            if ("D".equals(numType)) {
                editor.put("pc", colType.get("pc"));
                editor.put("sc", colType.get("sc"));
            } else {
                editor.put("sf", colType.get("sf"));
                editor.put("fieldstyle", 1);
            }
        }
        column.put("editor", editor);
    }

    public static boolean getListColumnVisible(boolean isList, boolean isLookUp, int visibleValue) {
        int shift;
        int mask;
        if (!isList) {
            mask = 8;
            shift = 3;
        } else {
            mask = isLookUp ? 2 : 1;
            shift = 1;
        }
        int ret = visibleValue & mask;
        int bitVisibile = ret > shift ? ret >> shift : ret;
        return bitVisibile == 1;
    }

    public static boolean checkCompare(List<Map<String, List<Object>>> fastFilterList) {
        List<Object> compare;
        boolean isCompare = false;
        if (fastFilterList != null && fastFilterList.size() > 0 && fastFilterList.get(0) != null && (compare = fastFilterList.get(0).get("Compare")) != null && compare.size() > 0) {
            isCompare = true;
        }
        return isCompare;
    }

    public static List<NlpAnalysisHttpRequest.EntityMeta.FieldBean> getCompareOpByNo(String billFormId) {
        Map meta = FormMetadataCache.getFilterMeta((String)billFormId);
        ArrayList<NlpAnalysisHttpRequest.EntityMeta.FieldBean> fieldBeanList = new ArrayList<NlpAnalysisHttpRequest.EntityMeta.FieldBean>(40);
        if (meta != null && meta.containsKey(FilterContainer.class.getSimpleName())) {
            String strFilterContainer = (String)meta.get(FilterContainer.class.getSimpleName());
            FilterContainer filterContainer = (FilterContainer)ControlTypes.fromJsonString((String)strFilterContainer);
            List items = filterContainer.getItems();
            LinkedHashMap<String, LocaleString> nameMap = new LinkedHashMap<String, LocaleString>();
            for (Control item : items) {
                if (!(item instanceof SchemeFilterView)) continue;
                for (Control childitem : ((SchemeFilterView)item).getItems()) {
                    FilterColumn filterColumn = (FilterColumn)childitem;
                    nameMap.put(filterColumn.getFieldName(), filterColumn.getCaption());
                }
            }
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)billFormId);
            String entityNumber = formConfig.getEntityTypeId();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            for (Map.Entry name : nameMap.entrySet()) {
                FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)((String)name.getKey()));
                List customCompareTypes = filterField.getAllCompareTypes();
                String filterControlType = filterField.getFilterControlType();
                if ("text".equals(filterControlType) && StringUtils.isNotBlank((CharSequence)filterField.getRefEntityId())) {
                    filterControlType = filterField.getRefEntityId();
                } else if (StringUtils.isEmpty((CharSequence)filterControlType)) {
                    filterControlType = "text";
                }
                NlpAnalysisHttpRequest.EntityMeta.FieldBean fieldBean = new NlpAnalysisHttpRequest.EntityMeta.FieldBean(filterField.getFieldName(), (LocaleString)name.getValue(), filterControlType, filterField.getComboItems(), customCompareTypes);
                fieldBeanList.add(fieldBean);
            }
        }
        return fieldBeanList;
    }

    public static String checkOpenNlp(String entityNumber) {
        String openResult = null;
        try {
            AisEntityService aisEntityService = (AisEntityService)ServiceFactory.getService((String)"AisEntityService");
            openResult = aisEntityService.getNLPSearchGuide(entityNumber);
        }
        catch (Exception e) {
            log.error("appid: bos", (Throwable)e);
        }
        return openResult;
    }

    public static String analysisSearch2Sql(String billFormId, String searchContent) throws IOException {
        String result = null;
        if (billFormId == null) {
            return result;
        }
        AisEntityService aisEntityService = (AisEntityService)ServiceFactory.getService((String)"AisEntityService");
        result = aisEntityService.nlTofilter(billFormId, searchContent);
        return result;
    }
}

