/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.list.ComboListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ComboListColumnAp
extends ListColumnAp {
    private static final long serialVersionUID = 5968874513700822052L;
    private int showStyle;

    @SimplePropertyAttribute
    public int getShowStyle() {
        return this.showStyle;
    }

    public void setShowStyle(int showStyle) {
        this.showStyle = showStyle;
    }

    @Override
    protected ListColumn createRuntimeControl() {
        return new ComboListColumn();
    }

    @Override
    public Map<String, Object> createControl() {
        Map<String, Object> ctl = super.createControl();
        if (this.getShowStyle() > 0) {
            ctl.put("showStyle", this.getShowStyle());
        }
        return ctl;
    }

    @Override
    protected void setRuntimeSimpleProperties(ListColumn ctl) {
        super.setRuntimeSimpleProperties(ctl);
        ComboListColumn comboListColumn = (ComboListColumn)ctl;
        comboListColumn.setShowStyle(this.getShowStyle());
    }

    private BillListAp getBillListAp(ControlAp<?> parent) {
        ControlAp parentItem = this.formMetadata.getItem(parent.getParentId());
        if (parentItem instanceof BillListAp) {
            return (BillListAp)parentItem;
        }
        if (parentItem != null) {
            return this.getBillListAp(parentItem);
        }
        return null;
    }

    @Override
    protected Map<String, Object> createEditor() {
        Map<String, Object> editor = super.createEditor();
        editor.put("type", "combo");
        if (this.getShowStyle() > 0) {
            editor.put("showStyle", this.getShowStyle());
        }
        int fieldStyle = this.isShowTitle() ? 0 : 1;
        editor.put("fileType", fieldStyle);
        this.createStore(editor);
        return editor;
    }

    private void createStore(Map<String, Object> editor) {
        String firstKey;
        String listFieldId;
        String restKey;
        EntityMetadata entityMetadata = this.formMetadata.getEntityMetadata();
        String entityId = null;
        BillListAp billListAp = this.getBillListAp(this);
        if (billListAp != null) {
            entityId = billListAp.getEntityId();
        }
        if ((restKey = (listFieldId = this.getListFieldId()).substring((firstKey = listFieldId.split("\\.")[0]).length())).startsWith(".")) {
            restKey = restKey.substring(1);
        }
        List<ValueMapItem> valueMapItems = this.createStore(entityId, firstKey, restKey);
        editor.put("st", ViewCommonUtil.getStore(this.getShowStyle(), valueMapItems));
    }

    private List<ValueMapItem> createStore(String entityId, String fieldKey, String restKey) {
        Field field = null;
        if (StringUtils.isNotEmpty((CharSequence)entityId)) {
            EntityMetadata newEntityMetadata;
            MetadataReader metadataReader = new MetadataReader();
            MetaBuildContext ctx = this.formMetadata.getBuildContext();
            if (ctx != null) {
                metadataReader.setAppGroup(ctx.getRebuildAppGroup());
            }
            if ((newEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity)) == null && ctx != null && ctx.isGray()) {
                metadataReader = new MetadataReader();
                newEntityMetadata = (EntityMetadata)metadataReader.readMeta(entityId, MetaCategory.Entity);
            }
            if (newEntityMetadata != null) {
                field = newEntityMetadata.getFieldByKey(fieldKey);
            }
        }
        ArrayList<ValueMapItem> valueMapItems = new ArrayList<ValueMapItem>();
        if (StringUtils.isNotEmpty((CharSequence)restKey) && field instanceof BasedataField) {
            String firstKey = restKey.split("\\.")[0];
            String lastKey = restKey.substring(firstKey.length());
            if (lastKey.startsWith(".")) {
                lastKey = lastKey.substring(1);
            }
            return this.createStore(((BasedataField)field).getBaseEntityId(), firstKey, lastKey);
        }
        if (field instanceof ComboField) {
            for (ComboItem comboItem : ((ComboField)field).getItems()) {
                valueMapItems.add(new ValueMapItem(comboItem.getImageKey(), comboItem.getValue(), comboItem.getCaption()));
            }
        }
        return valueMapItems;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        Object showStyleObject = props.get("ShowStyle");
        if (showStyleObject != null) {
            this.setShowStyle((Integer)showStyleObject);
        }
    }
}

