/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.list;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.filter.SortType;
import kd.bos.form.control.Control;
import kd.bos.list.IListColumnAp;
import kd.bos.list.ListColumn;
import kd.bos.list.SeqColumnType;
import kd.bos.metadata.form.ControlAp;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ListColumnAp
extends ControlAp<ListColumn>
implements IListColumnAp {
    private String listFieldId;
    private boolean hyperlink;
    private String order;
    private boolean showTitle = true;
    private String seqColumnType;
    private Tips ctlTips;
    private boolean autoTextWrap;
    private String fieldForeColor;
    private String fieldBackColor;
    private String fieldTextAlign;
    private int fieldFontSize = 12;
    private String dataType;
    private String columnOrderAndFilter = "0";

    public ListColumnAp() {
        this.visible = "default,lookup,init,new,edit,view,submit,audit";
    }

    @ComplexPropertyAttribute
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    public void setCtlTips(Tips ctlTips) {
        if (ctlTips != null) {
            this.ctlTips = ctlTips;
        }
    }

    @SimplePropertyAttribute(name="AutoTextWrap")
    public boolean isAutoTextWrap() {
        return this.autoTextWrap;
    }

    public void setAutoTextWrap(boolean autoTextWrap) {
        this.autoTextWrap = autoTextWrap;
    }

    @SimplePropertyAttribute
    public String getOrder() {
        return StringUtils.isBlank((CharSequence)this.order) ? SortType.NotOrder.name() : this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @SimplePropertyAttribute
    public String getSeqColumnType() {
        return StringUtils.isBlank((CharSequence)this.seqColumnType) ? SeqColumnType.NotSeq.name() : this.seqColumnType;
    }

    public void setSeqColumnType(String seqColumnType) {
        this.seqColumnType = seqColumnType;
    }

    @SimplePropertyAttribute(name="ShowTitle")
    @DefaultValueAttribute(value="true")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showLabel) {
        this.showTitle = showLabel;
    }

    @SimplePropertyAttribute
    public String getListFieldId() {
        return this.listFieldId;
    }

    public void setListFieldId(String listFieldId) {
        this.listFieldId = listFieldId;
    }

    @SimplePropertyAttribute(name="Hyperlink")
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="default,lookup,init,new,edit,view,submit,audit")
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible == null ? "default,lookup,init,new,edit,view,submit,audit" : visible;
    }

    @SimplePropertyAttribute
    public String getFieldForeColor() {
        return this.fieldForeColor;
    }

    public void setFieldForeColor(String fieldForeColor) {
        this.fieldForeColor = fieldForeColor;
    }

    @SimplePropertyAttribute
    public String getFieldBackColor() {
        return this.fieldBackColor;
    }

    public void setFieldBackColor(String fieldBackColor) {
        this.fieldBackColor = fieldBackColor;
    }

    @SimplePropertyAttribute
    public String getFieldTextAlign() {
        return this.fieldTextAlign;
    }

    public void setFieldTextAlign(String fieldTextAlign) {
        this.fieldTextAlign = fieldTextAlign;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="12")
    public int getFieldFontSize() {
        return this.fieldFontSize;
    }

    public void setFieldFontSize(int fieldFontsize) {
        this.fieldFontSize = fieldFontsize;
    }

    protected Map<String, Object> createEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        if (this.getFieldFontSize() != 12) {
            editor.put("fs", this.getFieldFontSize());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getFieldForeColor())) {
            editor.put("fc", this.getFieldForeColor());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getFieldBackColor())) {
            editor.put("bc", this.getFieldBackColor());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getFieldTextAlign())) {
            editor.put("text-align", this.getFieldTextAlign());
        }
        return editor;
    }

    public Map<String, Object> createControl() {
        Map ctl = super.createControl();
        if (this.isShowTitle()) {
            ctl.put("sti", true);
            ctl.put("header", this.getName());
        } else {
            ctl.put("sti", false);
            ctl.put("header", new LocaleString(""));
        }
        ctl.put("ln", this.isHyperlink());
        if (this.isAutoTextWrap()) {
            ctl.put("atw", this.isAutoTextWrap());
        }
        return ctl;
    }

    protected ListColumn createRuntimeControl() {
        return new ListColumn();
    }

    protected void setRuntimeSimpleProperties(ListColumn ctl) {
        if (StringUtils.isBlank((CharSequence)this.getListFieldId())) {
            this.addBuildError(2, this.getKey(), String.format(ResManager.loadKDString((String)"%1$s-%2$s\u9700\u8981\u7ed1\u5b9a\u5b57\u6bb5\u6620\u5c04", (String)"ListColumnAp_0", (String)"bos-form-core", (Object[])new Object[0]), this.getKey(), this.getName()));
        }
        super.setRuntimeSimpleProperties((Control)ctl);
        if (StringUtils.isNotBlank((CharSequence)this.getListFieldId())) {
            ctl.setListFieldKey(this.getListFieldId().toLowerCase());
        }
        ctl.setCaption(this.getName());
        ctl.setTextAlign(this.getTextAlign());
        ctl.setWidth(this.getWidth());
        ctl.setHyperlink(this.hyperlink);
        ctl.setForeColor(this.getForeColor());
        ctl.setBackColor(this.getBackColor());
        ctl.setFontSize(this.getFontSize());
        ctl.setVisible(this.getVisibleValue());
        ctl.setSeqColumnType(this.getSeqColumnType());
        ctl.setOrder(this.getOrder());
        ctl.setCtlTips(this.getCtlTips());
        ctl.setAutoTextWrap(this.isAutoTextWrap());
        ctl.setTableHeaderCellBackColor(this.getTableHeaderCellBackColor());
        if ("0".equals(this.getColumnOrderAndFilter())) {
            ctl.setColumnOrderAndFilter(true);
            ctl.setColumnOrder(true);
            ctl.setColumnFilter(true);
        } else if ("1".equals(this.getColumnOrderAndFilter())) {
            ctl.setColumnOrderAndFilter(false);
            ctl.setColumnOrder(false);
            ctl.setColumnFilter(false);
            ctl.setOrder(SortType.NotOrder.name());
        } else if ("2".equals(this.getColumnOrderAndFilter())) {
            ctl.setColumnOrderAndFilter(false);
            ctl.setColumnOrder(true);
            ctl.setColumnFilter(false);
        } else if ("3".equals(this.getColumnOrderAndFilter())) {
            ctl.setColumnOrderAndFilter(false);
            ctl.setColumnOrder(false);
            ctl.setColumnFilter(true);
            ctl.setOrder(SortType.NotOrder.name());
        }
    }

    public void setProperties(Map<String, Object> props) {
        this.setListFieldId((String)props.get("Id"));
        this.setSeqColumnType(props.get("SeqType").toString());
        this.setColumnOrderAndFilter("1");
    }

    @SimplePropertyAttribute(name="ColumnOrderAndFilter")
    @DefaultValueAttribute(value="0")
    public String getColumnOrderAndFilter() {
        return this.columnOrderAndFilter;
    }

    public void setColumnOrderAndFilter(String columnOrderAndFilter) {
        if ("true".equals(columnOrderAndFilter)) {
            columnOrderAndFilter = "0";
        } else if ("false".equals(columnOrderAndFilter)) {
            columnOrderAndFilter = "1";
        }
        this.columnOrderAndFilter = columnOrderAndFilter;
    }

    @SimplePropertyAttribute(name="DataType")
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

