/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.rule.ClientRule;
import kd.bos.metadata.form.rule.DisplayStyle;
import kd.bos.metadata.form.rule.ReportClientSetFieldfmtAction;
import kd.bos.metadata.form.rule.RowStyle;
import kd.bos.metadata.form.rule.SetRowStyleAction;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.report.ReportForm;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportFormAp
extends FormAp {
    private boolean asynQuery = false;
    private String DataControl;

    @SimplePropertyAttribute(name="AsynQuery")
    public boolean isAsynQuery() {
        return this.asynQuery;
    }

    public void setAsynQuery(boolean asynQuery) {
        this.asynQuery = asynQuery;
    }

    @SimplePropertyAttribute
    public String getDataControl() {
        return this.DataControl;
    }

    public void setDataControl(String dataControl) {
        this.DataControl = dataControl;
    }

    protected ReportForm createRuntimeControl() {
        ReportForm reportForm = new ReportForm();
        reportForm.setAsynQuery(this.asynQuery);
        return reportForm;
    }

    protected String getModelType() {
        return "report";
    }

    private ClientRule createRowStyleClientRule(String preCondition, String backgroundColor, int degree) {
        ClientRule clientRule = new ClientRule();
        clientRule.setEnabled(true);
        clientRule.setPreCondition(preCondition);
        ArrayList<SetRowStyleAction> bizRuleActions = new ArrayList<SetRowStyleAction>();
        SetRowStyleAction setRowStyleAction = new SetRowStyleAction();
        setRowStyleAction.setRET(126);
        ArrayList<RowStyle> rowStyles = new ArrayList<RowStyle>();
        RowStyle rowStyle = new RowStyle(Uuid8.generateShortUuid(), "#EB743F", backgroundColor, degree);
        rowStyle.setSummary(true);
        rowStyles.add(rowStyle);
        setRowStyleAction.setRowStyles(rowStyles);
        bizRuleActions.add(setRowStyleAction);
        clientRule.setTrueActions(bizRuleActions);
        clientRule.setGroupName("rowStyleRules");
        return clientRule;
    }

    private ClientRule createCellStyleClientRule(String preCondition) {
        ClientRule clientRule = new ClientRule();
        clientRule.setEnabled(true);
        clientRule.setPreCondition(preCondition);
        ArrayList<ReportClientSetFieldfmtAction> bizRuleActions = new ArrayList<ReportClientSetFieldfmtAction>();
        ReportClientSetFieldfmtAction reportClientSetFieldfmtAction = new ReportClientSetFieldfmtAction();
        reportClientSetFieldfmtAction.setRET(126);
        ArrayList<DisplayStyle> displayStyles = new ArrayList<DisplayStyle>();
        DisplayStyle displayStyle = new DisplayStyle();
        displayStyle.setSummary(true);
        displayStyle.setForeColor("#70441D");
        displayStyle.setFontSize(12);
        displayStyles.add(displayStyle);
        reportClientSetFieldfmtAction.setDisplayStyles(displayStyles);
        bizRuleActions.add(reportClientSetFieldfmtAction);
        clientRule.setTrueActions(bizRuleActions);
        clientRule.setGroupName("cellStyleRules");
        return clientRule;
    }

    private void createReportListClientRules(ControlAp<?> ctlAp) {
        ReportListAp reportListAp = (ReportListAp)ctlAp;
        ArrayList<ClientRule> clientRules = new ArrayList<ClientRule>(10);
        clientRules.add(this.createRowStyleClientRule("summarytype=1", "#FCF0C7", 100));
        clientRules.add(this.createRowStyleClientRule("summarytype=2", "#FEF6DB", 100));
        clientRules.add(this.createRowStyleClientRule("summarytype=3", "#FFF7DD", 100));
        clientRules.add(this.createCellStyleClientRule("summarytype=1"));
        clientRules.add(this.createCellStyleClientRule("summarytype=2"));
        clientRules.add(this.createCellStyleClientRule("summarytype=3"));
        for (ClientRule clientRule : reportListAp.getClientRules()) {
            clientRules.add(clientRule);
        }
        reportListAp.setClientRules(clientRules);
    }

    protected void buildRuntimeChildControls(Container ctl) {
        List items = ctl.getItems();
        for (ControlAp ctlAp : this.getItems()) {
            if (ctlAp.isHidden()) continue;
            if (ctlAp instanceof ReportListAp) {
                this.createReportListClientRules(ctlAp);
            }
            items.add(ctlAp.buildRuntimeControl());
        }
    }

    public void buildRuntimeMeta(List<RuntimeFormMeta> metas, String runtimeVersion) {
        super.buildRuntimeMeta(metas, runtimeVersion);
        this.buildReportFilter(metas);
    }

    private void buildReportFilter(List<RuntimeFormMeta> metas) {
        List items = this.formMetadata.getItems();
        ControlAp reportFilter = null;
        for (ControlAp item : items) {
            if (!"reportfilterap".equals(item.getKey())) continue;
            reportFilter = item;
            break;
        }
        if (reportFilter != null) {
            HashMap<String, String> listRunMeta = new HashMap<String, String>(1);
            listRunMeta.put(ReportFilterAp.class.getSimpleName(), SerializationUtils.toJsonString((Object)reportFilter.createControl()));
            RuntimeFormMeta meta = this.formMetadata.createRuntimeFormMeta();
            meta.setKey("ReportFilter");
            meta.setType((int)RuntimeMetaType.Form.getValue());
            meta.setData(SerializationUtils.toJsonString(listRunMeta));
            metas.add(meta);
        }
    }
}

