/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.qing.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SessionKeys;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import org.apache.commons.beanutils.MethodUtils;

public class QingFormUtil {
    private static final Log log = LogFactory.getLog(QingFormUtil.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qing", new DistributeCacheHAPolicy(true, true));
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String BOS_DEVP_CHOOSEMENU = "bos_devp_choosemenu";
    private static final String BOS_DEVP_APPTREELISTF_7 = "bos_devp_apptreelistf7";
    private static final String PERM_ROLE = "perm_role";
    private static final String TITLE = "title";
    private static final String APPNAME = "appname";
    private static final String OPERATION = "operation";
    private static final String LEVEL = "level";
    private static final String APP_ID = "appid";
    private static final String PAGE_ID = "pageId";
    private static final String APP_ID1 = "appId";
    private static final String APP_NUMBER = "appNumber";
    private static final String APP_NAME = "appName";
    public static final String QING_CALLBACK_KEY = "qingCallbackKey";
    private static final Set<Locale> SUPPORTED = new HashSet<Locale>();
    private static final String BOS_USER = "bos_user";
    public static final String entityID_uitheme = "bas_uitheme";
    public static final String entityID_useruitheme = "bas_useruitheme";

    public static String getQingTheme() {
        String result = "ierp";
        try {
            Object qingUtil = Class.forName("kd.bos.qing.plugin.QingUtil").newInstance();
            result = (String)MethodUtils.invokeMethod(qingUtil, (String)"getQingTheme", null);
        }
        catch (Throwable e) {
            log.error("getQingTheme error.", e);
        }
        return result;
    }

    public static String getQingURL(String url) {
        String sParamPathPrefix = UrlService.getDomainContextUrl();
        if (sParamPathPrefix == null) {
            throw new KDException(BosErrorCode.zookeepConfiguration, new Object[]{ResManager.loadKDString((String)"zk\u672a\u914d\u7f6edomain.contextUrl", (String)"QingFormUtil_0", (String)BOS_FORM_CORE, (Object[])new Object[0])});
        }
        if (sParamPathPrefix.endsWith("/")) {
            sParamPathPrefix = sParamPathPrefix.substring(0, sParamPathPrefix.lastIndexOf(47));
        }
        String sUrl = sParamPathPrefix + url;
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "language", QingFormUtil.getLocale());
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "skin", QingFormUtil.getQingTheme());
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "path", sParamPathPrefix);
        sUrl = QingFormUtil.appendAccountParamToUrl(sUrl);
        return sUrl;
    }

    public static String appendAccountParamToUrl(String url) {
        try {
            RequestContext requestContext = RequestContext.get();
            if (SessionKeys.isAccountSession((String)requestContext.getTenantId())) {
                url = QingFormUtil.appendParamToUrl(url, "kdcdc", requestContext.getAccountId());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return url;
    }

    public static String appendParamToUrl(String sUrl, String sParamKey, String sParamValue) {
        if (sParamValue != null && !"".equals(sParamValue.trim())) {
            sUrl = sUrl + (sUrl.indexOf("?") < 0 ? "?" : "&");
            sUrl = sUrl + sParamKey;
            sUrl = sUrl + "=";
            try {
                sParamValue = URLEncoder.encode(sParamValue, "utf-8");
                sParamValue = sParamValue.replace("+", "%20");
                sUrl = sUrl + sParamValue;
            }
            catch (UnsupportedEncodingException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return sUrl;
    }

    private static String getLocale() {
        RequestContext context = RequestContext.get();
        Locale locale = context.getLang().getLocale();
        if (!SUPPORTED.contains(locale)) {
            return QingFormUtil.demoteForBundle(locale);
        }
        return locale.toString();
    }

    private static String demoteForBundle(Locale locale) {
        Locale demotion = new Locale(locale.getLanguage(), locale.getCountry());
        if (SUPPORTED.contains(demotion)) {
            return demotion.toString();
        }
        demotion = new Locale(locale.getLanguage());
        if (SUPPORTED.contains(demotion)) {
            return demotion.toString();
        }
        return locale.toString();
    }

    public static void postMessage(IFormView view, String key, IFrameMessage msg) {
        if (msg != null) {
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.invokeControlMethod(key, "postMessage", new Object[]{msg});
        }
    }

    public static void addCardToHomepage(String sParams, IFormView view) {
        JSONObject jsonObject = JSONObject.parseObject((String)sParams);
        String cardId = jsonObject.getString("cardId");
        String cardName = jsonObject.getString("cardName");
        Object[] params = new Object[]{cardId, cardName, view};
        try {
            Object cardToHomepageUtil = Class.forName("kd.bos.qing.plugin.CardToHomepageUtil").newInstance();
            MethodUtils.invokeMethod(cardToHomepageUtil, (String)"addCardToHomepage", (Object[])params);
        }
        catch (Throwable e) {
            throw new KDException(e, BosErrorCode.methodInvocation, new Object[]{e.getMessage()});
        }
    }

    public static void linkageJump(String eventArgs, IFormView view) {
        try {
            Object[] params = new Object[]{eventArgs, view, true};
            Object jumpActionHandler = Class.forName("kd.bos.qing.plugin.actionhandler.LinkageJumpActionHandler").newInstance();
            MethodUtils.invokeMethod(jumpActionHandler, (String)"doJumpAction", (Object[])params);
        }
        catch (Throwable e) {
            log.error("invoke LinkageJumpActionHandler#doJumpAction error.", e);
        }
    }

    public static void showForm(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setPkId((Object)markID);
        bsp.setBillStatus(BillOperationStatus.VIEW);
        bsp.setFormId(formnumber);
        bsp.setStatus(OperationStatus.VIEW);
        bsp.setAppId(appId);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        openStyle.setClientShowType(ShowType.MainNewTabPage);
        bsp.setOpenStyle(openStyle);
        view.showForm((FormShowParameter)bsp);
    }

    private static void openTab(String appId, String markID, String formnumber, String parametertype, Map<String, Object> parameter, IFormView view) {
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appId);
        }
        catch (Exception e) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e94\u7528 %s \u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u53ef\u80fd\u5e94\u7528\u672a\u542f\u7528\u6216\u4e0d\u53ef\u89c1\uff01", (String)"QingFormUtil_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), appId));
            return;
        }
        String mainPageId = appInfo.getHomeId();
        if (mainPageId == null || mainPageId.trim().length() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u8bd5\uff01", (String)"QingFormUtil_2", (String)BOS_FORM_CORE, (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String entityName = "bos_formmeta";
        String selectProperties = "number, inheritpath";
        DynamicObjectType type = QingFormUtil.getSubEntityType(entityName, selectProperties);
        Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{mainPageId}, (DynamicObjectType)type);
        DynamicObject pageObject = (DynamicObject)rets.get(mainPageId);
        if (pageObject == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\uff01", (String)"QingFormUtil_3", (String)BOS_FORM_CORE, (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String mainPageNumber = pageObject.getString("number");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put("formnumber", formnumber);
        map.put("parametertype", parametertype);
        map.put("parameter", SerializationUtils.toJsonString(parameter));
        map.put(APPNAME, appInfo.getName().getLocaleValue());
        map.put("appmainnumber", mainPageNumber);
        Object[] invokeParams = new Object[]{appId, "markId", map, view};
        try {
            Object openPageUtils = Class.forName("kd.bos.portal.util.OpenPageUtils").newInstance();
            int arguments = invokeParams.length;
            Class[] parameterTypes = new Class[arguments];
            for (int i = 0; i < arguments; ++i) {
                parameterTypes[i] = invokeParams[i].getClass();
            }
            Object[] realInvokeParams = new Object[]{appId, markID, map, view};
            MethodUtils.invokeMethod(openPageUtils, (String)"openApp", (Object[])realInvokeParams, (Class[])parameterTypes);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.methodInvocation, new Object[]{e.getMessage()});
        }
    }

    public static void openAppMenuForm(String key, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(BOS_DEVP_CHOOSEMENU);
        CloseCallBack callBack = new CloseCallBack(QingClosedCallBack.class.getName(), BOS_DEVP_CHOOSEMENU);
        parameter.setCloseCallBack(callBack);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(QING_CALLBACK_KEY, key);
        view.showForm(parameter);
    }

    public static void openAppChooseForm(String key, IFormView view) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setLookUp(true);
        parameter.setBillFormId("bos_devportal_app_layout");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss formConfig = new StyleCss();
        formConfig.setWidth("960px");
        formConfig.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(formConfig);
        FormConfig f = FormMetadataCache.getListFormConfig((String)"bos_devportal_app_layout");
        parameter.setFormId(f.getF7ListFormId());
        parameter.setMultiSelect(false);
        parameter.setShowTitle(false);
        parameter.setHasRight(true);
        parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u9009\u62e9", (String)"QingFormUtil_9", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        parameter.setFormId(BOS_DEVP_APPTREELISTF_7);
        parameter.setCustomParam("runtime", (Object)false);
        CloseCallBack callBack = new CloseCallBack(QingClosedCallBack.class.getName(), BOS_DEVP_APPTREELISTF_7);
        parameter.setCloseCallBack(callBack);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(QING_CALLBACK_KEY, key);
        view.showForm((FormShowParameter)parameter);
    }

    public static void openRoleForm(String params, IFormView view, String key) {
        ListShowParameter param = QingFormUtil.createFormParam(PERM_ROLE, key);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        qFilters.add(enableFilter);
        param.setListFilterParameter(new ListFilterParameter(qFilters, null));
        try {
            ArrayList array = (ArrayList)JSONUtils.cast((String)params, ArrayList.class);
            param.setSelectedRows(array.toArray());
        }
        catch (IOException e1) {
            log.error(e1.getMessage());
        }
        param.setHasRight(true);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(QING_CALLBACK_KEY, key);
        view.showForm((FormShowParameter)param);
    }

    public static void openUserForm(String params, IFormView view, String key) {
        ListShowParameter param = QingFormUtil.createFormParam(BOS_USER, key);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        qFilters.add(enableFilter);
        param.setListFilterParameter(new ListFilterParameter(qFilters, null));
        try {
            ArrayList array = (ArrayList)JSONUtils.cast((String)params, ArrayList.class);
            param.setSelectedRows(array.toArray());
        }
        catch (IOException e1) {
            log.error(e1.getMessage());
        }
        param.setHasRight(true);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put(QING_CALLBACK_KEY, key);
        view.showForm((FormShowParameter)param);
    }

    private static ListShowParameter createFormParam(String billFormId, String key) {
        ListShowParameter param = ShowFormHelper.createShowListForm(billFormId, true);
        param.setMultiSelect(true);
        param.setShowApproved(true);
        param.setShowTitle(false);
        CloseCallBack closeCallBack = new CloseCallBack(QingClosedCallBack.class.getName(), billFormId);
        param.setCloseCallBack(closeCallBack);
        return param;
    }

    public static void openQingIFramePageInTab(String params, IFormView view) {
        JSONObject jsonObject = JSONObject.parseObject((String)params);
        String url = jsonObject.containsKey((Object)"url") ? jsonObject.getString("url") : "";
        String title = jsonObject.containsKey((Object)TITLE) ? jsonObject.getString(TITLE) : "";
        String appid = jsonObject.containsKey((Object)APP_ID1) ? jsonObject.getString(APP_ID1) : view.getFormShowParameter().getAppId();
        Base64.Encoder encoder = Base64.getEncoder();
        String markID = new String(encoder.encode(url.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, Object> parameter = new HashMap<String, Object>(3);
        parameter.put("formId", "qing_iframe_page");
        parameter.put("src", url);
        parameter.put(TITLE, title);
        QingFormUtil.openTab(appid, markID, "qing_iframe_page", "FormShowParameter", parameter, view);
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return type;
    }

    public static void closeTab(IFormView view) {
        view.close();
    }

    static {
        SUPPORTED.add(Locale.SIMPLIFIED_CHINESE);
        SUPPORTED.add(Locale.TRADITIONAL_CHINESE);
        SUPPORTED.add(Locale.ENGLISH);
    }

    private static class IDSet {
        private final Set<Object> sameSet = new HashSet<Object>();
        private final List<Object> idList = new ArrayList<Object>();

        private IDSet() {
        }

        void add(Object obj) {
            if (this.sameSet.add(obj)) {
                this.idList.add(obj);
            }
        }

        Object[] toArray() {
            return this.idList.toArray();
        }
    }

    public static class QingClosedCallBack
    implements ICloseCallBack {
        public void closedCallBack(ClosedCallBackEvent event) {
            IFormView view = event.getView();
            String pageId = view.getPageId();
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            String controlKey = pageCache.get(QingFormUtil.QING_CALLBACK_KEY);
            if (QingFormUtil.PERM_ROLE.equalsIgnoreCase(event.getActionId())) {
                IFrameMessage message = new IFrameMessage();
                message.setType(QingFormUtil.PERM_ROLE);
                message.setOrigin(pageId);
                ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
                HashMap<String, Object> rs = new HashMap<String, Object>(16);
                if (selectedRowCollection != null) {
                    rs.put(QingFormUtil.OPERATION, "confirm");
                    HashMap<Object, String> selecteds = new HashMap<Object, String>(1);
                    for (ListSelectedRow listSelectedRow : selectedRowCollection) {
                        Object id = listSelectedRow.getPrimaryKeyValue();
                        String name = listSelectedRow.getName();
                        selecteds.put(id, name);
                    }
                    rs.put("selecteds", selecteds);
                } else {
                    rs.put(QingFormUtil.OPERATION, "cancel");
                }
                rs.put(QingFormUtil.PAGE_ID, pageId);
                message.setContent(rs);
                QingFormUtil.postMessage(view, controlKey, message);
                pageCache.remove(QingFormUtil.QING_CALLBACK_KEY);
            } else if (QingFormUtil.BOS_USER.equalsIgnoreCase(event.getActionId())) {
                IFrameMessage message = new IFrameMessage();
                message.setType(QingFormUtil.BOS_USER);
                ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
                HashMap<String, Object> rs = new HashMap<String, Object>(16);
                if (selectedRowCollection != null) {
                    rs.put(QingFormUtil.OPERATION, "confirm");
                    HashMap<Object, String> selecteds = new HashMap<Object, String>(1);
                    for (ListSelectedRow listSelectedRow : selectedRowCollection) {
                        Object id = listSelectedRow.getPrimaryKeyValue();
                        String name = listSelectedRow.getName();
                        selecteds.put(id, name);
                    }
                    rs.put("selecteds", selecteds);
                } else {
                    rs.put(QingFormUtil.OPERATION, "cancel");
                }
                rs.put(QingFormUtil.PAGE_ID, pageId);
                message.setContent(rs);
                QingFormUtil.postMessage(view, controlKey, message);
                pageCache.remove(QingFormUtil.QING_CALLBACK_KEY);
            } else if (QingFormUtil.BOS_DEVP_CHOOSEMENU.equalsIgnoreCase(event.getActionId())) {
                IFrameMessage message = new IFrameMessage();
                message.setType("openAppMenuForm");
                Map rs = (Map)event.getReturnData();
                if (rs != null) {
                    HashMap<String, String> result = new HashMap<String, String>(16);
                    if (rs.containsKey(QingFormUtil.LEVEL) && rs.containsKey(QingFormUtil.APP_ID) && rs.containsKey(QingFormUtil.APPNAME)) {
                        String level = rs.get(QingFormUtil.LEVEL).toString();
                        if ("appnode".equalsIgnoreCase(level)) {
                            result.put(QingFormUtil.LEVEL, level);
                            result.put("cloudId", rs.get("cloudid").toString());
                            result.put("cloudNumber", rs.get("cloudnumber").toString());
                            result.put("cloudName", rs.get("cloudname").toString());
                            result.put(QingFormUtil.APP_ID1, rs.get(QingFormUtil.APP_ID).toString());
                            result.put(QingFormUtil.APP_NUMBER, rs.get("appnumber").toString());
                            result.put(QingFormUtil.APP_NAME, rs.get(QingFormUtil.APPNAME).toString());
                        } else if ("firmenunode".equalsIgnoreCase(level)) {
                            result.put(QingFormUtil.LEVEL, level);
                            result.put("cloudId", rs.get("cloudid").toString());
                            result.put("cloudNumber", rs.get("cloudnumber").toString());
                            result.put("cloudName", rs.get("cloudname").toString());
                            result.put(QingFormUtil.APP_ID1, rs.get(QingFormUtil.APP_ID).toString());
                            result.put(QingFormUtil.APP_NUMBER, rs.get("appnumber").toString());
                            result.put(QingFormUtil.APP_NAME, rs.get(QingFormUtil.APPNAME).toString());
                            result.put("appMenuId", rs.get("menuid").toString());
                            result.put("appMenuNumber", rs.get("menunumber").toString());
                            result.put("appMenuName", rs.get("menuname").toString());
                        } else if ("secmenunode".equalsIgnoreCase(level)) {
                            result.put(QingFormUtil.LEVEL, level);
                            result.put("cloudId", rs.get("cloudid").toString());
                            result.put("cloudNumber", rs.get("cloudnumber").toString());
                            result.put("cloudName", rs.get("cloudname").toString());
                            result.put(QingFormUtil.APP_ID1, rs.get(QingFormUtil.APP_ID).toString());
                            result.put(QingFormUtil.APP_NUMBER, rs.get("appnumber").toString());
                            result.put(QingFormUtil.APP_NAME, rs.get(QingFormUtil.APPNAME).toString());
                            result.put("appMenuId", rs.get("menuid").toString());
                            result.put("appMenuNumber", rs.get("menunumber").toString());
                            result.put("appMenuName", rs.get("menuname").toString());
                            result.put("appMenuId2", rs.get("menuid2").toString());
                            result.put("appMenuNumber2", rs.get("menunumber2").toString());
                            result.put("appMenuName2", rs.get("menuname2").toString());
                        } else {
                            view.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u83dc\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u7684level\u4e0d\u5728\u534f\u8bae\u8303\u56f4\u5185\u3002", (String)"QingFormUtil_6", (String)QingFormUtil.BOS_FORM_CORE, (Object[])new Object[0]));
                        }
                        result.put(QingFormUtil.PAGE_ID, pageId);
                        message.setContent(result);
                        QingFormUtil.postMessage(view, controlKey, message);
                        pageCache.remove(QingFormUtil.QING_CALLBACK_KEY);
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u83dc\u5355\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"QingFormUtil_7", (String)QingFormUtil.BOS_FORM_CORE, (Object[])new Object[0]));
                    }
                }
            } else if (QingFormUtil.BOS_DEVP_APPTREELISTF_7.equalsIgnoreCase(event.getActionId())) {
                IFrameMessage message = new IFrameMessage();
                message.setType("openAppChooseForm");
                ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
                if (selectedRowCollection != null && selectedRowCollection.size() > 0) {
                    ListSelectedRow listSelectedRow = selectedRowCollection.get(0);
                    String appNumber = listSelectedRow.getNumber();
                    AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                    String appName = appInfo.getName().getLocaleValue();
                    HashMap<String, String> rs = new HashMap<String, String>(4);
                    rs.put(QingFormUtil.APP_ID1, String.valueOf(listSelectedRow.getPrimaryKeyValue()));
                    rs.put(QingFormUtil.APP_NAME, appName);
                    rs.put(QingFormUtil.APP_NUMBER, appNumber);
                    rs.put(QingFormUtil.PAGE_ID, pageId);
                    message.setContent(rs);
                    QingFormUtil.postMessage(view, controlKey, message);
                    pageCache.remove(QingFormUtil.QING_CALLBACK_KEY);
                }
            }
        }
    }
}

