/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.ReportList;
import kd.bos.service.ServiceFactory;

class RptFieldControl {
    private static final Log log = LogFactory.getLog(RptFieldControl.class);
    private boolean controlFunction = false;
    private boolean useDimField = false;
    private String dimFldKey = null;
    private Set<Long> dimFldValues;
    private FieldControlRule fldCtrlRule = null;
    private ReportList reportList;

    public RptFieldControl(ReportList reportList) {
        this.reportList = reportList;
        this.loadFieldControlRule();
    }

    public boolean hasReadFieldRight(String colKey) {
        FieldControlRule fieldControlRule = this.fldCtrlRule;
        if (fieldControlRule == null) {
            return true;
        }
        if (fieldControlRule.getCanNotReadFields() == null) {
            return true;
        }
        if (colKey == null) {
            return true;
        }
        return !fieldControlRule.getCanNotReadFields().contains(colKey.split("\\.")[0]);
    }

    private IFormView getView() {
        return this.reportList.getView();
    }

    private IDataModel getModel() {
        return this.reportList.getModel();
    }

    private ReportQueryParam getReportQueryParam() {
        return this.reportList.getReportCache().getReportQueryParam(this.reportList.getView().getPageId());
    }

    private void loadFieldControlRule() {
        PermissionControlType permCtrl = this.getModel().getDataEntityType().getPermissionControlType();
        this.controlFunction = permCtrl.isControlFunction();
        if (!permCtrl.isControlFunction()) {
            return;
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, ShowFormHelper.getBizAppId(this.getView().getFormShowParameter()), this.getView().getEntityId());
        if (fieldControlRules == null) {
            return;
        }
        this.dimFldKey = permCtrl.getDataDimensionField();
        DynamicProperty dimProp = null;
        boolean bl = this.useDimField = StringUtils.isNotBlank((CharSequence)this.dimFldKey) && !"null".equals(this.dimFldKey);
        if (this.useDimField && (dimProp = this.getModel().getDataEntityType().getProperty(this.dimFldKey)) == null) {
            this.useDimField = false;
            this.dimFldKey = null;
        }
        this.dimFldValues = this.readDimFldValues();
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
            FieldControlRule temp;
            if (!this.filterFldControlRule(listField) || (temp = listField.getFieldControlRule()) == null) continue;
            fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
            fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
            fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
            fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
        }
        this.fldCtrlRule = fieldControlRule;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"ReportList", (String)"RptFieldControl.loadFieldControlRule", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("controlFunction", (Object)this.controlFunction);
                span.addLocaleTag("useDimField", (Object)this.useDimField);
                span.addLocaleTag("dimFldKey", (Object)this.dimFldKey);
                span.addLocaleTag("dimFldValues", this.dimFldValues);
                span.addLocaleTag("CanNotReadFields", this.fldCtrlRule != null ? this.fldCtrlRule.getCanNotReadFields() : "");
            }
        }
    }

    private boolean filterFldControlRule(FieldControlRuleDto ruleDto) {
        if (!this.useDimField) {
            return true;
        }
        if (this.dimFldValues.isEmpty()) {
            return true;
        }
        if (this.dimFldValues.contains(ruleDto.getMainOrgId())) {
            return true;
        }
        if (ruleDto.getIncludeSubOrg()) {
            for (long orgId : this.dimFldValues) {
                if (!ruleDto.getSubOrgId().contains(orgId)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Long> readDimFldValues() {
        try {
            if (StringUtils.isBlank((CharSequence)this.dimFldKey)) {
                return new HashSet<Long>(0);
            }
            HashSet<Long> dimFldValues = new HashSet<Long>(1);
            ReportQueryParam queryParam = this.getReportQueryParam();
            Object fldValue = queryParam.getFilter().getValue(this.dimFldKey);
            if (fldValue instanceof Long) {
                dimFldValues.add((Long)fldValue);
            } else if (fldValue instanceof DynamicObject) {
                dimFldValues.add((Long)((DynamicObject)fldValue).getPkValue());
            } else if (fldValue instanceof DynamicObjectCollection) {
                DynamicObjectCollection rows = (DynamicObjectCollection)fldValue;
                for (DynamicObject row : rows) {
                    Long bdId = (Long)row.getPkValue();
                    if (bdId == null || Long.compare(0L, bdId) == 0) continue;
                    dimFldValues.add(bdId);
                }
            }
            return dimFldValues;
        }
        catch (RuntimeException exp) {
            log.error((Throwable)exp);
            return new HashSet<Long>(0);
        }
    }
}

