/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.demo;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OCR;
import kd.bos.form.control.events.OCREvent;
import kd.bos.form.control.events.OCRListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DemoOCR
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnocr"});
        final OCR cor = (OCR)this.getControl("ocr");
        cor.addOCRListener(new OCRListener(){

            public void processOCR(OCREvent evt) {
                Map data = evt.getData();
                DemoOCR.this.setRecognizeContent(data, evt.getPicKey());
            }

            public void finishOCR() {
                Label statusLab = (Label)DemoOCR.this.getControl("status");
                statusLab.setText(ResManager.loadKDString((String)"\u53d1\u7968\u8bc6\u522b\u5b8c\u6210", (String)"DemoOCR_0", (String)"bos-form-core", (Object[])new Object[0]));
            }
        });
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                String picKey = (String)DemoOCR.this.getModel().getValue("pic", evt.getRow());
                cor.loadPicture(picKey);
            }
        });
    }

    private void setRecognizeContent(Map<String, String> data, String picKey) {
        int ronwIndex = this.getModel().createNewEntryRow("entryentity");
        IDataModel model = this.getModel();
        model.setValue("data", (Object)data.toString(), ronwIndex);
        model.setValue("pic", (Object)picKey, ronwIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        if (btn.getKey().equals("btnocr")) {
            Label statusLab = (Label)this.getControl("status");
            statusLab.setText(ResManager.loadKDString((String)"\u6b63\u5728\u626b\u63cf\u53d1\u7968...", (String)"DemoOCR_1", (String)"bos-form-core", (Object[])new Object[0]));
            OCR cor = (OCR)this.getControl("ocr");
            cor.scanAndOCR();
        }
    }
}

