/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.export;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.RowCellStyle;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FlexReportColumn;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportExportDataResult;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.export.IExporter;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.export.AbstractReportExport;
import kd.bos.report.export.ExportDataFromCache;
import kd.bos.report.export.ExportDataFromDataSet;
import kd.bos.report.export.ExportDataFromDataSetWithSheet;
import kd.bos.report.export.ExportManager;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class NormalExcelExport
extends AbstractReportExport {
    public NormalExcelExport(ReportList reportList) {
        this.reportList = reportList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    protected String normalExportExcel() {
        List<ReportExportDataResult> exportDataSet = null;
        this.reportListProxy = this.getReportListProxy();
        AbstractReportListModel listModel = this.reportList.getAbstractReportModel();
        Object exportOperate = ThreadCache.get((Object)"report:type");
        if (exportOperate == null) {
            exportOperate = "DirectExportExcel";
            ThreadCache.put((Object)"report:type", (Object)exportOperate);
        }
        if (!StringUtils.equals((CharSequence)exportOperate.toString(), (CharSequence)"ExportReportWithCache") && Boolean.parseBoolean(System.getProperty("bos.reportList.exportFormDataSet", "true"))) {
            exportDataSet = this.doQueryExportData();
        }
        if (exportDataSet == null && listModel.getRowCount() == 0) {
            this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u518d\u5c1d\u8bd5\u5bfc\u51fa\u3002", (String)"ReportList_0", (String)"bos-form-core", (Object[])new Object[0]));
            return "";
        }
        try {
            String string = this.splitExcelExport(listModel, exportDataSet);
            return string;
        }
        finally {
            if (!CollectionUtils.isEmpty(exportDataSet)) {
                for (ReportExportDataResult dataSet : exportDataSet) {
                    if (dataSet == null || dataSet.getDataSet() == null) continue;
                    dataSet.getDataSet().close();
                }
            }
        }
    }

    private List<ReportExportDataResult> doQueryExportData() {
        Object selectedObj;
        ReportQueryParam queryParam;
        AbstractReportListDataPlugin reportPlugin;
        ReportTaskParam param;
        String pageId = this.reportList.getView().getPageId();
        String directExportExcel = this.reportList.getView().getPageCache().get("DirectExportExcel");
        if (StringUtils.isNotEmpty((CharSequence)directExportExcel) && !StringUtils.equals((CharSequence)directExportExcel, (CharSequence)"exportreport")) {
            pageId = pageId + "_noQueryExport";
        }
        if ((param = this.reportList.getReportCache().getReportTaskParam(pageId, this.reportList.getKey())) == null) {
            return null;
        }
        String pluginClassName = param.getPluginClassName();
        if (StringUtils.isEmpty((CharSequence)pluginClassName)) {
            return null;
        }
        Class reportPluginClass = TypesContainer.getOrRegister((String)pluginClassName);
        try {
            reportPlugin = (AbstractReportListDataPlugin)reportPluginClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDException((Throwable)e, BosErrorCode.reportPluginInitError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u521d\u59cb\u5316\u5f02\u5e38\uff1a{0}\u3002", (String)"ReportList_5", (String)"bos-form-core", (Object[])new Object[]{reportPluginClass})});
        }
        try {
            queryParam = this.reportList.getQueryParam(pageId, reportPlugin);
            selectedObj = this.getSelectObject(pageId, param, reportPlugin);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e0d\u5b58\u5728\u5c5e\u6027%2$s\u6216%3$s", (String)"ReportList_6", (String)"bos-form-core", (Object[])new Object[0]), "AbstractReportListDataPlugin", "queryParam", "selectedObj"));
        }
        try {
            final DataSet export = reportPlugin.export(queryParam, selectedObj);
            if (export != null) {
                return new ArrayList(){
                    {
                        this.add(new ReportExportDataResult("sheet1", export));
                    }
                };
            }
            return reportPlugin.exportWithSheet(queryParam, selectedObj);
        }
        catch (KDBizException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportList_4", (String)"bos-form-core", (Object[])new Object[]{e.getMessage()})});
        }
        catch (Throwable e) {
            throw new KDException(e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportList_4", (String)"bos-form-core", (Object[])new Object[]{e.getMessage()})});
        }
    }

    private Object getSelectObject(String pageId, ReportTaskParam param, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field selectedObjField = AbstractReportListDataPlugin.class.getDeclaredField("selectedObj");
        selectedObjField.setAccessible(true);
        Object selectedObj = this.reportList.getReportCache().getOtherQueryParam(param, pageId);
        if (selectedObj != null) {
            selectedObjField.set(reportPlugin, selectedObj);
        }
        return selectedObj;
    }

    private String splitExcelExport(AbstractReportListModel listModel, List<ReportExportDataResult> exportData) {
        this.exportInitialize();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        ArrayList<AbstractReportColumn> exportColumns = new ArrayList<AbstractReportColumn>();
        List<AbstractReportColumn> columns = this.reportListProxy.getColumnList(listModel);
        List<ReportColumn> cols = this.reportListProxy.getReportColumnList(columns, true);
        this.getExportColumn(columns, exportColumns, map);
        int maxExcelRows = NormalExcelExport.getExportFileBatchSize();
        int maxExportSize = this.getMaxExportSize(null);
        int exportRowCount = 0;
        int startIndex = 0;
        int batchCount = 0;
        ArrayList<String> urls = new ArrayList<String>(10);
        String title = this.reportList.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        String fileName = this.getFilename(title);
        if (CollectionUtils.isEmpty(exportData)) {
            this.exportDataProvider = new ExportDataFromCache(listModel);
        } else {
            this.addSeqColumn(this.reportList.getColumns());
            List<ReportColumn> reportColumnList = listModel.getReportTaskResult() == null || listModel.getReportTaskResult().getReportColumnList() == null ? this.reportListProxy.getReportColumnList(this.reportList.getColumns(), true) : listModel.getReportTaskResult().getReportColumnList();
            this.exportDataProvider = exportData.size() == 1 ? new ExportDataFromDataSet(exportData.get(0).getDataSet(), exportData.get(0).getSheetName(), this.reportList.getView().getModel().getDataEntityType(), reportColumnList, listModel.getPageId(), listModel.getCtrlId(), this.reportList) : new ExportDataFromDataSetWithSheet(exportData, this.reportList.getView().getModel().getDataEntityType(), reportColumnList, listModel.getPageId(), listModel.getCtrlId(), this.reportList);
        }
        while (!this.getExportDataProvider(listModel).isLast(startIndex)) {
            try {
                String fileNameBatch = fileName;
                if (batchCount > 0) {
                    fileNameBatch = fileName + "_" + batchCount;
                }
                this.reportList.getReportCache().setProgress(listModel.getPageId(), 5);
                if (maxExcelRows <= 0) break;
                if (ExportManager.isStopExport(this.reportList.getView().getPageId(), this.reportList.getModel().getDataEntityType().getName())) {
                    return "";
                }
                ThreeTuple<Boolean, String, Integer> r = this.largeDataExportExcelPerBatch(listModel, null, columns, cols, exportColumns, map, startIndex, maxExcelRows, exportRowCount, fileNameBatch);
                if (!((Boolean)r.item1).booleanValue()) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)r.item2))) {
                        throw new KDException((String)r.item2);
                    }
                    return "";
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)r.item2))) {
                    urls.add((String)r.item2);
                }
                int lastRowCountExport = (Integer)r.item3;
                exportRowCount += lastRowCountExport;
                startIndex += maxExcelRows;
                int total = this.getExportDataProvider(listModel).getRowCount();
                if (total > 0) {
                    int progress = exportRowCount * 100 / total;
                    if (progress > 100) {
                        progress = 99;
                    }
                    if (this.getExportDataProvider(listModel).isLast(startIndex)) {
                        progress = 99;
                    }
                    this.reportList.getReportCache().setProgress(listModel.getPageId(), progress);
                }
                ++batchCount;
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        if (exportRowCount == 0) {
            this.reportList.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u518d\u5c1d\u8bd5\u5bfc\u51fa\u3002", (String)"ReportList_0", (String)"bos-form-core", (Object[])new Object[0]));
            return "";
        }
        boolean exceededExportLimit = this.getExportDataProvider(listModel).isExceededExportLimit();
        if (exceededExportLimit) {
            log.info("\u83b7\u53d6\u6570\u636e\u8d85\u8fc7\u9650\u5236\u884c\u6570\uff0climitCount={}", (Object)maxExportSize);
            this.reportList.getReportCache().setException(this.reportList.getView().getPageId(), new ReportException(ReportException.ShowType.SHOW_MESSAGE, String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u51fa\u8d85\u884c\u6570\u4e0a\u9650\uff08%1$s\u4e07\u884c\uff09\uff0c\r\n%2$s\u4e07\u884c\u5185\u6570\u636e\u5bfc\u51fa\u6210\u529f\uff0c\u8d85\u51fa\u90e8\u5206\u672a\u5bfc\u51fa\u3002", (String)"DataExcelExport_0", (String)"bos-form-core", (Object[])new Object[0]), this.maxExportLimit, this.maxExportLimit)));
        }
        return this.saveExportFileAsUrl(fileName, urls, this.getExportDataProvider(listModel).isWriteFileByRedis());
    }

    private void addSeqColumn(List<AbstractReportColumn> columns) {
        ReportColumn seqCol = new ReportColumn();
        seqCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"NormalExcelExport_1", (String)"bos-form-core", (Object[])new Object[0])));
        seqCol.setFieldKey("fseq");
        seqCol.setFreeze(true);
        seqCol.setFieldType("integer");
        columns.add(0, (AbstractReportColumn)seqCol);
    }

    @SdkInternal
    protected ThreeTuple<Boolean, String, Integer> largeDataExportExcelPerBatch(AbstractReportListModel listModel, ReportBatchQueryInfo byBatchInfo, List<AbstractReportColumn> columns, List<ReportColumn> cols, List<AbstractReportColumn> exportColumns, Map<String, Boolean> map, int startIndex, int excelMaxrow, int exportedRowCount, String fileName) {
        try {
            int rowCount = 0;
            IExporter exporter = (IExporter)Class.forName(this.reportList.getExcelExporter()).newInstance();
            SXSSFWorkbook wb = new SXSSFWorkbook(-1);
            TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(){

                public File createTempFile(String prefix, String suffix) throws IOException {
                    return File.createTempFile(prefix, suffix);
                }
            });
            exporter.setWb(wb);
            exporter.setMap(map);
            exporter.setSearchCondition(this.reportList.getView().getPageCache().get("searchCondition"));
            boolean isFlexFieldSplit = false;
            ArrayList<AbstractReportColumn> flexSplitColumns = new ArrayList();
            while (rowCount == 0 || rowCount < excelMaxrow && this.getExportDataProvider(listModel).moveToNextSheet()) {
                int size = 10000;
                int times = (excelMaxrow -= rowCount) / size;
                boolean hasMod = false;
                if (excelMaxrow % size != 0) {
                    ++times;
                    hasMod = true;
                }
                SXSSFSheet sheet = wb.createSheet(this.getExportDataProvider(listModel).getSheetName());
                exporter.setCaption(this.reportList.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
                exporter.setSize(size);
                exporter.setSheetName(this.getExportDataProvider(listModel).getSheetName());
                exporter.setMergeColumnRules(this.exportInitializeEvent.getMergeColumnRules());
                for (int i = 0; i < times; ++i) {
                    DynamicObjectCollection data;
                    exporter.setLoopTimes(i);
                    int rowSize = size;
                    if (i == times - 1 && hasMod) {
                        rowSize = excelMaxrow - i * size;
                    }
                    if ((data = this.getExportDataProvider(listModel).getRowData(startIndex + i * size, rowSize)) == null || data.size() == 0) {
                        sheet.flushRows();
                        break;
                    }
                    NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)data, cols);
                    listModel.preProcessExportData(exportColumns, data, numberFormatProvider);
                    ArrayList<RowCellStyle> rowCellStyles = new ArrayList<RowCellStyle>();
                    FormViewPluginProxy pluginProxy = (FormViewPluginProxy)listModel.getView().getService(FormViewPluginProxy.class);
                    if (pluginProxy instanceof ReportViewPluginProxy) {
                        ((ReportViewPluginProxy)pluginProxy).setRowStyles(rowCellStyles);
                    }
                    if (!isFlexFieldSplit) {
                        flexSplitColumns = (List)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)((Object)exportColumns))));
                        this.reportList.getFlexColumnSplitService().splitFlextColumn(flexSplitColumns);
                        exporter.setReportList(this.reportList);
                        isFlexFieldSplit = true;
                    }
                    exporter.export(flexSplitColumns, data, numberFormatProvider, rowCellStyles);
                    rowCount += data.size();
                    sheet.flushRows();
                    IReportView reportView = (IReportView)this.reportList.getView();
                    reportView.setProgress(exportedRowCount + i * size);
                    if (data.size() < size) break;
                }
                this.endExport(exporter, times);
            }
            String url = "";
            if (rowCount > 0) {
                if (this.getExportDataProvider(listModel).isWriteFileByRedis()) {
                    url = this.writeFile(wb, fileName);
                } else {
                    String path = this.getExportFilePath(fileName + ".xlsx");
                    url = this.writeFile2AttachmentFileService(wb, fileName + ".xlsx", path);
                }
            }
            wb.dispose();
            return new ThreeTuple((Object)true, (Object)url, (Object)rowCount);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.reportHeadEmpty)) {
                String sError = ResManager.loadKDString((String)"\u62a5\u8868\u5b57\u6bb5\u5168\u90e8\u9690\u85cf\u65f6\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"ReportList_2", (String)"bos-form-core", (Object[])new Object[0]);
                this.reportList.getView().showErrorNotification(sError);
                return new ThreeTuple((Object)false, null, (Object)0);
            }
            this.reportList.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5355\u5143\u683c\u5b57\u7b26\u8d85\u51faExcel\u9650\u5236\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"NormalExcelExport_0", (String)"bos-form-core", (Object[])new Object[0]));
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private static int getExportFileBatchSize() {
        return Integer.getInteger("bos.reportList.exportFileBatchSize", 1000000);
    }

    private void getExportColumn(List<AbstractReportColumn> columns, List<AbstractReportColumn> exportColumns, Map<String, Boolean> map) {
        FormatObject format = this.reportListProxy.getFormat();
        ArrayList<AbstractReportColumn> originColumns = new ArrayList<AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> originColumnMap = new HashMap<String, AbstractReportColumn>();
        List<GridConfigurationRow> configRows = this.reportListProxy.getUserGridConfigRows();
        if (CollectionUtils.isEmpty(configRows)) {
            Map<String, String> initFieldMap = new HashMap();
            List<Map<String, String>> initFieldList = this.reportList.getInitField();
            if (!CollectionUtils.isEmpty(initFieldList)) {
                initFieldMap = this.initFieldListToMap(initFieldList);
            }
            if (!CollectionUtils.isEmpty((Map)initFieldMap)) {
                this.removeByInitField(columns, initFieldMap);
            }
        }
        for (AbstractReportColumn abstractReportColumn : columns) {
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            String fieldKey = null;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)abstractReportColumn).getFieldKey();
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn child : childrens) {
                    if (child instanceof ReportOperationColumn) continue;
                    if (child instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)child, format);
                        continue;
                    }
                    child.setUserFormat(format);
                }
            } else {
                if (abstractReportColumn instanceof ReportColumn) {
                    fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
                }
                abstractReportColumn.setUserFormat(format);
            }
            if (!StringUtils.isBlank((CharSequence)fieldKey)) {
                originColumnMap.put(fieldKey, abstractReportColumn);
            }
            originColumns.add(abstractReportColumn);
        }
        HashMap<String, AbstractReportColumn> allColumnMap = new HashMap<String, AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> parentColumnMap = new HashMap<String, AbstractReportColumn>();
        this.allColumnMap(originColumnMap, allColumnMap, parentColumnMap);
        if (configRows != null && !configRows.isEmpty()) {
            Iterator<GridConfigurationRow> configRowsIterator = configRows.iterator();
            while (configRowsIterator.hasNext()) {
                GridConfigurationRow row = configRowsIterator.next();
                map.put(row.getFieldKey(), row.isHide());
                if (!row.isHide()) {
                    if (!CollectionUtils.isEmpty((Collection)row.getChildren())) {
                        AbstractReportColumn abstractReportColumn = (AbstractReportColumn)originColumnMap.get(row.getFieldKey());
                        if (abstractReportColumn instanceof ReportColumnGroup) {
                            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)abstractReportColumn;
                            if (CollectionUtils.isEmpty((Collection)reportColumnGroup.getChildren())) continue;
                            if (!row.isHide() && this.isAllHide(row.getChildren(), allColumnMap)) {
                                configRowsIterator.remove();
                                originColumns.remove(originColumnMap.get(row.getFieldKey()));
                                continue;
                            }
                            this.dealMulGroup(row, allColumnMap, parentColumnMap);
                        } else if (abstractReportColumn instanceof FlexReportColumn) {
                            List configurationRowList = row.getChildren();
                            Iterator iterator = configurationRowList.iterator();
                            while (iterator.hasNext()) {
                                GridConfigurationRow configurationRow = (GridConfigurationRow)iterator.next();
                                if (!configurationRow.isHide()) continue;
                                iterator.remove();
                            }
                            if (row.getChildren().size() == 0) {
                                configRowsIterator.remove();
                                originColumns.remove(originColumnMap.get(row.getFieldKey()));
                                continue;
                            }
                        }
                    }
                } else {
                    configRowsIterator.remove();
                }
                AbstractReportColumn column = null;
                for (Map.Entry columnEntry : originColumnMap.entrySet()) {
                    Object fieldKey = this.reportList.getMergeMap().get(columnEntry.getKey()) == null ? columnEntry.getKey() : this.reportList.getMergeMap().get(columnEntry.getKey());
                    if (!Objects.equals(fieldKey, row.getFieldKey())) continue;
                    column = (AbstractReportColumn)columnEntry.getValue();
                    break;
                }
                if (column == null) continue;
                exportColumns.add(column);
                originColumns.remove(column);
            }
        }
        exportColumns.addAll(originColumns);
        this.removeColumnNoReadFields(exportColumns);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireResetColumns(exportColumns);
        }
    }

    private Map<String, String> initFieldListToMap(List<Map<String, String>> initFieldList) {
        HashMap<String, String> resMap = new HashMap<String, String>(initFieldList.size());
        for (Map<String, String> map : initFieldList) {
            resMap.put(map.get("fieldkey"), map.get("isvisible"));
        }
        return resMap;
    }

    private void removeByInitField(List<AbstractReportColumn> columns, Map<String, String> initFieldMap) {
        Iterator<AbstractReportColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String fieldKey;
            AbstractReportColumn column = iterator.next();
            if (column instanceof ReportColumnGroup) {
                this.removeByInitField(((ReportColumnGroup)column).getChildren(), initFieldMap);
                continue;
            }
            if (!(column instanceof ReportColumn) || !initFieldMap.containsKey(fieldKey = ((ReportColumn)column).getFieldKey()) || Boolean.parseBoolean(initFieldMap.get(fieldKey))) continue;
            iterator.remove();
        }
    }

    private boolean isAllHide(List<GridConfigurationRow> gridConfigurationRowList, Map<String, AbstractReportColumn> allColumnMap) {
        for (GridConfigurationRow row : gridConfigurationRowList) {
            AbstractReportColumn abstractReportColumn = allColumnMap.get(row.getFieldKey());
            if (abstractReportColumn instanceof ReportColumn && !row.isHide()) {
                return false;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup) || row.isHide()) continue;
            return this.isAllHide(row.getChildren(), allColumnMap);
        }
        return true;
    }

    private void dealMulGroup(GridConfigurationRow gridConfigurationRow, Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> parentColumnMap) {
        for (GridConfigurationRow row : gridConfigurationRow.getChildren()) {
            AbstractReportColumn abstractReportColumn;
            if (row.getChildren().size() == 0 && row.isHide()) {
                abstractReportColumn = originColumnMap.get(row.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                    continue;
                }
                if (!(abstractReportColumn instanceof ReportColumn)) continue;
                this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                continue;
            }
            if (row.getChildren().size() <= 0) continue;
            if (row.isHide()) {
                abstractReportColumn = originColumnMap.get(gridConfigurationRow.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                } else if (abstractReportColumn instanceof ReportColumn) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                }
            }
            this.dealMulGroup(row, originColumnMap, parentColumnMap);
        }
    }

    private void removeGroupChild(Map<String, AbstractReportColumn> parentColumnMap, AbstractReportColumn abstractReportColumn, GridConfigurationRow row) {
        String fieldKey = "";
        if (abstractReportColumn instanceof ReportColumn) {
            fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
        } else if (abstractReportColumn instanceof ReportColumnGroup) {
            fieldKey = row.getFieldKey();
        }
        ReportColumnGroup reportColumnGroup = (ReportColumnGroup)parentColumnMap.get(fieldKey);
        if (reportColumnGroup == null) {
            return;
        }
        List columnList = reportColumnGroup.getChildren();
        Iterator iterator1 = columnList.iterator();
        while (iterator1.hasNext()) {
            AbstractReportColumn abstractReportColumn1 = (AbstractReportColumn)iterator1.next();
            if (abstractReportColumn1 instanceof ReportColumn) {
                if (!((ReportColumn)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
                iterator1.remove();
                continue;
            }
            if (!(abstractReportColumn1 instanceof ReportColumnGroup) || !((ReportColumnGroup)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
            iterator1.remove();
        }
    }

    private void allColumnMap(Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> map, Map<String, AbstractReportColumn> parentColumnMap) {
        for (Map.Entry<String, AbstractReportColumn> entry : originColumnMap.entrySet()) {
            if (entry.getValue() instanceof ReportColumn) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof ReportColumnGroup)) continue;
            map.put(entry.getKey(), entry.getValue());
            HashMap<String, AbstractReportColumn> groupMap = new HashMap<String, AbstractReportColumn>();
            for (AbstractReportColumn column : ((ReportColumnGroup)entry.getValue()).getChildren()) {
                if (column instanceof ReportColumn) {
                    groupMap.put(((ReportColumn)column).getFieldKey(), column);
                    parentColumnMap.put(((ReportColumn)column).getFieldKey(), entry.getValue());
                    continue;
                }
                if (!(column instanceof ReportColumnGroup)) continue;
                groupMap.put(((ReportColumnGroup)column).getFieldKey(), column);
                parentColumnMap.put(((ReportColumnGroup)column).getFieldKey(), entry.getValue());
            }
            this.allColumnMap(groupMap, map, parentColumnMap);
        }
    }
}

