/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.report.events.CreateFilterInfoEvent;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.report.processor.IReportColumnProcessor;

public abstract class AbstractProcessor
implements IReportColumnProcessor {
    private static final String NUMBER_GROUPS = "0,1,2,3,4";
    private IFormView view;
    private ReportColumn column;
    private String fieldKey;
    private String fieldType;
    private FilterField filterField = null;

    @Override
    public String getFieldType() {
        return this.fieldType;
    }

    @Override
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    protected MainEntityType getEntityType() {
        return EntityMetadataCache.getDataEntityType((String)this.view.getEntityId());
    }

    @Override
    public void setView(IFormView view) {
        this.view = view;
    }

    @Override
    public IFormView getView() {
        return this.view;
    }

    @Override
    public void setReportColumn(ReportColumn column) {
        this.column = column;
    }

    public ReportColumn getColumn() {
        return this.column;
    }

    @Override
    public void setFilterField(FilterField filterField) {
        this.filterField = filterField;
    }

    public FilterField getFilterField() {
        if (this.filterField == null) {
            this.filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)this.getFieldKey());
        }
        return this.filterField;
    }

    @Override
    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    protected Map<String, Object> createDefaultFilterInfo() {
        HashMap<String, Object> filterInfo = new HashMap<String, Object>();
        FilterField filterField = this.getFilterField();
        List filterFieldCompareTypes = null;
        filterFieldCompareTypes = filterField == null || filterField.getSrcFieldProp() instanceof BasedataProp ? (filterField != null && filterField.getSrcFieldProp() instanceof OrgProp ? filterField.getCompareTypes() : this.getDefaultCompareTypes()) : filterField.getCompareTypes();
        List<CompareType> compareTypes = this.getCompareTypes(filterFieldCompareTypes);
        ArrayList ctList = new ArrayList(10);
        HashMap<String, Object> map = null;
        for (CompareType ct : compareTypes) {
            map = new HashMap<String, Object>(16);
            map.put("id", ct.getId());
            map.put("name", ct.getName());
            map.put("value", ct.getValue());
            map.put("inputCtlType", ct.getInputCtlType());
            ctList.add(map);
        }
        if (ctList.isEmpty()) {
            filterInfo.put("filter", false);
        } else {
            filterInfo.put("filterItems", ctList);
        }
        return filterInfo;
    }

    protected List<CompareType> getCompareTypes(List<CompareType> compareTypes) {
        return compareTypes;
    }

    @Override
    public Map<String, Object> createFilterInfo() {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ReportViewPluginProxy proxy = (ReportViewPluginProxy)pluginProxy;
            CreateFilterInfoEvent event = new CreateFilterInfoEvent(this, this.view, this.fieldKey);
            proxy.fireBeforeCreateFilterInfo(event);
            if (event.isCancel() && !event.getFilterInfo().isEmpty()) {
                return event.getFilterInfo();
            }
        }
        return this.createDefaultFilterInfo();
    }

    private String getCompareGroups() {
        String groups = null;
        if (StringUtils.isBlank((CharSequence)this.fieldType)) {
            return null;
        }
        switch (this.getFieldType()) {
            case "text": {
                groups = NUMBER_GROUPS;
                break;
            }
            case "integer": 
            case "bigint": 
            case "decimal": 
            case "amount": 
            case "price": 
            case "qty": {
                groups = "0,4";
                break;
            }
            case "combofield": {
                groups = "10,11";
                break;
            }
            case "boolean": {
                groups = "10";
                break;
            }
            case "date": {
                groups = "0,2,4,5";
                break;
            }
            case "basedata": 
            case "unit": 
            case "currency": {
                groups = NUMBER_GROUPS;
                break;
            }
            default: {
                groups = NUMBER_GROUPS;
            }
        }
        return groups;
    }

    private List<CompareType> getDefaultCompareTypes() {
        String compareGroups = this.getCompareGroups();
        if (compareGroups == null) {
            return new ArrayList<CompareType>();
        }
        return FilterMetadata.get().getCompareTypes(compareGroups);
    }
}

