/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.report.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.product.ProductSettingService;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.userconfig.GridConfigDAO;

public class ReportListProxy {
    protected static final Log log = LogFactory.getLog(ReportListProxy.class);
    private ReportList reportList;

    public ReportListProxy(ReportList reportList) {
        this.reportList = reportList;
    }

    public List<AbstractReportColumn> getColumnList(IReportListModel reportModel) {
        FormViewPluginProxy pluginProxy;
        String key = this.reportList.getView().getEntityId() + "_" + this.reportList.getKey() + "_reportcolumnsmap";
        String columnsSetting = this.reportList.getModel().getCurrUserSetting(key);
        String json = this.reportList.getModel().getCurrUserSetting(this.reportList.getView().getFormShowParameter().getSettingKey());
        List columns = reportModel.getColumns();
        if (columnsSetting != null) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)columnsSetting);
            for (AbstractReportColumn column : columns) {
                if (column instanceof ReportColumn) {
                    ReportColumn c = (ReportColumn)column;
                    if (map.get(c.getFieldKey()) == null) continue;
                    c.setHide(((Boolean)map.get(c.getFieldKey())).booleanValue());
                    continue;
                }
                if (!(column instanceof ReportColumnGroup)) continue;
                ReportColumnGroup reportColumnGroup = (ReportColumnGroup)column;
                List childrenList = reportColumnGroup.getChildren();
                for (AbstractReportColumn reportColumn : childrenList) {
                    if (reportColumn instanceof ReportColumn) {
                        ReportColumn c = (ReportColumn)reportColumn;
                        if (map.get(c.getFieldKey()) == null) continue;
                        c.setHide(((Boolean)map.get(c.getFieldKey())).booleanValue());
                        continue;
                    }
                    if (!(reportColumn instanceof ReportColumnGroup)) continue;
                    this.doMulGroup(reportColumn, map);
                }
            }
        }
        if (json != null) {
            for (AbstractReportColumn column : columns) {
                this.resovleColumn(column, json);
            }
        }
        if ((pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class)) instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireAfterCreateColumn(this.reportList.getKey(), columns, reportModel.getReportQueryParam(), reportModel.getOtherQueryParam());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        this.reportList.setMergeMap(map);
        this.mergeColumn(columns);
        SingleOrgContextHelper.createReportSingleOrgContext(columns);
        this.filterBlackList(this.reportList.getView().getEntityId(), columns);
        return columns;
    }

    private void doMulGroup(AbstractReportColumn column, Map<String, Boolean> map) {
        ReportColumnGroup reportColumnGroup = (ReportColumnGroup)column;
        List childrenList = reportColumnGroup.getChildren();
        for (AbstractReportColumn reportColumn : childrenList) {
            if (reportColumn instanceof ReportColumn) {
                ReportColumn c = (ReportColumn)reportColumn;
                if (map.get(c.getFieldKey()) == null) continue;
                c.setHide(map.get(c.getFieldKey()).booleanValue());
                continue;
            }
            if (!(reportColumn instanceof ReportColumnGroup)) continue;
            this.doMulGroup(reportColumn, map);
        }
    }

    public List<ReportColumn> getReportColumnList(List<AbstractReportColumn> reportColumns, boolean isOnlyVisible) {
        ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
        this.setReportColumns(reportColumns, cols, isOnlyVisible);
        return cols;
    }

    public FormatObject getFormat() {
        String fmt;
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map userFormat = inteService.getUserFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        result.setDateFormat(new DateFormatObject(userFormat.get("dateFormat").toString()));
        return result;
    }

    public List<GridConfigurationRow> getUserGridConfigRows() {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        String formId = this.reportList.getView().getFormShowParameter().getFormId();
        List<Object> gridConfig = new ArrayList<GridConfigurationRow>(10);
        try {
            gridConfig = gridConfigDAO.getGridConfig(formId, this.reportList.getEntryKey());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return gridConfig;
    }

    public void saveGridConfig(List<GridConfigurationRow> configurationRowList) {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        String formId = this.reportList.getView().getFormShowParameter().getFormId();
        try {
            gridConfigDAO.saveGridConfig(formId, this.reportList.getEntryKey(), configurationRowList);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public ReportBatchQueryInfo getByBatchInfo() {
        AbstractReportListModel listModel = this.reportList.getAbstractReportModel();
        return (ReportBatchQueryInfo)listModel.getReportQueryParam().byBatchInfo();
    }

    public Method getReportPropUtil_createReportType() {
        if (ReportList.reportPropUtil_createReportType == null) {
            try {
                ReportList.reportPropUtil_createReportType = Class.forName("kd.bos.mvc.report.ReportPropUtil").getMethod("createReportType", DynamicObjectType.class, List.class);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
            }
        }
        return ReportList.reportPropUtil_createReportType;
    }

    public List<RowClickEventListener> getRowClickListeners() {
        return this.reportList.getRowClickListeners();
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols, boolean isOnlyVisible) {
        for (AbstractReportColumn acol : acols) {
            if (!(!(acol instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)acol).isHide())) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols, isOnlyVisible);
        }
    }

    private void resovleColumn(AbstractReportColumn column, String json) {
        JSONObject settings = JSON.parseObject((String)json);
        if (column instanceof ReportColumn) {
            JSONObject colObject;
            ReportColumn c = (ReportColumn)column;
            if (settings != null && settings.getJSONObject("reportlistap") != null && (colObject = settings.getJSONObject("reportlistap").getJSONObject("cw")) != null && colObject.get((Object)c.getFieldKey()) != null && colObject.get((Object)c.getFieldKey()) instanceof Integer) {
                int widthObj = (Integer)colObject.get((Object)c.getFieldKey());
                c.setWidth(new LocaleString("" + widthObj));
            }
        } else if (column instanceof ReportColumnGroup) {
            ReportColumnGroup g = (ReportColumnGroup)column;
            for (AbstractReportColumn r : g.getChildren()) {
                this.resovleColumn(r, json);
            }
        }
    }

    private void mergeColumn(List<AbstractReportColumn> columns) {
        HashMap<String, String> mergeMap = new HashMap<String, String>(16);
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!(column instanceof ReportColumnGroup)) continue;
            List cols = ((ReportColumnGroup)column).getChildren();
            this.mergeColumn(cols);
            if (!this.isOnlyOneVisibleColumn(cols)) continue;
            columns.remove(i);
            for (AbstractReportColumn col : cols) {
                if (!this.isVisible(col)) continue;
                col.setCaption(column.getCaption());
                if (col instanceof ReportColumn) {
                    mergeMap.put(((ReportColumn)col).getFieldKey(), ((ReportColumnGroup)column).getFieldKey());
                    continue;
                }
                if (!(col instanceof ReportColumnGroup)) continue;
                mergeMap.put(((ReportColumnGroup)col).getFieldKey(), ((ReportColumnGroup)column).getFieldKey());
            }
            columns.addAll(i, cols);
        }
        this.reportList.setMergeMap(mergeMap);
        this.reportList.getView().getPageCache().put("report_mergemap", SerializationUtils.toJsonString(mergeMap));
    }

    private boolean isOnlyOneVisibleColumn(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> cols = new ArrayList<AbstractReportColumn>();
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!this.isVisible(column)) continue;
            cols.add(column);
            if (cols.size() <= 1) continue;
            return false;
        }
        return cols.size() != 1 || cols.get(0) == null || ((AbstractReportColumn)cols.get(0)).isHideSingleColumnRow();
    }

    private void filterBlackList(String entityId, List<AbstractReportColumn> columns) {
        if (StringUtils.isBlank((CharSequence)entityId) || columns == null) {
            return;
        }
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List ctrls = service.getFormDisVistCtl(entityId);
        if (ctrls == null || ctrls.isEmpty()) {
            return;
        }
        this.setBlackListColumn(ctrls, columns);
    }

    private void setBlackListColumn(List<String> ctrls, List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (!ctrls.contains(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            List children = ((ReportColumnGroup)column).getChildren();
            this.setBlackListColumn(ctrls, children);
        }
    }

    private boolean isVisible(AbstractReportColumn column) {
        if (column instanceof ReportColumn && !((ReportColumn)column).isHide()) {
            return true;
        }
        if (column instanceof ReportColumnGroup) {
            List columns = ((ReportColumnGroup)column).getChildren();
            for (int i = 0; i < columns.size(); ++i) {
                if (!this.isVisible((AbstractReportColumn)columns.get(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

