/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.systree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.NodeInfo;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.systree.SystemTree;

public class FuncTree
extends SystemTree {
    private static Log log = LogFactory.getLog(FuncTree.class);
    private Boolean menuVisible;
    private Boolean permVisible;

    public void setMenuVisible(boolean val) {
        this.menuVisible = val;
    }

    public void setPermVisible(boolean val) {
        this.permVisible = val;
    }

    @Override
    public TreeNode loadTree(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        TreeNode rootNode = this.loadRootNode(biFunction);
        this.loadCloudNode(biFunction);
        this.loadAppNode(biFunction);
        this.loadFuncNode(biFunction);
        if (this.moveNullChilden) {
            this.removeNullChildNode(rootNode);
        }
        return rootNode;
    }

    private void loadFuncNode(BiFunction<String, NodeInfo, TreeNode> biFunction) {
        Map appMenuInfoMap = AppMetadataCache.getAllAppMenus();
        boolean checkPermVisible = this.permVisible != null;
        boolean checkMenuVisible = this.menuVisible != null;
        for (Map.Entry entry : appMenuInfoMap.entrySet()) {
            String appId = (String)entry.getKey();
            TreeNode appNode = (TreeNode)this.treeNodeMap.get(appId);
            if (appNode == null) continue;
            HashMap<String, List> nullParentMap = new HashMap<String, List>();
            List list = (List)entry.getValue();
            for (AppMenuInfo appMenuInfo : list) {
                TreeNode node = this.createTreeNode(appMenuInfo.getParentId(), (NodeInfo)appMenuInfo, biFunction);
                if (node == null) continue;
                String appNum = (String)this.deployAppIdNumMap.get(appMenuInfo.getParentId());
                TreeNode parentNode = null;
                parentNode = StringUtils.isBlank((CharSequence)appNum) ? (TreeNode)this.treeNodeMap.get(appMenuInfo.getParentId()) : (TreeNode)this.treeNodeMap.get(appNum);
                if (parentNode == null) {
                    List nodes = nullParentMap.computeIfAbsent(appMenuInfo.getParentId(), k -> new ArrayList());
                    nodes.add(node);
                    continue;
                }
                parentNode.addChild(node);
            }
            for (Map.Entry entry2 : nullParentMap.entrySet()) {
                String parentId = (String)entry2.getKey();
                TreeNode parentNode = (TreeNode)this.treeNodeMap.get(parentId);
                for (TreeNode node : (List)entry2.getValue()) {
                    if (parentNode != null) {
                        parentNode.addChild(node);
                        continue;
                    }
                    log.info("\u83dc\u5355{}\u6ca1\u627e\u5230\u7236\u8282\u70b9{}\u3002", (Object)node.getText(), (Object)parentId);
                }
            }
        }
    }
}

