/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.debug.DebugInfo;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.instance.AppGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.ListenTimerElapsedCache;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.mvc.form.FormView;
import kd.bos.script.debug.DebugCache;
import kd.bos.script.debug.DebugManager;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SessionManager {
    private SessionDAO sessionDAO;
    boolean isRequestThread = false;
    private Set<String> releasePageIds = new HashSet<String>(0);
    private static ThreadLocal<SessionManager> current = new ThreadLocal();
    private static String batchsave_cfg = "sessionmanager.pagecache.immediate";
    private static boolean isImmediate = false;
    private static final Log log = LogFactory.getLog((String)"SessionManager");
    private Map<String, IFormView> viewCache = new ConcurrentHashMap<String, IFormView>();
    private Map<String, IPageCache> ipageCache = new HashMap<String, IPageCache>();

    public static SessionManager getCurrent() {
        SessionManager currentSession = current.get();
        if (currentSession == null) {
            currentSession = new SessionManager();
            current.set(currentSession);
        }
        if (!StringUtils.equals((CharSequence)RequestContext.get().getGlobalSessionId(), (CharSequence)currentSession.sessionDAO.getSessionId())) {
            log.info("\u91cd\u65b0\u83b7\u53d6SessionManager,currentThreadId:{},userId:{}", (Object)Thread.currentThread().getId(), (Object)RequestContext.get().getUserId());
            currentSession = new SessionManager();
            current.set(currentSession);
        }
        return currentSession;
    }

    public SessionManager() {
        RequestContext context = RequestContext.get();
        String sessionId = context.getGlobalSessionId();
        this.sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
    }

    public static void reset() {
        SessionManager sessionManager = current.get();
        current.set(null);
    }

    private String makeTypeKey(String pageId) {
        return "form-page-" + pageId;
    }

    public String get(String key) {
        return (String)ThreadCache.get((Object)key, () -> this.sessionDAO.getAttribute(key));
    }

    public void put(String key, String value) {
        this.sessionDAO.setAttribute(key, value);
    }

    public void remove(String key) {
        this.sessionDAO.removeByKeyPrefix(key);
    }

    public IFormView getView(String pageId) {
        if (pageId == null) {
            return null;
        }
        IFormView view = this.viewCache.get(pageId);
        if (view == null) {
            IPageCache pageCache;
            String parameter;
            DebugCache dc = null;
            DebugInfo di = RequestContext.get().getDebugInfo();
            if (di != null && !di.isCmd()) {
                dc = DebugManager.getDebugCache((String)di.getDebugId());
                StringBuilder stringBuilder = new StringBuilder();
                DebugCache.names();
                view = (IFormView)dc.get(stringBuilder.append("_inner_formservice_formview").append(pageId).toString());
                if (view != null) {
                    this.viewCache.put(pageId, view);
                }
            }
            if (view == null && StringUtils.isNotBlank((CharSequence)(parameter = (pageCache = this.getPageCache(pageId)).get(FormShowParameter.class.getSimpleName())))) {
                FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)parameter);
                formShowParameter.endInit();
                view = formShowParameter.createView();
                if (this.releasePageIds.contains(pageId)) {
                    ((FormView)view).setReleasing(true);
                }
                view.addService(IPageCache.class, (Object)pageCache);
                this.initView(view, formShowParameter);
                this.viewCache.put(pageId, view);
                if (dc != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    DebugCache.names();
                    String viewCacheId = stringBuilder.append("_inner_formservice_formview").append(pageId).toString();
                    dc.set(viewCacheId, (Object)view);
                    List plugins = view.getFormShowParameter().getFormConfig().getPlugins();
                    if (plugins != null && plugins.size() > 0) {
                        for (Plugin plugin : plugins) {
                            if (plugin.getType() != 1) continue;
                            String scriptNumber = plugin.getClassName().substring(plugin.getClassName().lastIndexOf(46) + 1);
                            ArrayList<String> viewCacheIds = (ArrayList<String>)dc.get(scriptNumber);
                            if (viewCacheIds == null) {
                                viewCacheIds = new ArrayList<String>();
                            }
                            viewCacheIds.add(viewCacheId);
                            dc.set(scriptNumber, viewCacheIds);
                        }
                    }
                }
            }
        }
        return view;
    }

    public void setRequestThread(boolean isRequestThread) {
        this.isRequestThread = isRequestThread;
    }

    public IPageCache getPageCache(String pageId) {
        boolean batchSave;
        IPageCache cache = this.ipageCache.get(pageId);
        boolean bl = batchSave = !isImmediate && !this.isRequestThread;
        if (cache == null) {
            cache = new PageCache(pageId, batchSave);
        }
        return cache;
    }

    public IPageCache getPageCacheInMemory(String pageId) {
        IPageCache cache = this.ipageCache.get(pageId);
        return cache;
    }

    public void putPageCacheInMemory(IPageCache pageCache) {
        this.ipageCache.put(pageCache.getPageId(), pageCache);
    }

    public void commitCache() {
        for (IPageCache cache : this.ipageCache.values()) {
            cache.saveChanges();
        }
    }

    public FormShowParameter getFormShowParameter(String pageId) {
        if (pageId == null) {
            return null;
        }
        IPageCache pageCache = this.getPageCache(pageId);
        FormShowParameter formShowParameter = null;
        String parameter = pageCache.get(FormShowParameter.class.getSimpleName());
        if (StringUtils.isNotBlank((CharSequence)parameter)) {
            formShowParameter = FormShowParameter.fromJsonString((String)parameter);
            formShowParameter.endInit();
        }
        return formShowParameter;
    }

    public IFormView getViewNoPlugin(String pageId) {
        IPageCache pageCache;
        String parameter;
        if (pageId == null) {
            return null;
        }
        IFormView view = this.viewCache.get("np." + pageId);
        if (view == null && StringUtils.isNotBlank((CharSequence)(parameter = (pageCache = this.getPageCache(pageId)).get(FormShowParameter.class.getSimpleName())))) {
            FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)parameter);
            formShowParameter.endInit();
            view = formShowParameter.createView();
            ((FormView)view).setIgnorePlugin(true);
            if (this.releasePageIds.contains(pageId)) {
                ((FormView)view).setReleasing(true);
            }
            view.addService(IPageCache.class, (Object)pageCache);
            this.initView(view, formShowParameter);
            this.viewCache.put("np." + pageId, view);
        }
        return view;
    }

    private void initView(IFormView view, FormShowParameter formShowParameter) {
        try {
            view.initialize(formShowParameter);
        }
        catch (KDException e) {
            String appId;
            if (e.getErrorCode().getCode().equals("bos.metaNotFound") && !AppGroup.isCurrentGrayNode((String)(appId = formShowParameter.getServiceAppId())) && AppGroupUtils.isGrayApp((long)RequestContext.get().getCurrUserId(), (String)appId)) {
                String msg = ResManager.loadKDString((String)"\u975e\u7070\u5ea6\u8868\u5355\u4e2d\u4e0d\u80fd\u901a\u8fc7getView\u8bbf\u95ee\u7070\u5ea6\u8868\u5355\uff08%s\uff09", (String)"SessionManager_0", (String)"bos-form-mvc", (Object[])new Object[]{formShowParameter.getFormId()});
                ErrorCode errorCode = new ErrorCode("bos.grayMetaNotFound", msg);
                throw new KDBizException(errorCode, new Object[]{msg, e});
            }
            throw e;
        }
    }

    public boolean existView(String pageId) {
        if (pageId == null) {
            return false;
        }
        if (this.viewCache.containsKey(pageId)) {
            return true;
        }
        return PageCache.existView(pageId);
    }

    public IFormView getMainView(String rootPageId) {
        String pageId = this.getMainPageId(rootPageId);
        return this.getView(pageId);
    }

    public String getMainPageId(String rootPageId) {
        String key = "mainviewpageid" + rootPageId;
        return this.get(key);
    }

    public void putMainPageId(String rootPageId, String pageId) {
        String key = "mainviewpageid" + rootPageId;
        this.put(key, pageId);
    }

    public void clearPageSession(String rootPageId, String pageId) {
        RootPageCache.removePageId(rootPageId, pageId);
        this.viewCache.remove(pageId);
        this.clearLocalPageCache(pageId);
    }

    public void clearLocalPageCache(String pageId) {
        this.ipageCache.remove(pageId);
    }

    public void addReleasePage(String pageId) {
        this.releasePageIds.add(pageId);
    }

    public List<String> getTimerElapsedListener(String rootPageId) {
        return ListenTimerElapsedCache.getTimerElapsedListener(rootPageId);
    }

    static {
        isImmediate = Boolean.parseBoolean(System.getProperty(batchsave_cfg));
        ConfigurationUtil.observeChange((String)batchsave_cfg, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                isImmediate = Boolean.parseBoolean(System.getProperty(batchsave_cfg));
            }
        });
    }
}

