/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.base;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IBaseModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.mvc.base.BaseController;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.base.BaseViewPluginProxy;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BaseView
extends BillView {
    @Override
    protected FormController createFormController() {
        return new BaseController((IFormView)this);
    }

    @Override
    protected FormDataModel createDataModel() {
        Object mainOrgId = this.getFormShowParameter().getCustomParam("mainOrgId");
        BaseModel model = new BaseModel(this.getEntityId(), this.getPageId(), this.services);
        if (mainOrgId != null) {
            model.putContextVariable(model.getDataEntityType().getMainOrg(), mainOrgId);
        }
        return model;
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new BaseViewPluginProxy();
    }

    @Override
    protected void onClose() {
        CloseCallBack closeCallBack = this.getFormShowParameter().getCloseCallBack();
        if (closeCallBack != null && "_Quick_Add_New_".equals(closeCallBack.getActionId())) {
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            IBaseModel model = (IBaseModel)this.getModel();
            if (model.getDataEntityType() instanceof BillEntityType) {
                Object pkid;
                BillEntityType baseEntityType = (BillEntityType)model.getDataEntityType();
                String statusKey = baseEntityType.getBillStatus();
                DynamicProperty baseProp = baseEntityType.getProperty(statusKey);
                if ((StringUtils.isBlank((CharSequence)statusKey) || baseProp == null || baseProp.isDbIgnore() || BillStatus.C.toString().equals(model.getValue(statusKey))) && StringUtils.isNotBlank((Object)(pkid = model.getDataEntity().getPkValue()))) {
                    ListSelectedRow row = new ListSelectedRow(pkid, Boolean.TRUE);
                    this.appendNumberAndName(model, baseEntityType, row);
                    listSelectedRows.add((Object)row);
                    this.returnDataToParent(listSelectedRows);
                }
            }
        }
        super.onClose();
    }

    private void appendNumberAndName(IBaseModel model, BillEntityType entityType, ListSelectedRow selectedRow) {
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType baseEntityType = (BasedataEntityType)entityType;
            String numberProperty = baseEntityType.getNumberProperty();
            selectedRow.setNumber(this.getPropertyVale(model, baseEntityType, numberProperty));
            String nameProperty = baseEntityType.getNameProperty();
            selectedRow.setName(this.getPropertyVale(model, baseEntityType, nameProperty));
        }
    }

    private String getPropertyVale(IBaseModel model, BasedataEntityType baseEntityType, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Object value = "";
        DynamicProperty baseProp = baseEntityType.getProperty(key);
        if (baseProp != null) {
            value = model.getValue(key);
            if (value instanceof ILocaleString) {
                value = value.toString();
            }
            if (value == null) {
                value = "";
            }
        }
        return value.toString();
    }
}

