/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.container.FormRoot;
import kd.bos.form.field.ExRateConfigUtil;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormController;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.beanutils.ConvertUtils;

public class BillController
extends FormController {
    private static final Log log = LogFactory.getLog(BillController.class);
    private static final String SPAN_TYPE_NAME = "formview";

    public BillController(IFormView view) {
        super(view);
    }

    @Override
    public void loadData() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"BillController.loadData");){
            BillShowParameter billShowParameter = (BillShowParameter)this.view.getFormShowParameter();
            BillModel model = (BillModel)((Object)this.view.getService(IDataModel.class));
            Object pkId = billShowParameter.getPkId();
            if (pkId == null) {
                billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            } else if (pkId != null && billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW && !this.isCopyBill(billShowParameter)) {
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            model.beginInit();
            if (billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
                this.initModelContextVariable(billShowParameter, model);
                if (pkId != null && billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
                    if (pkId.getClass() != model.getDataEntityType().getPrimaryKey().getPropertyType()) {
                        pkId = ConvertUtils.convert((Object)pkId, (Class)model.getDataEntityType().getPrimaryKey().getPropertyType());
                    }
                    try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billShowParameter.getRouteKey(), (String)billShowParameter.getArchiveKey());){
                        model.copy(pkId, this.isCopyRelateEntity(billShowParameter), this.isCopyEmptyRow(billShowParameter));
                    }
                    if (StringUtils.isNotBlank((CharSequence)billShowParameter.getBillTypeId())) {
                        long billTypeId = Long.parseLong(billShowParameter.getBillTypeId());
                        String billTypeKey = ((BillEntityType)model.getDataEntityType()).getBillType();
                        if (StringUtils.isNotBlank((CharSequence)billTypeKey)) {
                            model.setValue(billTypeKey, billTypeId);
                        }
                    }
                } else {
                    model.createNewData();
                }
            } else if (pkId == null) {
                model.createNewData();
            } else {
                if (pkId.getClass() != model.getDataEntityType().getPrimaryKey().getPropertyType()) {
                    pkId = ConvertUtils.convert((Object)pkId, (Class)model.getDataEntityType().getPrimaryKey().getPropertyType());
                }
                model.setPKValue(pkId);
                boolean loadSuccess = true;
                try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billShowParameter.getRouteKey(), (String)billShowParameter.getArchiveKey());){
                    model.load(pkId);
                }
                catch (RuntimeException kdexp) {
                    loadSuccess = false;
                    this.getView().showTipNotification(kdexp.getMessage());
                    log.error((Throwable)kdexp);
                    span.error((Throwable)kdexp);
                    model.createNewData();
                }
                if (loadSuccess) {
                    ((BillViewPluginProxy)this.getPluginProxy()).fireAfterLoadData(new EventObject(this.view));
                    if (MutexHelper.isOpenIntentLocks()) {
                        StringBuilder errorMsg = new StringBuilder();
                        this.requestIntentLock(pkId, errorMsg);
                    } else {
                        StringBuilder errMsg = new StringBuilder();
                        MainEntityType dataEntityType = model.getDataEntityType();
                        String billNo = null;
                        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
                            billNo = model.getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
                        }
                        HashMap<String, String> lockRequireInfo = new HashMap<String, String>(3);
                        boolean recordOrRequireMutex = this.recordOrRequireMutex(clientViewProxy, billShowParameter, billShowParameter.getCustomParams(), pkId, billNo, errMsg, true, lockRequireInfo);
                        if (!recordOrRequireMutex) {
                            if (!StringUtils.equals((CharSequence)"true", (CharSequence)this.getView().getPageCache().get("billController:lockedConfirm"))) {
                                Map<String, String> lockInfo = this.getLockInfo((String)lockRequireInfo.get("MUTEX_ENTITY_KEY"), (String)lockRequireInfo.get("MUTEX_OPER_KEY"), (String)lockRequireInfo.get("MUTEX_OBJ_ID"));
                                if (!CollectionUtils.isEmpty(lockInfo) && StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)lockInfo.get("userid")) && StringUtils.equals((CharSequence)"modify", (CharSequence)lockInfo.get("opkey"))) {
                                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bd5", (String)"BillController_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f3a\u5236\u8e22\u51fa", (String)"BillController_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("billController_lockedConfirm", "kd.bos.form.plugin.BillConfirmCallBackPlugin", MessageCallBackType.Class);
                                    this.getView().showConfirm(errMsg.toString(), null, MessageBoxOptions.YesNo, null, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(lockRequireInfo));
                                } else {
                                    this.getView().showTipNotification(errMsg.toString());
                                }
                                this.getView().getPageCache().put("billController:lockedConfirm", "true");
                            }
                            billShowParameter.setStatus(OperationStatus.VIEW);
                        }
                    }
                } else {
                    this.recordOrRequireMutex(clientViewProxy, billShowParameter, billShowParameter.getCustomParams(), pkId, null, null, false, Collections.emptyMap());
                }
            }
            if (!LayoutControlInfo.isBillTypeLayout() && ((BillView)this.getView()).loadPageLayout()) {
                return;
            }
            model.setCacheExpireAfter(true);
            model.endInit();
            clientViewProxy.addAction("setFormStatus", (Object)billShowParameter.getBillStatus().getValue());
            this.getView().cacheFormShowParameter();
            if (this.isCopyBill(billShowParameter)) {
                this.updateAttachment();
            }
            this.view.updateView();
            ExRateConfigUtil.sendExRateConfigAction((IFormView)this.getView());
            this.createCsrfToken();
            super.sendHotTips();
        }
    }

    protected void updateAttachment() {
        Map propCollections = this.getView().getModel().getDataEntityType().getAllFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            if (!(propMap.getValue() instanceof IAttachmentProp)) continue;
            String attachmentKey = ((IDataEntityProperty)propMap.getValue()).getName();
            this.updateAttachmentProp(attachmentKey);
        }
    }

    private void updateAttachmentProp(String attachmentKey) {
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        IDataEntityProperty property = mainType.findProperty(attachmentKey);
        if (property.getParent() instanceof MainEntityType) {
            DynamicObjectCollection attEntryRows = (DynamicObjectCollection)this.getView().getModel().getValue(attachmentKey);
            ArrayList<Long> attPKIds = new ArrayList<Long>();
            for (DynamicObject row : attEntryRows) {
                Long attPKId = row.getLong("fbasedataid_id");
                if (attPKId == null || Long.compare(0L, attPKId) == 0) continue;
                attPKIds.add(attPKId);
            }
            this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]));
            this.getView().updateView(attachmentKey);
        } else if (property.getParent() instanceof EntryType) {
            int entryRowCount = this.getView().getModel().getEntryRowCount(property.getParent().getName());
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection attEntryRows = (DynamicObjectCollection)this.getView().getModel().getValue(attachmentKey, i);
                ArrayList<Long> attPKIds = new ArrayList<Long>();
                for (DynamicObject row : attEntryRows) {
                    Long attPKId = row.getLong("fbasedataid_id");
                    if (attPKId == null || Long.compare(0L, attPKId) == 0) continue;
                    attPKIds.add(attPKId);
                }
                this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]), i);
                this.getView().updateView(attachmentKey, i);
            }
        }
    }

    private boolean recordOrRequireMutex(IClientViewProxy clientViewProxy, BillShowParameter billShowParameter, Map<String, Object> mutexInfo, Object pkId, String billNo, StringBuilder errMsg, boolean isRequire, Map<String, String> lockRequireInfo) {
        String mutexObjId;
        String mutexOperationKey;
        String mutexEntityKey;
        boolean isSuccess = true;
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        String mutexTransferComplete = pageCache.get("MUTEX_TRANSFER_COMPLETE");
        if (StringUtils.isBlank((CharSequence)mutexTransferComplete)) {
            pageCache.put("MUTEX_TRANSFER_COMPLETE", "true");
            mutexEntityKey = (String)mutexInfo.get("MUTEX_ENTITY_KEY");
            mutexOperationKey = (String)mutexInfo.get("MUTEX_OPER_KEY");
            mutexObjId = (String)mutexInfo.get("MUTEX_OBJ_ID");
        } else {
            mutexEntityKey = pageCache.get("MUTEX_ENTITY_KEY");
            mutexOperationKey = pageCache.get("MUTEX_OPER_KEY");
            mutexObjId = pageCache.get("MUTEX_OBJ_ID");
        }
        if (isRequire && (StringUtils.isBlank((CharSequence)mutexObjId) || StringUtils.isBlank((CharSequence)mutexOperationKey) || StringUtils.isBlank((CharSequence)mutexEntityKey)) && this.isRequireMutexStatus(clientViewProxy, billShowParameter) && StringUtils.isNotBlank((Object)pkId)) {
            try {
                boolean isStrict;
                lockRequireInfo.put("MUTEX_ENTITY_KEY", this.getView().getEntityId());
                lockRequireInfo.put("MUTEX_OPER_KEY", "modify");
                lockRequireInfo.put("MUTEX_OBJ_ID", String.valueOf(pkId));
                lockRequireInfo.put("billNo", billNo);
                boolean bl = isStrict = !billShowParameter.isEnableUserReentrant();
                if (StringUtils.isBlank((CharSequence)billNo)) {
                    billNo = String.valueOf(pkId);
                }
                MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), billNo, null, this.getView().getEntityId(), "modify", isStrict, "default");
                isSuccess = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
                if (isSuccess) {
                    mutexEntityKey = this.getView().getEntityId();
                    mutexObjId = pkId.toString();
                    mutexOperationKey = "modify";
                }
            }
            catch (Exception e) {
                isSuccess = false;
                log.error(errMsg.toString(), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mutexObjId) && StringUtils.isNotBlank((CharSequence)mutexOperationKey) && StringUtils.isNotBlank((CharSequence)mutexEntityKey)) {
            HashMap<String, String> mutexMap = new HashMap<String, String>();
            mutexMap.put("MUTEX_ENTITY_KEY", mutexEntityKey);
            mutexMap.put("MUTEX_OBJ_ID", mutexObjId);
            mutexMap.put("MUTEX_OPER_KEY", mutexOperationKey);
            pageCache.put(mutexMap);
            MutexHelper.register((IFormView)this.view, (String)mutexObjId, (String)mutexEntityKey, (String)mutexOperationKey);
        }
        return isSuccess;
    }

    private boolean isRequireMutexStatus(IClientViewProxy clientViewProxy, BillShowParameter billShowParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"BillController.isRequireMutexStatus", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("status", (Object)billShowParameter.getStatus());
            span.addLocaleTag("billstatus", (Object)billShowParameter.getBillStatus());
            if (billShowParameter.getStatus() == OperationStatus.VIEW) {
                boolean bl = false;
                return bl;
            }
            if (billShowParameter.getBillStatus() == BillOperationStatus.VIEW) {
                boolean bl = false;
                return bl;
            }
            if (billShowParameter.getBillStatus() != BillOperationStatus.EDIT && this.isAuditStatus()) {
                FormRoot rootControl = (FormRoot)this.getView().getRootControl();
                boolean allLock = MutexHelper.allFieldWithRequiredLock((IClientViewProxy)clientViewProxy, (List)rootControl.getItems(), (BillOperationStatus)BillOperationStatus.AUDIT, (MainEntityType)this.getView().getModel().getDataEntityType());
                span.addLocaleTag("isAuditStatus", (Object)true);
                span.addLocaleTag("allLock", (Object)allLock);
                boolean bl = !allLock;
                return bl;
            }
            if ((billShowParameter.getBillStatus() == BillOperationStatus.SUBMIT || billShowParameter.getBillStatus() == BillOperationStatus.EDIT) && this.isSubmitStatus()) {
                FormRoot rootControl = (FormRoot)this.getView().getRootControl();
                boolean allLock = MutexHelper.allFieldWithRequiredLock((IClientViewProxy)clientViewProxy, (List)rootControl.getItems(), (BillOperationStatus)BillOperationStatus.SUBMIT, (MainEntityType)this.getView().getModel().getDataEntityType());
                span.addLocaleTag("isSubmitStatus", (Object)true);
                span.addLocaleTag("allLock", (Object)allLock);
                boolean bl = !allLock;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean isAuditStatus() {
        return this.isRequiredStatus("C");
    }

    private boolean isSubmitStatus() {
        return this.isRequiredStatus("B");
    }

    private boolean isRequiredStatus(String requiredStatus) {
        BillEntityType mainType = (BillEntityType)this.getView().getModel().getDataEntityType();
        if (StringUtils.isBlank((CharSequence)mainType.getBillStatus())) {
            return false;
        }
        IDataEntityProperty statusProp = mainType.findProperty(mainType.getBillStatus());
        if (statusProp == null) {
            return false;
        }
        if (!(statusProp instanceof BillStatusProp)) {
            return false;
        }
        if (this.getView().getModel().getDataEntity() == null) {
            return false;
        }
        String statusValue = (String)this.getView().getModel().getValue(statusProp.getName());
        return StringUtils.equalsIgnoreCase((CharSequence)statusValue, (CharSequence)requiredStatus);
    }

    protected void initModelContextVariable(BillShowParameter billShowParameter, BillModel model) {
        GroupProp groupProp;
        Map parentInfo;
        String billTypeId;
        String filterSelectValues;
        super.initModelContextVariable((FormShowParameter)billShowParameter, (IDataModel)model);
        String selectOrgId = (String)billShowParameter.getCustomParam("SELECT_ORG_ID");
        if (selectOrgId != null) {
            model.putContextVariable("SELECT_ORG_ID", selectOrgId);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterSelectValues = (String)billShowParameter.getCustomParam("filterSelectedValues")))) {
            Map selectedValues = (Map)SerializationUtils.deSerializeFromBase64((String)filterSelectValues);
            for (Map.Entry entry : selectedValues.entrySet()) {
                model.putContextVariable(((String)entry.getKey()).replace('.', '_'), entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(billTypeId = billShowParameter.getBillTypeId()))) {
            model.putContextVariable("DEFAULT_BILLTYPE_ID", billTypeId);
        }
        if ((parentInfo = (Map)billShowParameter.getCustomParam("tree_parent_id")) != null && parentInfo.containsKey("key") && parentInfo.containsKey("value") && (groupProp = (GroupProp)model.getProperty((String)parentInfo.get("key"))) != null) {
            model.putContextVariable(groupProp.getName(), parentInfo.get("value"));
        }
    }

    private boolean isCopyBill(BillShowParameter billShowParameter) {
        if (!billShowParameter.getCustomParams().containsKey("iscopy")) {
            return false;
        }
        return billShowParameter.getCustomParams().containsKey("iscopy");
    }

    private boolean isCopyRelateEntity(BillShowParameter billShowParameter) {
        if (!billShowParameter.getCustomParams().containsKey("isCopyRelateEntity")) {
            return false;
        }
        return (Boolean)billShowParameter.getCustomParams().get("isCopyRelateEntity");
    }

    private boolean isCopyEmptyRow(BillShowParameter billShowParameter) {
        if (!billShowParameter.getCustomParams().containsKey("CopyEmptyRow")) {
            return false;
        }
        return (Boolean)billShowParameter.getCustomParams().get("CopyEmptyRow");
    }

    private boolean requestIntentLock(Object pkId, StringBuilder errMsg) {
        boolean isSuccess = true;
        String entityId = this.getView().getEntityId();
        if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((Object)pkId)) {
            String intentKey = MutexHelper.requireIntent((IFormView)this.getView(), (String)entityId, (Object)String.valueOf(pkId), (StringBuilder)errMsg);
            if (StringUtils.isBlank((CharSequence)intentKey)) {
                return false;
            }
        } else {
            errMsg.append("apply for intent lock fail");
            isSuccess = false;
        }
        return isSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getLockInfo(String entityKey, String operationKey, String objId) {
        if (!StringUtils.isNotBlank((CharSequence)entityKey)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)objId)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)operationKey)) return Collections.emptyMap();
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.getLockInfo(objId, groupId, entityKey);
            return map;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return Collections.emptyMap();
    }
}

