/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BillLayoutScheme;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDefValueProvider;

public class BillDefValueProvider
extends FormDefValueProvider {
    private static final Log log = LogFactory.getLog(BillDefValueProvider.class);
    private static final String FORMID_BOS_LAYOUTSCHEME = "bos_newpageconfig";
    private static final String KEY_FIELD_CONTROL_ENTRY = "fieldcontrolentry";
    private IFormView view;
    Long schemeId;
    Map<String, Object> defValueMap = null;

    public BillDefValueProvider(IFormView view, Long schemeId) {
        super(view);
        this.schemeId = schemeId;
        this.view = view;
    }

    public Object getDefValue(IFieldHandle fieldProp) {
        Object loayoutDefaultValue = this.getLayoutDefaultValue(fieldProp);
        return loayoutDefaultValue != null ? loayoutDefaultValue : super.getDefValue(fieldProp);
    }

    public FieldDefValue getDefValue2(IFieldHandle fieldProp) {
        return this.getLayoutDefaultValue(fieldProp) != null ? null : super.getDefValue2(fieldProp);
    }

    private Object getLayoutDefaultValue(IFieldHandle fieldProp) {
        String key = "";
        Object defaultValue = null;
        if (fieldProp instanceof IDataEntityProperty) {
            key = ((IDataEntityProperty)fieldProp).getName();
        }
        Map<String, Object> defValueMap = this.getDefValueMap();
        if (fieldProp instanceof BooleanProp) {
            Object defValue = defValueMap.get(key);
            if (StringUtils.isNotBlank((Object)defValue) && ("true".equalsIgnoreCase(defValue.toString()) || "false".equalsIgnoreCase(defValue.toString()))) {
                defaultValue = Boolean.parseBoolean(defValue.toString());
            }
        } else if (fieldProp instanceof DynamicProperty && StringUtils.isNotBlank((Object)defValueMap.get(key))) {
            defaultValue = defValueMap.get(key);
        }
        return defaultValue;
    }

    private Map<String, Object> getDefValueMap() {
        if (this.defValueMap == null) {
            this.getDefSchemeId();
            this.defValueMap = this.schemeId == null || Long.compare(0L, this.schemeId) == 0 ? new HashMap<String, Object>() : BillDefValueProvider.getLayoutDefValue(this.schemeId);
        }
        return this.defValueMap;
    }

    private static Map<String, Object> getLayoutDefValue(Long schemeId) {
        HashMap<String, Object> defValueMap = new HashMap<String, Object>();
        Object[] pkIds = new Long[]{schemeId};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_LAYOUTSCHEME);
        Map dataFromCache = BusinessDataReader.loadFromCache((Object[])pkIds, (DynamicObjectType)dt);
        DynamicObject billLayoutObj = (DynamicObject)dataFromCache.get(schemeId);
        if (billLayoutObj == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5e03\u5c40\u65b9\u6848\u65e0\u6cd5\u67e5\u51fa\u6570\u636e id:%s", (String)"BillDefValueProvider_0", (String)"bos-form-mvc", (Object[])new Object[0]), schemeId.toString());
            throw new KDException(new ErrorCode("BillDefValueProvider_01", errMsg), new Object[0]);
        }
        DynamicObjectCollection fldctlentry = billLayoutObj.getDynamicObjectCollection(KEY_FIELD_CONTROL_ENTRY);
        for (DynamicObject fldctlRow : fldctlentry) {
            String key;
            String string = key = StringUtils.isBlank((CharSequence)fldctlRow.getString("entityfieldkey")) ? fldctlRow.getString("fieldkey") : fldctlRow.getString("entityfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)fldctlRow.getString("defaultvalue"))) continue;
            defValueMap.put(key, fldctlRow.getString("defaultvalue"));
        }
        if (LayoutControlInfo.isOutLog()) {
            StackTraceElement[] stackTrace;
            log.info(String.format("BillDefValueProvider.getLayoutDefValue.ctlMap:%s", SerializationUtils.toJsonString(defValueMap)));
            StringBuilder sb = new StringBuilder();
            sb.append("layoutlog - ");
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = stackTraceElement.getClassName();
                String methodName = stackTraceElement.getMethodName();
                sb.append(className).append(",").append(methodName).append(System.lineSeparator());
            }
            log.info(sb.toString());
        }
        return defValueMap;
    }

    private void getDefSchemeId() {
        if (this.schemeId == null || Long.compare(0L, this.schemeId) == 0) {
            BillShowParameter billShowParameter;
            if (!(this.view.getModel() instanceof IBillModel)) {
                return;
            }
            BillShowParameter billShowParameter2 = billShowParameter = this.view.getFormShowParameter() instanceof BillShowParameter ? (BillShowParameter)this.view.getFormShowParameter() : null;
            if (billShowParameter == null) {
                return;
            }
            BillLayoutScheme layoutScheme = this.getLayoutScheme(billShowParameter, (IBillModel)this.view.getModel());
            BillLayoutSchemeAssignEntity blsa = layoutScheme.getLayoutScheme();
            if (blsa != null) {
                this.schemeId = blsa.getId();
            }
        }
    }

    private BillLayoutScheme getLayoutScheme(BillShowParameter billShowParameter, IBillModel model) {
        BillLayoutParameter blp = new BillLayoutParameter();
        Long newOrgValue = billShowParameter.getLayoutMainOrgId();
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        long billTypeId = 0L;
        String billType = billShowParameter.getBillTypeId();
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            try {
                billTypeId = Long.parseLong(billType);
            }
            catch (Exception e) {
                billTypeId = 0L;
            }
        }
        blp.setBillTypeId(billTypeId);
        return new BillLayoutScheme(model, billShowParameter, blp);
    }
}

