/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.TableModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.param.ParameterReader;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillModel
extends FormDataModel
implements IBillModel {
    private static final Log log = LogFactory.getLog(BillModel.class);
    private static final String SPAN_TYPE_NAME = "datamodel";
    private Boolean isTableCache;

    public BillModel(String entityNumber, String pageId, Map<Class<?>, Object> services) {
        super(entityNumber, pageId, services);
    }

    public BillModel(String entityNumber, String pageId, Map<Class<?>, Object> services, String appId, String permissionItem) {
        super(entityNumber, pageId, services, appId, permissionItem);
    }

    public boolean isFromWebApi() {
        return Boolean.TRUE.equals(this.getContextVariable("MODEL_INIT_BY_WEBAPI"));
    }

    private boolean isLoadHeadOnly() {
        return Boolean.TRUE.equals(this.getContextVariable("MODEL_INIT_LOADHEADONLY"));
    }

    private boolean isLoadSplitpage() {
        return Boolean.TRUE.equals(this.getContextVariable("MODEL_INIT_LOADSPLITPAGE"));
    }

    protected DynamicObject newDataEntity() {
        DynamicObject billObj = super.newDataEntity();
        return billObj;
    }

    @KSMethod
    public Object createNewData(Object newObject) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.createNewData");){
            Object obj = super.createNewData(newObject);
            BillEntityType bt = (BillEntityType)this.getDataEntityType();
            if (StringUtils.isNotBlank((CharSequence)bt.getEntityTypeId())) {
                ((DynamicObject)obj).set("EntityTypeId", (Object)this.getMainEntityType().getName());
            }
            Object object = obj;
            return object;
        }
    }

    public Object createNewData(Object newObject, Supplier<OperationResult> initializer) {
        this.clearTableModelCache();
        return super.createNewData(newObject, initializer);
    }

    public void push(Object newObject) {
        this.dataEntity = (DynamicObject)newObject;
        this.repository = null;
        this.clearTableModelCache();
    }

    @KSMethod
    public DynamicObject getMainOrgUnit() {
        BillEntityType billType = (BillEntityType)this.getDataEntityType();
        if (billType != null) {
            MainOrgProp mainOrgProperty = billType.getMainOrgProperty();
            if (mainOrgProperty == null) {
                return null;
            }
            return (DynamicObject)this.getValue(mainOrgProperty.getName());
        }
        return null;
    }

    @KSMethod
    public Long getMainOrgId() {
        DynamicObject orgObj = this.getMainOrgUnit();
        if (orgObj == null) {
            return null;
        }
        return Long.parseLong(String.valueOf(orgObj.getPkValue()));
    }

    @KSMethod
    public Object getPKValue() {
        DynamicObject ret = this.getDataEntity();
        return ret.getPkValue();
    }

    @KSMethod
    public void setPKValue(Object value) {
    }

    @KSMethod
    public void load(Object pkId, Supplier<OperationResult> initializer) {
        OperationResult result;
        block25: {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.load", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
                span.addTag("pkid", String.valueOf(pkId));
                LoadDataEventArgs e = new LoadDataEventArgs((Object)this, pkId);
                this.modelEventProxy.fireLoadData(e);
                this.dataEntity = e.getDataEntity();
                if (this.dataEntity != null) break block25;
                try (ThreadReadWriteContext ctx = DB.beginThreadWrite();){
                    boolean splitPage;
                    this.dataEntity = this.isLoadHeadOnly() ? BusinessDataReader.loadHead((Object)pkId, (DynamicObjectType)this.getDataEntityType()) : ((splitPage = Boolean.parseBoolean(System.getProperty("billmodel.splitpage", "false"))) || this.isLoadSplitpage() ? BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)this.getDataEntityType(), (int)0, (int)this.getEntryPageSize()) : BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)this.getDataEntityType()));
                }
            }
        }
        this.repository = null;
        this.initTableModelCache(this.dataEntity);
        if (initializer != null && !(result = initializer.get()).isSuccess()) {
            throw new KDBizException(StringUtils.isNotBlank((CharSequence)result.getMessage()) ? result.getMessage() : ResManager.loadKDString((String)"\u8c03\u7528\u521d\u59cb\u5316\u5931\u8d25\uff01", (String)"BillModel_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        }
    }

    @KSMethod
    public void load(Object pkId) {
        this.load(pkId, null);
    }

    public boolean useTableCache() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"useTableCache");){
            if (this.isTableCache == null) {
                this.isTableCache = TableModelCache.isTableCache((String)this.getPageId());
            }
            span.addLocaleTag("isTableCache", (Object)this.isTableCache);
            boolean bl = this.isTableCache;
            return bl;
        }
    }

    private void initTableModelCache(DynamicObject dataEntity) {
        boolean isSysPropOn = false;
        String paramKey = "bosentryserverfiltersort";
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)dataEntity.getDataEntityType().getName());
        if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)paramKey)) {
            isSysPropOn = billParamObj.getBoolean(paramKey);
        }
        if (!isSysPropOn) {
            this.clearTableModelCache();
            return;
        }
        boolean isSplitPage = false;
        if (dataEntity.getDataEntityState().getEntryInfos() != null) {
            for (Map.Entry item : dataEntity.getDataEntityState().getEntryInfos().entrySet()) {
                EntryInfo entryInfo = (EntryInfo)item.getValue();
                if (entryInfo.getRowCount() == null || entryInfo.getRowCount() <= entryInfo.getPageSize()) continue;
                isSplitPage = true;
                break;
            }
        }
        if (isSplitPage) {
            TableModelCache cache = new TableModelCache((IRefrencedataProvider)this, this.getDataEntityType(), this.getPageId());
            cache.initTable(dataEntity);
        } else {
            this.clearTableModelCache();
        }
    }

    private void clearTableModelCache() {
        if (this.useTableCache()) {
            this.isTableCache = null;
            TableModelCache cache = new TableModelCache((IRefrencedataProvider)this, this.getDataEntityType(), this.getPageId());
            cache.release();
        }
    }

    @KSMethod
    public void syncDataFromDB(Collection<String> fieldKeys) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.syncDataFromDB");){
            PKFieldProp pkFieldProp = (PKFieldProp)this.getDataEntityType().getPrimaryKey();
            Object pkValue = this.getPKValue();
            if (pkFieldProp.getValueComparator().compareValue(pkValue)) {
                return;
            }
            this.getDataEntity(true);
            MainEntityType subMainType = (MainEntityType)this.getDataEntityType().getSubEntityType(fieldKeys);
            DynamicObject objFromDB = BusinessDataServiceHelper.loadSingle((Object)this.getPKValue(), (DynamicObjectType)subMainType);
            for (IDataEntityProperty property : subMainType.getProperties()) {
                if (fieldKeys.contains(property.getName())) {
                    this.setValue(property.getName(), property.getValueFast((Object)objFromDB));
                    continue;
                }
                if (!(property instanceof EntryProp)) continue;
                DynamicObjectCollection entryRowsFromDB = (DynamicObjectCollection)property.getValueFast((Object)objFromDB);
                DynamicObjectCollection entryRowsFromMem = this.getEntityEntity(property.getName());
                this.syncEntryRowsFromDB((EntryType)((EntryProp)property).getItemType(), fieldKeys, entryRowsFromDB, entryRowsFromMem);
            }
        }
    }

    private void syncEntryRowsFromDB(EntryType subEntryType, Collection<String> fieldKeys, DynamicObjectCollection entryRowsFromDB, DynamicObjectCollection entryRowsFromMem) {
        HashMap<String, DynamicObject> dctRowsFromDB = new HashMap<String, DynamicObject>();
        for (DynamicObject entryRowFromDB : entryRowsFromDB) {
            String entryId = String.valueOf(entryRowFromDB.getPkValue());
            dctRowsFromDB.put(entryId, entryRowFromDB);
        }
        ArrayList<Integer> delRows = new ArrayList<Integer>();
        int rowIndex = 0;
        for (DynamicObject entryRowFromMem : entryRowsFromMem) {
            String entryId = String.valueOf(entryRowFromMem.getPkValue());
            DynamicObject entryRowFromDB = (DynamicObject)dctRowsFromDB.get(entryId);
            if (entryRowFromDB == null) {
                delRows.add(rowIndex);
            } else {
                for (IDataEntityProperty property : subEntryType.getProperties()) {
                    String refIdProp;
                    if (!fieldKeys.contains(property.getName()) || !(property instanceof BasedataProp) || (refIdProp = ((BasedataProp)property).getRefIdPropName()) == null || fieldKeys.contains(refIdProp)) continue;
                    fieldKeys.add(refIdProp);
                }
                for (IDataEntityProperty property : subEntryType.getProperties()) {
                    if (fieldKeys.contains(property.getName())) {
                        property.setValue((Object)entryRowFromMem, property.getValueFast((Object)entryRowFromDB));
                        continue;
                    }
                    if (!(property instanceof EntryProp)) continue;
                    DynamicObjectCollection subEntryRowsFromDB = (DynamicObjectCollection)property.getValueFast((Object)entryRowFromDB);
                    DynamicObjectCollection subEntryRowsFromMem = entryRowFromMem.getDynamicObjectCollection(property.getName());
                    this.syncEntryRowsFromDB((EntryType)((EntryProp)property).getItemType(), fieldKeys, subEntryRowsFromDB, subEntryRowsFromMem);
                }
            }
            ++rowIndex;
        }
        if (!delRows.isEmpty()) {
            Collections.reverse(delRows);
            Iterator iterator = delRows.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                entryRowsFromMem.remove(i);
            }
        }
    }

    public void copy(Object pkId, boolean isCopyLinkEntry) {
        this.copy(pkId, isCopyLinkEntry, false);
    }

    public void copy(Object pkId, boolean isCopyLinkEntry, boolean isCopyEmptyRow) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"bill.copy");){
            this.dataEntity = this.newDataEntity();
            this.repository = null;
            MainEntityType dt = this.getDataEntityType();
            DynamicObject dataEntityCopy = new DynamicObject((DynamicObjectType)dt);
            try {
                dataEntityCopy = BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)dt);
            }
            catch (RuntimeException exp) {
                log.error((Throwable)exp);
                span.addLocaleTag("entityNumber", (Object)this.getDataEntityType().getName());
                span.addLocaleTag("pkId", pkId);
                span.addLocaleTag("isCopyLinkEntry", (Object)isCopyLinkEntry);
                span.addLocaleTag("isCopyEmptyRow", (Object)isCopyEmptyRow);
                span.throwException((Throwable)exp);
                throw new KDBizException(exp.getMessage());
            }
            this.copyEntityData((EntityType)dt, dataEntityCopy, this.dataEntity, 0, isCopyLinkEntry, isCopyEmptyRow);
            ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
            dataEntitySet.Parse(new DynamicObject[]{this.dataEntity}, dt);
            for (EntityType entityType : dt.getAllEntities().values()) {
                ExtendedDataEntity[] rows;
                for (ExtendedDataEntity row : rows = dataEntitySet.FindByEntityKey(entityType.getName())) {
                    row.getDataEntity().getDataEntityState().setPushChanged(true);
                }
            }
            this.modelEventProxy.fireAfterCopyeData(new EventObject((Object)this));
        }
    }
}

