/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.bill;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.mvc.bill.BillTypeApHelper;
import kd.bos.mvc.form.FormDefValueProvider;

public class BillTypeDefValueProvider
extends FormDefValueProvider {
    private IFormView view;
    private Long billtypePk;
    Map<String, Object> defValueMap = null;

    public BillTypeDefValueProvider(IFormView view, Long billtypePk) {
        super(view);
        this.view = view;
        this.billtypePk = billtypePk;
    }

    public Long getBilltypePk() {
        if (this.billtypePk == null && this.view != null) {
            this.billtypePk = BillTypeApHelper.getDefaultBillTypeId(this.view.getEntityId());
            if (this.billtypePk == null) {
                this.billtypePk = 0L;
            }
        }
        return this.billtypePk;
    }

    public void setBilltypePk(Long billtypePk) {
        this.billtypePk = billtypePk;
    }

    private Map<String, Object> getDefValueMap() {
        if (this.defValueMap == null) {
            Long billTypeId = this.getBilltypePk();
            this.defValueMap = billTypeId == null || Long.compare(0L, billTypeId) == 0 ? new HashMap<String, Object>() : BillTypeApHelper.getBillTypeDefValue(billTypeId, this.view instanceof IMobileView);
        }
        return this.defValueMap;
    }

    public Object getDefValue(IFieldHandle fieldProp) {
        Object billTypeDefaultValue = this.getBillTypeDefaultValue(fieldProp);
        return billTypeDefaultValue != null ? billTypeDefaultValue : super.getDefValue(fieldProp);
    }

    public FieldDefValue getDefValue2(IFieldHandle fieldProp) {
        return this.getBillTypeDefaultValue(fieldProp) != null ? null : super.getDefValue2(fieldProp);
    }

    private Object getBillTypeDefaultValue(IFieldHandle fieldProp) {
        String key = "";
        Object defaultValue = null;
        if (fieldProp instanceof IDataEntityProperty) {
            key = ((IDataEntityProperty)fieldProp).getName();
        }
        Map<String, Object> defValueMap = this.getDefValueMap();
        if (fieldProp instanceof BooleanProp) {
            Object defValue = defValueMap.get(key);
            if (StringUtils.isNotBlank((Object)defValue) && ("true".equalsIgnoreCase(defValue.toString()) || "false".equalsIgnoreCase(defValue.toString()))) {
                defaultValue = Boolean.parseBoolean(defValue.toString());
            }
        } else if (fieldProp instanceof DynamicProperty && StringUtils.isNotBlank((Object)defValueMap.get(key))) {
            defaultValue = defValueMap.get(key);
        }
        return defaultValue;
    }
}

