/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.schedule.executor.ExecutorService;

public class ExportProgressImpl
implements ExportProgress {
    private static final Log log = LogFactory.getLog(ExportProgressImpl.class);
    private String taskId;
    private int progress;
    private String desc;
    private Map<String, Object> custData = new HashMap<String, Object>();

    public ExportProgressImpl(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public void feedbackProgress(int total, int complete) {
        this.progress = 0;
        if (total != 0) {
            this.progress = complete * 100 / total;
        }
        if (this.progress >= 100) {
            this.progress = 99;
        } else if (this.progress < 0) {
            this.progress = 0;
        }
        this.custData.put("total", String.valueOf(total));
        this.custData.put("complete", String.valueOf(complete));
        this.desc = String.format(ResManager.loadKDString((String)"\u5df2\u5904\u7406 %1$s/%2$s \u5f20\u5355\u636e", (String)"ExportProgressImpl_0", (String)"bos-form-mvc", (Object[])new Object[0]), complete, total);
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    @Override
    public void feedbackCustData(Map<String, Object> data) {
        if (data != null) {
            this.custData.putAll(data);
        }
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    @Override
    public void fail(String failMessage) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("fail", true);
        data.put("failmessage", failMessage);
        this.feedbackCustData(data);
    }

    @Override
    public void feedbackFileUrl(String url) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("downloadurl", url);
        this.feedbackCustData(data);
    }

    @Override
    public void feedbackLogId(Object logId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logid", logId);
        this.feedbackCustData(data);
    }

    @Override
    public void complete() {
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, this.custData);
    }
}

