/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.IntentMutexResult;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.MutexInfo;
import kd.bos.form.operate.MutexResult;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.IntentLockInfo;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.RootPageCache;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.service.ServiceFactory;

public class FormMutexService
implements IFormMutexService {
    private static final Log log = LogFactory.getLog(FormMutexService.class);
    private static final String ENTITY_KEY = "MUTEX_ENTITY_KEY";
    private static final String OPERATION_KEY = "MUTEX_OPER_KEY";
    private static final String OBJ_PKID = "MUTEX_OBJ_ID";
    private static final String HENTITY_ID = "HMUTEX_ENTITY_ID";
    private static final String HOBJ_PKID = "HMUTEX_OBJ_ID";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";
    private static final String PROJECTNAME = "bos-form-mvc";
    private static final String INTENT_KEY = "INTENTKEY_";
    private static String mobLockTimeOutMinute = System.getProperty("mutex.locktimeout.mob", "30");
    private static DistributeSessionlessCache cache = null;
    private IFormView view;

    public FormMutexService(IFormView view) {
        this.view = view;
    }

    public MutexResult require(String entityNum, Object pkId, String opKey, boolean isStrict) {
        boolean opResult;
        MutexLockInfo requestInfo = new MutexLockInfo(String.valueOf(pkId), null, null, entityNum, opKey, isStrict, "default");
        MutexInfo lockInfo = FormMutexService.creatMutexInfo(requestInfo);
        String mutexGroupId = this.getMutexGroupId(entityNum, opKey);
        MutexResult result = new MutexResult();
        if (StringUtils.isNotBlank((CharSequence)mutexGroupId)) {
            requestInfo.setGroupId(mutexGroupId);
            lockInfo.setGroupId(mutexGroupId);
            opResult = this.requireMutex(this.view, requestInfo, lockInfo);
        } else {
            opResult = true;
        }
        result.setSuccess(opResult);
        result.setLockInfo(lockInfo);
        if (!opResult) {
            result.setErrMsg(ResManager.loadKDString((String)"\u7533\u8bf7\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770bMutexResult.lockInfo\u5bf9\u8c61", (String)"FormMutexService_6", (String)PROJECTNAME, (Object[])new Object[0]));
        }
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"FormMutexService.require", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("entityNum", (Object)entityNum);
                span.addLocaleTag("pkId", pkId);
                span.addLocaleTag("opKey", (Object)opKey);
                span.addLocaleTag("isStrict", (Object)isStrict);
                span.addLocaleTag("opResult", (Object)opResult);
                span.addLocaleTag("result", (Object)result);
            }
        }
        return result;
    }

    public MutexResult releaseMutex() {
        Objects.requireNonNull(this.view, ResManager.loadKDString((String)"\u91ca\u653e\u7f51\u7edc\u63a7\u5236\u7684\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormMutexService_2", (String)PROJECTNAME, (Object[])new Object[0]));
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        String entityKey = pageCache.get(ENTITY_KEY);
        String operKey = pageCache.get(OPERATION_KEY);
        String objId = pageCache.get(OBJ_PKID);
        boolean releaseRet = true;
        if (StringUtils.isNotBlank((CharSequence)entityKey) && StringUtils.isNotBlank((CharSequence)operKey) && StringUtils.isNotBlank((CharSequence)objId)) {
            try (DataMutex dataMutex = DataMutex.create();){
                releaseRet = dataMutex.release(objId, entityKey, operKey);
                if (releaseRet) {
                    AutoReleaseLock.create().unRegister(objId, entityKey, operKey);
                    String group = this.getMutexGroupId(entityKey, operKey);
                    if (StringUtils.isNotBlank((CharSequence)group)) {
                        FormMutexService.getCache().remove(FormMutexService.getPageRelationKey(entityKey, group, objId));
                    }
                    pageCache.put(ENTITY_KEY, null);
                    pageCache.put(OPERATION_KEY, null);
                    pageCache.put(OBJ_PKID, null);
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61[ %1$s ]\u4e92\u65a5\u9501\u51fa\u9519,%2$s", (String)"FormMutexService_4", (String)PROJECTNAME, (Object[])new Object[0]), objId, e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        MutexResult mutexResult = new MutexResult();
        mutexResult.setSuccess(releaseRet);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"FormMutexService.releaseMutex", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("entityKey", (Object)entityKey);
                span.addLocaleTag("operKey", (Object)operKey);
                span.addLocaleTag("objId", (Object)objId);
                span.addLocaleTag("releaseRet", (Object)releaseRet);
            }
        }
        return mutexResult;
    }

    public String getMutexGroupId(String entityNum, String opKey) {
        return MutexHelper.getMutexGroupId((String)entityNum, (String)opKey);
    }

    public IntentMutexResult requireIntent(String entityNum, Object pkId) {
        IntentMutexResult result = new IntentMutexResult();
        FormMutexService.requireIntent(this.view, entityNum, pkId, result);
        result.setSuccess(StringUtils.isNotBlank((CharSequence)result.getIntentKey()));
        return result;
    }

    private static void requireIntent(IFormView view, String entityNum, Object pkId, IntentMutexResult mutexInfo) {
        try (DataMutex dataMutex = DataMutex.create();){
            String timestamp = String.valueOf(System.currentTimeMillis());
            String intentKey = UUID.randomUUID().toString();
            IntentLockInfo lockInfo = dataMutex.requireIntent(String.valueOf(pkId), entityNum, timestamp, intentKey);
            if (lockInfo != null) {
                IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
                pageCache.put(HENTITY_ID, entityNum);
                pageCache.put(HOBJ_PKID, String.valueOf(pkId));
                pageCache.put(INTENT_KEY + pkId, intentKey);
            } else {
                intentKey = null;
            }
            mutexInfo.setIntentKey(intentKey);
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u610f\u5411\u9501\u51fa\u9519;error:%s", (String)"FormMutexService_5", (String)PROJECTNAME, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }

    public IntentMutexResult releaseIntent(String intentKey) {
        IntentMutexResult result = new IntentMutexResult();
        FormMutexService.releaseIntent(this.view, intentKey, result);
        return result;
    }

    private static void releaseIntent(IFormView view, String intentKey, IntentMutexResult mutexInfo) {
        boolean release = false;
        try (DataMutex dataMutex = DataMutex.create();){
            if (view instanceof IListView) {
                ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
                for (ListSelectedRow selectedRow : selectedRows) {
                    String entityId = ((IListView)view).getBillFormId();
                    Object pkId = selectedRow.getPrimaryKeyValue();
                    release = dataMutex.releaseIntent(entityId, String.valueOf(pkId));
                }
            }
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            String entityId = pageCache.get(HENTITY_ID);
            String pkId = pageCache.get(HOBJ_PKID);
            if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((CharSequence)pkId)) {
                release = StringUtils.isNotBlank((CharSequence)intentKey) ? dataMutex.releaseIntent(entityId, pkId, intentKey) : dataMutex.releaseIntent(entityId, pkId);
            }
        }
        catch (IOException e) {
            log.error("\u91ca\u653e\u610f\u5411\u9501\u51fa\u9519,error: %s", (Object)e.getMessage());
        }
        mutexInfo.setSuccess(release);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutexResult destoryLockingPage(String entityNum, Object pkId, String opKey, boolean ignoreActiveState, List<String> ignorePageIds) {
        Throwable throwable;
        MutexResult result = new MutexResult();
        result.setSuccess(true);
        MutexInfo mutexInfo = new MutexInfo();
        try {
            throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                String group = this.getMutexGroupId(entityNum, opKey);
                Map info = dataMutex.getLockInfo(String.valueOf(pkId), group, entityNum);
                if (info == null || info.isEmpty()) {
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
                String lockSessionId = (String)info.get("GLOBALSESSION");
                String lockUserId = (String)info.get("userid");
                String lockOpkeySetString = (String)info.get("opkey");
                mutexInfo.setSessionId(lockSessionId);
                mutexInfo.setUserId(this.parseUserIdStr(lockUserId));
                mutexInfo.setGroupId((String)info.get("groupId"));
                mutexInfo.setEntityNumber((String)info.get("entityKey"));
                mutexInfo.setClient((String)info.get("client"));
                mutexInfo.setDataObjId((String)info.get("dataObjId"));
                if (!StringUtils.equals((CharSequence)String.valueOf(RequestContext.get().getCurrUserId()), (CharSequence)lockUserId)) {
                    result.setSuccess(false);
                    result.setErrMsg(ResManager.loadKDString((String)"\u65e0\u6cd5\u6e05\u7406\u5176\u5b83\u7528\u6237\u7533\u8bf7\u7684\u9501\u3002", (String)"FormMutexService_0", (String)PROJECTNAME, (Object[])new Object[0]));
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
                List socketIds = WebSocketIdReader.getWebSocketIds((String)RequestContext.get().getAccountId(), (String)lockSessionId);
                if (!ignoreActiveState && !socketIds.isEmpty()) {
                    result.setSuccess(false);
                    result.setErrMsg(ResManager.loadKDString((String)"\u9501\u5b9a\u9875\u9762\u7684\u4f1a\u8bdd\u5904\u4e8e\u5728\u7ebf\u72b6\u6001\uff0c\u65e0\u6cd5\u9500\u6bc1\u9875\u9762\u3002", (String)"FormMutexService_1", (String)PROJECTNAME, (Object[])new Object[0]));
                    MutexResult mutexResult = result;
                    return mutexResult;
                }
                if (StringUtils.isNotBlank((CharSequence)lockOpkeySetString)) {
                    String[] opKeyArr;
                    for (String op : opKeyArr = StringUtils.split((String)lockOpkeySetString, (String)",")) {
                        dataMutex.release(String.valueOf(pkId), entityNum, op);
                    }
                }
                FormService formService = (FormService)ServiceFactory.getService(FormService.class);
                String pageId = (String)FormMutexService.getCache().get(FormMutexService.getPageRelationKey(entityNum, group, pkId.toString()), opKey);
                log.info("ignorePageIds:{}", (Object)ignorePageIds.toString());
                if (pageId != null && pageId.length() > 0 && !ignorePageIds.contains(pageId)) {
                    log.info("releaseRootPage, rootPageId: {}", (Object)pageId);
                    List<String> childrenList = this.getChildrenPages(pageId);
                    for (String child : childrenList) {
                        if (ignorePageIds.contains(child)) continue;
                        formService.releaseRootPage(child, false);
                    }
                    formService.releaseRootPage(pageId, false);
                } else if (!RequestContext.get().getGlobalSessionId().equals(lockSessionId)) {
                    log.info("sessionEnd: {}, userId: {}", (Object)lockSessionId, (Object)RequestContext.get().getCurrUserId());
                    formService.sessionEnd(lockSessionId);
                }
                dataMutex.release(String.valueOf(pkId), entityNum, opKey);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            FormMutexService.throwMutexCreateException(e);
        }
        if (!EntityTracer.isRealtime()) return result;
        throwable = null;
        try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"FormMutexService.destoryLockingPage", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("entityNum", (Object)entityNum);
            span.addLocaleTag("pkId", pkId);
            span.addLocaleTag("opKey", (Object)opKey);
            span.addLocaleTag("ignoreActiveState", (Object)ignoreActiveState);
            span.addLocaleTag("result", (Object)result);
            return result;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public MutexResult destoryLockingPage(String entityNum, Object pkId, String opKey, boolean ignoreActiveState) {
        return this.destoryLockingPage(entityNum, pkId, opKey, ignoreActiveState, Collections.emptyList());
    }

    private List<String> getChildrenPages(String parentPageId) {
        FormShowParameter showParameter = SessionManager.getCurrent().getFormShowParameter(parentPageId);
        if (showParameter == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(10);
        String rootPageId = showParameter.getRootPageId();
        Map<String, String> childPageIds = RootPageCache.getPageIdsWithPid(rootPageId);
        HashMap<String, List<String>> tileMapping = new HashMap<String, List<String>>(childPageIds.size() + 1);
        tileMapping.put(rootPageId, new ArrayList(10));
        tileMapping.put(parentPageId, new ArrayList(10));
        for (Map.Entry<String, String> keys : childPageIds.entrySet()) {
            String pageId = keys.getKey();
            String currentParentPageId = keys.getValue();
            List childList = tileMapping.getOrDefault(currentParentPageId, new ArrayList(3));
            childList.add(pageId);
            tileMapping.put(currentParentPageId, childList);
        }
        List pageIds = (List)tileMapping.get(parentPageId);
        if (pageIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.findAllChild(tileMapping, parentPageId, result);
        return result;
    }

    private void findAllChild(Map<String, List<String>> tileMapping, String currentPageId, List<String> result) {
        List<String> pageIds = tileMapping.get(currentPageId);
        if (pageIds == null || pageIds.isEmpty()) {
            return;
        }
        result.addAll(pageIds);
        for (String pageId : pageIds) {
            this.findAllChild(tileMapping, pageId, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requireMutex(IFormView view, MutexLockInfo requestInfo, MutexInfo info) {
        RequestContext rc = RequestContext.get();
        boolean isSuccess = true;
        String entityNumber = requestInfo.getEntityNumber();
        String opKey = requestInfo.getOperationKey();
        this.release(view);
        try (DataMutex dataMutex = DataMutex.create();){
            String objId = requestInfo.getDataObjId();
            isSuccess = dataMutex.require(requestInfo);
            if (!isSuccess && FormMutexService.enableReentrantMob(RequestContext.get(), dataMutex.getLockInfo())) {
                requestInfo.setStrict(false);
                isSuccess = dataMutex.require(requestInfo);
            }
            if (isSuccess) {
                info.setUserId(rc.getCurrUserId());
                info.setClient(rc.getClient());
                info.setSessionId(rc.getGlobalSessionId());
                if (view instanceof IListView) return isSuccess;
                FormMutexService.register(view, objId, entityNumber, opKey, requestInfo.getGroupId());
                IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
                pageCache.put(ENTITY_KEY, entityNumber);
                pageCache.put(OPERATION_KEY, opKey);
                pageCache.put(OBJ_PKID, objId);
                return isSuccess;
            }
            Map lockedInfo = dataMutex.getLockInfo();
            if (lockedInfo == null || lockedInfo.isEmpty()) {
                boolean bl = isSuccess;
                return bl;
            }
            info.setClient((String)lockedInfo.get("client"));
            info.setSessionId((String)lockedInfo.get("GLOBALSESSION"));
            String userId = (String)lockedInfo.get("userid");
            info.setUserId(this.parseUserIdStr(userId));
            return isSuccess;
        }
        catch (IOException e) {
            FormMutexService.throwMutexCreateException(e);
        }
        return isSuccess;
    }

    private long parseUserIdStr(String userId) {
        try {
            return Long.parseLong(userId);
        }
        catch (NumberFormatException e) {
            log.error(String.format("FormMutex_error, locked userId is %s", userId));
            return -1L;
        }
    }

    private static void throwMutexCreateException(Exception e) {
        ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"FormMutexService_3", (String)PROJECTNAME, (Object[])new Object[0]), e.getMessage()));
        throw new KDException((Throwable)e, ec, new Object[0]);
    }

    private static boolean enableReentrantMob(RequestContext rc, Map<String, String> dataLockInfo) {
        if (dataLockInfo == null) {
            return false;
        }
        long userId = rc.getCurrUserId();
        long current = System.currentTimeMillis();
        long lockedTime = Long.parseLong(dataLockInfo.get("lockedTime"));
        if (!StringUtils.equals((CharSequence)String.valueOf(userId), (CharSequence)dataLockInfo.get("userid"))) {
            return false;
        }
        return "mobile".equalsIgnoreCase(dataLockInfo.get("client")) && current - lockedTime > Long.parseLong(mobLockTimeOutMinute) * 60L * 1000L;
    }

    private boolean release(IFormView view) {
        Objects.requireNonNull(view, ResManager.loadKDString((String)"\u91ca\u653e\u7f51\u7edc\u63a7\u5236\u7684\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormMutexService_2", (String)PROJECTNAME, (Object[])new Object[0]));
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String entityKey = pageCache.get(ENTITY_KEY);
        String operKey = pageCache.get(OPERATION_KEY);
        String objId = pageCache.get(OBJ_PKID);
        boolean releaseRet = true;
        if (StringUtils.isNotBlank((CharSequence)entityKey) && StringUtils.isNotBlank((CharSequence)operKey) && StringUtils.isNotBlank((CharSequence)objId)) {
            try (DataMutex dataMutex = DataMutex.create();){
                releaseRet = dataMutex.release(objId, entityKey, operKey);
                if (releaseRet) {
                    AutoReleaseLock.create().unRegister(objId, entityKey, operKey);
                    String group = this.getMutexGroupId(entityKey, operKey);
                    if (StringUtils.isNotBlank((CharSequence)group)) {
                        FormMutexService.getCache().remove(FormMutexService.getPageRelationKey(entityKey, group, objId));
                    }
                    pageCache.put(ENTITY_KEY, null);
                    pageCache.put(OPERATION_KEY, null);
                    pageCache.put(OBJ_PKID, null);
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61[ %1$s ]\u4e92\u65a5\u9501\u51fa\u9519,%2$s", (String)"FormMutexService_4", (String)PROJECTNAME, (Object[])new Object[0]), objId, e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        return releaseRet;
    }

    private static MutexInfo creatMutexInfo(MutexLockInfo requestLockInfo) {
        MutexInfo info = new MutexInfo();
        info.setDataObjId(requestLockInfo.getDataObjId());
        info.setGroupId(requestLockInfo.getGroupId());
        info.setEntityNumber(requestLockInfo.getEntityNumber());
        info.setOperationKey(requestLockInfo.getOperationKey());
        return info;
    }

    private static void register(IFormView view, String entityNumber, String dataObjId, String groupId, String opKey) {
        AutoReleaseLock.create().register(entityNumber, dataObjId, groupId);
        if (StringUtils.isNotBlank((CharSequence)opKey)) {
            FormMutexService.getCache().put(FormMutexService.getPageRelationKey(dataObjId, opKey, entityNumber), groupId, view.getPageId(), FormMutexService.getPageRelationTimeOut().intValue());
        }
    }

    private static Integer getPageRelationTimeOut() {
        return Integer.parseInt(System.getProperty("mutex.pagerelation.timeout_s", "14400"));
    }

    private static DistributeSessionlessCache getCache() {
        if (cache != null) {
            return cache;
        }
        cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mutexHelper_pageRelation", new DistributeCacheHAPolicy(true, true));
        return cache;
    }

    private static String getPageRelationKey(String entityKey, String group, String objId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + "_mutex_lastlockpage_" + entityKey + "_" + group + "_" + objId;
    }
}

