/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.MobLocation;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.ClientMethod;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.RefreshResultType;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.TimeZoneLocationEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.MobFormViewPluginProxy;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.MobLocationProvider;
import kd.bos.mvc.form.MobileFormController;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MobileFormView
extends FormView
implements IMobileView {
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private static final String SPAN_TYPE_NAME = "formview";
    private static Log log = LogFactory.getLog(MobileFormView.class);

    @Override
    public void initialize(FormShowParameter formShowParameter) {
        super.initialize(formShowParameter);
    }

    @Override
    protected FormController createFormController() {
        return new MobileFormController((IFormView)this);
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new MobFormViewPluginProxy();
    }

    public void upload(List<Object> arg0) {
        MobFormViewPluginProxy pluginProxy = (MobFormViewPluginProxy)this.getPluginProxy();
        pluginProxy.fireMobileUpload(new UploadEvent((Object)this, arg0));
    }

    public long getCurrentCityId() {
        return MobLocationProvider.getCurrentCityId();
    }

    public void showOperationResult(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size();
        if (size > 0) {
            if (size == 1) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(0);
                if (errorInfo instanceof OperateErrorInfo) {
                    if (((OperateErrorInfo)errorInfo).getLevel() == ErrorLevel.Warning || ((OperateErrorInfo)errorInfo).getLevel() == ErrorLevel.Error) {
                        this.showTipNotification(errorInfo.getMessage(), this.getDuration());
                    } else {
                        this.showErrorNotification(errorInfo.getMessage());
                    }
                    return;
                }
                this.showTipNotification(errorInfo.getMessage());
                return;
            }
            StringBuilder val = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(i);
                val.append(i + 1).append(ResManager.loadKDString((String)"\u3001", (String)"MobileBillView_1", (String)BOS_FORM_MVC, (Object[])new Object[0])).append(errorInfo.getMessage()).append(System.lineSeparator());
                if (!(errorInfo instanceof ValidationErrorInfo) || !ValidataErrorCode.AttTimeout.getCode().equals(((ValidationErrorInfo)errorInfo).getErrorCode())) continue;
                this.showConfirm(errorInfo.getMessage(), MessageBoxOptions.OK);
                return;
            }
            String title = ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"MobileBillView_0", (String)BOS_FORM_MVC, (Object[])new Object[0]);
            this.showConfirm(title, val.toString(), MessageBoxOptions.None);
        } else if (operationResult.getSuccessPkIds().size() == 1) {
            this.showSuccessNotification(operationResult.getMessage());
        } else {
            this.showErrorNotification(operationResult.getMessage());
        }
    }

    @Override
    protected void initiPluginProxy() {
        super.initiPluginProxy();
        this.addPlugin((IFormPlugin)new YzjContextMenuClickPlugin());
        log.info("\u6ce8\u518c\u4e91\u4e4b\u5bb6\u5206\u4eab\u63d2\u4ef6\u5b8c\u6bd5-MobileFormView.initiPluginProxy()");
    }

    @KSMethod
    public void setMenuItemVisible(boolean value, String ... itemKeys) {
        HashMap<String, Object> visableMap = new HashMap<String, Object>();
        visableMap.put("visible", value);
        visableMap.put("keys", itemKeys);
        ((IClientViewProxy)this.getService(IClientViewProxy.class)).addAction("setMenuItemVisible", visableMap);
    }

    @KSMethod
    public void locate() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        clientViewProxy.addAction("getLocation", (Object)new Object[0]);
    }

    @KSMethod
    public void timeZoneLocate() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        clientViewProxy.addAction("getTimeZone", new HashMap());
    }

    public MobLocation getLocation() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"MobileFormView.getLocation");){
            MobLocation mobLocation = MobLocationProvider.getMobLocation();
            return mobLocation;
        }
    }

    public void setLocation(Map<String, String> location) {
        MobLocationProvider.setLocation(location);
        if (this.getPluginProxy() instanceof MobFormViewPluginProxy) {
            LocateEvent locateEvent = new LocateEvent((Object)this, MobLocationProvider.getMobLocation());
            ((MobFormViewPluginProxy)this.getPluginProxy()).fireLocate(locateEvent);
        }
    }

    public void setTimeZone(Map<String, String> map) {
        String timeZoneNum = "";
        if (map != null && map.containsKey("timezone")) {
            timeZoneNum = map.get("timezone");
        }
        if (this.getPluginProxy() instanceof MobFormViewPluginProxy) {
            TimeZoneLocationEvent e = new TimeZoneLocationEvent((Object)this, timeZoneNum);
            ((MobFormViewPluginProxy)this.getPluginProxy()).fireTimeZoneLocate(e);
        }
    }

    @KSMethod
    public void callClientAppMethod(ClientMethod clientMethod, Object parameter) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getService(IClientViewProxy.class);
        String method = clientMethod.getValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", method);
        if (parameter != null) {
            map.put("parameter", parameter);
        }
        clientViewProxy.addAction("callAppMethod", map);
    }

    public void refreshData() {
        if (this.getPluginProxy() instanceof MobFormViewPluginProxy) {
            ((MobFormViewPluginProxy)this.getPluginProxy()).fireRefreshData();
        }
    }

    public void setRefreshResult(String result, Integer duration, RefreshResultType type) {
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        Integer tempDuration = duration;
        if (duration == null) {
            tempDuration = 3000;
        }
        param.put("content", result);
        param.put("type", type.getValue());
        param.put("duration", tempDuration);
        this.getClientProxy().addAction("setRefreshResult", param);
    }

    @SdkInternal
    public void afterMobilePageClose() {
        if (this.getPluginProxy() instanceof MobFormViewPluginProxy) {
            ((MobFormViewPluginProxy)this.getPluginProxy()).fireAfterMobilePageClose(new EventObject((Object)this));
        }
    }
}

