/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

class TileTabUtil {
    private static final String SUB_MAIN_TAB = "_submaintab_";
    private static final String MAIN_VIEW_TAB = "tabap";
    private IFormView mainView;
    private String pageId;
    private static final String TAB_ITEMS_TABPAGEKEYS = "_Tab_Items_TabPageKeys";

    public TileTabUtil() {
    }

    public TileTabUtil(IFormView mainView, String pageId) {
        this.mainView = mainView;
        this.pageId = pageId;
    }

    protected IFormView getMainView() {
        return this.mainView;
    }

    protected String getPageId() {
        return this.pageId;
    }

    protected boolean isTileTab(FormShowParameter param) {
        Control tabap;
        IFormView mainview;
        boolean isTileTab = false;
        if (this.enableTileMenu() && (param.getOpenStyle().getShowType() == ShowType.NewTabPage || param.getOpenStyle().getShowType() == ShowType.MainNewTabPage) && SUB_MAIN_TAB.equals(param.getOpenStyle().getTargetKey()) && (mainview = this.getMainView()) != null && !mainview.getPageId().equals(this.getPageId()) && (tabap = mainview.getControl(MAIN_VIEW_TAB)) != null) {
            isTileTab = true;
        }
        return isTileTab;
    }

    protected boolean enableTileMenu() {
        IFormView mainview = this.getMainView();
        if (mainview == null || !"home_page".equals(mainview.getFormShowParameter().getFormId())) {
            return Boolean.FALSE;
        }
        String key = "tile_menu_mode_enable";
        CustomParam customParam = new CustomParam();
        customParam.setGroupNumber("kd_svc_customerparam");
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        customParam.setSearchKeySet(keys);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        return parameterMap != null && Boolean.TRUE.toString().equals(parameterMap.get(key));
    }

    protected boolean isOverMaxTileTabs() {
        Control tabap;
        IFormView mainview = this.getMainView();
        if (mainview != null && (tabap = mainview.getControl(MAIN_VIEW_TAB)) instanceof Tab) {
            List items;
            int noFilterSize;
            int totalSize;
            if (tabap.getView() == null) {
                return false;
            }
            IPageCache cache = (IPageCache)tabap.getView().getService(IPageCache.class);
            String casheString = cache.get(TAB_ITEMS_TABPAGEKEYS);
            if (StringUtils.isEmpty((CharSequence)casheString)) {
                return false;
            }
            Set tabPageKeys = (Set)SerializationUtils.fromJsonString((String)casheString, HashSet.class);
            List noFilterItems = ((Tab)tabap).getNoFilterItems();
            int tabPagetKeySize = 0;
            if (tabPageKeys != null && noFilterItems != null) {
                HashSet<String> noFilterKeys = new HashSet<String>(16);
                for (Control item : noFilterItems) {
                    noFilterKeys.add(item.getKey());
                }
                for (String tabPageKey : tabPageKeys) {
                    if (noFilterKeys.contains(tabPageKey)) continue;
                    ++tabPagetKeySize;
                }
            }
            if ((totalSize = (noFilterSize = noFilterItems == null ? 0 : noFilterItems.size()) + tabPagetKeySize) > this.getMaxTileTabs() && (items = ((Tab)tabap).getItems()) != null && items.size() >= this.getMaxTileTabs()) {
                return true;
            }
        }
        return false;
    }

    protected int getMaxTileTabs() {
        return 100;
    }
}

