/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.IRegisterFlexPropertyListener;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.RegisterFlexPropertyArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.FlexField;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.qing.QingQueryContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.QingCachedListFormParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.QingView;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.list.AbstractListView;
import kd.sdk.annotation.SdkInternal;

public class ListController
extends FormController {
    private static final String SPAN_TYPE_NAME = "list";
    private static final String VALUE = ".value";

    public ListController(IFormView view) {
        super(view);
    }

    public void viewChanged(String viewName) {
    }

    @Override
    public void loadData() {
        if (!this.getView().getFormShowParameter().isHasRight()) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            HashMap<String, Object> ret = new HashMap<String, Object>(16);
            FormConfigFactory.checkShowFormRightByUserID(this.getView().getFormShowParameter(), ret, userId);
            Object cancelMessageObject = ret.get("cancelMessage");
            if (cancelMessageObject != null) {
                throw new KDBizException(cancelMessageObject.toString());
            }
        }
        super.loadData();
    }

    @Override
    protected void sendHotTips() {
    }

    @Override
    public void formClosedCallBack(CloseCallBackWraper closeCallBackWraper) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.formClosedCallBack");){
            ((AbstractListView)this.getView()).initialContext();
            if (closeCallBackWraper.isBillView()) {
                AbstractListViewPluginProxy proxy = (AbstractListViewPluginProxy)this.view.getService(FormViewPluginProxy.class);
                CloseCallBack closeCallBack = closeCallBackWraper.getCloseCallBack();
                Object pkId = closeCallBackWraper.getPkId();
                BillClosedCallBackEvent e = new BillClosedCallBackEvent((Object)this, closeCallBack, pkId);
                proxy.fireBillClosedCallBack(e);
            }
            CloseCallBack closeCallBack = closeCallBackWraper.getCloseCallBack();
            ((AbstractListView)this.getView()).initFilterGridView();
            ((AbstractListView)this.getView()).initListModel();
            if (this.getView().getClass().getName().equals(closeCallBack.getClassName())) {
                ICloseCallBack iCloseCallBack = (ICloseCallBack)this.getView();
                iCloseCallBack.closedCallBack(new ClosedCallBackEvent((Object)this, closeCallBack.getActionId(), closeCallBackWraper.getReturnData()));
            } else {
                super.formClosedCallBack(closeCallBackWraper);
            }
        }
    }

    public QingMeta getQingColumns() {
        QingView qingView = this.getQingView();
        ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>();
        for (Control control : qingView.getItems()) {
            if (!(control instanceof IListColumn)) continue;
            listColumns.add((IListColumn)control);
        }
        AbstractListView abstractListView = (AbstractListView)this.getView();
        MainEntityType entityType = (MainEntityType)abstractListView.getListModel().getDataEntityType();
        List entryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)entityType);
        listColumns = ViewCommonUtil.getEntityFields((EntityType)entityType, listColumns, (String)abstractListView.getEntryEntity(), (List)entryEntityDtos);
        entryEntityDtos = ViewCommonUtil.getValidEntryListByListColumn((EntityType)entityType, listColumns);
        return this.createQingMeta(entryEntityDtos, listColumns, entityType);
    }

    private Field createField(IListColumn column, IDataEntityProperty fieldProp, MainEntityType entityType) {
        Object field = fieldProp instanceof FlexProp ? new FlexField() : new Field();
        if (fieldProp instanceof ISimpleProperty) {
            ISimpleProperty simpleProperty = (ISimpleProperty)fieldProp;
            switch (simpleProperty.getDbType()) {
                case 91: 
                case 93: {
                    field.setFieldType(QingFieldType.DateTime.toNumber());
                    break;
                }
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    field.setFieldType(QingFieldType.Number.toNumber());
                    break;
                }
                default: {
                    field.setFieldType(QingFieldType.String.toNumber());
                    break;
                }
            }
        } else {
            field.setFieldType(QingFieldType.String.toNumber());
        }
        field.setKey(column.getListFieldKey());
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)column.getListFieldKey());
        if (filterField != null) {
            if (fieldProp instanceof FlexProp) {
                field.setKey(filterField.getFullFieldName() + VALUE);
                field.setOrmKey(filterField.getFullFieldName() + VALUE);
            } else {
                field.setOrmKey(filterField.getFullFieldName());
            }
            if (filterField.getSrcFieldProp() instanceof MulBasedataProp) {
                field.addCustomInfo("MulBaseData", (Object)Boolean.TRUE);
                field.setFieldType(QingFieldType.String.toNumber());
            }
        }
        field.setName(column.getCaption());
        field.setEntity(column.getEntityName());
        HashMap<String, LocaleString> enumItems = null;
        if (fieldProp instanceof ComboProp) {
            enumItems = new HashMap<String, LocaleString>(16);
            for (ValueMapItem valueMapItem : ((ComboProp)fieldProp).getComboItems()) {
                enumItems.put(valueMapItem.getValue(), valueMapItem.getName());
            }
        } else if (fieldProp instanceof FlexProp) {
            FlexProp flexProp = (FlexProp)fieldProp;
            flexProp.extendFlexProperties(entityType.getName() + "_" + flexProp.getName(), new IRegisterFlexPropertyListener((Field)field){
                final /* synthetic */ Field val$field;
                {
                    this.val$field = field;
                }

                public void registerProperty(RegisterFlexPropertyArgs registerFlexPropertyArgs) {
                    LocaleString displayName;
                    int qingFieldType = 0;
                    if (registerFlexPropertyArgs.getBaseProp() != null) {
                        displayName = registerFlexPropertyArgs.getBaseProp().getDisplayName();
                    } else {
                        displayName = registerFlexPropertyArgs.getDimensionProp().getDisplayName();
                        qingFieldType = QingFieldType.String.toNumber();
                    }
                    Field flexTypeField = new Field();
                    flexTypeField.setKey(registerFlexPropertyArgs.getDataEntityProperty().getAlias());
                    flexTypeField.setName(displayName);
                    flexTypeField.setFieldType(qingFieldType);
                    ((FlexField)this.val$field).addField(flexTypeField);
                }
            });
        }
        field.setEnumItems(enumItems);
        if (filterField != null && filterField.getSrcFieldProp() instanceof MulBasedataProp) {
            field.setEnumItems(null);
        }
        return field;
    }

    private QingMeta createQingMeta(List<EntryEntityDto> entryEntityDtos, List<IListColumn> listColumns, MainEntityType entityType) {
        QingMeta qingMeta = new QingMeta();
        int defaultFieldType = QingFieldType.String.toNumber();
        if (entryEntityDtos != null) {
            for (EntryEntityDto dto : entryEntityDtos) {
                EntryEntity entryEntity = new EntryEntity();
                entryEntity.setKey(dto.getKey());
                entryEntity.setName(dto.getName());
                entryEntity.setParentKey(dto.getParentKey());
                String pkFieldName = dto.getPkFieldName();
                String parentKey = dto.getParentKey();
                if (pkFieldName != null) {
                    if (parentKey == null || parentKey.isEmpty()) {
                        pkFieldName = pkFieldName.substring(pkFieldName.indexOf(46) + 1);
                    }
                    entryEntity.setPkFieldName(pkFieldName);
                    Field field = new Field();
                    field.setEntity(dto.getKey());
                    field.setOrmKey(pkFieldName);
                    field.setFieldType(defaultFieldType);
                    field.setHide(true);
                    field.setKey(pkFieldName);
                    field.setName(new LocaleString(String.format(ResManager.loadKDString((String)"%s.\u4e3b\u952e", (String)"ListController_0", (String)"bos-form-mvc", (Object[])new Object[0]), dto.getName())));
                    qingMeta.addColumn(field);
                }
                qingMeta.addEntryEntity(entryEntity);
            }
        }
        if (listColumns != null) {
            for (IListColumn column : listColumns) {
                FilterField filterField = FilterField.create((MainEntityType)entityType, (String)column.getListFieldKey());
                if (filterField == null) continue;
                qingMeta.addColumn(this.createField(column, filterField.getFieldProp(), entityType));
            }
        }
        return qingMeta;
    }

    private QingView getQingView() {
        String entityId = ((ListShowParameter)this.view.getFormShowParameter()).getBillFormId();
        QingView qingView = (QingView)FormMetadataCache.getListQingView((String)entityId);
        AbstractListView abstractListView = (AbstractListView)this.getView();
        abstractListView.setMetadata();
        return qingView;
    }

    public DynamicObjectCollection getData(int startRow, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.getData");){
            QueryResult queryResult = this.queryData(startRow, limit);
            DynamicObjectCollection dynamicObjectCollection = queryResult.getCollection();
            return dynamicObjectCollection;
        }
    }

    protected QueryResult queryData(int startRow, int limit) {
        AbstractListView abstractListView = (AbstractListView)this.getView();
        return abstractListView.queryData(startRow, limit);
    }

    protected QueryResult queryData(ListSelectedRowCollection listSelectedRowCollection) {
        AbstractListView abstractListView = (AbstractListView)this.getView();
        return abstractListView.queryDataBySelectedRows(listSelectedRowCollection);
    }

    public String getQingQueryFilterParameter() {
        AbstractListView thisView = (AbstractListView)this.getView();
        QingCachedListFormParameter qingListShowParameter = (QingCachedListFormParameter)thisView.getFormShowParameter().createQingCachedFormParameter();
        qingListShowParameter.setQingCachedFilterHolder(thisView.getQingCachedFilterHolder());
        return qingListShowParameter.serialize();
    }

    public void restoreQingQueryFilterParameter(QingCachedListFormParameter qingCachedListFormParameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.restoreQingQueryFilterParameter");){
            AbstractListView abstractListView = (AbstractListView)this.getView();
            abstractListView.setQingCachedFilterHolder(qingCachedListFormParameter.getQingCachedFilterHolder());
        }
    }

    private List<ListField> getQingListFields() {
        AbstractListView thisView = (AbstractListView)this.getView();
        QingView qingView = thisView.getQingView();
        if (qingView == null) {
            return new ArrayList<ListField>();
        }
        List listColumns = new ArrayList<IListColumn>();
        for (Control control : qingView.getItems()) {
            if (!(control instanceof IListColumn)) continue;
            listColumns.add((IListColumn)control);
        }
        MainEntityType entityType = (MainEntityType)thisView.getListModel().getDataEntityType();
        List entryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)entityType);
        listColumns = ViewCommonUtil.getEntityFields((EntityType)entityType, listColumns, (String)thisView.getEntryEntity(), (List)entryEntityDtos);
        qingView.getItems().clear();
        for (IListColumn control : listColumns) {
            qingView.getItems().add((Control)control);
        }
        return qingView.getListFields();
    }

    public QingData getQingData(Integer startRow, Integer limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.getQingData");){
            AbstractListView thisView = (AbstractListView)this.getView();
            IListModel listModel = thisView.getListModel();
            listModel.setFilterParameter(thisView.getBillListFilterParameter());
            listModel.setListFields(this.getQingListFields());
            String cacheId = this.getView().getPageId();
            String controlKey = "billlistap_forQing";
            if (startRow == 1) {
                PageRowCacheUtils.clearPageRowcache((String)cacheId, (String)controlKey);
            }
            listModel.setPageId(cacheId);
            PageRowCacheUtils.setPageId((String)cacheId);
            PageRowCacheUtils.setControlKey((String)controlKey);
            Map data = listModel.getQingData(startRow - 1, limit.intValue());
            QingData qingData = this.createQingData(data);
            return qingData;
        }
    }

    public QingQueryContext getQingQueryContext() {
        AbstractListView thisView = (AbstractListView)this.getView();
        IListModel listModel = thisView.getListModel();
        List<ListField> qingListFields = this.getQingListFields();
        MainEntityType mainEntityType = (MainEntityType)listModel.getDataEntityType();
        List validListFields = new ArrayList();
        if (!qingListFields.isEmpty()) {
            validListFields = EntityTypeUtil.getAllListField((EntityType)mainEntityType, qingListFields, (boolean)false);
        }
        List mergeQFilters = thisView.getBillListFilterParameter().getQFilters();
        ArrayList<String> selectFields = new ArrayList<String>();
        for (ListField qListField : validListFields) {
            if (!qListField.isVisible()) continue;
            if (qListField.getSrcFieldProp() instanceof PKFieldProp) {
                selectFields.add(qListField.getFieldName());
                continue;
            }
            if (qListField.getSrcFieldProp() instanceof FlexProp) {
                selectFields.add(qListField.getFieldName() + VALUE);
                continue;
            }
            FilterField filterField = FilterField.create((MainEntityType)mainEntityType, (String)qListField.getListFieldKey());
            if (filterField == null || filterField.getSrcFieldProp() instanceof BasedataProp && filterField.getFieldProp() instanceof BasedataProp || filterField.isFieldPropAliasEmpty()) continue;
            selectFields.add(filterField.getFullFieldName());
        }
        return new QingQueryContext(selectFields, mergeQFilters, mainEntityType.getName());
    }

    public FilterParameter getListViewFilterParameter() {
        AbstractListView thisView = (AbstractListView)this.getView();
        return thisView.getListViewFilterParameter();
    }

    public int queryBillDataCount() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.queryBillDataCount");){
            AbstractListView thisView = (AbstractListView)this.getView();
            int n = thisView.queryBillDataCount();
            return n;
        }
    }

    private int queryListRealCount() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.queryListRealCount");){
            AbstractListView listView = (AbstractListView)this.getView();
            int n = listView.queryListRealCount();
            return n;
        }
    }

    public List<SummaryResult> querySummaryResults(String ... summaryFields) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.querySummaryResults");){
            AbstractListView thisView = (AbstractListView)this.getView();
            List<SummaryResult> list = thisView.querySummaryResults(summaryFields);
            return list;
        }
    }

    private QingData createQingData(Map<String, Object> listData) {
        QingData qingData = new QingData();
        qingData.setDataindex((Map)listData.get("dataindex"));
        List rows = (List)listData.get("rows");
        if (rows != null && !rows.isEmpty()) {
            Object row0 = rows.get(0);
            ArrayList<Object[]> qingRows = new ArrayList<Object[]>(rows.size());
            if (row0 instanceof Object[]) {
                for (Object row : rows) {
                    qingRows.add((Object[])row);
                }
            } else if (row0 instanceof List) {
                for (Object row : rows) {
                    qingRows.add(((List)row).toArray());
                }
            } else {
                throw new KDException(BosErrorCode.dataSource, new Object[]{"unexpected dataType of rows: " + row0.getClass()});
            }
            qingData.setRows(qingRows);
        } else {
            qingData.setRows(new ArrayList(0));
        }
        return qingData;
    }

    public String isFilterChanged() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        return pageCache.get("isFilterChanged");
    }

    @Override
    public void registerListener() {
        AbstractListView abstractListView = (AbstractListView)this.getView();
        if (!this.bRegListner) {
            this.getPluginProxy().fireRegisterListener(new EventObject(this.getView()));
            abstractListView.registerListener();
            this.bRegListner = true;
        }
    }

    @Override
    public void postData(List<Map<String, Object>> postDatas) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListController.postData");){
            Map<String, Object> controlStates;
            Iterator<Map.Entry<String, Object>> iterator;
            if (postDatas == null) {
                return;
            }
            if (!postDatas.isEmpty() && (iterator = (controlStates = postDatas.get(0)).entrySet().iterator()).hasNext()) {
                String mainControlKey = iterator.next().getKey();
                Control mainControl = this.getView().getControl(mainControlKey);
                if (mainControl instanceof BillList && iterator.hasNext()) {
                    String controlKey = iterator.next().getKey();
                    Control control = this.getView().getControl(controlKey);
                    BillList billList = (BillList)mainControl;
                    if (control == null) {
                        AbstractListView abstractListView = (AbstractListView)this.getView();
                        abstractListView.setMetadata();
                    }
                    this.getView().createControlIndex(billList.getItems());
                }
            }
            super.postData(postDatas);
        }
    }

    public void saveDiaglogSize(Map<String, Object> setting) {
        HashMap<String, Object> settingMap;
        String settingStr = this.getView().getModel().getCurrUserSetting(this.getF7SettingKey());
        if (StringUtils.isNotBlank((CharSequence)settingStr)) {
            settingMap = (HashMap<String, Object>)SerializationUtils.fromJsonString((String)settingStr, Map.class);
            settingMap.putAll(setting);
        } else {
            settingMap = new HashMap<String, Object>(setting);
        }
        this.getView().getModel().setCurrUserSetting(RequestContext.get().getCurrUserId(), this.getF7SettingKey(), SerializationUtils.toJsonString(settingMap));
    }

    private String getF7SettingKey() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String settingKey = formId + "F7Setting";
        return settingKey;
    }

    @SdkInternal
    public void showListColumnSetting(String schemeId) {
        AbstractListView abstractListView = (AbstractListView)this.getView();
        abstractListView.showListColumnSetting(schemeId);
    }

    @SdkInternal
    public void showListSort(String schemeId) {
        AbstractListView abstractListView = (AbstractListView)this.getView();
        abstractListView.showListSort(schemeId);
    }
}

