/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

final class ListDataProviderMask {
    private static final Log logger = LogFactory.getLog(ListDataProviderMask.class);
    static final int MASK_GET_DATA = 1;
    static final int MASK_GET_REAL_COUNT = 2;
    static final int MASK_GET_MAX_COUNT = 4;
    static final int MASK_GET_SUMMARY_RESULTS = 8;
    static final int MASK_OVERRIDE = 15;

    static int mask(Class<? extends IListDataProvider> handlerType) {
        int mask = 0;
        try {
            if (IListDataProvider.class.isAssignableFrom(handlerType)) {
                mask |= 0xF;
                if (ListDataProviderMask.isNative(handlerType, "getData", Integer.TYPE, Integer.TYPE)) {
                    mask &= 0xFFFFFFFE;
                }
                if (ListDataProviderMask.isNative(handlerType, "getRealCount", new Class[0])) {
                    mask &= 0xFFFFFFFD;
                }
                if (ListDataProviderMask.isNative(handlerType, "getMaxCount", new Class[0])) {
                    mask &= 0xFFFFFFFB;
                }
                if (ListDataProviderMask.isNative(handlerType, "getSummaryResults", new Class[0])) {
                    mask &= 0xFFFFFFF7;
                }
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("IListDataProviderMask.mask0", e.getMessage()), new Object[0]);
        }
        return mask;
    }

    private static boolean isNative(final Class<?> handlerType, final String methodName, final Class<?> ... paramTypes) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                Method m;
                try {
                    m = handlerType.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Class {} missing method {}, assume we can not skip execution", new Object[]{handlerType, methodName, e});
                    }
                    return false;
                }
                return m.isAnnotationPresent(Native.class);
            }
        });
    }

    private ListDataProviderMask() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Native {
    }
}

