/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.QFilterDto;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CompareTypeField;
import kd.bos.filter.CompareTypeModel;
import kd.bos.filter.CompareTypeModelCollection;
import kd.bos.filter.CompareTypeQuery;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.filter.PinnedConditionCollection;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.QingCachedFilterContainerFilterValues;
import kd.bos.form.QingCachedFilterHolder;
import kd.bos.form.QingCachedFilterValues;
import kd.bos.form.control.Control;
import kd.bos.form.control.CustomView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AddCustomViewEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetListener;
import kd.bos.form.events.SumDataLoadOnFirstSetEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.ApproverListColumn;
import kd.bos.list.BillList;
import kd.bos.list.ColumnMetaFactory;
import kd.bos.list.F7SelectedList;
import kd.bos.list.FieldSort;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListColumnCompareServiceHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MulBdPermUtil;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.events.IndexModeSetEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.MultiFieldsSortEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.list.query.QueryFactory;
import kd.bos.list.service.ListFormShowParameterIn;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListUserConfig;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.mvc.list.VoucherNoUtil;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ListView
extends AbstractListView {
    private static final String SPAN_TYPE_NAME = "list";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String ISCONTAINLOWER = "iscontainlower";
    private static final String QUERY_FILTER_PARAMETER_TYPE = "queryFilterParameterType";
    private static final String FILTERCONTAINERID = "filtercontainerap";
    private boolean isContainFastSearchValuesOnUpdateView = false;
    ITreeListView treeListView;
    private ListColumnCompareTypesSetListener listColumnCompareTypesSetListener;
    private Map<String, List<CompareType>> fieldCompareTypeMap;

    @Override
    public QingCachedFilterHolder getQingCachedFilterHolder() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            return new QingCachedFilterHolder((QingCachedFilterValues)new QingCachedFilterContainerFilterValues(FILTERCONTAINERID, filterContainer.getCachedFilterValues()));
        }
        return super.getQingCachedFilterHolder();
    }

    @Override
    public void setBillFormId(String billFormId) {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        filterContainer.setBillFormId(billFormId);
        super.setBillFormId(billFormId);
    }

    @Override
    public ITreeListView getTreeListView() {
        if (this.treeListView == null) {
            this.initTreeListView();
        }
        return this.treeListView;
    }

    @Override
    protected FormViewPluginProxy createPluginProxy() {
        return new ListViewPluginProxy();
    }

    private void addListColumnCompareTypesSetListener(BillList list) {
        if (this.listColumnCompareTypesSetListener == null) {
            this.listColumnCompareTypesSetListener = listColumnCompareTypesSetEvent -> {
                ListViewPluginProxy formViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                formViewPluginProxy.fireListColumnCompareTypesSet(listColumnCompareTypesSetEvent);
            };
            list.addListColumnCompareTypesSetListener(this.listColumnCompareTypesSetListener);
        }
    }

    @Override
    protected void addBillListListener(BillList billList) {
        this.addListColumnCompareTypesSetListener(billList);
        super.addBillListListener(billList);
    }

    @Override
    @KSMethod
    public OperationResult invokeOperation(String operationKey) {
        OperateOption operateOption = OperateOption.create();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            operateOption.setVariableValue("filterSelectedValues", SerializationUtils.serializeToBase64((Object)filterContainer.getSelectedValues()));
        }
        operateOption.setVariableValue("isListViewOp4Mutex", "true");
        operateOption.setVariableValue("bos_support_bigdata_aysn", String.valueOf(true));
        operateOption.setVariableValue("SpecialDataPerm_CurrentAppId", this.getFormShowParameter().getAppId());
        return super.invokeOperation(operationKey, operateOption);
    }

    @Override
    public void refresh() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.refresh", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            FilterContainer filterContainer;
            if (this.isNeedRefreshTree()) {
                this.refreshTreeView();
            }
            if ((filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID)) != null) {
                filterContainer.refresh();
            }
            super.refresh();
            this.refreshQingView();
            this.refreshCustomView();
        }
    }

    protected HashMap<Object, Object> getNumberById(List<Object> ids) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object id : ids) {
            map.put(id, "");
        }
        for (ListSelectedRow row : selectedRows) {
            Object key = row.getPrimaryKeyValue();
            if (!map.containsKey(key)) continue;
            map.put(key, this.getNumber(row));
        }
        return map;
    }

    private String getNumber(ListSelectedRow row) {
        String number = "";
        EntityType et = this.getListModel().getDataEntityType();
        number = et instanceof BasedataEntityType ? row.getNumber() : (et instanceof BillEntityType ? row.getBillNo() : row.getPrimaryKeyValue().toString());
        return number;
    }

    @Override
    public void focusRootNode() {
        if (this.getTreeListView() != null) {
            this.getTreeListView().focusRootNode();
            this.getListCache().setTreeRootListFilterParameter(new FilterParameter(this.getTreeListView().getTreeModel().getListFilter(), null));
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (!this.context.getFastQueryFilterParameter().getQFilters().isEmpty()) {
                qFilters.addAll(this.context.getFastQueryFilterParameter().getQFilters());
            } else if (this.getTreeListView().getTreeModel().getListFilter() != null) {
                qFilters.add(this.getTreeListView().getTreeModel().getListFilter());
            }
            FilterParameter filterParameter = new FilterParameter(qFilters, null);
            filterParameter.setSelectFields(this.getSelectFields());
            billList.setQueryFilterParameter(filterParameter);
        }
    }

    @Override
    protected FilterParameter getQueryFilterParameter() {
        QFilter filter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!this.context.getFastQueryFilterParameter().getQFilters().isEmpty()) {
            qFilters.addAll(this.context.getFastQueryFilterParameter().getQFilters());
        } else if (this.getTreeListView() != null && this.getTreeListView().getTreeModel() != null && (filter = this.getTreeListView().getTreeModel().getListFilter()) != null) {
            qFilters.add(filter);
        }
        FilterParameter filterParameter = new FilterParameter(qFilters, null);
        filterParameter.setSelectFields(this.getSelectFields());
        return filterParameter;
    }

    private void addFilterContainerInitListener(FilterContainer filterContainer, boolean isLoad) {
        filterContainer.addFilterContainerInitListener(filterContainerInitEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            FilterContainerInitArgs filterContainerInitArgs = new FilterContainerInitArgs(filterContainerInitEvent);
            listViewPluginProxy.fireFilterContainerInit(filterContainerInitArgs);
            if (isLoad || !this.context.getFilterControlContext().isTriggerSearch()) {
                this.initBillListByMetadata();
            }
        });
    }

    private void addFilterContainerSetFilter(FilterContainer filterContainer) {
        filterContainer.addSetFilterListeners(setFilterEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            listViewPluginProxy.fireFilterColumnSetFilter(setFilterEvent);
        });
    }

    private List<QFilter> getTreeListFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter filter = this.getTreeListView().getTreeModel().getListFilter();
        if (filter != null) {
            qFilters.add(filter);
        }
        return qFilters;
    }

    private void clearFastFilter() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            filterContainer.clearFast();
            this.getPageCache().remove("fast:filter");
        }
    }

    private void buildGroupChildFilter(TreeNode root, String currentId, List<QFilter> filters) {
        ITreeModel treeListModel = this.getTreeListView().getTreeModel();
        GroupProp groupProp = treeListModel.getGroupProp();
        TreeNode currentNode = root.getTreeNode(currentId);
        if (currentNode == null) {
            return;
        }
        String longNumber = currentNode.getLongNumber();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            String groupName = groupProp.getName();
            IQuery query = QueryFactory.createQuery();
            List idArrays = query.getChildsId(groupProp, longNumber);
            ListIterator<QFilter> listIterator = filters.listIterator();
            while (listIterator.hasNext()) {
                QFilter filter = listIterator.next();
                if (filter == null || !filter.getProperty().equals(groupName)) continue;
                listIterator.remove();
                int dbType = groupProp.getDbType();
                List ids = idArrays.stream().map(obj -> DbTypeConverter.safeConvert((int)dbType, (Object)obj)).collect(Collectors.toList());
                filter.or(new QFilter(groupName, "in", (Object)ids.toArray()));
                listIterator.add(filter);
            }
        }
    }

    private void buildTreeChildFilter(TreeNode root, String currentId, List<QFilter> filters) {
        boolean containNow = true;
        FieldEdit nowEdit = (FieldEdit)this.getControl("iscontainnow");
        if (nowEdit != null) {
            containNow = (Boolean)nowEdit.getModel().getValue("iscontainnow");
        }
        ITreeModel treeListModel = this.getTreeListView().getTreeModel();
        GroupProp groupProp = treeListModel.getGroupProp();
        TreeNode currentNode = root.getTreeNode(currentId);
        if (currentNode == null) {
            return;
        }
        String longNumber = currentNode.getLongNumber();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            if (!filters.isEmpty() && containNow && ((ParentBasedataProp)groupProp).isShowTreeNow()) {
                int dbType = groupProp.getDbType();
                Object id = DbTypeConverter.safeConvert((int)dbType, (Object)currentId);
                QFilter filter = new QFilter("id", "=", id);
                filters.get(0).or(filter);
            }
            EntityType et = this.getListModel().getDataEntityType();
            BasedataEntityType bet = groupProp.getEntityType();
            if (et.getName().equals(bet.getName())) {
                String longNumberDLM = ((ParentBasedataProp)groupProp).getLongNumberDLM();
                QFilter qFilter = new QFilter("longnumber", "like", (Object)(longNumber + longNumberDLM + "%"));
                if (!filters.isEmpty()) {
                    filters.get(0).or(qFilter);
                } else {
                    filters.add(qFilter);
                }
            } else {
                this.buildCustomTreeFilter(groupProp, longNumber, filters);
            }
        } else if (!filters.isEmpty() && containNow && ((ParentBasedataProp)groupProp).isShowTreeNow()) {
            int dbType = groupProp.getDbType();
            Object id = DbTypeConverter.safeConvert((int)dbType, (Object)currentId);
            QFilter filter = new QFilter("id", "=", id);
            filters.get(0).or(filter);
        }
    }

    private void buildCustomTreeFilter(GroupProp groupProp, String longNumber, List<QFilter> filters) {
        String groupName = groupProp.getName();
        IQuery query = QueryFactory.createQuery();
        List idArrays = query.getChildsId(groupProp, longNumber);
        ListIterator<QFilter> listIterator = filters.listIterator();
        while (listIterator.hasNext()) {
            QFilter filter = listIterator.next();
            if (filter == null || !filter.getProperty().equals(groupName)) continue;
            listIterator.remove();
            int dbType = groupProp.getDbType();
            List ids = idArrays.stream().map(obj -> DbTypeConverter.safeConvert((int)dbType, (Object)obj)).collect(Collectors.toList());
            filter.or(new QFilter(groupName, "in", (Object)ids.toArray()));
            listIterator.add(filter);
        }
    }

    private void addContainNowOrLowerFilter(Object currentNodeId, List<QFilter> filters) {
        ITreeModel treeListModel = this.getTreeListView().getTreeModel();
        FieldEdit lowerEdit = (FieldEdit)this.getControl(ISCONTAINLOWER);
        boolean containLower = true;
        if (lowerEdit != null) {
            containLower = (Boolean)lowerEdit.getModel().getValue(ISCONTAINLOWER);
        }
        FieldEdit showDisabledDataEdit = (FieldEdit)this.getControl("isshowdisabled");
        boolean showDisabledData = false;
        if (showDisabledDataEdit != null) {
            showDisabledData = (Boolean)showDisabledDataEdit.getModel().getValue("isshowdisabled");
        }
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        billList.setShowDisabledData(showDisabledData);
        if (treeListModel != null && currentNodeId != null) {
            GroupProp groupProp = treeListModel.getGroupProp();
            String currentId = (String)currentNodeId;
            TreeNode root = treeListModel.getRoot();
            if (root != null && groupProp != null) {
                if (containLower && currentId.equals(root.getId())) {
                    return;
                }
                if (containLower && groupProp.isShowTreeLower() && !(groupProp instanceof ParentBasedataProp)) {
                    this.buildGroupChildFilter(root, currentId, filters);
                } else if (groupProp instanceof ParentBasedataProp) {
                    this.buildTreeChildFilter(root, currentId, filters);
                } else if (!containLower && currentNodeId.toString().equals(root.getId())) {
                    QFilter filter = new QFilter(groupProp.getName(), "=", (Object)0);
                    filters.add(filter);
                } else if (!groupProp.isShowTreeLower()) {
                    this.setVisible(false, new String[]{ISCONTAINLOWER});
                }
            }
        }
    }

    private List<QFilter> addLowerTreeNodeFilters(Object currentNodeId, List<QFilter> filters) {
        String isCacel;
        if (filters == null || filters.isEmpty()) {
            filters = this.getTreeListFilters();
        }
        if (!"true".equals(isCacel = this.getPageCache().get("isCacel"))) {
            this.addContainNowOrLowerFilter(currentNodeId, filters);
        }
        return filters;
    }

    private void addTreeNodeClickListener(final ITreeListView treeListView) {
        treeListView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                BillList billList;
                ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)ListView.this.getService(FormViewPluginProxy.class);
                listViewPluginProxy.fireTreeNodeClick(evt);
                String rootId = "";
                if (treeListView.getTreeModel().getRoot() != null) {
                    rootId = treeListView.getTreeModel().getRoot().getId();
                }
                if (!StringUtils.equals((CharSequence)rootId, (CharSequence)String.valueOf(evt.getNodeId()))) {
                    ListView.this.clearFastFilter();
                }
                if (!evt.isCancel() && (billList = (BillList)ListView.this.getControl(ListView.this.context.getBillListId())) != null) {
                    TreeView treeView;
                    String fastfilter;
                    List filters = ListView.this.addLowerTreeNodeFilters(evt.getNodeId(), null);
                    ListView.this.getListCache().setTreeListFilterParameter(new FilterParameter(filters, null));
                    if (StringUtils.equals((CharSequence)rootId, (CharSequence)String.valueOf(evt.getNodeId())) && StringUtils.isNotBlank((CharSequence)(fastfilter = ListView.this.getPageCache().get("fast:filter")))) {
                        List fastQfilters = SerializationUtils.fromJsonStringToList((String)fastfilter, QFilterDto.class);
                        for (QFilterDto filterDto : fastQfilters) {
                            filters.add(QFilter.fromSerializedString((String)filterDto.getFilter()));
                        }
                    }
                    billList.setQueryFilterParameter(new FilterParameter(filters, null));
                    ListView.this.getPageCache().put(ListView.QUERY_FILTER_PARAMETER_TYPE, "tree");
                    boolean isF7 = false;
                    if (evt.getSource() instanceof TreeView && (treeView = (TreeView)evt.getSource()) != null && treeView.getView() != null && treeView.getView().getFormShowParameter() instanceof ListShowParameter) {
                        isF7 = ((ListShowParameter)treeView.getView().getFormShowParameter()).isLookUp();
                    }
                    if (!isF7) {
                        billList.clearSelection();
                    }
                    ListView.this.initFilterGridView();
                    billList.bindData(null);
                    ListView.this.refreshQingView();
                }
            }
        });
        this.refreshCustomView();
    }

    private void refreshTreeView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.refreshTreeView", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            boolean canRefreshTree;
            boolean bl = canRefreshTree = this.getTreeListView() != null && this.getTreeListView().getTreeModel() != null && this.getTreeListView().getTreeModel().getGroupProp() != null && this.getTreeListView().getTreeModel().getGroupProp().isNeedRefreshTree();
            if (!canRefreshTree) {
                return;
            }
            List<QFilter> filters = this.getTreeListFilters();
            GroupProp prop = this.getTreeListView().getTreeModel().getGroupProp();
            Object currentId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeListView().getTreeModel().getRoot();
            if (currentId == null || root == null) {
                this.getTreeListView().refreshTreeView();
                this.afterRefreshTreeView(filters);
                return;
            }
            TreeNode treeNode = root.getTreeNode(currentId.toString());
            if (treeNode == null) {
                this.afterRefreshTreeView(filters);
                return;
            }
            this.setTreeFilterParameter();
            if (prop instanceof ParentBasedataProp) {
                this.setTreeModelFilter();
                if (currentId.equals(root.getId())) {
                    this.getTreeListView().getTreeModel().refreshNode((Object)root.getId());
                    this.getTreeListView().refreshTreeNode(root.getId(), false);
                } else {
                    String parentId = treeNode.getParentid();
                    this.getTreeListView().getTreeModel().refreshNode((Object)parentId);
                    this.getTreeListView().refreshTreeNode(parentId, false);
                    currentId = this.getTreeListView().getTreeModel().getCurrentNodeId();
                    TreeNode afterNode = root.getTreeNode(currentId.toString());
                    if (afterNode != null) {
                        this.getTreeListView().getTreeView().expand(parentId);
                        this.getTreeListView().getTreeView().focusNode(afterNode);
                    }
                    filters = null;
                }
            } else {
                this.getTreeListView().getTreeModel().refreshNode(currentId);
                this.getTreeListView().refreshTreeNode(currentId.toString(), false);
            }
            filters = this.addLowerTreeNodeFilters(currentId, filters);
            this.cacheTreeFilterParameter();
            String matchNodesCacheKey = this.getPageId() + "_matchNodes";
            this.getPageCache().remove(matchNodesCacheKey);
            this.afterRefreshTreeView(filters);
        }
    }

    private void cacheTreeFilterParameter() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        List qFilters = listShowParameter.getTreeFilterParameter().getQFilters();
        if (!qFilters.isEmpty()) {
            ArrayList<QFilterDto> cacheFilters = new ArrayList<QFilterDto>(qFilters.size());
            for (QFilter qFilter : qFilters) {
                cacheFilters.add(new QFilterDto(qFilter.toSerializedString()));
            }
            this.getPageCache().put("customTreeFilter", SerializationUtils.toJsonString(cacheFilters));
        }
    }

    private void afterRefreshTreeView(List<QFilter> filters) {
        if ((this.getListCache().getTreeListFilterParameter().getQFilters().isEmpty() || !this.context.getFastQueryFilterParameter().getQFilters().isEmpty()) && filters.toString().equalsIgnoreCase(this.getListCache().getTreeRootListFilterParameter().getQFilters().toString())) {
            return;
        }
        this.clearFastFilter();
        this.getListCache().setTreeListFilterParameter(new FilterParameter(filters, null));
        BillList billList = (BillList)this.getControl(this.context.getBillListId());
        if (billList != null) {
            billList.setQueryFilterParameter(new FilterParameter(filters, null));
        }
    }

    private void setTreeModelFilter() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.setTreeModelFilter", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
            ITreeModel treemodel = this.getTreeListView().getTreeModel();
            BasedataEntityType entityType = treemodel.getGroupProp().getEntityType();
            BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent((Object)this, listShowParameter, BasedataControllerSourceEnum.TREE);
            List controllers = BasedataHelper.createPlugin((List)entityType.getBasedataControllersProp());
            for (IBasedataController controller : controllers) {
                EntityTraceSpan span1 = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(controller.getClass().getName() + ".buildBaseDataCoreFilter"));
                Throwable throwable = null;
                try {
                    controller.buildBaseDataCoreFilter(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span1 == null) continue;
                    if (throwable != null) {
                        try {
                            span1.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span1.close();
                }
            }
            if (!event.getQfilters().isEmpty()) {
                treemodel.getTreeFilter().addAll(event.getQfilters());
            }
        }
    }

    private void setTreeFilterParameter() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        List qFilters = listShowParameter.getTreeFilterParameter().getQFilters();
        if (!qFilters.isEmpty()) {
            ITreeModel treeModel = this.getTreeListView().getTreeModel();
            treeModel.getTreeFilter().addAll(qFilters);
        }
    }

    private void setFilterContainerTitle(FilterContainer filterContainer) {
        LocaleString title = new LocaleString(this.getFormShowParameter().getCaption());
        if (StringUtils.isBlank((Object)title) && StringUtils.isBlank((Object)filterContainer.getTitle())) {
            title = FormMetadataCache.getFormConfig((String)this.getBillFormId()).getCaption();
        }
        if (StringUtils.isNotBlank((Object)title)) {
            filterContainer.setTitle(title);
        }
    }

    @Override
    protected boolean isLinkQuery() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            return !filterContainer.getLinkQueryPkIdCollection().isEmpty();
        }
        return super.isLinkQuery();
    }

    @Override
    protected void initLinkQueryPkIdCollection() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
            filterContainer.setLinkQueryDescription(listShowParameter.getLinkQueryDescription());
            filterContainer.putLinkQueryPkIdCollection(listShowParameter.getLinkQueryPkIdCollection());
        }
    }

    @Override
    protected void restoreQingFilterValues() {
        QingCachedFilterContainerFilterValues qingCachedFilterContainerFilterValues;
        FilterContainer qingFilterContainer;
        super.restoreQingFilterValues();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            filterContainer.setCachedFilterValues(new FilterContainerFilterValues());
        }
        if (this.qingCachedFilterHolder != null && this.qingCachedFilterHolder.getQingCachedFilterValues() instanceof QingCachedFilterContainerFilterValues && (qingFilterContainer = (FilterContainer)this.getControl((qingCachedFilterContainerFilterValues = (QingCachedFilterContainerFilterValues)this.qingCachedFilterHolder.getQingCachedFilterValues()).getControlKey())) != null) {
            qingFilterContainer.setCachedFilterValues(qingCachedFilterContainerFilterValues.getCachedFilterValues());
        }
    }

    @Override
    public void updateView() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.updateView", (EntityTraceHint)EntityTraceHint.getHintLinkAPM());){
            String setting;
            this.refreshTreeView();
            ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
            FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
            BillList billList = (BillList)this.getControl(this.context.getBillListId());
            this.context.setArchiveKey(listShowParameter.getArchiveKey());
            if (filterContainer != null) {
                this.setFilterContainerTitle(filterContainer);
                this.addFilterContainerCommonBaseDataColumnDependFieldSetListener(filterContainer);
                this.addFilterContainerSetFilter(filterContainer);
                this.addFilterContainerInitListener(filterContainer, true);
                this.addSetFilterContainerFlatListener(filterContainer);
                this.addSetFilterContainerBaseDataSearchClosedListener(filterContainer);
                this.addCloseQueryByOrListener(filterContainer);
                this.addExpandListener(filterContainer);
                if (listShowParameter.getCustomParam("searchValueMap") != null) {
                    this.isContainFastSearchValuesOnUpdateView = true;
                    filterContainer.setSearchValueMap((Map)listShowParameter.getCustomParam("searchValueMap"));
                }
                filterContainer.addAfterBindDataListener(afterBindDataEvent -> {
                    this.setSelectedMainOrgIds(this.context.getSelectedMainOrgIds());
                    if (billList != null) {
                        this.setBillListFilterParameter(billList);
                        ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
                        SumDataLoadOnFirstSetEvent sumDataLoadOnFirstSetEvent = new SumDataLoadOnFirstSetEvent((Object)this);
                        listViewPluginProxy.fireSumDataLoadOnFirstSet(sumDataLoadOnFirstSetEvent);
                        billList.setSumDataLoadOnFirst(sumDataLoadOnFirstSetEvent.isSumDataLoadOnFirst());
                    }
                });
                filterContainer.setSchemeId(listShowParameter.getFilterSchemeId());
            }
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            MultiFieldsSortEvent multiFieldsSortEvent = new MultiFieldsSortEvent((Object)this);
            listViewPluginProxy.fireSetMultiSortFields(multiFieldsSortEvent);
            if (!multiFieldsSortEvent.getMultiSortFields().isEmpty()) {
                this.getListCache().putMultiSortFields(multiFieldsSortEvent.getMultiSortFields());
            }
            if (StringUtils.isNotBlank((CharSequence)(setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)((billList != null ? billList.getBillFormId() : this.getBillFormId()) + "_msf"))))) {
                this.getListCache().putFieldSortConfig(SerializationUtils.fromJsonStringToList((String)setting, FieldSort.class));
            }
            IndexModeSetEvent indexModeSetEvent = new IndexModeSetEvent((Object)this);
            listViewPluginProxy.fireSetIndexMode(indexModeSetEvent);
            if (billList != null && indexModeSetEvent.isIndexMode()) {
                billList.setIndexMode(true);
            }
            EnableCustomSumEvent enableCustomSumEvent = new EnableCustomSumEvent((Object)this);
            listViewPluginProxy.fireSetEnableCustomSum(enableCustomSumEvent);
            if (billList != null && !enableCustomSumEvent.isEnableCustomSum()) {
                billList.setEnableCustomSum(false);
            }
            super.updateView();
            this.refreshQingView();
            this.refreshCustomView();
            this.listShowParameterRowsSelected(listShowParameter, billList);
        }
    }

    private void listShowParameterRowsSelected(ListShowParameter listShowParameter, BillList billList) {
        ListSelectedRowCollection selectedRows;
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(this.context.getF7SeletedControlId());
        if (billList != null && f7SelectedList != null && listShowParameter.isMultiSelect() && !(selectedRows = billList.getSelectedRows()).isEmpty()) {
            HashSet<Object> currentRowSet = new HashSet<Object>(16);
            for (Object listSelectedRow : this.getCurrentListAllRowCollection()) {
                currentRowSet.add(listSelectedRow);
            }
            boolean hasCurrent = false;
            for (ListSelectedRow selectedRow : selectedRows) {
                if (!currentRowSet.contains(selectedRow)) continue;
                hasCurrent = true;
                break;
            }
            List<ValueTextItem> selectedItems = this.getF7SelectedItems(selectedRows);
            this.setMulAuthorizedData(selectedRows);
            if (!hasCurrent) {
                f7SelectedList.addItems(selectedItems);
            }
        }
    }

    private void setMulAuthorizedData(ListSelectedRowCollection selectedRows) {
        if (this.getViewNoPlugin(this.getFormShowParameter().getParentPageId()) instanceof ReportView) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getFormShowParameter();
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(this.context.getF7SeletedControlId());
        String originFieldKey = (String)listShowParameter.getCustomParam("originFieldKey");
        if (StringUtils.isNotBlank((CharSequence)originFieldKey)) {
            String parentFormId = listShowParameter.getParentFormId();
            parentFormId = FormMetadataCache.getFormConfig((String)parentFormId).getEntityTypeId();
            ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
            Long userId = RequestContext.get().getCurrUserId();
            String appId = listShowParameter.getAppId();
            HashMap customParams = new HashMap();
            customParams.putAll(listShowParameter.getCustomParams());
            boolean b = permissionService.existsMulBdPropDataRule(userId.longValue(), appId, parentFormId, originFieldKey, customParams);
            if (b && !selectedRows.isEmpty()) {
                ArrayList<Object> pks = new ArrayList<Object>();
                for (ListSelectedRow row : selectedRows) {
                    pks.add(row.getPrimaryKeyValue());
                }
                MulBdPermUtil.setAuthorizedData((IFormView)this, (String)f7SelectedList.getKey(), pks);
            }
        }
    }

    private void initTreeListView() {
        if (this.treeListView == null && this.getControl("treeview") != null) {
            this.listModel = null;
            CreateTreeListViewEvent e = new CreateTreeListViewEvent((Object)this);
            ((ListViewPluginProxy)this.getPluginProxy()).fireCreateTreeListView(e);
            this.treeListView = e.getView() == null ? new TreeListView() : e.getView();
            if (this.treeListView != null) {
                this.addTreeNodeClickListener(this.treeListView);
                this.treeListView.initialize((IListView)this, (TreeView)this.getControl("treeview"));
            }
        }
    }

    @Override
    protected void initialContext() {
        super.initialContext();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            filterContainer.setBillFormId(this.getBillFormId());
            filterContainer.setContext(this.context);
            filterContainer.setNeedShareScheme(true);
            if (this.getFormShowParameter().getCustomParam("searchFields") != null) {
                filterContainer.setSearchFields((List)this.getFormShowParameter().getCustomParam("searchFields"));
            }
        }
        this.initTreeListView();
    }

    @Override
    protected Map<String, Object> getListMetadata() {
        return FormMetadataCache.getListMeta((String)this.getBillFormId());
    }

    @Override
    protected void openBillOrReturnData() {
        if (this.isLookup()) {
            this.returnLookupData();
        } else {
            this.openBill();
        }
    }

    private List<ValueTextItem> getF7SelectedItems(ListSelectedRowCollection listSelectedRowCollection) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        String text = "";
        Map map = new HashMap(0);
        FuzzySearch fuzzySearch = ParameterReader.loadBillParameterFormCache((String)this.getEntityTypeId()).getFuzzySearch();
        if (fuzzySearch != null && fuzzySearch.isF7FullName()) {
            Object[] Ids = listSelectedRowCollection.getPrimaryKeyValues();
            map = BusinessDataServiceHelper.loadFromCache((String)this.getEntityTypeId(), (String)"fullname", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Ids)});
        }
        String name = "";
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            if (fuzzySearch != null && fuzzySearch.isF7FullName()) {
                Object object = ((DynamicObject)map.get(listSelectedRow.getPrimaryKeyValue())).get("fullname");
                if (object != null) {
                    name = object.toString();
                }
            } else {
                name = listSelectedRow.getName();
            }
            text = StringUtils.isNotBlank((CharSequence)name) ? name : (StringUtils.isNotBlank((CharSequence)listSelectedRow.getNumber()) ? listSelectedRow.getNumber() : listSelectedRow.getBillNo());
            valueTextItems.add(new ValueTextItem(listSelectedRow.toString(), text));
        }
        return valueTextItems;
    }

    void addF7SelectedListener(BillList billList) {
        final F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(this.context.getF7SeletedControlId());
        if (f7SelectedList != null) {
            billList.addListRowClickListener(new ListRowClickListener(){

                public void listRowDoubleClick(ListRowClickEvent arg0) {
                    throw new UnsupportedOperationException();
                }

                public void listRowClick(ListRowClickEvent listRowClickEvent) {
                    f7SelectedList.addItems(ListView.this.getF7SelectedItems(ListView.this.isMergeRow() ? listRowClickEvent.getListSelectedRowCollection().getBillListSelectedRowCollection() : listRowClickEvent.getListSelectedRowCollection()));
                }
            });
            f7SelectedList.addF7SelectedListRemoveListener(f7SelectedListRemoveEvent -> {
                billList.restoreSelection(f7SelectedListRemoveEvent.getParam().toString());
                this.getListCache().savePageCache();
            });
            f7SelectedList.addF7SelectedListRemoveAllListener(f7SelectedListRemoveEvent -> {
                FormShowParameter showParameter = this.getFormShowParameter();
                String parentFormId = (String)showParameter.getCustomParam("originFormId");
                String originFieldKey = (String)showParameter.getCustomParam("originFieldKey");
                String json = this.getPageCache().get(parentFormId + "__" + originFieldKey);
                if (StringUtils.isNotBlank((CharSequence)json)) {
                    List unRemovablePks = SerializationUtils.fromJsonStringToList((String)json, String.class);
                    billList.restoreUnRemovablePks(unRemovablePks);
                } else {
                    this.clearSelection();
                }
                this.getListCache().savePageCache();
            });
            f7SelectedList.addF7SelectedListSortListener(f7SelectedListSortEvent -> {
                ListSelectedRowCollection listSelectedRowCollection = billList.sortListSelectedRowsByKeys(f7SelectedListSortEvent.getSortItems());
                f7SelectedList.addItems(this.getF7SelectedItems(listSelectedRowCollection));
                this.getListCache().savePageCache();
            });
        }
    }

    @Override
    protected void setBillListFilterParameter(BillList billList) {
        if (this.getListCache().getTreeListFilterParameter().getQFilters().isEmpty() || !this.context.getFastQueryFilterParameter().getQFilters().isEmpty()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.addAll(this.context.getFastQueryFilterParameter().getQFilters());
            if (!qFilters.isEmpty()) {
                if (this.treeListView != null && this.treeListView.getTreeModel() instanceof TreeListModel && (((TreeListModel)this.treeListView.getTreeModel()).isGobackToRoot() || this.isContainFastSearchValuesOnUpdateView)) {
                    this.focusRootNode();
                    this.getListCache().setTreeListFilterParameter(new FilterParameter());
                } else if (this.treeListView != null && this.treeListView.getTreeModel() != null) {
                    Object currentNodeId = this.treeListView.getTreeModel().getCurrentNodeId();
                    QFilter filter = this.getTreeListView().getTreeModel().getListFilter();
                    this.getTreeListView().getTreeModel().setCurrentNodeId(currentNodeId);
                    qFilters.add(filter);
                }
                this.getPageCache().put(QUERY_FILTER_PARAMETER_TYPE, "fast");
            } else if (this.treeListView != null && this.treeListView.getTreeModel() != null) {
                Object currentNodeId = this.treeListView.getTreeModel().getCurrentNodeId();
                QFilter filter = this.getTreeListView().getTreeModel().getListFilter();
                if (currentNodeId != null) {
                    this.getTreeListView().getTreeModel().setCurrentNodeId(currentNodeId);
                }
                if (filter != null) {
                    qFilters.add(filter);
                }
                this.addContainNowOrLowerFilter(currentNodeId, qFilters);
            }
            if (this.context.getFastQueryFilterParameter().getQFilters().isEmpty() && !qFilters.isEmpty()) {
                this.getListCache().setTreeListFilterParameter(new FilterParameter(qFilters, null));
            }
            billList.setQueryFilterParameter(new FilterParameter(qFilters, null));
            this.cacheFastFilters();
        } else if (this.context.getFastQueryFilterParameter().getQFilters().isEmpty() && !this.getListCache().getTreeListFilterParameter().getQFilters().isEmpty()) {
            billList.setQueryFilterParameter(new FilterParameter(this.getListCache().getTreeListFilterParameter().getQFilters(), null));
            this.getPageCache().put(QUERY_FILTER_PARAMETER_TYPE, "tree");
            this.cacheFastFilters();
        }
        super.setBillListFilterParameter(billList);
    }

    private void cacheFastFilters() {
        ArrayList<QFilterDto> fastfilters = new ArrayList<QFilterDto>(10);
        for (QFilter qFilter : this.context.getFastQueryFilterParameter().getQFilters()) {
            fastfilters.add(new QFilterDto(qFilter.toSerializedString()));
        }
        this.getPageCache().put("fast:filter", SerializationUtils.toJsonString(fastfilters));
    }

    private void registerFilterContainer(ListViewPluginProxy listViewPluginProxy) {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            this.addFilterContainerCommonBaseDataColumnDependFieldSetListener(filterContainer);
            this.addFilterContainerSetFilter(filterContainer);
            this.addFilterContainerInitListener(filterContainer, false);
            this.addSetFilterContainerFlatListener(filterContainer);
            this.addSetFilterContainerBaseDataSearchClosedListener(filterContainer);
            this.addCloseQueryByOrListener(filterContainer);
            this.addExpandListener(filterContainer);
            this.addSchemeValidateListener(filterContainer);
            filterContainer.addSearchClickListener(searchClickEvent -> {
                FilterContainerSearchClickArgs filterContainerSearchClickArgs = new FilterContainerSearchClickArgs(searchClickEvent);
                listViewPluginProxy.fireFilterContainerSearchClick(filterContainerSearchClickArgs);
                searchClickEvent.setFilterParameter(null);
            });
            filterContainer.addAfterSearchClickListener(searchClickEvent -> {
                BillList billList;
                FilterContainerSearchClickArgs filterContainerSearchClickArgs = new FilterContainerSearchClickArgs(searchClickEvent);
                listViewPluginProxy.fireFilterContainerAfterSearchClick(filterContainerSearchClickArgs);
                this.setFilterContainerTitle(filterContainer);
                this.setSelectedMainOrgIds(this.context.getSelectedMainOrgIds());
                if (this.context.getFilterControlContext().isTriggerSearch() && (billList = (BillList)this.getControl(this.context.getBillListId())) != null) {
                    this.setBillListFilterParameter(billList);
                    billList.bindData(null);
                    this.refreshQingView();
                }
            });
            filterContainer.addBeforeF7SelectListener(arg_0 -> ((ListViewPluginProxy)listViewPluginProxy).fireFilterContainerBeforeF7Select(arg_0));
            filterContainer.addSwitchModeListener(switchModeEvent -> {
                this.setFilterContainerTitle(filterContainer);
                this.setSelectedMainOrgIds(this.context.getSelectedMainOrgIds());
                BillList billList = (BillList)this.getControl(this.context.getBillListId());
                if (billList != null) {
                    this.setBillListFilterParameter(billList);
                    billList.bindData(null);
                    this.refreshQingView();
                }
            });
        }
        this.refreshCustomView();
    }

    private void addSetFilterContainerBaseDataSearchClosedListener(FilterContainer filterContainer) {
        filterContainer.addSetFilterContainerBaseDataSearchClosedListener(setFilterContainerBaseDataSearchClosedEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            listViewPluginProxy.fireFilterContainerSetBaseDataSearchClosed(setFilterContainerBaseDataSearchClosedEvent);
        });
    }

    private void addSetFilterContainerFlatListener(FilterContainer filterContainer) {
        filterContainer.addSetFilterContainerFlatListener(setFilterContainerFlatEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            listViewPluginProxy.fireFilterContainerSetFlat(setFilterContainerFlatEvent);
        });
    }

    private void addFilterContainerCommonBaseDataColumnDependFieldSetListener(FilterContainer filterContainer) {
        ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        filterContainer.addBaseDataColumnDependFieldSetListener(arg_0 -> ((ListViewPluginProxy)listViewPluginProxy).fireCommonBaseDataColumnDependFieldSet(arg_0));
    }

    private void addCloseQueryByOrListener(FilterContainer filterContainer) {
        filterContainer.addQueryByOrListener(closeQueryByOrEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            listViewPluginProxy.fireCloseQueryByOr(closeQueryByOrEvent);
        });
    }

    private void addExpandListener(FilterContainer filterContainer) {
        filterContainer.addExpandListener(expandEvent -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            listViewPluginProxy.fireFilterContainerExpand(expandEvent);
        });
    }

    private void addSchemeValidateListener(FilterContainer filterContainer) {
        filterContainer.addSchemeValidateListener(filterSchemeDto -> {
            ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
            return listViewPluginProxy.fireFilterContainerSchemeValidate(filterSchemeDto);
        });
    }

    @Override
    protected void initFilterGridView() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            if (this.getListCache().hasFlexFiler()) {
                filterContainer.refresh();
            } else {
                this.context.setFieldCompareTypeMap(this.getFieldCompareTypeMap(filterContainer));
            }
        }
    }

    private Map<String, List<CompareType>> getFieldCompareTypeMap(FilterContainer filterContainer) {
        if (this.fieldCompareTypeMap == null) {
            this.fieldCompareTypeMap = new HashMap<String, List<CompareType>>();
            if (filterContainer.getCompareTypeConfig() != null) {
                CompareTypeModelCollection compareTypeModelCollection = CompareTypeQuery.getCompareTypeModelCollection();
                for (CompareTypeField compareTypeField : filterContainer.getCompareTypeConfig().getCompareTypeFields()) {
                    this.putCompareTypeField(compareTypeModelCollection, compareTypeField);
                }
            }
        }
        return this.fieldCompareTypeMap;
    }

    private void putCompareTypeField(CompareTypeModelCollection compareTypeModelCollection, CompareTypeField compareTypeField) {
        CompareType compareType = null;
        for (CompareTypeModel compareTypeModel : compareTypeModelCollection) {
            if (!compareTypeModel.getId().equals(compareTypeField.getId())) continue;
            compareType = compareTypeModel.createCompareType();
        }
        if (compareType != null) {
            String[] fieldNames;
            for (String fieldName : fieldNames = compareTypeField.getFieldNames().split(",")) {
                List<CompareType> compareTypes = new ArrayList<CompareType>();
                if (this.fieldCompareTypeMap.containsKey(fieldName)) {
                    compareTypes = this.fieldCompareTypeMap.get(fieldName);
                }
                compareTypes.add(compareType);
                this.fieldCompareTypeMap.put(fieldName, compareTypes);
            }
        }
    }

    @Override
    public void registerListener() {
        super.registerListener();
        final ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        BillList list = (BillList)this.getControl(this.context.getBillListId());
        if (list != null) {
            list.addListRowDoubleClickListener(new ListRowClickListener(){

                public void listRowDoubleClick(ListRowClickEvent listrowclickevent) {
                    listViewPluginProxy.fireListRowDoubleClick(listrowclickevent);
                    if (!listrowclickevent.isCancel() && ListView.this.isLookup()) {
                        ListView.this.returnLookupData();
                    } else if (ListView.this.getFormShowParameter().getFormConfig().isAllowDoubleClick() && !ListView.this.isLookup()) {
                        ListView.this.openBill();
                    }
                }
            });
            list.addHyperClickListener(hyperlinkclickevent -> {
                HyperLinkClickArgs billListHyperLinkClickArgs = new HyperLinkClickArgs(hyperlinkclickevent, false);
                listViewPluginProxy.fireBillListHyperLinkClick(billListHyperLinkClickArgs);
                if (!billListHyperLinkClickArgs.isCancel()) {
                    ListColumnMeta listColumnMeta = null;
                    Map formShowParameterIn = null;
                    boolean isApproverListColumn = false;
                    for (IListColumn listColumn : this.getShowListColumns()) {
                        if (listColumn instanceof ApproverListColumn && ((ApproverListColumn)listColumn).getKey().equals(hyperlinkclickevent.getFieldName())) {
                            isApproverListColumn = true;
                            break;
                        }
                        if (!(listColumn instanceof Control) || !((Control)listColumn).getKey().equals(hyperlinkclickevent.getFieldName())) continue;
                        listColumnMeta = ColumnMetaFactory.getListColumnMeta((String)listColumn.getClass().getSimpleName());
                        formShowParameterIn = listColumn.getColumnServiceContext();
                        break;
                    }
                    if (listColumnMeta != null) {
                        ListFormShowParameterIn listFormShowParameterIn = new ListFormShowParameterIn(listColumnMeta.name(), this.getFocusRowPkId().toString(), this.getEntityTypeId());
                        listFormShowParameterIn.setFormShowParameterIn(formShowParameterIn);
                        FormShowParameter formShowParameter1 = ListColumnCompareServiceHelper.getFormShowParameter((ListFormShowParameterIn)listFormShowParameterIn);
                        if (formShowParameter1 != null) {
                            this.showForm(formShowParameter1);
                        } else if (listColumnMeta == ListColumnMeta.VoucherNoListColumn) {
                            VoucherNoUtil.traceVoucher(this.getFocusRowPkId().toString(), (IFormView)this, this.getEntityTypeId(), (String)formShowParameterIn.get("operationKey"), (String)formShowParameterIn.get("voucherFieldId"));
                        }
                    } else if (isApproverListColumn) {
                        WorkflowServiceHelper.viewFlowchart((String)this.getPageId(), (Object)this.getFocusRowPkId());
                    } else {
                        this.openBillOrReturnData();
                    }
                }
            });
            ListShowParameter parameter = (ListShowParameter)this.getFormShowParameter();
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(this.context.getF7SeletedControlId());
            if (f7SelectedList != null && parameter.isMultiSelect()) {
                this.addF7SelectedListener(list);
                list.addClearSelectionListener(event -> f7SelectedList.removeAllItemsByClient());
            }
            list.addScrollListListener(scrollListEvent -> this.initFilterGridView());
            list.addEntryHyperLinkClickListener(entryHyperLinkClickEvent -> listViewPluginProxy.fireEntryHyperLinkClick(entryHyperLinkClickEvent));
            IndexModeSetEvent indexModeSetEvent = new IndexModeSetEvent((Object)this);
            listViewPluginProxy.fireSetIndexMode(indexModeSetEvent);
            if (list != null && indexModeSetEvent.isIndexMode()) {
                list.setIndexMode(true);
            }
        }
        this.registerFilterContainer(listViewPluginProxy);
    }

    @Override
    public void changeListView(String billFormId) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.changeListView");){
            span.addTag("billFormId", billFormId);
            super.changeListView(billFormId);
            FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
            if (filterContainer != null) {
                filterContainer.setEntityId("");
                filterContainer.bindData(null);
            }
        }
    }

    @Override
    public ControlFilters getControlFilters() {
        FilterContainerFilterValues cachedFilterValues;
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null && this.controlFilters == null && !(cachedFilterValues = filterContainer.getCachedFilterValues()).isEmpty()) {
            this.controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues(), cachedFilterValues.getOtherFilterValues());
            this.controlFilters.setAndFilter(filterContainer.getAndFilter());
        }
        return this.controlFilters;
    }

    @Override
    protected boolean checkSelectedRows(ListSelectedRowCollection listSelectedRowCollection) {
        Object skipCheckSelectRows = this.formShowParameter.getCustomParam("skipCheckSelectRows");
        if (skipCheckSelectRows != null && ((Boolean)skipCheckSelectRows).booleanValue()) {
            listSelectedRowCollection.setClearFlag(true);
            return true;
        }
        if (listSelectedRowCollection.isEmpty()) {
            boolean isFromCommonOrSchemeFilter;
            Object isFromCommonFilterColumn = this.formShowParameter.getCustomParam("isFromCommonFilterColumn");
            Object isFromSchemeFilterColumn = this.formShowParameter.getCustomParam("isFromSchemeFilterColumn");
            boolean bl = isFromCommonOrSchemeFilter = isFromCommonFilterColumn != null && (Boolean)isFromCommonFilterColumn != false || isFromSchemeFilterColumn != null && (Boolean)isFromSchemeFilterColumn != false;
            if (isFromCommonOrSchemeFilter) {
                if (((ListShowParameter)this.formShowParameter).isMustInput()) {
                    this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ListView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                    return false;
                }
                return true;
            }
            this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ListView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"ListView.closedCallBack");){
            super.closedCallBack(closedCallBackEvent);
            this.refreshCustomView();
        }
    }

    @Override
    void afterSetMetadata(BillList billList) {
        ListUserConfig listUserConfig = ListUserConfig.retrieve(this.getProfileKey());
        if (listUserConfig != null) {
            billList.setPageRow(listUserConfig.getPageRows());
            Optional filterMode = this.getListCache().getFilterMode();
            if (listUserConfig.getFilterMode() != null && !filterMode.isPresent()) {
                this.getListCache().setFilterMode(listUserConfig.getFilterMode().intValue());
            }
        }
        super.afterSetMetadata(billList);
    }

    @Override
    protected void setMetadata() {
        super.setMetadata();
        this.addCustomView();
    }

    private CustomView queryCustomViews() {
        ListViewPluginProxy formViewPluginProxy = (ListViewPluginProxy)this.getService(FormViewPluginProxy.class);
        AddCustomViewEvent addCustomViewEvent = new AddCustomViewEvent((Object)this);
        formViewPluginProxy.fireAddCustomViews(addCustomViewEvent);
        return addCustomViewEvent.getCustomView();
    }

    private void addCustomView() {
        CustomView customViewObj = this.queryCustomViews();
        if (customViewObj != null) {
            ArrayList<Control> controlList = new ArrayList<Control>();
            controlList.add((Control)customViewObj);
            this.createControlIndex(controlList);
            List items = customViewObj.getItems();
            if (items != null && !items.isEmpty()) {
                items.stream().forEach(item -> item.bindData(new BindingContext((Object)this.getModel())));
            }
            if (Boolean.TRUE.toString().equals(this.getPageCache().get("refreshCustomView"))) {
                return;
            }
            this.getClientProxy().invokeControlMethod(this.getGridState().getKey(), "addCustomView", new Object[]{customViewObj.getSerCustomView()});
            this.getPageCache().put("refreshCustomView", "true");
        }
    }

    private void refreshCustomView() {
        CustomView customView = this.queryCustomViews();
        if (customView != null) {
            this.getClientProxy().invokeControlMethod(customView.getKey(), "refresh", new Object[0]);
        }
    }

    public void setPinnedCondition(PinnedConditionCollection pinnedConditionCollection) {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        if (filterContainer != null) {
            filterContainer.setPinnedCondition(pinnedConditionCollection);
        }
    }

    @Override
    @SdkInternal
    boolean isNeedCheckMainOrgQFilter() {
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTERCONTAINERID);
        return filterContainer != null;
    }
}

