/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report;

import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;

public class ReportController
extends FormController {
    private static final Log log = LogFactory.getLog(ReportController.class);

    public ReportController(IFormView view) {
        super(view);
    }

    @Override
    public void loadData() {
        try {
            log.info("ReportController loadData start");
            ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            ReportQueryParam queryParam = showParameter.getReportQueryParam();
            ReportView view = this.getView();
            ReportFilter custCont = view.getCustomFilterContainer();
            if (queryParam != null) {
                if (custCont != null) {
                    super.loadData();
                    custCont.loadQuerySchemeData(queryParam);
                    custCont.search();
                } else {
                    view.setQueryParam(queryParam);
                    view.setHasQueryParam(true);
                    super.loadData();
                }
                view.setjoinQuery(true);
            } else {
                super.loadData();
                if (custCont != null) {
                    custCont.initDefaultQueryScheme();
                }
            }
            log.info("ReportController loadData end");
        }
        catch (Exception e) {
            log.error("\u62a5\u8868loadData\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public ReportView getView() {
        return (ReportView)super.getView();
    }
}

