/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report;

import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.FormulaProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.MulComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportPropUtil {
    public static DynamicObjectType createReportType(DynamicObjectType itemType, List<ReportColumn> columns) {
        try {
            DynamicObjectType newType = (DynamicObjectType)itemType.clone();
            ReportPropUtil.registerMissingProperty(newType, itemType, columns);
            return newType;
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e});
        }
    }

    private static void registerMissingProperty(DynamicObjectType itemType, DynamicObjectType srcType, List<ReportColumn> columns) {
        for (ReportColumn col : columns) {
            ReportPropUtil.registerMissingProperty(itemType, srcType, col);
        }
        for (ReportColumn col : columns) {
            ReportPropUtil.regMissRefBasedataProp(itemType, srcType, col);
        }
    }

    private static void registerMissingProperty(DynamicObjectType itemType, DynamicObjectType srcType, ReportColumn column) {
        try {
            ReportColumn col = column;
            DynamicProperty prop = null;
            if (col.getFieldKey() != null) {
                prop = srcType.getProperty(col.getFieldKey());
            }
            if (prop == null) {
                prop = ReportPropUtil.createProperty(itemType, col);
            }
            if (prop != null) {
                col.setFieldProperty(prop);
            }
            ReportPropUtil.setRefOrg(prop, column);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private static void setRefOrg(DynamicProperty prop, ReportColumn column) {
        if (prop instanceof OrgProp) {
            column.setRefOrg(true);
            column.setOrgFuncs(((OrgProp)prop).getOrgFunc());
        } else {
            String controlKey = null;
            if (prop instanceof BasedataProp) {
                BasedataProp baseProp = (BasedataProp)prop;
                controlKey = baseProp.getBaseEntityId();
            } else if (prop instanceof MulBasedataProp) {
                MulBasedataProp mulBaseProp = (MulBasedataProp)prop;
                controlKey = mulBaseProp.getBaseEntityId();
            }
            if ("bos_org".equals(controlKey)) {
                column.setRefOrg(true);
            }
        }
    }

    private static void regMissRefBasedataProp(DynamicObjectType type, DynamicObjectType srcType, ReportColumn column) {
        try {
            ReportColumn col = column;
            if (col.getRefBasedataProp() != null) {
                DynamicProperty prop = type.getProperty(col.getRefBasedataProp());
                if (prop != null && col.getFieldProperty() == null) {
                    col.setFieldProperty(prop);
                }
                ReportPropUtil.setRefOrg(prop, column);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private static DynamicProperty createProperty(DynamicObjectType type, ReportColumn col) {
        if (col.getFieldType() == null) {
            return null;
        }
        DynamicProperty prop = col.getFieldProperty();
        if (prop == null) {
            switch (col.getFieldType()) {
                case "text": {
                    TextProp textProp = new TextProp();
                    if (col instanceof TextReportColumn) {
                        TextReportColumn textReportColumn = (TextReportColumn)col;
                        textProp.setPassword(textReportColumn.isPassword());
                    }
                    prop = textProp;
                    break;
                }
                case "integer": {
                    prop = new IntegerProp();
                    break;
                }
                case "bigint": {
                    prop = new BigIntProp();
                    break;
                }
                case "decimal": {
                    DecimalProp decimalProp = new DecimalProp();
                    decimalProp.setScale(col.getScale());
                    prop = decimalProp;
                    break;
                }
                case "amount": {
                    AmountProp amountProp = new AmountProp();
                    amountProp.setControlPropName(col.getCurrencyField());
                    prop = amountProp;
                    break;
                }
                case "price": {
                    PriceProp priceProp = new PriceProp();
                    priceProp.setControlPropName(col.getCurrencyField());
                    prop = priceProp;
                    break;
                }
                case "qty": {
                    QtyProp qtyProp = new QtyProp();
                    qtyProp.setControlPropName(col.getMeasureUnitField());
                    prop = qtyProp;
                    break;
                }
                case "combofield": {
                    ComboProp comboProp = new ComboProp();
                    if (col instanceof MulComboReportColumn) {
                        comboProp = new MulComboProp();
                    }
                    if (col instanceof ComboReportColumn) {
                        ComboReportColumn comboColumn = (ComboReportColumn)col;
                        comboProp.setComboItems(comboColumn.getComboItems());
                    }
                    prop = comboProp;
                    break;
                }
                case "boolean": 
                case "checkbox": {
                    prop = new BooleanProp();
                    break;
                }
                case "date": {
                    prop = new DateProp();
                    break;
                }
                case "assistant": {
                    AssistantProp assistantProp = new AssistantProp();
                    ReportPropUtil.initBasedataProp((BasedataProp)assistantProp, col);
                    prop = assistantProp;
                    break;
                }
                case "basedata": {
                    BasedataProp bdp = new BasedataProp();
                    if ("bd_measureunits".equalsIgnoreCase(col.getEntityId())) {
                        bdp = new UnitProp();
                    } else if ("bd_currency".equalsIgnoreCase(col.getEntityId())) {
                        bdp = new CurrencyProp();
                    }
                    ReportPropUtil.initBasedataProp(bdp, col);
                    prop = bdp;
                    break;
                }
                case "unit": {
                    UnitProp unitProp = new UnitProp();
                    ReportPropUtil.initBasedataProp((BasedataProp)unitProp, col);
                    prop = unitProp;
                    break;
                }
                case "currency": {
                    CurrencyProp currencyProp = new CurrencyProp();
                    if (StringUtils.isBlank((CharSequence)col.getEntityId())) {
                        col.setEntityId("bd_currency");
                    }
                    ReportPropUtil.initBasedataProp((BasedataProp)currencyProp, col);
                    prop = currencyProp;
                    break;
                }
                case "flex": {
                    FlexProp flexp = new FlexProp();
                    ReportPropUtil.initBasedataProp((BasedataProp)flexp, col);
                    prop = flexp;
                    break;
                }
                case "formula": {
                    FormulaProp pf = new FormulaProp();
                    pf.setFormula(col.getFormula());
                    prop = pf;
                    break;
                }
                case "picture": {
                    prop = new TextProp();
                    break;
                }
            }
        }
        if (prop != null && type.getProperty(prop.getName()) == null) {
            String name = col.getDateIndex() != null ? col.getDateIndex() + "_" + col.getFieldKey() : col.getFieldKey();
            prop.setName(name);
            type.addProperty(prop);
            prop = type.getProperty(prop.getName());
            col.setFieldProperty(prop);
            if (prop instanceof BasedataProp) {
                DynamicProperty refIdProp = (DynamicProperty)((BasedataProp)prop).getRefIdProp();
                refIdProp.setName(prop.getName() + "_Id");
                type.addProperty(refIdProp);
                ((BasedataProp)prop).setRefIdProp((IDataEntityProperty)type.getProperty(refIdProp.getName()));
            }
        }
        return prop;
    }

    private static void initBasedataProp(BasedataProp p, ReportColumn col) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)col.getEntityId());
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId(col.getEntityId());
        p.setRefIdPropName(col.getFieldKey() + "_Id");
        Object idProp = null;
        idProp = entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        idProp.setName(col.getFieldKey() + "_Id");
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(col.getDisplayProp());
    }
}

