/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.click;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportTree;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReportTreeNodeClick {
    private ReportTreeNodeClick() {
        throw new IllegalStateException("ReportTreeNodeClick Utility class");
    }

    public static void treeNodeClick(TreeNodeEvent evt, ReportView view) {
        TreeNode node;
        ReportTree tree = (ReportTree)evt.getSource();
        if (ReportTreeNodeClick.hasLeaf(tree, node = tree.getTreeNode(evt.getNodeId().toString()))) {
            String selectedObj = node.getId();
            ReportList reportList = view.getReportList();
            if (!StringUtils.isEmpty((CharSequence)tree.getBaseEntityId())) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)tree.getBaseEntityId());
                DynamicObject[] selectedObjs = BusinessDataServiceHelper.load((Object[])new Object[]{node.getId()}, (DynamicObjectType)entityType);
                if (selectedObjs != null && selectedObjs.length > 0) {
                    ReportTreeNodeClick.queryReportList(selectedObjs[0], view);
                } else if (reportList != null) {
                    reportList.initEmptyGrid();
                    view.getPageCache().put("isReportSearching", "false");
                }
            } else {
                ReportTreeNodeClick.queryReportList(selectedObj, view);
            }
        }
    }

    private static boolean hasLeaf(ReportTree tree, TreeNode node) {
        return !tree.isLeafNodeQuery() || tree.isLeafNodeQuery() && node != null && (node.getChildren() == null || node.getChildren().isEmpty());
    }

    private static void queryReportList(Object selectedObj, ReportView view) {
        ReportList reportList = view.getReportList();
        if (reportList != null) {
            reportList.submitTask(view.getReportCache().getReportQueryParam(view.getPageId()), selectedObj);
        }
    }
}

