/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.export;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportException;
import kd.bos.mvc.report.export.AbstractReportExport;
import kd.bos.report.ReportList;

public class CommonExcelExport
extends AbstractReportExport {
    @Override
    public void export() {
        ReportList list = this.view.getReportList();
        String content = list.exportExcel();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            if (this.view.getFormOperate() != null) {
                DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
                String[] tempFile = content.split("id=");
                if (tempFile.length > 1) {
                    HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
                    String tempFileId = tempFile[1];
                    refEntitiyMap.put("entityNum", this.view.getEntityId());
                    refEntitiyMap.put("appId", this.view.getFormShowParameter().getServiceAppId());
                    refEntitiyMap.put("permissionItemId", this.view.getFormOperate().getPermissionItemId());
                    distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
                }
            }
            this.view.download(content);
            this.view.getPageCache().put("report_exp_downloadfileurl", content);
            ReportException exception = this.view.getReportCache().getException(this.view.getPageId());
            if (exception != null && StringUtils.isNotBlank((CharSequence)exception.getContent())) {
                if (exception.getShowType() == ReportException.ShowType.SHOW_NOTIFICATION_MSG) {
                    this.view.showErrorNotification(exception.getContent());
                } else if (exception.getShowType() == ReportException.ShowType.SHOW_ERROR_MESSAGE) {
                    this.view.showErrMessage(exception.getContent(), ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"CommonExcelExport_1", (String)"bos-form-mvc", (Object[])new Object[0]));
                } else {
                    this.view.showMessage(exception.getContent());
                }
                this.view.getReportCache().clearExceptionMsg(this.view.getPageId());
            } else {
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"CommonExcelExport_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            }
        }
    }
}

