/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.report.listener;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.mvc.report.ReportView;
import kd.bos.mvc.report.listener.ReportProgressListenerBase;

public class AsynQueryProgressListener
extends ReportProgressListenerBase
implements ProgresssListener {
    public AsynQueryProgressListener(ReportView view) {
        this.view = view;
    }

    public void onProgress(ProgressEvent evt) {
        if (this.isExportProgressing()) {
            return;
        }
        ProgressBar bar = (ProgressBar)this.view.getControl("progressbarap");
        int progress = this.getProgress();
        if (progress >= 100) {
            evt.setProgress(100);
            ReportException exception = this.reportCache.getException(this.getPageId());
            if (exception == null || StringUtils.isBlank((CharSequence)exception.getContent())) {
                this.showQueryMessage(this.view);
                this.view.showData();
            } else {
                if (exception.getShowType() == ReportException.ShowType.SHOW_NOTIFICATION_MSG) {
                    this.view.showErrorNotification(exception.getContent());
                } else if (exception.getShowType() == ReportException.ShowType.SHOW_ERROR_MESSAGE) {
                    this.view.showErrMessage(exception.getContent(), ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u5f02\u5e38:", (String)"AsynQueryProgressListener_0", (String)"bos-form-mvc", (Object[])new Object[0]));
                } else {
                    this.view.showMessage(exception.getContent());
                }
                this.getReportCache().clearExceptionMsg(this.getPageId());
            }
            bar.stop();
            this.view.getPageCache().put("isReportSearching", "false");
            this.view.setVisible(false, new String[]{"progressbarap"});
        } else {
            evt.setProgress(progress);
        }
    }

    private void showQueryMessage(ReportView view) {
        ReportQueryParam queryParam = this.reportCache.getReportQueryParam(this.pageId);
        String message = queryParam.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            queryParam.setMessage(null);
            this.reportCache.setReportQueryParam(this.pageId, queryParam);
            view.showMessage(message);
        }
    }
}

