/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import kd.bos.extplugin.aop.AOPCall;
import kd.bos.extplugin.aop.AOPContext;
import kd.bos.extplugin.internal.AOPInjector;
import kd.bos.extplugin.internal.PluginProviderFactory;

public final class AOPCaller
implements AutoCloseable {
    private static final ThreadLocal<AOPCaller> th = new ThreadLocal();
    private AOPCaller parent;
    private AOPCall before;
    private AOPCall after;
    private String methodId;

    public static <T> AOPContext<T> createAndSetAOPContext(String clsName, String method, Class<?>[] parameterTypes, AOPCall<T> before, AOPCall<T> after) {
        PluginProviderFactory.checkAOPConfig(clsName);
        String methodId = AOPInjector.getMethodId(clsName, method, parameterTypes);
        AOPCaller caller = new AOPCaller(before, after, methodId);
        return caller::close;
    }

    public static void callBefore(String methodId, Object target, Object[] args) {
        AOPCall before;
        AOPCaller ctx = AOPCaller.peekAOPCaller(methodId);
        if (ctx != null && (before = ctx.before) != null) {
            before.call(target, args);
        }
    }

    public static void callAfter(String methodId, Object target, Object[] args) {
        AOPCall after;
        AOPCaller ctx = AOPCaller.peekAOPCaller(methodId);
        if (ctx != null && (after = ctx.after) != null) {
            after.call(target, args);
        }
    }

    private static AOPCaller peekAOPCaller(String methodId) {
        AOPCaller ctx = th.get();
        while (ctx != null) {
            if (ctx.methodId.equals(methodId)) {
                return ctx;
            }
            ctx = ctx.parent;
        }
        return null;
    }

    private AOPCaller(AOPCall before, AOPCall after, String methodId) {
        this.before = before;
        this.after = after;
        this.methodId = methodId;
        this.parent = th.get();
        th.set(this);
    }

    @Override
    public void close() {
        if (this.parent == null) {
            th.remove();
        } else {
            th.set(this.parent);
        }
    }
}

