/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import kd.bos.extplugin.internal.AOPCaller;
import kd.bos.extplugin.internal.PluginLogable;
import kd.bos.xdb.exception.ExceptionUtil;

final class AOPInjector
implements PluginLogable {
    private static final boolean all_method = Boolean.getBoolean("form.plugin.aop.all_method");
    private static final Class<?>[] emptyParameterTypes = new Class[0];
    private static final String CODE_BEGIN_BEFORE = AOPCaller.class.getName() + ".callBefore(";
    private static final String CODE_BEGIN_AFTER = AOPCaller.class.getName() + ".callAfter(";
    private static final String CODE_END1 = ",this,$args);";
    private static final String CODE_END2 = ",null,$args);";

    AOPInjector() {
    }

    static void injectCode(Set<String> types) {
        ClassPool pool = ClassPool.getDefault();
        for (String type : types) {
            try {
                CtClass cls = pool.getCtClass(type);
                for (CtMethod method : cls.getDeclaredMethods()) {
                    if (!all_method && !AccessFlag.isPublic((int)method.getModifiers())) continue;
                    String methodId = "\"" + AOPInjector.getMethodId(type, method) + "\"";
                    String endCode = CODE_END1;
                    if ((method.getModifiers() & 8) != 0) {
                        endCode = CODE_END2;
                    }
                    method.insertBefore(CODE_BEGIN_BEFORE + methodId + endCode);
                    method.insertAfter(CODE_BEGIN_AFTER + methodId + endCode);
                }
                cls.toClass();
            }
            catch (Throwable e) {
                String msg = type + " aop inject code error: " + e.getMessage();
                log.error(msg, e);
                throw ExceptionUtil.asRuntimeException((String)msg, (Throwable)e);
            }
        }
    }

    static String getMethodId(String clsName, String method, Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            parameterTypes = emptyParameterTypes;
        }
        StringBuilder id = new StringBuilder(64).append(clsName).append('#').append(method).append('#').append(parameterTypes.length);
        if (parameterTypes.length > 0) {
            for (Class<?> type : parameterTypes) {
                id.append('|').append(type.getName());
            }
        }
        return id.toString();
    }

    private static String getMethodId(String cls, CtMethod method) throws NotFoundException {
        CtClass[] ptypes = method.getParameterTypes();
        StringBuilder id = new StringBuilder(64).append(cls).append('#').append(method.getName()).append('#').append(ptypes.length);
        if (ptypes.length > 0) {
            for (CtClass type : ptypes) {
                id.append('|').append(type.getName());
            }
        }
        return id.toString();
    }
}

