/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.extplugin.PluginProvider;
import kd.bos.extplugin.internal.PluginDBProvider;

public final class PluginProviderFactory {
    private static Set<String> aopClassNames = Collections.emptySet();
    private static Supplier<PluginProvider> sp;

    static PluginProvider getPluginProvider() {
        if (sp == null) {
            sp = () -> PluginDBProvider.get();
        }
        return sp.get();
    }

    static void setProvider(Supplier<PluginProvider> sp) {
        PluginProviderFactory.sp = sp;
    }

    static void checkAOPConfig(String clsName) {
        if (!aopClassNames.contains(clsName)) {
            throw new IllegalStateException("Not configured for AOP: " + clsName);
        }
    }

    public static Set<String> getConfiguredClassNames() {
        return aopClassNames;
    }
}

