/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.extplugin.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginFilter;
import kd.bos.extplugin.PluginProvider;
import kd.bos.extplugin.PluginProxy;
import kd.bos.extplugin.internal.PluginLogable;
import kd.bos.extplugin.internal.PluginProviderFactory;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.sdk.kingscript.mixture.ScriptImplement;
import kd.sdk.kingscript.mixture.ScriptImplementFactory;

public final class PluginProxyImpl<P>
implements PluginProxy<P>,
PluginLogable {
    public static final String SCRIPT_EXPORT_EXT_PLUGIN_NAME = "ext";
    private static final String SPAN_TYPE_NAME = "ext";
    private P defaultPlugin;
    private List<P> pluginList = new ArrayList<P>();

    public PluginProxyImpl(P defaultPlugin, Class<P> pluginCls, String caseName, PluginFilter filter, PluginProvider pluginProvider) {
        this.defaultPlugin = defaultPlugin;
        for (Class<?> cls : pluginProvider.getPluginClasses(caseName, filter)) {
            try {
                if (ScriptImplement.class.isAssignableFrom(cls)) {
                    this.pluginList.add(((Supplier)ScriptImplementFactory.newInstance(cls, (String)"ext", scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)).getValue()).get());
                    continue;
                }
                this.pluginList.add(cls.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    public PluginProxyImpl(P defaultPlugin, Class<P> pluginCls, String caseName, PluginFilter filter) {
        this(defaultPlugin, pluginCls, caseName, filter, PluginProviderFactory.getPluginProvider());
    }

    @Override
    public <R> List<R> callAfter(PluginCall<P, R> caller) {
        ArrayList<R> ret = new ArrayList<R>(this.pluginList.size() + 1);
        ret.add(caller.call(this.defaultPlugin));
        for (P plugin : this.pluginList) {
            EntityTraceSpan span = EntityTracer.create((String)"ext", (String)plugin.getClass().getName());
            Throwable throwable = null;
            try {
                ret.add(caller.call(plugin));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        return ret;
    }

    @Override
    public <R> List<R> callBefore(PluginCall<P, R> caller) {
        ArrayList<R> ret = new ArrayList<R>(this.pluginList.size() + 1);
        for (P plugin : this.pluginList) {
            EntityTraceSpan span = EntityTracer.create((String)"ext", (String)plugin.getClass().getName());
            Throwable throwable = null;
            try {
                ret.add(caller.call(plugin));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        ret.add(caller.call(this.defaultPlugin));
        return ret;
    }

    @Override
    public <R> List<R> callReplace(PluginCall<P, R> caller) {
        ArrayList<R> ret = new ArrayList<R>(this.pluginList.size());
        for (P plugin : this.pluginList) {
            EntityTraceSpan span = EntityTracer.create((String)"ext", (String)plugin.getClass().getName());
            Throwable throwable = null;
            try {
                ret.add(caller.call(plugin));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        return ret;
    }

    @Override
    public <R> List<R> callReplaceIfPresent(PluginCall<P, R> caller) {
        if (this.pluginList.isEmpty()) {
            ArrayList<R> ret = new ArrayList<R>(1);
            ret.add(caller.call(this.defaultPlugin));
            return ret;
        }
        return this.callReplace(caller);
    }

    @Override
    public List<P> getPlugins() {
        return new ArrayList<P>(this.pluginList);
    }
}

